/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.domaindefine;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.domaindefine.DMImpExpUtil;
import kd.bos.entity.ISVInfo;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.newdevportal.domaindefine.DomainDefineBasePlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

public class DMExportGuidePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
UploadListener {
    private static final Log logger = LogFactory.getLog(DMExportGuidePlugin.class);
    private static final String TREEVIEW_AP = "treeviewap";
    private static final String TREEVIEW_SELECT = "treeviewselect";
    private static final String ROOTNODE = "rootnode";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String NEXT_STEP = "nextstep";
    private static final String BEFORE_STEP = "beforestep";
    private static final String PARENTID = "parentid";
    private static final String TABPANEL = "tabpanel";
    private static final String LEFT_ROOT = "leftRoot";
    private static final String RIGHT_ROOT = "rightRoot";
    private static final String NUMBER_NAME = "number,name";
    private static final String EXPORT_NAME = "dmexport";
    private static final String BOS_DEVP_ELEMENT = "bos_devp_element";
    private static final String BOS_DEVP_PROPERPTY = "bos_devp_properpty";
    private static final String BOS_DEVP_OPERATION = "bos_devp_operation";
    private static final String BOS_DEVP_DMEXPORT = "bos_devp_dmexport";
    private static final String BOS_DEVP_RULE = "bos_devp_rule";
    private static final String BOS_DEVP_VALIDATION = "bos_devp_validation";
    private static final String BOS_DEVP_OPSERVICE = "bos_devp_opservice";
    private static final String NUMBER = "number";
    private static final String MDL = "mdl";
    private static final String NAME = "name";
    private static final String EXPORT = "export";
    private static final String BTN_DELNODE = "btn_delnode";
    private static final String BTN_ADDNODE = "btn_addnode";
    private static final String SOURCENAME = "sourcename";
    private static final String SOURCEURL = "sourceurl";
    private static final String SOURCEENTRYENTITY = "sourceentryentity";
    private static final String URLINFO = "urlinfo";
    private static final String UPLOADCALLBACK = "uploadcallback";
    private static final String UPLOADJAR = "uploadjar";
    private static final String ID = "id";
    private static final String TYPE = "type";
    private static final String PREFIX_GROUP = "group_";
    private static final String PREFIX_ELE = "ele_";
    private static final String PREFIX_PRO = "pro_";
    private static final String PREFIX_OPE = "ope_";
    private static final String PREFIX_FOR = "for_";
    private static final String PREFIX_ENT = "ent_";
    private static final String PREFIX_VAL = "val_";
    private static final String PREFIX_OPS = "ops_";
    private static final String TEXT = "text";
    private static final String ENABLE = "enable";
    private static final String PROPERTY = "property";
    private static final String ELEMENT = "element";
    private static final String OPERATION = "operation";
    private static final String FORMRULE = "formrule";
    private static final String ENTITYRULE = "entityrule";
    private static final String VALIDATOR = "validator";
    private static final String OPSERVICE = "opservice";

    private String getModelDisplayName(String key) {
        String value = "";
        switch (key) {
            case "element": {
                value = ResManager.loadKDString((String)"\u5143\u7d20", (String)"DMExportGuidePlugin_11", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "property": {
                value = ResManager.loadKDString((String)"\u5143\u7d20\u5c5e\u6027", (String)"DMExportGuidePlugin_12", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "operation": {
                value = ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"DMExportGuidePlugin_13", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "formrule": {
                value = ResManager.loadKDString((String)"\u754c\u9762\u89c4\u5219", (String)"DMExportGuidePlugin_14", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "entityrule": {
                value = ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219", (String)"DMExportGuidePlugin_15", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "validator": {
                value = ResManager.loadKDString((String)"\u6821\u9a8c\u5668", (String)"DMExportGuidePlugin_16", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "opservice": {
                value = ResManager.loadKDString((String)"\u64cd\u4f5c\u670d\u52a1", (String)"DMExportGuidePlugin_17", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
            }
        }
        return value;
    }

    public void registerListener(EventObject e) {
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEW_AP);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView selectTree = (TreeView)this.getView().getControl(TREEVIEW_SELECT);
        selectTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{BTN_ADDNODE, BTN_DELNODE, NEXT_STEP, BEFORE_STEP, EXPORT});
        this.addItemClickListeners(new String[]{"sourcetoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        TreeNode leftRoot = this.leftTreeInit();
        TreeView leftTree = (TreeView)this.getView().getControl(TREEVIEW_AP);
        leftTree.addNode(leftRoot);
        leftTree.setRootVisible(false);
        TreeNode rightRoot = new TreeNode("", ROOTNODE, ResManager.loadKDString((String)"\u5df2\u9009\u5143\u6a21\u578b", (String)"", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        rightRoot.setIsOpened(true);
        TreeView rightTree = (TreeView)this.getView().getControl(TREEVIEW_SELECT);
        rightTree.addNode(rightRoot);
        rightTree.setRootVisible(false);
    }

    private TreeNode leftTreeInit() {
        TreeNode leftRoot = new TreeNode("", ROOTNODE, ResManager.loadKDString((String)"\u5143\u6a21\u578b\u5217\u8868", (String)"DMExportGuidePlugin_18", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        leftRoot.setIsOpened(true);
        QFilter isv = this.consISVFilter();
        TreeNode treeNode = this.consElementNode(isv);
        if (null != treeNode) {
            leftRoot.addChild(treeNode);
        }
        if (null != (treeNode = this.consProperty(isv))) {
            leftRoot.addChild(treeNode);
        }
        if (null != (treeNode = this.consOperation(isv))) {
            leftRoot.addChild(treeNode);
        }
        if (null != (treeNode = this.consFormRule(isv))) {
            leftRoot.addChild(treeNode);
        }
        if (null != (treeNode = this.consEntityRule(isv))) {
            leftRoot.addChild(treeNode);
        }
        if (null != (treeNode = this.consValidator(isv))) {
            leftRoot.addChild(treeNode);
        }
        if (null != (treeNode = this.consOpService(isv))) {
            leftRoot.addChild(treeNode);
        }
        String leftTreeNodesValue = SerializationUtils.toJsonString((Object)leftRoot);
        this.getPageCache().put(LEFT_ROOT, leftTreeNodesValue);
        return leftRoot;
    }

    private QFilter consISVFilter() {
        ISVInfo isvInfo = ISVServiceHelper.getISVInfo();
        QFilter isv = new QFilter("isv", "=", (Object)isvInfo.getId());
        return isv;
    }

    private TreeNode consElementNode(QFilter filter) {
        Map<String, List<DynamicObject>> elementMap = this.getElementMap(filter);
        if (null != elementMap && elementMap.size() > 0) {
            ArrayList<TreeNode> groupList = new ArrayList<TreeNode>(elementMap.size());
            for (Map.Entry<String, List<DynamicObject>> entry : elementMap.entrySet()) {
                String groupNumber = entry.getKey();
                String groupName = "";
                List<DynamicObject> elements = entry.getValue();
                ArrayList<TreeNode> elementList = new ArrayList<TreeNode>(elements.size());
                for (DynamicObject element : elements) {
                    String number = element.getString(NUMBER);
                    String name = element.getString(NAME);
                    TreeNode elementNode = new TreeNode(PREFIX_GROUP + groupNumber, PREFIX_ELE + number, name);
                    elementList.add(elementNode);
                    groupName = element.getString("categoryname");
                }
                TreeNode groupNode = new TreeNode(ELEMENT, PREFIX_GROUP + groupNumber, groupName);
                groupNode.addChildren(elementList);
                groupList.add(groupNode);
            }
            TreeNode element = new TreeNode(ROOTNODE, ELEMENT, this.getModelDisplayName(ELEMENT));
            element.addChildren(groupList);
            return element;
        }
        return null;
    }

    private Map<String, List<DynamicObject>> getElementMap(QFilter filter) {
        Map elementMap = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVP_ELEMENT, (String)"category,categoryname,number,name", (QFilter[])new QFilter[]{filter});
        if (null != elementMap && elementMap.size() > 0) {
            HashMap<String, List<DynamicObject>> categoryMap = new HashMap<String, List<DynamicObject>>(16);
            for (DynamicObject value : elementMap.values()) {
                String category = value.getString("category");
                if (categoryMap.containsKey(category)) {
                    ((List)categoryMap.get(category)).add(value);
                    continue;
                }
                ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
                dynamicObjects.add(value);
                categoryMap.put(category, dynamicObjects);
            }
            return categoryMap;
        }
        return null;
    }

    private TreeNode consOpService(QFilter enable) {
        Map opServiceMap = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVP_OPSERVICE, (String)NUMBER_NAME, (QFilter[])new QFilter[]{enable});
        return this.consTreeNode(opServiceMap, OPSERVICE, PREFIX_OPS);
    }

    private TreeNode consValidator(QFilter enable) {
        Map validatorMap = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVP_VALIDATION, (String)NUMBER_NAME, (QFilter[])new QFilter[]{enable});
        return this.consTreeNode(validatorMap, VALIDATOR, PREFIX_VAL);
    }

    private TreeNode consEntityRule(QFilter enable) {
        QFilter form = new QFilter(TYPE, "=", (Object)"entitymeta");
        Map entityRuleMap = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVP_RULE, (String)NUMBER_NAME, (QFilter[])new QFilter[]{form.and(enable)});
        return this.consTreeNode(entityRuleMap, ENTITYRULE, PREFIX_ENT);
    }

    private TreeNode consFormRule(QFilter enable) {
        QFilter form = new QFilter(TYPE, "=", (Object)"formmeta");
        Map formRuleMap = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVP_RULE, (String)NUMBER_NAME, (QFilter[])new QFilter[]{form.and(enable)});
        return this.consTreeNode(formRuleMap, FORMRULE, PREFIX_FOR);
    }

    private TreeNode consOperation(QFilter enable) {
        Map operationMap = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVP_OPERATION, (String)NUMBER_NAME, (QFilter[])new QFilter[]{enable});
        return this.consTreeNode(operationMap, OPERATION, PREFIX_OPE);
    }

    private TreeNode consProperty(QFilter isv) {
        Map propertyMap = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVP_PROPERPTY, (String)NUMBER_NAME, (QFilter[])new QFilter[]{isv});
        return this.consTreeNode(propertyMap, PROPERTY, PREFIX_PRO);
    }

    private TreeNode consTreeNode(Map<Object, DynamicObject> baseDataMap, String type, String prefix) {
        if (null != baseDataMap && baseDataMap.size() > 0) {
            ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(baseDataMap.size());
            for (DynamicObject value : baseDataMap.values()) {
                String number = value.getString(NUMBER);
                String name = value.getString(NAME);
                TreeNode treeNode = new TreeNode(type, prefix + number, name);
                nodeList.add(treeNode);
            }
            TreeNode node = new TreeNode(ROOTNODE, type, this.getModelDisplayName(type));
            node.addChildren(nodeList);
            return node;
        }
        return null;
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase(Locale.ENGLISH)) {
            case "btn_addnode": {
                this.addNode();
                break;
            }
            case "btn_delnode": {
                this.deleteNode();
                break;
            }
            case "nextstep": {
                this.nextStep(key);
                break;
            }
            case "beforestep": {
                this.beforeStep(key);
                break;
            }
            case "export": {
                this.export();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (UPLOADCALLBACK.equals(evt.getActionId()) && evt.getReturnData() != null) {
            Map returnInfo = (Map)evt.getReturnData();
            JSONArray urlArr = (JSONArray)returnInfo.get(URLINFO);
            int sourceRowCount = this.getModel().getEntryRowCount(SOURCEENTRYENTITY);
            this.getModel().batchCreateNewEntryRow(SOURCEENTRYENTITY, urlArr.size());
            for (int i = 0; i < urlArr.size(); ++i) {
                JSONObject urlInfo = (JSONObject)urlArr.get(i);
                int limit = i + sourceRowCount;
                urlInfo.forEach((urlName, url) -> {
                    this.getModel().setValue(SOURCENAME, urlName, limit);
                    this.getModel().setValue(SOURCEURL, url, limit);
                });
            }
        }
    }

    public void itemClick(ItemClickEvent e) {
        String key;
        switch (key = e.getItemKey()) {
            case "uploadjar": {
                this.upLoadResourceMethod();
                break;
            }
        }
    }

    private void upLoadResourceMethod() {
        String selectNode = this.getPageCache().get(RIGHT_ROOT);
        if (StringUtils.isBlank((CharSequence)selectNode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u5143\u6a21\u578b\u3002", (String)"DMExportGuidePlugin_20", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_dmexport_upload");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, UPLOADCALLBACK));
        this.getView().showForm(parameter);
    }

    public void beforeStep(String key) {
        Tab tab = (Tab)this.getView().getControl(TABPANEL);
        if (BEFORE_STEP.equals(key)) {
            tab.activeTab("modeltab");
        }
    }

    public void nextStep(String key) {
        Tab tab = (Tab)this.getView().getControl(TABPANEL);
        if (NEXT_STEP.equals(key)) {
            tab.activeTab("sourceupload");
        }
    }

    private void deleteNode() {
        TreeView selectTree = (TreeView)this.getView().getControl(TREEVIEW_SELECT);
        List ids = selectTree.getTreeState().getCheckedNodeIds();
        if (ids.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u79fb\u9664\u7684\u6570\u636e\u3002", (String)"DMExportGuidePlugin_21", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        ids.remove(ROOTNODE);
        String rightNodeCache = this.getPageCache().get(RIGHT_ROOT);
        if (StringUtils.isNotBlank((CharSequence)rightNodeCache)) {
            TreeNode selectNode = (TreeNode)SerializationUtils.fromJsonString((String)rightNodeCache, TreeNode.class);
            ids.forEach(id -> selectNode.deleteChildNode(id));
            if (!CollectionUtils.isEmpty((Collection)selectNode.getChildren())) {
                rightNodeCache = SerializationUtils.toJsonString((Object)selectNode);
                this.getPageCache().put(RIGHT_ROOT, rightNodeCache);
            } else {
                this.getPageCache().put(RIGHT_ROOT, "");
            }
        }
        selectTree.deleteNodes(ids);
        selectTree.uncheckNode(ROOTNODE);
    }

    private void addNode() {
        TreeView rightTree = (TreeView)this.getView().getControl(TREEVIEW_SELECT);
        TreeView leftTree = (TreeView)this.getView().getControl(TREEVIEW_AP);
        List leftSelectIds = leftTree.getTreeState().getCheckedNodeIds();
        if (leftSelectIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u5143\u6a21\u578b\u3002", (String)"DMExportGuidePlugin_22", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        TreeNode selectedNode = this.genRightTreeNode();
        selectedNode.setIsOpened(true);
        rightTree.deleteAllNodes();
        rightTree.addNode(selectedNode);
        rightTree.updateNode(selectedNode);
        if (leftSelectIds.size() == 1) {
            List selectNodes = leftTree.getTreeState().getSelectedNodes();
            Map selectNodeInfo = (Map)selectNodes.get(0);
            String nodeId = (String)selectNodeInfo.get(ID);
            String parentNodeId = (String)selectNodeInfo.get(PARENTID);
            boolean isParent = (Boolean)selectNodeInfo.get("isParent");
            if (isParent) {
                rightTree.showNode(nodeId);
                rightTree.expand(nodeId);
            } else {
                rightTree.showNode(parentNodeId);
                rightTree.expand(parentNodeId);
            }
        }
    }

    private TreeNode genRightTreeNode() {
        TreeView leftTree = (TreeView)this.getView().getControl(TREEVIEW_AP);
        List selectNodes = leftTree.getTreeState().getSelectedNodes();
        String rightNodeCache = this.getPageCache().get(RIGHT_ROOT);
        String leftRootCache = this.getPageCache().get(LEFT_ROOT);
        if (StringUtils.isBlank((CharSequence)leftRootCache)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"DMExportGuidePlugin_23", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return new TreeNode("", ROOTNODE, ResManager.loadKDString((String)"\u5df2\u9009\u5143\u6a21\u578b", (String)"DMExportGuidePlugin_19", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
        TreeNode leftRoot = (TreeNode)SerializationUtils.fromJsonString((String)leftRootCache, TreeNode.class);
        if (null == leftRoot || CollectionUtils.isEmpty((Collection)leftRoot.getChildren())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"DMExportGuidePlugin_24", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return new TreeNode("", ROOTNODE, ResManager.loadKDString((String)"\u5df2\u9009\u5143\u6a21\u578b", (String)"DMExportGuidePlugin_19", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
        TreeNode rightRoot = StringUtils.isNotBlank((CharSequence)rightNodeCache) ? (TreeNode)SerializationUtils.fromJsonString((String)rightNodeCache, TreeNode.class) : new TreeNode("", ROOTNODE, ResManager.loadKDString((String)"\u5df2\u9009\u5143\u6a21\u578b", (String)"DMExportGuidePlugin_19", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        for (Map selectNode : selectNodes) {
            String parentId = (String)selectNode.get(PARENTID);
            String id = (String)selectNode.get(ID);
            String text = (String)selectNode.get(TEXT);
            TreeNode treeNode = rightRoot.getTreeNode(id);
            if (null != treeNode) continue;
            TreeNode curNode = new TreeNode(parentId, id, text);
            this.saveNode(leftRoot, rightRoot, curNode);
        }
        String rightNode = SerializationUtils.toJsonString((Object)rightRoot);
        this.getPageCache().put(RIGHT_ROOT, rightNode);
        return rightRoot;
    }

    private void saveNode(TreeNode leftRoot, TreeNode rightRoot, TreeNode curNode) {
        String parentId = curNode.getParentid();
        TreeNode parentNode = rightRoot.getTreeNode(parentId);
        if (null == parentNode) {
            parentNode = leftRoot.getTreeNode(parentId);
            String parentid = parentNode.getParentid();
            if (!"".equalsIgnoreCase(parentid)) {
                TreeNode treeNode = new TreeNode(parentid, parentNode.getId(), parentNode.getText());
                treeNode.addChild(curNode);
                this.saveNode(leftRoot, rightRoot, treeNode);
            }
        } else {
            parentNode.addChild(curNode);
            return;
        }
    }

    private void export() {
        String rightNodeStr = this.getPageCache().get(RIGHT_ROOT);
        if (StringUtils.isBlank((CharSequence)rightNodeStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u5143\u6a21\u578b\u3002", (String)"DMExportGuidePlugin_22", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        TreeNode rightNode = (TreeNode)SerializationUtils.fromJsonString((String)rightNodeStr, TreeNode.class);
        if (rightNode == null || CollectionUtils.isEmpty((Collection)rightNode.getChildren())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u5143\u6a21\u578b\u3002", (String)"DMExportGuidePlugin_22", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        DynamicObject dmExport = BusinessDataServiceHelper.newDynamicObject((String)BOS_DEVP_DMEXPORT);
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject curUser = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        curUser.set(ID, (Object)currUserId);
        dmExport.set("creator", (Object)curUser);
        dmExport.set("createdate", (Object)new Date());
        DynamicObjectCollection entryentity = dmExport.getDynamicObjectCollection("entryentity");
        HashMap<String, String> xmlMap = new HashMap<String, String>(16);
        this.genXML(rightNode, entryentity, xmlMap);
        HashMap<String, byte[]> jarMap = new HashMap<String, byte[]>();
        String jarName = this.genJar(jarMap);
        dmExport.set("jarname", (Object)jarName);
        String zipName = this.getZipFile(rightNode);
        byte[] bytes = this.zipFiles(xmlMap, jarMap);
        try {
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipName, bytes, 5000);
            this.handleTempFilePermission(url, BOS_DEVP_DMEXPORT, MDL);
            this.getView().openUrl(url);
            dmExport.set("filename", (Object)zipName);
            String billno = DBServiceHelper.genLongIds((String)"t_dm_dmexport", (int)1)[0] + "";
            dmExport.set("billno", (Object)billno);
            MultiLangEnumBridge desc = new MultiLangEnumBridge("\u5143\u6a21\u578b\u5bfc\u51fa\u6210\u529f", "DMExportGuidePlugin_9", BOS_DEVPORTAL_NEW_PLUGIN);
            DomainDefineBasePlugin.buildLog(BOS_DEVP_DMEXPORT, "metamodelexport", "1", desc);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dmExport});
        }
        catch (Exception e) {
            logger.error("\u5143\u6a21\u578b\u5bfc\u51fa\uff1asave bos_devp_dmexport exception {}", (Throwable)e);
            MultiLangEnumBridge desc = new MultiLangEnumBridge("\u5143\u6a21\u578b\u5bfc\u51fa\u5931\u8d25", "DMExportGuidePlugin_10", BOS_DEVPORTAL_NEW_PLUGIN);
            DomainDefineBasePlugin.buildLog(BOS_DEVP_DMEXPORT, "metamodelexport", "0", desc);
        }
        this.getView().close();
    }

    private void handleTempFilePermission(String url, String formId, String appId) {
        String tempFileId = UrlUtil.getParam((String)url, (String)ID);
        HashMap<String, String> parameter = new HashMap<String, String>(3);
        parameter.put("entityNum", formId);
        parameter.put("appId", appId);
        parameter.put("permissionItemId", "47150e89000000ac");
        DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(formId);
        redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(parameter), 600);
    }

    private String getZipFile(TreeNode treeNode) {
        String id;
        List nodes = treeNode.getChildren();
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String dataFormat = sdf.format(date);
        String model_export = ResManager.loadKDString((String)"\u6a21\u578b\u5bfc\u51fa", (String)"DMExportGuidePlugin_7", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
        String zipFileName = null;
        if (nodes.size() > 1) {
            return model_export + "-" + dataFormat + ".zip";
        }
        switch (id = ((TreeNode)nodes.get(0)).getId()) {
            case "element": {
                zipFileName = this.buildFileName(model_export, ResManager.loadKDString((String)"\u5143\u7d20", (String)"DMExportGuidePlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), dataFormat);
                break;
            }
            case "property": {
                zipFileName = this.buildFileName(model_export, ResManager.loadKDString((String)"\u5143\u7d20\u5c5e\u6027", (String)"DMExportGuidePlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), dataFormat);
                break;
            }
            case "operation": {
                zipFileName = this.buildFileName(model_export, ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"DMExportGuidePlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), dataFormat);
                break;
            }
            case "formrule": {
                zipFileName = this.buildFileName(model_export, ResManager.loadKDString((String)"\u754c\u9762\u89c4\u5219", (String)"DMExportGuidePlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), dataFormat);
                break;
            }
            case "entityrule": {
                zipFileName = this.buildFileName(model_export, ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219", (String)"DMExportGuidePlugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), dataFormat);
                break;
            }
            case "validator": {
                zipFileName = this.buildFileName(model_export, ResManager.loadKDString((String)"\u6821\u9a8c\u5668", (String)"DMExportGuidePlugin_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), dataFormat);
                break;
            }
            case "opservice": {
                zipFileName = this.buildFileName(model_export, ResManager.loadKDString((String)"\u64cd\u4f5c\u670d\u52a1", (String)"DMExportGuidePlugin_6", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), dataFormat);
                break;
            }
            default: {
                zipFileName = model_export + "-" + dataFormat + ".zip";
            }
        }
        return zipFileName;
    }

    private String buildFileName(String model, String nodeName, String dateStr) {
        return String.format("%1$s-%2$s-%3$s.zip", model, nodeName, dateStr);
    }

    private byte[] getZipData(ZipArchiveInputStream zipIn) throws IOException {
        int readLength = 0;
        byte[] buf = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((readLength = zipIn.read(buf, 0, 1024)) != -1) {
            bos.write(buf, 0, readLength);
        }
        bos.flush();
        bos.close();
        return bos.toByteArray();
    }

    private String genJar(Map<String, byte[]> jarMap) {
        DynamicObjectCollection sourceEntryEntity = this.getModel().getEntryEntity(SOURCEENTRYENTITY);
        if (!CollectionUtils.isEmpty((Collection)sourceEntryEntity)) {
            StringBuilder sbd = new StringBuilder();
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            for (DynamicObject dynamicObject : sourceEntryEntity) {
                String sourceUrl = dynamicObject.getString(SOURCEURL);
                try (InputStream inputStream = cache.getInputStream(sourceUrl);
                     ZipArchiveInputStream zipIn = new ZipArchiveInputStream(inputStream);){
                    ZipArchiveEntry zipEntry;
                    while ((zipEntry = zipIn.getNextZipEntry()) != null) {
                        byte[] buf;
                        String fileName;
                        if (zipEntry.isDirectory() || !(fileName = zipEntry.getName()).endsWith(".jar") || (buf = this.getZipData(zipIn)) == null || buf.length <= 0) continue;
                        jarMap.put(fileName, buf);
                    }
                }
                catch (IOException e) {
                    logger.error("metamodel export: genJar() exception {}", (Throwable)e);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"DMExportGuidePlugin_25", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                }
                String sourceName = dynamicObject.getString(SOURCENAME);
                sbd.append(sourceName).append(",");
            }
            return sbd.toString();
        }
        return "";
    }

    private void genXML(TreeNode treeNode, DynamicObjectCollection entryentity, Map<String, String> xmlMap) {
        List children = treeNode.getChildren();
        String id = treeNode.getId();
        if (CollectionUtils.isEmpty((Collection)children)) {
            DynamicObject dynamicObject = entryentity.addNew();
            int size = entryentity.size();
            DynamicObject data = this.getDetail(treeNode, dynamicObject);
            if (null == data) {
                logger.warn("metamodel export: the corresponding data cannot be queried on the leaf node, parentid = {},id = {}", (Object)treeNode.getParentid(), (Object)id);
                return;
            }
            dynamicObject.set(NUMBER, data.get(NUMBER));
            OrmLocaleValue ormLocaleValue = (OrmLocaleValue)data.get(NAME);
            dynamicObject.set(NAME, (Object)ormLocaleValue.getLocaleValue());
            dynamicObject.set("seq", (Object)size);
            String xml = new DMImpExpUtil().toExportXml(data);
            xmlMap.put(id + "_" + data.get(NAME) + ".xml", xml);
        } else {
            for (TreeNode child : children) {
                this.genXML(child, entryentity, xmlMap);
            }
        }
    }

    private DynamicObject getDetail(TreeNode treeNode, DynamicObject dynamicObject) {
        DynamicObject data;
        String id = treeNode.getId();
        String parentId = treeNode.getParentid();
        if (parentId.contains(PREFIX_GROUP)) {
            dynamicObject.set(TYPE, (Object)this.getModelDisplayName(ELEMENT));
            id = id.replace(PREFIX_ELE, "");
            QFilter idFilter = new QFilter(NUMBER, "=", (Object)id);
            QFilter[] qFilters = new QFilter[]{idFilter};
            data = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_DEVP_ELEMENT, (QFilter[])qFilters);
        } else if (PROPERTY.equalsIgnoreCase(parentId)) {
            dynamicObject.set(TYPE, (Object)this.getModelDisplayName(PROPERTY));
            id = id.replace(PREFIX_PRO, "");
            QFilter idFilter = new QFilter(NUMBER, "=", (Object)id);
            QFilter[] qFilters = new QFilter[]{idFilter};
            data = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_DEVP_PROPERPTY, (QFilter[])qFilters);
        } else if (OPERATION.equalsIgnoreCase(parentId)) {
            dynamicObject.set(TYPE, (Object)this.getModelDisplayName(OPERATION));
            id = id.replace(PREFIX_OPE, "");
            QFilter idFilter = new QFilter(NUMBER, "=", (Object)id);
            QFilter[] qFilters = new QFilter[]{idFilter};
            data = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_DEVP_OPERATION, (QFilter[])qFilters);
        } else if (FORMRULE.equalsIgnoreCase(parentId)) {
            dynamicObject.set(TYPE, (Object)this.getModelDisplayName(FORMRULE));
            id = id.replace(PREFIX_FOR, "");
            QFilter idFilter = new QFilter(NUMBER, "=", (Object)id);
            QFilter[] qFilters = new QFilter[]{idFilter};
            data = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_DEVP_RULE, (QFilter[])qFilters);
        } else if (ENTITYRULE.equalsIgnoreCase(parentId)) {
            dynamicObject.set(TYPE, (Object)this.getModelDisplayName(ENTITYRULE));
            id = id.replace(PREFIX_ENT, "");
            QFilter idFilter = new QFilter(NUMBER, "=", (Object)id);
            QFilter[] qFilters = new QFilter[]{idFilter};
            data = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_DEVP_RULE, (QFilter[])qFilters);
        } else if (VALIDATOR.equalsIgnoreCase(parentId)) {
            dynamicObject.set(TYPE, (Object)this.getModelDisplayName(VALIDATOR));
            id = id.replace(PREFIX_VAL, "");
            QFilter idFilter = new QFilter(NUMBER, "=", (Object)id);
            QFilter[] qFilters = new QFilter[]{idFilter};
            data = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_DEVP_VALIDATION, (QFilter[])qFilters);
        } else if (OPSERVICE.equalsIgnoreCase(parentId)) {
            dynamicObject.set(TYPE, (Object)this.getModelDisplayName(OPSERVICE));
            id = id.replace(PREFIX_OPS, "");
            QFilter idFilter = new QFilter(NUMBER, "=", (Object)id);
            QFilter[] qFilters = new QFilter[]{idFilter};
            data = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_DEVP_OPSERVICE, (QFilter[])qFilters);
        } else {
            return null;
        }
        return data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] zipFiles(Map<String, String> xmlMap, Map<String, byte[]> jarMap) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ZipOutputStream out = new ZipOutputStream(bos);){
            ZipEntry entry;
            for (Map.Entry<String, String> byArray2 : xmlMap.entrySet()) {
                entry = new ZipEntry(byArray2.getKey());
                entry.setMethod(8);
                out.putNextEntry(entry);
                out.write(byArray2.getValue().getBytes());
                out.closeEntry();
                out.flush();
            }
            for (Map.Entry<String, String> entry2 : jarMap.entrySet()) {
                entry = new ZipEntry(entry2.getKey());
                entry.setMethod(8);
                out.putNextEntry(entry);
                out.write((byte[])entry2.getValue());
                out.closeEntry();
                out.flush();
            }
            out.close();
            byte[] bytes = bos.toByteArray();
            bos.close();
            byte[] byArray = bytes;
            return byArray;
        }
        catch (IOException e) {
            logger.error("failed to export the metamodel: exception:{}", (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"DMExportGuidePlugin_26", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return null;
        }
    }
}

