/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.domaindefine;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.newdevportal.domaindefine.BaseListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class DMExportListPlugin
extends BaseListPlugin {
    private static final String VIEW = "view";
    private static final String EXPORT = "export";
    private static final String ENABLE = "enable";
    private static final String BOS_DEVP_ELEMENT = "bos_devp_element";
    private static final String BOS_DEVP_OPSERVICE = "bos_devp_opservice";
    private static final String BOS_DEVP_PROPERPTY = "bos_devp_properpty";
    private static final String BOS_DEVP_OPERATION = "bos_devp_operation";
    private static final String BOS_DEVP_RULE = "bos_devp_rule";
    private static final String BOS_DEVP_VALIDATION = "bos_devp_validation";
    private static final String NUMBER_NAME = "number,name";
    private static final String BOS_DEVP_DMEXPORT = "bos_devp_dmexport";

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if (VIEW.equals(evt.getOperationKey())) {
            this.showBill(BillOperationStatus.VIEW, false);
            evt.setCancel(true);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbarap = (Toolbar)this.getControl("toolbarap");
        toolbarap.addItemClickListener((ItemClickListener)this);
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        String itemKey = e.getItemKey();
        if ("bar_export".equalsIgnoreCase(itemKey)) {
            if (!this.hasPermission()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5143\u6a21\u578b\u5bfc\u51fa\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u64cd\u4f5c\u3002", (String)"DMExportListPlugin_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
                return;
            }
            if (this.checkExistData()) {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("bos_devp_dmexport_guide");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EXPORT));
                this.getView().showForm(formShowParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6a21\u578b\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"DMExportListPlugin_1", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean hasPermission() {
        long userId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        int flag = PermissionServiceHelper.checkPermission((Long)userId, (Long)0L, (String)appId, (String)BOS_DEVP_DMEXPORT, (String)"47150e89000000ac");
        return flag == 1;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (EXPORT.equalsIgnoreCase(actionId)) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }

    private boolean checkExistData() {
        QFilter enable = new QFilter(ENABLE, "=", (Object)"1");
        Map dataMap = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVP_ELEMENT, (String)"category,categoryname,number,name", (QFilter[])new QFilter[]{enable});
        if (null != dataMap && dataMap.size() > 0) {
            return true;
        }
        dataMap = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVP_PROPERPTY, (String)NUMBER_NAME, (QFilter[])new QFilter[0]);
        if (null != dataMap && dataMap.size() > 0) {
            return true;
        }
        dataMap = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVP_OPERATION, (String)NUMBER_NAME, (QFilter[])new QFilter[]{enable});
        if (null != dataMap && dataMap.size() > 0) {
            return true;
        }
        dataMap = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVP_VALIDATION, (String)NUMBER_NAME, (QFilter[])new QFilter[]{enable});
        if (null != dataMap && dataMap.size() > 0) {
            return true;
        }
        dataMap = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVP_RULE, (String)NUMBER_NAME, (QFilter[])new QFilter[]{enable});
        if (null != dataMap && dataMap.size() > 0) {
            return true;
        }
        dataMap = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVP_OPSERVICE, (String)NUMBER_NAME, (QFilter[])new QFilter[]{enable});
        return null != dataMap && dataMap.size() > 0;
    }
}

