/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.domaindefine;

import java.io.IOException;
import java.io.InputStream;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.domaindefine.DMImportAPI;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.domainmodel.define.DomainModelTypeFactory;
import kd.bos.newdevportal.domaindefine.DomainDefineBasePlugin;
import org.dom4j.DocumentException;

public class DMImportFilePlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String URL = "url";
    private static final String FILENAME = "filename";
    private static final String ATTACHMENTPANELAP = "attachmentpanelap";
    private static final String BTNOK = "btnok";
    private static Log log = LogFactory.getLog(DMImportFilePlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel dbspanel = (AttachmentPanel)this.getView().getControl(ATTACHMENTPANELAP);
        dbspanel.addUploadListener((UploadListener)this);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey().toLowerCase(Locale.ENGLISH);
        if (BTNOK.equals(key)) {
            try {
                this.doImport();
            }
            catch (IOException | DocumentException e) {
                log.error("\u5bfc\u5165\u5143\u6a21\u578b\u5931\u8d25\u3002", e);
                String errorMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"DMImportFilePlugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                MultiLangEnumBridge desc = new MultiLangEnumBridge("\u5143\u6a21\u578b\u5bfc\u5165\u5931\u8d25", "DMImportFilePlugin_11", BOS_DEVPORTAL_NEW_PLUGIN);
                DomainDefineBasePlugin.buildLog("bos_devp_dmimport", "metamodelimport", "0", desc);
                this.getView().showErrorNotification(errorMsg + e.getMessage());
            }
            catch (KDException ex) {
                this.getView().showTipNotification(ex.getMessage());
            }
        }
    }

    public void upload(UploadEvent evt) {
        if (evt == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u5668zk\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"DMImportFilePlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Object[] urls = evt.getUrls();
        if (urls == null || urls.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u5668zk\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"DMImportFilePlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Map urlMsg = (Map)urls[0];
        String urlName = (String)urlMsg.get("name");
        String url = (String)urlMsg.get(URL);
        this.getPageCache().put(FILENAME, urlName);
        this.getPageCache().put(URL, url);
    }

    private boolean hasAttachmentUploading() {
        IPageCache cache = this.getView().getPageCache();
        String uploadingAttJson = cache.get("UploadingAtt" + this.getView().getPageId());
        return StringUtils.isNotBlank((CharSequence)uploadingAttJson);
    }

    private boolean isHaveAttachment() {
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl(ATTACHMENTPANELAP);
        List attachmentData = panel.getAttachmentData();
        return attachmentData.isEmpty();
    }

    private boolean check() {
        String noAttacthmentMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u9644\u4ef6\u3002", (String)"DMImportFilePlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
        if (this.isHaveAttachment()) {
            this.getView().showTipNotification(noAttacthmentMsg);
            return false;
        }
        if (this.hasAttachmentUploading()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"DMImportFilePlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        String zipFileName = this.getPageCache().get(FILENAME);
        if (zipFileName == null) {
            this.getView().showErrorNotification(noAttacthmentMsg);
            return false;
        }
        String url = this.getPageCache().get(URL);
        if (url == null) {
            this.getView().showErrorNotification(noAttacthmentMsg);
            return false;
        }
        return true;
    }

    private void doImport() throws IOException, DocumentException {
        if (!this.check()) {
            return;
        }
        String zipFileName = this.getPageCache().get(FILENAME);
        String newZipFileName = this.getAttachmentFileName();
        if (StringUtils.isNotBlank((CharSequence)newZipFileName)) {
            zipFileName = newZipFileName;
        }
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String url = this.getPageCache().get(URL);
        DMImportAPI api = new DMImportAPI();
        try (InputStream inStream = cache.getInputStream(url);){
            api.importZip(zipFileName, (String)this.getModel().getValue("desc"), inStream, this::onSave);
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5bfc\u5165\u5b8c\u6210\u3002", (String)"DMImportFilePlugin_8", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener("doclose"));
        MultiLangEnumBridge desc = new MultiLangEnumBridge("\u5143\u6a21\u578b\u5bfc\u5165\u6210\u529f", "DMImportFilePlugin_10", BOS_DEVPORTAL_NEW_PLUGIN);
        DomainDefineBasePlugin.buildLog("bos_devp_dmimport", "metamodelimport", "1", desc);
    }

    private void onSave(List<DynamicObject> list) {
        for (DynamicObject row : list) {
            if (!this.check(row)) continue;
            this.removeDomainModelCache(row);
        }
    }

    private boolean check(DynamicObject row) {
        String type;
        if (row.getDataEntityType().getName().equals("bos_devp_properpty") && !this.isValidateType(type = row.getString("type"))) {
            throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u5143\u7d20\u5c5e\u6027\u4e0d\u5408\u6cd5\u3002%1$s- %2$s", (String)"DMImportFilePlugin_9", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{row.getString("number"), row.getString("name")})});
        }
        return true;
    }

    private boolean isValidateType(String propertyType) {
        switch (propertyType) {
            case "text": 
            case "dimension": 
            case "checkbox": 
            case "integer": 
            case "color": 
            case "slider": 
            case "btnedit": 
            case "combo": 
            case "mcombo": 
            case "refcombo": 
            case "date": 
            case "daterange": 
            case "decimal": 
            case "position": 
            case "radius": 
            case "ecombo": 
            case "refmcombo": {
                return true;
            }
        }
        return false;
    }

    private void removeDomainModelCache(DynamicObject row) {
        String modelTypeIds;
        if (row.getDynamicObjectType().getName().equals("bos_devp_element") && !StringUtils.isBlank((CharSequence)(modelTypeIds = row.getBoolean("issys") ? row.getString("modeltype") : row.getString("applynumber")))) {
            String[] domainTypeIds;
            for (String domainTypeId : domainTypeIds = modelTypeIds.split(",")) {
                if (StringUtils.isBlank((CharSequence)domainTypeId)) continue;
                DomainModelTypeFactory.removeCache((String)domainTypeId);
            }
        }
    }

    private String getAttachmentFileName() {
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl(ATTACHMENTPANELAP);
        List attachmentData = panel.getAttachmentData();
        if (!attachmentData.isEmpty()) {
            Map files = (Map)attachmentData.get(0);
            return (String)files.get("name");
        }
        return "";
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if ("doclose".equals(event.getCallBackId())) {
            this.getView().returnDataToParent((Object)"ok");
            this.getView().close();
        }
    }
}

