/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.domaindefine;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IClientViewProxy;
import kd.bos.isv.ISVService;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.define.DomainModelTypeFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class DomainDefineBasePlugin
extends AbstractBasePlugIn {
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String ISV = "isv";
    protected boolean canSetISV = false;
    private static Map<String, DomainModelType> domainModelTypeCache = new ConcurrentHashMap<String, DomainModelType>();

    protected <T> T fromXML(String xml, T t) {
        ArrayList dts = new ArrayList();
        DcxmlSerializer ser = new DcxmlSerializer((DcBinder)new ListDcxmlBinder(true, dts));
        return (T)ser.deserializeFromString(xml, t);
    }

    protected <T> String toXml(T t, T baseEntity) {
        ArrayList dts = new ArrayList();
        DcxmlSerializer ser = new DcxmlSerializer((DcBinder)new ListDcxmlBinder(true, dts));
        return ser.serializeToString(t, baseEntity);
    }

    protected <T> void cloneEntity(T t, T newEntity) {
        String xml = this.toXml(t, null);
        this.fromXML(xml, newEntity);
    }

    protected DomainModelType getDomainModelTypeCache(String modelType) {
        DomainModelType data = domainModelTypeCache.computeIfAbsent(modelType, key -> DomainModelTypeFactory.getDomainModelTypeSys((String)key, (boolean)true));
        DomainModelType cloneData = new DomainModelType();
        this.cloneEntity(data, cloneData);
        return cloneData;
    }

    protected void clearDomainModelCache(String modelType) {
        domainModelTypeCache.remove(modelType);
    }

    protected LocaleString getLocaleString(String name) {
        return this.getLocaleString(name, -1);
    }

    protected LocaleString getLocaleString(Object value) {
        if (value instanceof OrmLocaleValue) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            for (String loId : ((OrmLocaleValue)value).keySet()) {
                map.put(loId, ((OrmLocaleValue)value).get((Object)loId));
            }
            return LocaleString.fromMap(map);
        }
        throw new RuntimeException(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u7c7b\u578b\uff1a%s\u3002", (String)"DomainDefineBasePlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{value.getClass().getName()}));
    }

    protected LocaleString getLocaleString(String name, int rowIndex) {
        Object value = this.getModel().getValue(name, rowIndex);
        return this.getLocaleString(value);
    }

    protected boolean checkNumber() {
        String number = (String)this.getModel().getValue(NUMBER);
        if (StringUtils.isBlank((CharSequence)number)) {
            return true;
        }
        Pattern pattern = Pattern.compile("^[a-zA-Z0-9]+[a-zA-Z0-9_]*$");
        if (!pattern.matcher(number).matches()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u4ee5\u5b57\u6bcd\u548c\u6570\u5b57\u5f00\u5934\u4e14\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"DomainDefineBasePlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (!this.checkDuplicateNumber(number)) {
            return false;
        }
        String isvId = ISVService.getISVInfo().getId();
        if (!"kingdee".equals(isvId) && !"".equals(isvId)) {
            String upIsv = Character.toString(isvId.trim().charAt(0)).toUpperCase() + isvId.substring(1);
            if (!number.startsWith(isvId) && !number.startsWith(upIsv)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u4f7f\u7528\u5f00\u53d1\u5546\u6807\u8bc6\u524d\u7f00\uff1a<\u5f00\u53d1\u5546\u6807\u8bc6>\u7f16\u7801\u3002", (String)"DomainDefineBasePlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    protected boolean checkDuplicateNumber(String number) {
        QFilter[] filter = new QFilter[]{new QFilter(NUMBER, "=", (Object)number)};
        Map data = BusinessDataReader.loadFromCache((String)this.getModel().getDataEntityType().getName(), (QFilter[])filter);
        if (data != null) {
            data.remove(this.getModel().getValue(ID));
            if (data.size() > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d\u3002", (String)"DomainDefineBasePlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    protected boolean checkIsv() {
        if (this.canSetISV) {
            String isvId = (String)this.getModel().getValue(ISV);
            if (!StringUtils.isBlank((CharSequence)isvId) && !isvId.equals(ISVService.getISVInfo().getId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u672c\u5f00\u53d1\u5546\u521b\u5efa\u4e0d\u53ef\u4fee\u6539\u3002", (String)"DomainDefineBasePlugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                return false;
            }
            return true;
        }
        return true;
    }

    protected boolean checkSys() {
        if (((Boolean)this.getModel().getValue("issys")).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u9884\u8bbe\u6570\u636e\u3002", (String)"DomainDefineBasePlugin_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void checkCurrentIsv(String btn) {
        String isv = ISVService.getISVInfo().getId();
        if (!isv.equals(this.getModel().getValue(ISV))) {
            if (btn != null) {
                this.getView().setVisible(Boolean.FALSE, new String[]{btn});
            }
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).removeAction("setFormStatus");
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    protected DynamicObject loadSingleFromCache(Object pkValue, DynamicObjectType entityType) {
        Map ret = BusinessDataReader.loadFromCache((Object[])new Object[]{pkValue}, (DynamicObjectType)entityType);
        return (DynamicObject)ret.get(pkValue);
    }

    public void afterCreateNewData(EventObject e) {
        if (this.canSetISV) {
            this.getModel().setValue(ISV, (Object)ISVService.getISVInfo().getId());
        }
    }

    public static String loadIsv(String entityName, String number) {
        QFilter qFilter = new QFilter(NUMBER, "=", (Object)number);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (QFilter[])qFilters);
        return object == null ? null : object.getString(ISV);
    }

    public static boolean isExist(String entityName, String number) {
        QFilter qFilter = new QFilter(NUMBER, "=", (Object)number);
        QFilter[] qFilters = new QFilter[]{qFilter};
        return QueryServiceHelper.exists((String)entityName, (QFilter[])qFilters);
    }

    public static void buildLog(String formId, String msg, String description) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        logInfo.setBizAppID(BizAppServiceHelp.getAppIdByAppNumber((String)"mdl"));
        logInfo.setBizObjID(formId);
        logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        logInfo.setOpTime(new Date());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(msg);
        logInfo.setOpDescription(description);
        logService.addLog(logInfo);
    }

    protected static void buildLog(String formId, String opNumber, String status, MultiLangEnumBridge description) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        logInfo.setBizAppID(BizAppServiceHelp.getAppIdByAppNumber((String)"mdl"));
        logInfo.setBizObjID(formId);
        logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        logInfo.setOpTime(new Date());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(opNumber, description);
        logInfo.setStatus(status);
        logInfo.setOpDesc(description, new String[0]);
        logInfo.setKeyWord(formId);
        logService.addLog((AppLogInfo)logInfo);
    }

    protected DynamicObject loadSingleFromCache(Object pkValue, String entityType) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityType);
        Map ret = BusinessDataReader.loadFromCache((Object[])new Object[]{pkValue}, (DynamicObjectType)type);
        return (DynamicObject)ret.get(pkValue);
    }

    protected DynamicObject loadSingleFromCache(String entityType, QFilter[] qFilters) {
        Map ret = BusinessDataReader.loadFromCache((String)entityType, (QFilter[])qFilters);
        return ret == null ? null : (ret.values().iterator().hasNext() ? (DynamicObject)ret.values().iterator().next() : null);
    }

    protected Map<String, DynamicObject> loadDataByNumber(String entityType, String[] numberList, Function<String, DynamicObject> saveData) {
        QFilter[] qFilters = new QFilter[]{new QFilter(NUMBER, "in", (Object)numberList)};
        Map data = BusinessDataReader.loadFromCache((String)entityType, (QFilter[])qFilters);
        HashMap<String, DynamicObject> ret = new HashMap<String, DynamicObject>(16);
        for (String[] value : data.values()) {
            ret.put(value.getString(NUMBER), (DynamicObject)value);
        }
        if (saveData != null) {
            ArrayList<DynamicObject> notExistsData = new ArrayList<DynamicObject>(16);
            for (String s : numberList) {
                if (ret.containsKey(s)) continue;
                notExistsData.add(saveData.apply(s));
            }
            if (notExistsData.size() > 0) {
                Object[] saveResults;
                for (Object saveResult : saveResults = SaveServiceHelper.save((DynamicObject[])notExistsData.toArray(new DynamicObject[notExistsData.size()]))) {
                    DynamicObject o = (DynamicObject)saveResult;
                    ret.put(o.getString(NUMBER), o);
                }
            }
        }
        return ret;
    }
}

