/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.domaindefine;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.field.PinYinBaseUtil;
import kd.bos.lang.Lang;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.newdevportal.domaindefine.BaseListPlugin;
import kd.bos.newdevportal.domaindefine.DomainModelTypes;
import kd.bos.newdevportal.domaindefine.XmlDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class DomainTypeListPlugin
extends BaseListPlugin {
    private static final String VIEW = "view";
    private static final String NUMBER = "number";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String MODIFY = "modify";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String ISSYS = "issys";
    private static final String APPLYNUMBER = "applynumber";
    private static final String BOS_DEVP_ELEMENT = "bos_devp_element";
    private static final String EXTEND = "extend";

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (NUMBER.equals(args.getFieldName())) {
            this.showBill(BillOperationStatus.VIEW, true);
            args.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (VIEW.equals(evt.getItemKey())) {
            this.showBill(BillOperationStatus.VIEW, true);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        XmlDataProvider provider = new XmlDataProvider();
        provider.initDataList(this::getDataList);
        args.setListDataProvider((IListDataProvider)provider);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (MODIFY.equals(args.getSource())) {
            args.setCancel(true);
        }
    }

    private List<DynamicObject> getDataList(Predicate<DynamicObject> fileFunc, final DynamicObjectType type, String orderExpr) {
        List<DomainModelType> domainModelTypeList = DomainModelTypes.getDomainModelTypeList();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        QFilter[] filter = new QFilter[]{new QFilter("enable", "=", (Object)"1")};
        DynamicObjectCollection rs = QueryServiceHelper.query((String)BOS_DEVP_ELEMENT, (String)"number,modeltype,applynumber", (QFilter[])filter);
        int i = 0;
        for (DomainModelType domainModelType : domainModelTypeList) {
            DynamicObject row = new DynamicObject(type);
            row.set(ID, (Object)i);
            row.set(NUMBER, (Object)domainModelType.getId());
            row.set(NAME, (Object)domainModelType.getName());
            row.set(ISSYS, (Object)true);
            boolean exists = this.isExists(rs, domainModelType.getId());
            if (exists) {
                row.set(EXTEND, (Object)true);
            }
            list.add(row);
            ++i;
        }
        if (StringUtils.isNotBlank((CharSequence)orderExpr)) {
            final String[] orderBys = orderExpr.split(",");
            list.sort(new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    for (String orderBy : orderBys) {
                        String[] s = orderBy.split(" ");
                        DynamicProperty property = type.getProperty(s[0]);
                        if (property == null) continue;
                        int result = 0;
                        String one = "";
                        String two = "";
                        if (o1.get((IDataEntityProperty)property) instanceof OrmLocaleValue) {
                            if (Lang.get().equals((Object)Lang.zh_CN)) {
                                try {
                                    one = PinYinBaseUtil.converterToSpell((String)o1.getString(s[0]));
                                    two = PinYinBaseUtil.converterToSpell((String)o2.getString(s[0]));
                                }
                                catch (BadHanyuPinyinOutputFormatCombination ex) {
                                    one = o1.getString(s[0]);
                                    two = o2.getString(s[0]);
                                }
                            } else {
                                one = o1.getString(s[0]);
                                two = o2.getString(s[0]);
                            }
                        } else {
                            one = o1.getString(s[0]);
                            two = o2.getString(s[0]);
                        }
                        result = one.compareTo(two);
                        if (result == 0) continue;
                        if (!s[1].equals("asc")) {
                            result = -1 * result;
                        }
                        return result;
                    }
                    return 0;
                }
            });
        }
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(16);
        for (DynamicObject row : list) {
            if (!fileFunc.test(row)) continue;
            resultList.add(row);
        }
        return resultList;
    }

    private boolean isExists(DynamicObjectCollection rs, String modelTypeId) {
        for (DynamicObject row : rs) {
            if (!modelTypeId.equals(row.getString("modeltype")) && !this.isContain(row.getString(APPLYNUMBER), modelTypeId)) continue;
            return true;
        }
        return false;
    }

    private boolean isContain(String modeltypes, String modelType) {
        String[] s;
        for (String t : s = modeltypes.split(",")) {
            if (!modelType.equals(t)) continue;
            return true;
        }
        return false;
    }
}

