/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.domaindefine;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.define.DomainModelTypeFactory;
import kd.bos.newdevportal.domaindefine.DomainDefineBasePlugin;

public class DomainTypePlugIn
extends DomainDefineBasePlugin
implements TabSelectListener {
    private static final String EXTEND = "extend";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String PARENT = "parent";
    private static final String PARENTNUMBER = "parentnumber";
    private static final String TABAP = "tabap";
    private static final String REFRESH = "refresh";
    private static final String OPTYPETAB = "optypetab";
    private static final String FORMRULETAB = "formruletab";
    private static final String ENTITYRULETAB = "entityruletab";
    private static final String VALIDATORTAB = "validatortab";
    private static final String OPBIZTAB = "opbiztab";
    private static final String MODELTYPE = "modeltype";
    private static final String BOS_DEVP_OPLIST = "bos_devp_oplist";
    private static final String METATYPE = "metatype";
    private static final String FORMMETA = "formmeta";
    private static final String BOS_DEVP_RULELIST = "bos_devp_rulelist";
    private static final String ENTITYMETA = "entitymeta";
    private static final String BOS_DEVP_VALIDATIONLIST = "bos_devp_validationlist";
    private static final String BOS_DEVP_OPSERVICELIST = "bos_devp_opservicelist";
    private static final String ELEMENTTYPETAB = "elementtypetab";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tabap = (Tab)this.getView().getControl(TABAP);
        tabap.addTabSelectListener((TabSelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.doFillParent();
        Tab tabap = (Tab)this.getView().getControl(TABAP);
        this.tabSelected(new TabSelectEvent((Object)this, tabap.getCurrentTab()));
    }

    private void doFillParent() {
        String number = (String)this.getView().getFormShowParameter().getCustomParam(NUMBER);
        if (number != null) {
            DomainModelType domainModelType = DomainModelTypeFactory.getDomainModelType((String)number, (boolean)true);
            this.getModel().setValue(EXTEND, (Object)true);
            this.getModel().setValue(NUMBER, (Object)number);
            this.getModel().setValue(NAME, (Object)domainModelType.getName());
            this.getModel().setValue(PARENT, (Object)(number + " - " + domainModelType.getName()));
            this.getModel().setValue(PARENTNUMBER, (Object)number);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (REFRESH.equals(evt.getItemKey())) {
            this.doRefresh();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equals("showinvisible")) {
            this.doRefresh();
        }
    }

    private void doRefresh() {
        this.getView().getPageCache().remove(ELEMENTTYPETAB);
        this.getView().getPageCache().remove(OPTYPETAB);
        this.getView().getPageCache().remove(FORMRULETAB);
        this.getView().getPageCache().remove(ENTITYRULETAB);
        this.getView().getPageCache().remove(VALIDATORTAB);
        this.getView().getPageCache().remove(OPBIZTAB);
        Tab tabap = (Tab)this.getView().getControl(TABAP);
        this.tabSelected(new TabSelectEvent((Object)this, tabap.getCurrentTab()));
        this.doFillParent();
        this.getModel().setDataChanged(false);
    }

    public void tabSelected(TabSelectEvent evt) {
        HashMap<String, Object> params;
        if (ELEMENTTYPETAB.equals(evt.getTabKey())) {
            params = new HashMap<String, Object>();
            params.put(MODELTYPE, this.getModel().getValue(NUMBER));
            params.put("showinvisible", this.getModel().getValue("showinvisible"));
            this.showFormInTab(evt.getTabKey(), "bos_devp_elementtypelist", params);
        }
        if (OPTYPETAB.equals(evt.getTabKey())) {
            params = new HashMap();
            params.put(MODELTYPE, this.getModel().getValue(NUMBER));
            this.showFormInTab(evt.getTabKey(), BOS_DEVP_OPLIST, params);
        }
        if (FORMRULETAB.equals(evt.getTabKey())) {
            params = new HashMap();
            params.put(MODELTYPE, this.getModel().getValue(NUMBER));
            params.put(METATYPE, FORMMETA);
            this.showFormInTab(evt.getTabKey(), BOS_DEVP_RULELIST, params);
        }
        if (ENTITYRULETAB.equals(evt.getTabKey())) {
            params = new HashMap();
            params.put(MODELTYPE, this.getModel().getValue(NUMBER));
            params.put(METATYPE, ENTITYMETA);
            this.showFormInTab(evt.getTabKey(), BOS_DEVP_RULELIST, params);
        }
        if (VALIDATORTAB.equals(evt.getTabKey())) {
            params = new HashMap();
            params.put(MODELTYPE, this.getModel().getValue(NUMBER));
            this.showFormInTab(evt.getTabKey(), BOS_DEVP_VALIDATIONLIST, params);
        }
        if (OPBIZTAB.equals(evt.getTabKey())) {
            params = new HashMap();
            params.put(MODELTYPE, this.getModel().getValue(NUMBER));
            this.showFormInTab(evt.getTabKey(), BOS_DEVP_OPSERVICELIST, params);
        }
    }

    private void showFormInTab(String tabKey, String formId, Map<String, Object> params) {
        String pageId = this.getPageCache().get(tabKey);
        if (pageId != null) {
            return;
        }
        FormShowParameter lsp = new FormShowParameter();
        this.getPageCache().put(tabKey, lsp.getPageId());
        lsp.setFormId(formId);
        lsp.getOpenStyle().setTargetKey(tabKey);
        lsp.getOpenStyle().setShowType(ShowType.InContainer);
        if (params != null) {
            params.forEach((arg_0, arg_1) -> ((FormShowParameter)lsp).setCustomParam(arg_0, arg_1));
        }
        lsp.setParentFormId(this.getView().getFormShowParameter().getFormId());
        this.getView().showForm(lsp);
    }
}

