/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.domaindefine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.instance.Instance;
import kd.bos.isv.ISVService;
import kd.bos.list.events.BillClosedCallBackEvent;
import kd.bos.metadata.domainmodel.Category;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.metadata.domainmodel.define.DomainModelTypeFactory;
import kd.bos.newdevportal.domaindefine.BaseListPlugin;
import kd.bos.newdevportal.domaindefine.DomainDefineBasePlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ElementTypeListPlugIn
extends BaseListPlugin {
    private static final String REFRESH = "refresh";
    private static final String REFRESHSYS = "refreshsys";
    private static final String APPLYNUMBER = "applynumber";
    private static final String BOS_DEVP_ELEMENT = "bos_devp_element";
    private static final String DYNAMIC_FORM_MODEL = "DynamicFormModel";
    private static final String T_DM_ELEMENTTYPE = "t_dm_elementtype";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String CLEARCACHE = "clearcache";
    private static final String DISABLE = "disable";
    private static final String ENABLE = "enable";
    private static final String BOS_DEVP_PROPERPTY = "bos_devp_properpty";
    private static final String ISSYS = "issys";
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String XML_TAG = "xml_tag";
    private static final String BOS_DEVP_ELEMENTCATEGORY = "bos_devp_elementcategory";
    private static final String PACKAGENAME = "packagename";
    private static final String CATEGORY = "category";
    private static final String ENTRYENTITY = "entryentity";
    private static final String PROPERTYNUMBER = "propertynumber";
    private static final String BTNEXTEND = "btnextend";
    private static final String NEW = "new";

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (NEW.equals(evt.getOperationKey())) {
            evt.setCancel(true);
            this.newShowParam();
        }
    }

    private void clearCache(String modelTypeId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy());
        String key = Instance.getClusterName() + "_DomainModelType" + DomainModelType.getVersion() + RequestContext.get().getLang();
        cache.remove(key, modelTypeId);
        DomainModelTypeFactory.removeCache((String)modelTypeId);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (REFRESHSYS.equals(evt.getItemKey())) {
            this.doRefreshSysData();
            this.getView().invokeOperation(REFRESH);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"DomainDefine_12", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
        if (CLEARCACHE.equals(evt.getItemKey())) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            this.doClearCache(selectedRows.getEntryPrimaryKeyValues());
        }
        if (BTNEXTEND.equals(evt.getItemKey())) {
            BaseShowParameter bsp = new BaseShowParameter();
            bsp.setCustomParam("extend", (Object)true);
            bsp.getOpenStyle().setShowType(ShowType.Modal);
            bsp.getOpenStyle().setShowType(ShowType.NewTabPage);
            bsp.getOpenStyle().setTargetKey("_submaintab_");
            bsp.setFormId(BOS_DEVP_ELEMENT);
            bsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTNEXTEND));
            ShowType showType = this.getView().getFormShowParameter().getOpenStyle().getShowType();
            if (this.getView().getMainView() != null || showType == ShowType.NewTabPage) {
                IFormView parentView = this.getView().getParentView();
                parentView.showForm((FormShowParameter)bsp);
                this.getView().sendFormAction(parentView);
            } else {
                bsp.getOpenStyle().setShowType(ShowType.Modal);
                bsp.getOpenStyle().setTargetKey("");
                this.getView().showForm((FormShowParameter)bsp);
            }
        }
    }

    public void billClosedCallBack(BillClosedCallBackEvent e) {
        if (BTNEXTEND.equals(e.getCloseCallBack().getActionId()) && !e.getPkId().equals(0L)) {
            this.getView().invokeOperation(REFRESH);
        }
    }

    private void doClearCache(Object[] pks) {
        Object[] datas;
        for (Object deletData : datas = BusinessDataReader.load((Object[])pks, (IDataEntityType)EntityMetadataCache.getDataEntityType((String)BOS_DEVP_ELEMENT))) {
            String[] domainTypeIds;
            String applyNumber = ((DynamicObject)deletData).getString(APPLYNUMBER);
            if (StringUtils.isBlank((CharSequence)applyNumber)) continue;
            for (String domainTypeId : domainTypeIds = applyNumber.split(",")) {
                if (StringUtils.isBlank((CharSequence)domainTypeId)) continue;
                this.clearCache(domainTypeId);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Delete) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            Iterator iterator = listSelectedData.iterator();
            String currentIsv = ISVService.getISVInfo().getId();
            while (iterator.hasNext()) {
                ListSelectedRow row = (ListSelectedRow)iterator.next();
                String number = row.getNumber();
                boolean exist = DomainDefineBasePlugin.isExist(BOS_DEVP_ELEMENT, number);
                if (!exist) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"ElementTypeListPlugIn_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                String isv = DomainDefineBasePlugin.loadIsv(BOS_DEVP_ELEMENT, number);
                if (currentIsv == null || currentIsv.equals(isv)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5305\u542b\u975e\u5f53\u524d\u5f00\u53d1\u5546\u5143\u7d20\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002", (String)"ElementTypeListPlugIn_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ((DISABLE.equals(args.getOperateKey()) || ENABLE.equals(args.getOperateKey())) && args.getOperationResult().getSuccessPkIds().size() > 0) {
            this.doClearCache(args.getOperationResult().getSuccessPkIds().toArray());
        }
    }

    private <T> String toXml(T t) {
        ArrayList dts = new ArrayList();
        DcxmlSerializer ser = new DcxmlSerializer((DcBinder)new ListDcxmlBinder(true, dts));
        return ser.serializeToString(t, null);
    }

    private Map<String, DynamicObject> doInsertSysProperty(List<ElementType> list) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)BOS_DEVP_PROPERPTY);
        QFilter[] filter = new QFilter[]{new QFilter(ISSYS, "=", (Object)true)};
        DeleteServiceHelper.delete((String)BOS_DEVP_PROPERPTY, (QFilter[])filter);
        ArrayList<DynamicObject> rows = new ArrayList<DynamicObject>(16);
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        int i = 0;
        for (ElementType elementType : list) {
            for (Property property : elementType.getProperties()) {
                if (map.containsKey(property.getPropertyName())) continue;
                DynamicObject row = new DynamicObject((DynamicObjectType)dataEntityType);
                row.set(ID, (Object)i);
                row.set(NUMBER, (Object)property.getPropertyName());
                row.set(NAME, (Object)property.getName());
                Map editor = property.getEditor();
                if (editor != null) {
                    row.set(TYPE, editor.get(TYPE));
                }
                row.set(XML_TAG, (Object)this.toXml(property));
                row.set(ISSYS, (Object)true);
                row.set("isv", (Object)"kingdee");
                rows.add(row);
                ++i;
                map.put(property.getPropertyName(), row);
            }
        }
        SaveServiceHelper.save((DynamicObject[])rows.toArray(new DynamicObject[0]));
        return map;
    }

    private Map<String, DynamicObject> doInsertSysCategory(List<Category> list) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)BOS_DEVP_ELEMENTCATEGORY);
        QFilter[] filter = new QFilter[]{new QFilter(ISSYS, "=", (Object)true)};
        DeleteServiceHelper.delete((String)BOS_DEVP_ELEMENTCATEGORY, (QFilter[])filter);
        ArrayList<DynamicObject> rows = new ArrayList<DynamicObject>(16);
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        int i = 0;
        for (Category category : list) {
            if (map.containsKey(category.getId())) continue;
            DynamicObject row = new DynamicObject((DynamicObjectType)dataEntityType);
            row.set(ID, (Object)i);
            row.set(NUMBER, (Object)category.getId());
            row.set(NAME, (Object)category.getName());
            row.set(XML_TAG, (Object)this.toXml(category));
            row.set(ISSYS, (Object)true);
            rows.add(row);
            ++i;
            map.put(category.getId(), row);
        }
        SaveServiceHelper.save((DynamicObject[])rows.toArray(new DynamicObject[0]));
        return map;
    }

    private void doRefreshSysData() {
        DomainModelType dynamicFormModel = DomainModelTypeFactory.getDomainModelTypeSys((String)DYNAMIC_FORM_MODEL, (boolean)true);
        List categories = dynamicFormModel.getCategories();
        Map<String, DynamicObject> categoryMap = this.doInsertSysCategory(categories);
        ArrayList<ElementType> allElementTypeList = new ArrayList<ElementType>(16);
        for (Category category : categories) {
            allElementTypeList.addAll(category.getElementTypes());
        }
        Map<String, DynamicObject> propertyMap = this.doInsertSysProperty(allElementTypeList);
        QFilter[] filter = new QFilter[]{new QFilter(ISSYS, "=", (Object)true)};
        DeleteServiceHelper.delete((String)BOS_DEVP_ELEMENT, (QFilter[])filter);
        for (Category category : categories) {
            this.doInsertSysElement(category.getElementTypes(), propertyMap, categoryMap.get(category.getId()));
        }
    }

    private void doInsertSysElement(List<ElementType> list, Map<String, DynamicObject> propertyMap, DynamicObject category) {
        DynamicObject[] rows = new DynamicObject[list.size()];
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)BOS_DEVP_ELEMENT);
        long[] longIds = DBServiceHelper.genLongIds((String)T_DM_ELEMENTTYPE, (int)list.size());
        int i = 0;
        for (ElementType elementType : list) {
            DynamicObject row = new DynamicObject((DynamicObjectType)dataEntityType);
            row.set(ID, (Object)longIds[i]);
            row.set(NUMBER, (Object)elementType.getId());
            LocaleString name = elementType.getName();
            row.set(NAME, (Object)name);
            row.set(PACKAGENAME, (Object)elementType.getPackageName());
            row.set(ISSYS, (Object)true);
            row.set(CATEGORY, (Object)category);
            row.set(ENABLE, (Object)1);
            row.set("isv", (Object)"kingdee");
            String xml = this.toXml(elementType);
            row.set(XML_TAG, (Object)xml);
            for (Property property : elementType.getProperties()) {
                DynamicObjectCollection entryentity = row.getDynamicObjectCollection(ENTRYENTITY);
                DynamicObject entryRow = entryentity.addNew();
                entryRow.set(PROPERTYNUMBER, (Object)propertyMap.get(property.getPropertyName()));
                entryRow.set("expand", (Object)true);
            }
            rows[i] = row;
            ++i;
        }
        SaveServiceHelper.save((DynamicObject[])rows);
    }
}

