/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.domaindefine;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.OperationType;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.entity.operate.OperationTypes;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.domainmodel.define.DomainModelTypeFactory;

public class OperatorListPlugin
extends AbstractFormPlugin {
    public static final String ENTRYENTITY = "entryentity";
    public static final String NUMBER = "number";
    public static final String NAME = "name";
    public static final String DESC = "desc";
    public static final String MODELTYPE = "modeltype";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String EVT = "evt";

    private boolean containModelType(Set<String> modelTypes, Set<String> expModelTypes) {
        for (String modelType : modelTypes) {
            if (!expModelTypes.contains(modelType)) continue;
            return true;
        }
        return false;
    }

    public void afterCreateNewData(EventObject e) {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam(MODELTYPE);
        if (modelType != null) {
            OperationTypes operationTypes = OperationTypeCache.loadAll();
            if (modelType.equals("MobileBillFormModel") || modelType.equals("MobileListModel") || modelType.equals("BillListCardViewModel")) {
                modelType = "BillFormModel";
            }
            Set<String> modelTypes = new HashSet();
            if (StringUtils.isNotBlank((CharSequence)modelType)) {
                modelTypes = DomainModelTypeFactory.getParentDomainType((String)modelType);
                modelTypes.add(modelType);
            }
            ArrayList<OperationType> list = new ArrayList<OperationType>(16);
            for (OperationType opType : operationTypes.getOpTypes()) {
                if (opType.isDisable() || !this.containModelType(opType.getModelTypes(), modelTypes)) continue;
                list.add(opType);
            }
            int count = this.getModel().getEntryRowCount(ENTRYENTITY);
            if (count < list.size()) {
                this.getModel().batchCreateNewEntryRow(ENTRYENTITY, list.size() - count);
            }
            int row = 0;
            for (OperationType op : list) {
                this.getModel().setValue(NUMBER, (Object)op.getId(), row);
                this.getModel().setValue(NAME, (Object)op.getName(), row);
                this.getModel().setValue(DESC, (Object)op.getDesc(), row);
                if (StringUtils.isBlank((CharSequence)op.getWebApiClass()) && StringUtils.isBlank((CharSequence)op.getFormServiceClass())) {
                    this.getModel().setValue(EVT, (Object)ResManager.loadKDString((String)"\u524d\u7aef", (String)"DomainDefine_14", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), row);
                } else {
                    this.getModel().setValue(EVT, (Object)ResManager.loadKDString((String)"\u540e\u7aef", (String)"DomainDefine_15", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), row);
                }
                ++row;
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u9875\u9762\u9700\u8981\u4f20\u5165modeltype\u3002", (String)"DomainDefine_13", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
    }
}

