/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.domaindefine;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.newdevportal.domaindefine.PropertyBasePlugin;

public class PropertyDimensionPlugin
extends PropertyBasePlugin {
    private static final String UNITS = "units";
    private static final String UNIT = "unit";
    private static final String DEFAULT = "default";
    private static final String CHECKBOXDEFAULT = "cboxdefault";
    private static final String MM = "mm";
    private static final String PX = "px";
    private static final String PERC = "%";
    private static final String PERCENT = "percent";
    private static final String BLANK = "";

    @Override
    protected void restore(Map<String, Object> editor, DynamicObject dataEntity) {
        JSONArray units;
        String defaultSplice = (String)editor.get(DEFAULT);
        if (StringUtils.isNotEmpty((CharSequence)defaultSplice)) {
            String defaultValue = BLANK;
            if (defaultSplice.contains(PX)) {
                defaultValue = defaultSplice.replace(PX, BLANK);
                dataEntity.set(UNIT, (Object)PX);
            } else if (defaultSplice.contains(PERC)) {
                defaultValue = defaultSplice.replace(PERC, BLANK);
                dataEntity.set(UNIT, (Object)PERC);
            } else if (defaultSplice.contains(MM)) {
                defaultValue = defaultSplice.replace(MM, BLANK);
                dataEntity.set(UNIT, (Object)MM);
            }
            if (StringUtils.isNotBlank((CharSequence)defaultValue)) {
                dataEntity.set(DEFAULT, (Object)Integer.valueOf(defaultValue));
            }
        }
        if (null != (units = (JSONArray)editor.get(UNITS)) && !units.isEmpty()) {
            for (Object unit : units) {
                switch (unit.toString()) {
                    case "px": {
                        dataEntity.set(PX, (Object)true);
                        break;
                    }
                    case "%": {
                        dataEntity.set(PERCENT, (Object)true);
                        break;
                    }
                    case "mm": {
                        dataEntity.set(MM, (Object)true);
                        break;
                    }
                    case "\u9ed8\u8ba4": {
                        dataEntity.set(CHECKBOXDEFAULT, (Object)true);
                    }
                }
            }
        }
        this.checkCurrentIsv(null);
    }

    @Override
    protected Map storage() {
        boolean checkboxDefault;
        boolean checkboxMm;
        boolean checkboxPercent;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Integer defaultValue = dataEntity.getInt(DEFAULT);
        String unitValue = dataEntity.getString(UNIT);
        String defaultSplice = BLANK;
        if (!StringUtils.isBlank((CharSequence)unitValue)) {
            defaultSplice = defaultValue + unitValue;
        }
        ArrayList<String> unitList = new ArrayList<String>(4);
        boolean checkboxPX = dataEntity.getBoolean(PX);
        if (checkboxPX) {
            unitList.add(PX);
        }
        if (checkboxPercent = dataEntity.getBoolean(PERCENT)) {
            unitList.add(PERC);
        }
        if (checkboxMm = dataEntity.getBoolean(MM)) {
            unitList.add(MM);
        }
        if (checkboxDefault = dataEntity.getBoolean(CHECKBOXDEFAULT)) {
            unitList.add(ResManager.loadKDString((String)"\u9ed8\u8ba4", (String)"PropertyDimensionPlugin_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        }
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        if (StringUtils.isNotEmpty((CharSequence)defaultSplice)) {
            map.put(DEFAULT, defaultSplice);
        }
        map.put(UNITS, unitList);
        return map;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if (PX.equalsIgnoreCase(name) || PERCENT.equalsIgnoreCase(name) || MM.equalsIgnoreCase(name)) {
            this.updateUnitCombo();
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.updateUnitCombo();
    }

    private void updateUnitCombo() {
        boolean pxFlag = (Boolean)this.getModel().getValue(PX);
        boolean percentFlag = (Boolean)this.getModel().getValue(PERCENT);
        boolean mmFlag = (Boolean)this.getModel().getValue(MM);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(3);
        if (pxFlag) {
            comboItems.add(new ComboItem(new LocaleString(PX), PX));
        }
        if (percentFlag) {
            comboItems.add(new ComboItem(new LocaleString(PERC), PERC));
        }
        if (mmFlag) {
            comboItems.add(new ComboItem(new LocaleString(MM), MM));
        }
        ComboEdit unit = (ComboEdit)this.getControl(UNIT);
        unit.setComboItems(comboItems);
    }

    @Override
    protected boolean checkData(boolean isClose) {
        boolean pxFlag = (Boolean)this.getModel().getValue(PX);
        boolean percentFlag = (Boolean)this.getModel().getValue(PERCENT);
        boolean mmFlag = (Boolean)this.getModel().getValue(MM);
        if (!(pxFlag || percentFlag || mmFlag)) {
            if (!isClose) {
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5c3a\u5bf8\u5355\u4f4d\u3002", (String)"PropertyDimensionPlugin_1", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            }
            return false;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String unitValue = dataEntity.getString(UNIT);
        if (StringUtils.isBlank((CharSequence)unitValue)) {
            this.getModel().setValue(DEFAULT, null);
        }
        return true;
    }
}

