/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.domaindefine;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.isv.ISVService;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.newdevportal.domaindefine.DomainDefineBasePlugin;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;

public class PropertyPlugin
extends DomainDefineBasePlugin {
    public static final String TYPE = "type";
    public static final String TARGET_KEY = "panelpropertydefine";
    public static final String PARM_XML = "xml";
    public static final String XML_TAG = "xml_tag";
    public static final String SAVE = "save";
    private static final String BOS_DEVP_PROPERTY = "bos_devp_properpty";

    public PropertyPlugin() {
        this.canSetISV = true;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object xml = this.getView().getFormShowParameter().getCustomParam(PARM_XML);
        if (xml != null) {
            Property property = new Property();
            this.fromXML((String)xml, property);
            this.getModel().setValue("number", (Object)property.getPropertyName());
            this.getModel().setValue("name", (Object)property.getName());
            this.getModel().setValue("desc", (Object)property.getDescription());
            this.getModel().setValue(PARM_XML, xml);
            Map editor = property.getEditor();
            if (editor != null) {
                this.getModel().setValue(TYPE, editor.get(TYPE));
                this.showPropertyConfig((String)editor.get(TYPE), property.getEditor());
            } else {
                this.getModel().setValue(TYPE, (Object)"");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (TYPE.equals(e.getProperty().getName())) {
            this.showPropertyConfig((String)this.getModel().getValue(TYPE), null);
        }
    }

    public void afterBindData(EventObject e) {
        Object xml;
        super.afterBindData(e);
        if (Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam("viewmode"))) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).removeAction("setFormStatus");
            this.getView().setStatus(OperationStatus.VIEW);
        }
        if ((xml = this.getView().getFormShowParameter().getCustomParam(PARM_XML)) != null || "EDIT".equals(this.getView().getFormShowParameter().getStatus().name())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"name"});
            this.getView().setEnable(Boolean.FALSE, new String[]{TYPE});
            this.getView().setEnable(Boolean.FALSE, new String[]{"desc"});
        }
        this.checkCurrentIsv(null);
    }

    public void afterLoadData(EventObject e) {
        String xml = (String)this.getModel().getValue(XML_TAG);
        Property property = new Property();
        property = this.fromXML(xml, property);
        this.showPropertyConfig((String)this.getModel().getValue(TYPE), property.getEditor());
    }

    private boolean isModifyMode() {
        return this.getView().getFormShowParameter().getCustomParam(PARM_XML) != null;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (SAVE.equals(evt.getItemKey())) {
            if (!this.isModifyMode() && !this.checkNumber()) {
                evt.setCancel(true);
                return;
            }
            if (!this.createXML(false)) {
                evt.setCancel(true);
                return;
            }
            if (this.isModifyMode() && !this.checkAttribute()) {
                evt.setCancel(true);
                return;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String isv = ISVService.getISVInfo().getId();
        if (isv.equals(this.getModel().getValue("isv")) && !Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam("viewmode"))) {
            this.createXML(true);
        }
        super.beforeClosed(e);
    }

    private boolean createXML(Boolean isClose) {
        IFormView lastConfigView = this.getLastConfigView();
        if (lastConfigView != null) {
            FormViewPluginProxy proxy = (FormViewPluginProxy)lastConfigView.getService(FormViewPluginProxy.class);
            CustomEventArgs args = new CustomEventArgs((Object)this, "editor", "read", isClose.toString());
            proxy.fireCustomEvent(args);
            this.getView().sendFormAction(lastConfigView);
            String editor = (String)lastConfigView.getModel().getDataEntity().get("editor");
            if (StringUtils.isBlank((CharSequence)editor)) {
                return false;
            }
            String xml = this.toXml();
            this.getModel().setValue(XML_TAG, (Object)xml);
        }
        return true;
    }

    private IFormView getLastConfigView() {
        IPageCache pageCache = this.getView().getPageCache();
        String lastPageId = pageCache.get("lastpage");
        if (lastPageId != null) {
            IFormView view = this.getView().getView(lastPageId);
            return view;
        }
        return null;
    }

    private void showPropertyConfig(String type, Map<String, Object> editor) {
        String formId = "";
        switch (type) {
            case "combo": {
                formId = "bos_devp_property_combo";
                break;
            }
            case "mcombo": {
                formId = "bos_devp_property_mcombo";
                break;
            }
            case "text": {
                formId = "bos_devp_property_text";
                break;
            }
            case "dimension": {
                formId = "bos_devp_property_dimensi";
                break;
            }
            case "checkbox": {
                formId = "bos_devp_property_cbox";
                break;
            }
            case "color": {
                formId = "bos_devp_property_color";
                break;
            }
            case "slider": {
                formId = "bos_devp_property_slider";
                break;
            }
            case "integer": {
                formId = "bos_devp_property_integer";
                break;
            }
            case "refcombo": {
                formId = "bos_devp_property_refcomb";
                break;
            }
            case "btnedit": {
                formId = "bos_devp_property_btnedit";
                break;
            }
            case "ecombo": {
                formId = "bos_devp_property_ecmobo";
                break;
            }
            case "date": {
                formId = "bos_devp_property_date";
                break;
            }
            case "daterange": {
                formId = "bos_devp_property_dtrange";
                break;
            }
            case "decimal": {
                formId = "bos_devp_property_decimal";
                break;
            }
            case "position": {
                formId = "bos_devp_property_positio";
                break;
            }
            case "radius": {
                formId = "bos_devp_property_radius";
            }
        }
        IPageCache pageCache = this.getView().getPageCache();
        if (!"".equals(formId)) {
            IFormView view;
            String lastPageId = pageCache.get("lastpage");
            if (lastPageId != null && (view = this.getView().getView(lastPageId)) != null) {
                String data = DynamicObjectSerializeUtil.serialize((Object[])new Object[]{view.getModel().getDataEntity(true)}, (DynamicObjectType)view.getModel().getDataEntityType());
                pageCache.put(lastPageId, data);
                view.close();
                this.getView().sendFormAction(view);
            }
            FormShowParameter parameter = new FormShowParameter();
            String pageId = type + formId + this.getView().getPageId();
            parameter.setPageId(pageId);
            parameter.setFormId(formId);
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.InContainer);
            openStyle.setTargetKey(TARGET_KEY);
            String isv = (String)this.getModel().getValue("isv");
            String data = pageCache.get(pageId);
            parameter.setCustomParam("data", (Object)data);
            if (editor != null) {
                parameter.setCustomParam("editor", editor);
            }
            parameter.setCustomParam("isv", (Object)isv);
            parameter.setOpenStyle(openStyle);
            this.getView().showForm(parameter);
            pageCache.put("lastpage", pageId);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (SAVE.equals(operate.getOperateKey()) && this.isModifyMode()) {
            this.getModel().setDataChanged(false);
            this.getView().returnDataToParent(this.getModel().getValue(XML_TAG));
            args.setCancel(true);
            this.getView().close();
        }
    }

    private boolean checkAttribute() {
        String number = (String)this.getModel().getValue("number");
        if (number == null || StringUtils.isBlank((CharSequence)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"PropertyPlugin_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return false;
        }
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        if (name == null || name.isEmpty() || StringUtils.isBlank((CharSequence)name.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"PropertyPlugin_1", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return false;
        }
        String type = (String)this.getModel().getValue(TYPE);
        if (type == null || StringUtils.isBlank((CharSequence)type)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"PropertyPlugin_2", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private String toXml() {
        Property p = new Property();
        p.setPropertyName((String)this.getModel().getValue("number"));
        p.setName(this.getLocaleString("name"));
        p.setDescription(this.getLocaleString("desc"));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(TYPE, this.getModel().getValue(TYPE));
        IFormView lastConfigView = this.getLastConfigView();
        if (lastConfigView != null) {
            FormViewPluginProxy proxy = (FormViewPluginProxy)lastConfigView.getService(FormViewPluginProxy.class);
            CustomEventArgs args = new CustomEventArgs((Object)this, "editor", "read", "");
            proxy.fireCustomEvent(args);
            String editor = (String)lastConfigView.getModel().getDataEntity().get("editor");
            map.putAll((Map)SerializationUtils.fromJsonString((String)editor, Map.class));
        }
        p.setEditor(map);
        return this.toXml(p, null);
    }
}

