/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.domaindefine;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.newdevportal.domaindefine.PropertyBasePlugin;
import kd.bos.util.StringUtils;

public class PropertyRefComboPlugin
extends PropertyBasePlugin {
    private static final String REF = "ref";
    private static final String DISPLAY_ITEM = "displayItem";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String CAPTION = "caption";
    private static final String ELEMENT = "element";
    private static final String TYPE = "type";
    private static final String META_TYPE = "metatype";
    private static final String META_RANGE = "range";
    private static final String ENTITY_META = "entitymeta";
    private static final String FORM_META = "formmeta";
    private static final String ENTITY_ROOT = "entityrootitem";
    private static final String FORM_ROOT = "formrootitem";
    private static final String ENTITY_PARENT = "entityparentitem";
    private static final String FORM_PARENT = "formparentitem";
    private static final String CURRENT = "current";
    private static final String ROOT = "root";
    private static final String PARENT = "parent";
    private static final String FORM = "form";
    private static final String ENTITY = "entity";

    @Override
    protected void restore(Map<String, Object> editor, DynamicObject dataEntity) {
        JSONObject ref = (JSONObject)editor.get(REF);
        if (null != ref) {
            dataEntity.set(ELEMENT, ref.get((Object)NAME));
            JSONObject displayItem = (JSONObject)ref.get((Object)DISPLAY_ITEM);
            dataEntity.set(CAPTION, displayItem.get((Object)CAPTION));
            dataEntity.set(VALUE, displayItem.get((Object)VALUE));
            String type = (String)ref.get((Object)TYPE);
            if (type != null) {
                List<String> info = this.typeInfo(type);
                dataEntity.set(META_TYPE, (Object)info.get(0));
                dataEntity.set(META_RANGE, (Object)info.get(1));
            }
        }
        this.checkCurrentIsv(null);
    }

    @Override
    protected Map storage() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        HashMap map = new HashMap(1);
        String element = dataEntity.getString(ELEMENT);
        String caption = dataEntity.getString(CAPTION);
        String value = dataEntity.getString(VALUE);
        HashMap<String, String> displayItem = new HashMap<String, String>(2);
        displayItem.put(CAPTION, caption);
        displayItem.put(VALUE, value);
        HashMap<String, Object> ref = new HashMap<String, Object>(8);
        ref.put(NAME, element);
        ref.put(DISPLAY_ITEM, displayItem);
        String type = this.refComBoType();
        if (type != null) {
            ref.put(TYPE, type);
        }
        map.put(REF, ref);
        return map;
    }

    private List<String> typeInfo(String type) {
        ArrayList<String> info = new ArrayList<String>(2);
        if (type.contains(ENTITY)) {
            info.add(ENTITY_META);
            switch (type) {
                case "entitymeta": {
                    info.add(CURRENT);
                    break;
                }
                case "entityrootitem": {
                    info.add(ROOT);
                    break;
                }
                case "entityparentitem": {
                    info.add(PARENT);
                    break;
                }
            }
        } else {
            info.add(FORM_META);
            switch (type) {
                case "formmeta": {
                    info.add(CURRENT);
                    break;
                }
                case "formrootitem": {
                    info.add(ROOT);
                    break;
                }
                case "formparentitem": {
                    info.add(PARENT);
                    break;
                }
            }
        }
        return info;
    }

    private String refComBoType() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String metaType = dataEntity.getString(META_TYPE);
        String range = dataEntity.getString(META_RANGE);
        String type = null;
        if (metaType == null || range == null) {
            return null;
        }
        if (ENTITY_META.equals(metaType)) {
            switch (range) {
                case "current": {
                    type = ENTITY_META;
                    break;
                }
                case "root": {
                    type = ENTITY_ROOT;
                    break;
                }
                case "parent": {
                    type = ENTITY_PARENT;
                    break;
                }
            }
        } else {
            switch (range) {
                case "current": {
                    type = FORM_META;
                    break;
                }
                case "root": {
                    type = FORM_ROOT;
                    break;
                }
                case "parent": {
                    type = FORM_PARENT;
                    break;
                }
            }
        }
        return type;
    }

    @Override
    protected boolean checkData(boolean isClose) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String element = dataEntity.getString(ELEMENT);
        String caption = dataEntity.getString(CAPTION);
        String value = dataEntity.getString(VALUE);
        String metaType = dataEntity.getString(META_TYPE);
        String range = dataEntity.getString(META_RANGE);
        if (StringUtils.isBlank((String)element)) {
            if (!isClose) {
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5c5e\u6027\u7f16\u7801\u3002", (String)"PropertyRefComboPlugin_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            }
            return false;
        }
        if (StringUtils.isBlank((String)caption)) {
            if (!isClose) {
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5f15\u7528\u6807\u9898\u3002", (String)"PropertyRefComboPlugin_1", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            }
            return false;
        }
        if (StringUtils.isBlank((String)value)) {
            if (!isClose) {
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5f15\u7528\u503c\u3002", (String)"PropertyRefComboPlugin_2", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            }
            return false;
        }
        if (StringUtils.isBlank((String)metaType)) {
            if (!isClose) {
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u67e5\u8be2\u5143\u6570\u636e\u7c7b\u578b\u3002", (String)"PropertyRefComboPlugin_4", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            }
            return false;
        }
        if (StringUtils.isBlank((String)range)) {
            if (!isClose) {
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u67e5\u8be2\u8303\u56f4\u3002", (String)"PropertyRefComboPlugin_5", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            }
            return false;
        }
        Pattern pattern = Pattern.compile("^[a-zA-Z0-9]+[a-zA-Z0-9_]*$");
        if (!pattern.matcher(element).matches()) {
            if (!isClose) {
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u5c5e\u6027\u7f16\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\u3002\u7f16\u7801\u5fc5\u987b\u4ee5\u5b57\u6bcd\u548c\u6570\u5b57\u5f00\u5934\u4e14\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"PropertyRefComboPlugin_3", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }
}

