/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.domaindefine;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.OperationType;
import kd.bos.entity.operate.OperationTypes;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.operation.OperationTypeLoader;
import kd.bos.metadata.entity.validation.ValidationType;
import kd.bos.metadata.entity.validation.ValidationTypeLoader;
import kd.bos.metadata.entity.validation.ValidationTypes;

public class ValidationListPlugin
extends AbstractFormPlugin {
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String OPWHITELIST = "opwhitelist";
    private static final String OPBLACKLIST = "opblacklist";
    private static final String MODELTYPE = "modeltype";
    private static final String ENTRYENTITY = "entryentity";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String DESC = "desc";
    private static final String LEVEL = "level";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationTypes operationTypes = OperationTypeLoader.loadAll();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        for (OperationType opType : operationTypes.getOpTypes()) {
            if (opType.isDisable()) continue;
            ComboItem item = new ComboItem(opType.getName(), opType.getId());
            items.add(item);
        }
        MulComboEdit ctl = (MulComboEdit)this.getControl(OPWHITELIST);
        if (ctl != null) {
            ctl.setComboItems(items);
        }
        if ((ctl = (MulComboEdit)this.getControl(OPBLACKLIST)) != null) {
            ctl.setComboItems(items);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam(MODELTYPE);
        if (modelType != null) {
            ValidationTypes validationTypes = ValidationTypeLoader.load();
            ArrayList<ValidationType> list = new ArrayList<ValidationType>(16);
            for (ValidationType type : validationTypes.getTypes()) {
                if (type.isDisabled() || !this.contains(type.getOpWhiteList(), modelType, true) && this.contains(type.getOpBlackList(), modelType, false)) continue;
                list.add(type);
            }
            int count = this.getModel().getEntryRowCount(ENTRYENTITY);
            if (count < list.size()) {
                this.getModel().batchCreateNewEntryRow(ENTRYENTITY, list.size() - count);
            }
            int row = 0;
            for (ValidationType op : list) {
                this.getModel().setValue(NUMBER, (Object)op.getId(), row);
                this.getModel().setValue(NAME, (Object)op.getName(), row);
                this.getModel().setValue(DESC, (Object)op.getDesc(), row);
                this.getModel().setValue(LEVEL, (Object)(StringUtils.isBlank((CharSequence)op.getErrorLevel()) ? "-" : op.getErrorLevel()), row);
                this.getModel().setValue(OPWHITELIST, (Object)op.getOpWhiteList(), row);
                this.getModel().setValue(OPBLACKLIST, (Object)op.getOpBlackList(), row);
                ++row;
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u9875\u9762\u9700\u8981\u4f20\u5165modeltype\u3002", (String)"DomainDefine_13", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
    }

    private boolean contains(String list, String text, boolean blankTrue) {
        String[] ss;
        if (StringUtils.isBlank((CharSequence)list)) {
            return blankTrue;
        }
        HashSet<String> set = new HashSet<String>(16);
        for (String s : ss = list.split(",")) {
            if (StringUtils.isBlank((CharSequence)s)) continue;
            set.add(s);
        }
        return set.contains(text);
    }
}

