/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.domaindefine;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.QueryBuilderFactory;
import kd.bos.newdevportal.domaindefine.OutDataSupplier;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;

public class XmlDataProvider
extends ListDataProvider {
    private static final Log log = LogFactory.getLog(XmlDataProvider.class);
    private static final String FSEQ = "fseq";
    private OutDataSupplier<Predicate<DynamicObject>, DynamicObjectType, String, List<DynamicObject>> dataSupplier;
    private List<DynamicObject> cacheDataList = null;
    private boolean isSelectedAllRows;
    private boolean defaultOrder = true;

    public void initDataList(OutDataSupplier<Predicate<DynamicObject>, DynamicObjectType, String, List<DynamicObject>> dataSupplier) {
        this.dataSupplier = dataSupplier;
    }

    public void setDefaultOrder(boolean defaultOrder) {
        super.setDefaultOrder(defaultOrder);
        this.defaultOrder = defaultOrder;
    }

    protected void setSelectedAllRows(boolean isSelectedAllRows) {
        super.setSelectedAllRows(isSelectedAllRows);
        this.isSelectedAllRows = isSelectedAllRows;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        if (this.isSelectedAllRows && this.isOnlyPK4SelectedAllRows()) {
            this.setListFields(this.getPKFields());
            this.setKeyFields(this.getPKFields());
        }
        QueryBuilder thisQueryBuilder = QueryBuilderFactory.createQueryBuilder((IListDataProvider)this, (int)start, (int)limit, (boolean)false, (boolean)this.isSelectedAllRows, (boolean)this.defaultOrder);
        thisQueryBuilder.setSelectedAllRows(this.isSelectedAllRows);
        this.setQueryBuilder(thisQueryBuilder);
        DynamicObjectCollection rows = this.getOutData(start, limit);
        if (rows.size() < limit) {
            if (rows.isEmpty()) {
                List<DynamicObject> dataList = this.getDataList();
                start -= dataList.size();
            } else {
                start = 0;
            }
            DynamicObjectCollection dbRows = super.getData(start, limit - rows.size());
            rows.addAll((Collection)dbRows);
        }
        int seq = start;
        for (DynamicObject row : rows) {
            row.set(FSEQ, (Object)seq++);
        }
        this.getQueryResult().setCollection(rows);
        return rows;
    }

    private DynamicObjectCollection getOutData(int start, int limit) {
        DynamicObjectCollection rows = new DynamicObjectCollection(this.getQueryBuilder().getReturnEntityType(), null);
        List<DynamicObject> dataList = this.getDataList();
        for (int i = start; i < start + limit && i < dataList.size(); ++i) {
            DynamicObject row = new DynamicObject(rows.getDynamicObjectType());
            for (IDataEntityProperty property : rows.getDynamicObjectType().getProperties()) {
                if (dataList.get(i).getDynamicObjectType().getProperties().get((Object)property.getName()) == null) continue;
                property.setValue((Object)row, dataList.get(i).get(property.getName()));
            }
            rows.add((Object)row);
        }
        return rows;
    }

    private List<DynamicObject> getDataList() {
        if (this.cacheDataList == null) {
            this.cacheDataList = this.dataSupplier.apply(this::isFilter, (DynamicObjectType)this.getEntityType(), this.getOrderByExpr());
        }
        return this.cacheDataList;
    }

    public boolean isExceedMaxCount() {
        return this.getMaxCount() > this.getMaxReturnData();
    }

    public int getBillDataCount() {
        List<DynamicObject> dataList = this.getDataList();
        return dataList.size() + super.getBillDataCount();
    }

    public int getMaxCount() {
        List<DynamicObject> dataList = this.getDataList();
        return dataList.size() + super.getMaxCount();
    }

    public int getRealCount() {
        List<DynamicObject> dataList = this.getDataList();
        return dataList.size() + super.getRealCount();
    }

    private boolean isFilter(DynamicObject data) {
        log.info(String.format("XmlDataProvider filters: %s", Arrays.asList(this.getQueryBuilder().getFilters())));
        for (QFilter qFilter : this.getQueryBuilder().getFilters()) {
            boolean value = this.isOneFilter(data, qFilter);
            if (value) continue;
            return false;
        }
        return true;
    }

    private boolean isOneFilter(DynamicObject data, QFilter qFilter) {
        IDataEntityProperty property;
        String qFilterProperty = qFilter.getProperty();
        if (!StringUtils.equals((CharSequence)"1", (CharSequence)qFilterProperty) && (property = (IDataEntityProperty)data.getDataEntityType().getProperties().get((Object)qFilter.getProperty())) == null) {
            return false;
        }
        switch (qFilter.getCP().toLowerCase()) {
            case "ftlike": {
                return this.isFTLikeFilter(data, qFilter);
            }
            case "=": {
                if (StringUtils.equals((CharSequence)"1", (CharSequence)qFilterProperty)) {
                    return true;
                }
                if (qFilter.getValue().equals(QEmptyValue.value)) {
                    return data.get(qFilter.getProperty()) == null || data.get(qFilter.getProperty()).equals("");
                }
                return this.isEqual(data.get(qFilter.getProperty()), qFilter.getValue());
            }
            case "!=": 
            case "<>": {
                if (StringUtils.equals((CharSequence)"1", (CharSequence)qFilterProperty)) {
                    return false;
                }
                if (qFilter.getValue().equals(QEmptyValue.value)) {
                    return data.get(qFilter.getProperty()) != null || !data.get(qFilter.getProperty()).equals("");
                }
                return !this.isEqual(data.get(qFilter.getProperty()), qFilter.getValue());
            }
            case "is not null": {
                return !StringUtils.isBlank((Object)data.get(qFilter.getProperty()));
            }
            case "in": {
                List value = (List)qFilter.getValue();
                return this.inCompare(data.get(qFilter.getProperty()), value, false);
            }
            case "not in": {
                List value = (List)qFilter.getValue();
                return this.inCompare(data.get(qFilter.getProperty()), value, true);
            }
            case "like": {
                return this.likeCompare(data.get(qFilter.getProperty()), (String)qFilter.getValue(), false);
            }
            case "not like": {
                return this.likeCompare(data.get(qFilter.getProperty()), (String)qFilter.getValue(), true);
            }
        }
        throw new KDException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"%s\u4e0d\u652f\u6301\u6bd4\u8f83\u7b26\u53f7\u3002", (String)"XmlDataProvider_0", (String)"bos-devportal-new-plugin", (Object[])new Object[]{qFilter.getCP()})});
    }

    private boolean isFTLikeFilter(DynamicObject data, QFilter qFilter) {
        String filterValue = (String)qFilter.getValue();
        String[] nameValues = filterValue.split("#");
        if (nameValues.length != 2) {
            return true;
        }
        String[] names = nameValues[0].split(",");
        String[] values = nameValues[1].split("\b");
        boolean isOk = false;
        for (String name : names) {
            for (String value : values) {
                if (!this.contains(data.get(name), value)) continue;
                isOk = true;
                break;
            }
            if (isOk) break;
        }
        return isOk;
    }

    private boolean contains(Object data, Object value) {
        if (data instanceof Boolean) {
            return ((Boolean)data != false ? "1" : "0").contains(value.toString());
        }
        return data.toString().toLowerCase().contains(value.toString().toLowerCase());
    }

    private boolean isEqual(Object data, Object value) {
        if (data instanceof Boolean) {
            return ((Boolean)data != false ? "1" : "0").equals(value.toString());
        }
        if (data instanceof ILocaleString) {
            return ((ILocaleString)data).getLocaleValue().equals(value);
        }
        return data.equals(value);
    }

    private boolean startsWith(Object data, Object value) {
        if (data instanceof Boolean) {
            return ((Boolean)data != false ? "1" : "0").equals(value.toString());
        }
        return data.toString().startsWith(value.toString());
    }

    private boolean endsWith(Object data, Object value) {
        if (data instanceof Boolean) {
            return ((Boolean)data != false ? "1" : "0").equals(value.toString());
        }
        return data.toString().endsWith(value.toString());
    }

    private boolean inCompare(Object data, List<?> value, boolean reverse) {
        if (data == null) {
            return false;
        }
        boolean result = false;
        for (Object o : value) {
            if (!this.contains(data, o)) continue;
            result = true;
            break;
        }
        return !reverse == result;
    }

    private boolean likeCompare(Object data, String value, boolean reverse) {
        if (data == null) {
            return false;
        }
        boolean left = false;
        if (value.startsWith("%")) {
            left = true;
            value = value.substring(1);
        }
        boolean right = false;
        if (value.endsWith("%")) {
            right = true;
            value = value.substring(0, value.length() - 1);
        }
        boolean result = left && right ? this.contains(data, value) : (right ? this.startsWith(data, value) : this.endsWith(data, value));
        return !reverse == result;
    }
}

