/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.domaindefine.service;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.FunCall;
import kd.bos.newdevportal.domaindefine.service.ExtSaveIsvValidator;

public class BillFunctionSavePlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("defformula");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ExtSaveIsvValidator());
        e.addValidator((AbstractValidator)new FormulaSyntaxValidator());
    }

    public static class FormulaSyntaxValidator
    extends AbstractValidator {
        public void validate() {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                String number = (String)dataEntity.getValue("number");
                String defFormula = (String)dataEntity.getValue("defformula");
                if (StringUtils.isBlank((CharSequence)defFormula)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u3010\u9ed8\u8ba4\u8868\u8fbe\u5f0f\u3011\u5b57\u6bb5\u5fc5\u5f55\u3002", (String)"BillFunctionSavePlugin_01", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
                    continue;
                }
                try {
                    Expr expr = FormulaEngine.parseFormula((String)defFormula);
                    if (!(expr instanceof FunCall) || StringUtils.equalsIgnoreCase((CharSequence)((FunCall)expr).getName(), (CharSequence)number)) continue;
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9ed8\u8ba4\u8868\u8fbe\u5f0f\u3010%1$s\u3011\u672a\u5305\u542b\u51fd\u6570\u7f16\u7801\u3010%2$s\u3011\uff0c\u53ef\u80fd\u4f1a\u5bfc\u81f4\u8fd0\u884c\u65f6\u627e\u4e0d\u5230\u51fd\u6570\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58\u3002", (String)"BillFunctionSavePlugin_02", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), defFormula, number), ErrorLevel.Warning);
                }
                catch (RuntimeException ex) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9ed8\u8ba4\u8868\u8fbe\u5f0f\u3010%1$s\u3011\u8bed\u6cd5\u9519\u8bef\uff0c\u89e3\u6790\u5931\u8d25\u3002", (String)"BillFunctionSavePlugin_03", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), defFormula));
                }
            }
        }
    }
}

