/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.dynamicform;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.CacheKeyUtil;

public class AppFunctionCacheUtils {
    private static final String DEVPORTAL_NEW_APP_FUNCTION = "DEVPORTAL_NEW_APP_FUNCTION";
    private static final int TIMEOUT = 60;
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("DEVPORTAL_NEW_APP_FUNCTION", new DistributeCacheHAPolicy());

    protected static void putToCache(String bizAppId, Object appFunctions) {
        String rootCacheKey = AppFunctionCacheUtils.getRootCacheKey();
        String key = AppFunctionCacheUtils.genBlackListCacheKey(bizAppId);
        AppFunctionCacheUtils.putToCache(rootCacheKey, key, SerializationUtils.toJsonString((Object)appFunctions));
    }

    private static void putToCache(String type, String key, String data) {
        cache.put(type, key, data, 60);
    }

    protected static String getFromCache(String bizAppId) {
        String type = AppFunctionCacheUtils.getRootCacheKey();
        String key = AppFunctionCacheUtils.genBlackListCacheKey(bizAppId);
        return (String)ThreadCache.get((Object)(type + "." + key), () -> (String)cache.get(type, key));
    }

    private static String getRootCacheKey() {
        return String.format("%s_%s", CacheKeyUtil.getAcctId(), DEVPORTAL_NEW_APP_FUNCTION);
    }

    private static String genBlackListCacheKey(String key) {
        return (key + ".cache_key").toLowerCase();
    }

    public static void removeCache() {
        String type = AppFunctionCacheUtils.getRootCacheKey();
        cache.remove(type);
    }

    protected static void removeCache(String bizAppId) {
        String type = AppFunctionCacheUtils.getRootCacheKey();
        String key = AppFunctionCacheUtils.genBlackListCacheKey(bizAppId);
        cache.remove(type, key);
    }
}

