/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.entity;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.designer.property.alias.IPropertyConverter;
import kd.bos.designer.property.alias.PropertyConverterFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.FormDesigner;
import kd.bos.form.control.events.PropertyEvent;
import kd.bos.form.control.events.PropertyListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.domainmodel.DomainModelType;

public class AbstractEntityDesignerPlugin
extends AbstractFormPlugin
implements PropertyListener {
    public static final String BOS_MOBILEPREVIEW = "bos_mobilepreview";
    public static final String FORM_ID = "formId";
    public static final String PARAM_FORM = "form";
    public static final String PARAM_VALUE = "value";
    public static final String PARAM_CONTEXT = "context";
    public static final String PARAM_ITEM = "item";
    public static final String PARAM_ITEM_ID = "itemId";
    public static final String PARAM_MODEL_TYPE = "modelType";
    public static final String PARAM_META_TYPE = "metaType";
    public static final String PARAM_PROPERTY_NAME = "propertyName";
    public static final String PARAM_DESIGNER_MODEL_TYPE = "designermodeltype";
    public static final String PARAM_PROPERTY_EDIT = "propertyEdit";
    public static final String PREFIX_MOB = "Mob";
    public static final String PARAM_DESIGNER_PAGEID = "designerPageId";
    public static final String PARAM_MODEL_TYPE_1 = "modeltype";
    private static String designerKey = "formdesigner";
    private static final String PREVIEWLANG = "preview_lang";

    protected String getDesignerKey() {
        return designerKey;
    }

    public void registerListener(EventObject e) {
        FormDesigner designer = (FormDesigner)this.getView().getControl(this.getDesignerKey());
        designer.addPropertyButtonClickListener((PropertyListener)this);
    }

    private FormShowParameter createListShowParameter(Map<String, Object> openParameter) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(openParameter.get(FORM_ID).toString());
        showParameter.setCustomParam("selectaction", (Object)"FieldEdit");
        StyleCss css = new StyleCss();
        if (openParameter.containsKey("width")) {
            css.setWidth(openParameter.get("width").toString());
        } else {
            css.setWidth("960px");
        }
        if (openParameter.containsKey("height")) {
            css.setWidth(openParameter.get("height").toString());
        } else {
            css.setHeight("580px");
        }
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)openParameter.get(FORM_ID).toString());
        showParameter.setFormId(formConfig.getF7ListFormId());
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setLookUp(true);
        boolean isMultiSelect = false;
        if (openParameter.containsKey("multiSelect") && openParameter.get("multiSelect").equals("true")) {
            isMultiSelect = true;
        }
        showParameter.setMultiSelect(isMultiSelect);
        showParameter.setShowTitle(false);
        if (openParameter.containsKey(PARAM_MODEL_TYPE_1)) {
            String formPara = openParameter.get(PARAM_MODEL_TYPE_1).toString();
            showParameter.setCustomParam(PARAM_MODEL_TYPE_1, (Object)formPara);
        } else if (openParameter.containsKey("listStyle")) {
            showParameter.setLookUp(false);
            showParameter.setFormId(formConfig.getListFormId());
        }
        return showParameter;
    }

    public void click(PropertyEvent e) {
        PropertyEditHelper.cachePropEventParam((IFormView)this.getView(), (PropertyEvent)e);
        Map clickParam = e.getParam();
        if (clickParam.containsKey("type") && "del".equalsIgnoreCase((String)clickParam.get("type"))) {
            this.deleteRefField(e);
        } else {
            Map openParameter = (Map)clickParam.get(PARAM_FORM);
            FormShowParameter showParameter = openParameter.containsKey("showType") && openParameter.get("showType").equals("ListType") ? this.createListShowParameter(openParameter) : FormShowParameter.createFormShowParameter((Map)openParameter);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam(PARAM_ITEM_ID, (Object)e.getItemId());
            showParameter.setCustomParam(PARAM_DESIGNER_PAGEID, (Object)this.getView().getPageId());
            showParameter.setCustomParam(PARAM_MODEL_TYPE, (Object)this.getPageCache().get(PARAM_MODEL_TYPE));
            showParameter.setCustomParam(PARAM_META_TYPE, (Object)e.getMetaType());
            showParameter.setCustomParam(PARAM_PROPERTY_NAME, (Object)e.getPropertName());
            showParameter.setCustomParam(PARAM_VALUE, e.getParam().get(PARAM_VALUE));
            showParameter.setCustomParam(PARAM_CONTEXT, e.getParam().get(PARAM_CONTEXT));
            showParameter.setParentFormId(this.getPageCache().get("openformid"));
            if (openParameter.containsKey(PARAM_DESIGNER_MODEL_TYPE)) {
                showParameter.setClientParam(PARAM_MODEL_TYPE, openParameter.get(PARAM_DESIGNER_MODEL_TYPE));
                showParameter.setClientParam("modelver", (Object)DomainModelType.getVersion());
            }
            String bizappid = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
            showParameter.setCustomParam("bizappid", (Object)bizappid);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, PARAM_PROPERTY_EDIT);
            closeCallBack.setControlKey(((Control)e.getSource()).getKey());
            showParameter.setCloseCallBack(closeCallBack);
            this.beforeShowPropertyEdit(e, showParameter);
            this.getView().showForm(showParameter);
        }
    }

    protected void beforeShowPropertyEdit(PropertyEvent e, FormShowParameter showParameter) {
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (PARAM_PROPERTY_EDIT.equalsIgnoreCase(e.getActionId()) && e.getReturnData() != null) {
            FormDesigner designer = (FormDesigner)this.getView().getControl(this.getDesignerKey());
            if (e.getReturnData() instanceof List) {
                designer.setProperty((List)e.getReturnData());
            } else {
                designer.setProperty((Map)e.getReturnData());
            }
            PropertyEditHelper.clearPropEventParamCache((IFormView)this.getView());
        }
    }

    public void getPropertyAlias(PropertyEvent e) {
        Map openParameter = (Map)e.getParam().get(PARAM_FORM);
        String formId = (String)openParameter.get(FORM_ID);
        IPropertyConverter cv = PropertyConverterFactory.create((String)formId);
        if (cv != null) {
            cv.setContext(e.getParam().get(PARAM_CONTEXT), e.getItemId());
            cv.setModelType(this.getPageCache().get(PARAM_MODEL_TYPE));
            Object value = e.getParam().get(PARAM_VALUE);
            Object alias = cv.convert(value);
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put(PARAM_ITEM_ID, e.getItemId());
            para.put(PARAM_META_TYPE, e.getMetaType());
            para.put(PARAM_PROPERTY_NAME, e.getPropertName());
            para.put(PARAM_VALUE, value);
            para.put("alias", alias);
            FormDesigner designer = (FormDesigner)e.getSource();
            designer.setProperty(para);
        }
    }

    protected void preview(String formId, String modelType) {
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            HashMap<String, String> para = new HashMap<String, String>();
            String tempNumber = formId;
            if (modelType.startsWith(PREFIX_MOB)) {
                tempNumber = BOS_MOBILEPREVIEW;
            }
            para.put(FORM_ID, tempNumber);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
            if (modelType.startsWith(PREFIX_MOB)) {
                showParameter.setCustomParam("number", (Object)formId);
                showParameter.setCustomParam(PARAM_MODEL_TYPE, (Object)modelType);
                showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
                showParameter.setClientParam("preview", (Object)"true");
            } else {
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
            }
            showParameter.setCustomParam("formConfigShowLang", (Object)this.getPreviewLang());
            this.getView().showForm(showParameter);
        }
    }

    protected Map<String, Object> fillBackInheritProperty(Map<String, Object> originMeta, Map<String, Object> needFillMeta) {
        if (null == originMeta || originMeta.isEmpty() || null == needFillMeta || needFillMeta.isEmpty()) {
            return needFillMeta;
        }
        List items = (List)needFillMeta.get("Items");
        if (null == items) {
            return needFillMeta;
        }
        Map<String, Boolean> inheritMap = this.getInheritMap(originMeta);
        for (Map item : items) {
            String id = (String)item.get("Id");
            if (!StringUtils.isNotBlank((CharSequence)id) || !inheritMap.containsKey(id)) continue;
            item.put("Inherit", inheritMap.get(id));
        }
        return needFillMeta;
    }

    protected void switchPreviewLang(String lang) {
        if (StringUtils.isNotBlank((CharSequence)lang)) {
            this.getPageCache().put(PREVIEWLANG, lang);
        }
    }

    protected String getPreviewLang() {
        String lang = this.getPageCache().get(PREVIEWLANG);
        return lang == null ? RequestContext.get().getLang().toString() : lang.toString();
    }

    private Map<String, Boolean> getInheritMap(Map<String, Object> meta) {
        HashMap<String, Boolean> inheritMap = new HashMap<String, Boolean>();
        if (null == meta || meta.isEmpty()) {
            return inheritMap;
        }
        List items = (List)meta.get("Items");
        if (null == items || items.isEmpty()) {
            return inheritMap;
        }
        items.stream().forEach(item -> {
            String id = (String)item.get("Id");
            Boolean inherit = (Boolean)item.get("Inherit");
            if (StringUtils.isNotBlank((CharSequence)id) && null != inherit) {
                inheritMap.put(id, inherit);
            }
        });
        return inheritMap;
    }

    protected void deleteRefField(PropertyEvent e) {
    }
}

