/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.entity;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.newdevportal.app.my.PageType;
import kd.bos.newdevportal.util.GotoDesignerUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;

public class BizObjectTreeListPlugin
extends StandardTreeListPlugin {
    private static final String ROOT_NODE_ID = "-1";
    private static final String ENTITY_ID_KEY = "entityId";
    private TreeNodeBuilder cloudBuild = new CloudTreeNodeBuilder();
    private TreeNodeBuilder appBuild = new AppTreeNodeBuilder();

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        FormShowParameter showParameter = new FormShowParameter();
        ListSelectedRow selectedRow = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo();
        String entityId = (String)selectedRow.getPrimaryKeyValue();
        showParameter.setCustomParam(ENTITY_ID_KEY, (Object)entityId);
        showParameter.setFormId("bos_devpn_businessobj");
        showParameter.setStatus(OperationStatus.EDIT);
        MainEntityType mainEntity = EntityMetadataCache.getDataEntityTypeById((String)selectedRow.getPrimaryKeyValue().toString());
        String objectName = mainEntity.getDisplayName().toString();
        showParameter.setCaption(objectName);
        showParameter.setCustomParam("objectname", (Object)objectName);
        IFormView mainView = this.getView().getMainView();
        if (mainView != null) {
            showParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
            showParameter.getOpenStyle().setTargetKey("_submaintab_");
            mainView.showForm(showParameter);
            this.getView().sendFormAction(mainView);
        } else {
            showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
            this.getView().showForm(showParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing) {
            Donothing op = (Donothing)args.getSource();
            String key = op.getOperateKey();
            ListSelectedRowCollection rows = args.getListSelectedData();
            if (rows.isEmpty()) {
                return;
            }
            ListSelectedRow row = rows.get(0);
            String formId = (String)row.getPrimaryKeyValue();
            switch (key) {
                case "showentity": {
                    GotoDesignerUtils.gotoDesigner(PageType.EntityObject.getValue(), this.getView(), formId);
                    break;
                }
                case "showpage": {
                    GotoDesignerUtils.gotoDesigner(PageType.Page.getValue(), this.getView(), formId);
                    break;
                }
            }
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent nodeEvent) {
        super.buildTreeListFilter(nodeEvent);
        String nodeId = nodeEvent.getNodeId().toString();
        QFilter modelFilter = this.getModelFilter(nodeEvent);
        modelFilter.and(new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel")));
        nodeEvent.addQFilter(modelFilter);
        nodeEvent.setCancel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QFilter getModelFilter(BuildTreeListFilterEvent nodeEvent) {
        long beginTime = System.currentTimeMillis();
        System.out.print("abcde getModelFilter being:" + System.currentTimeMillis() + " |");
        try {
            String nodeId = nodeEvent.getNodeId().toString();
            TreeListModel model = (TreeListModel)nodeEvent.getSource();
            TreeNode currentNode = model.getRoot().getTreeNode(nodeId);
            TreeNodeType type = TreeNodeType.valueOf(currentNode.getData());
            QFilter qFilter = null;
            switch (type) {
                case root: {
                    qFilter = new QFilter("bizappid.id", "is not null", (Object)"");
                    break;
                }
                case cloud: {
                    JSONArray units = this.getAppIdsByCloudId(nodeId);
                    qFilter = new QFilter("bizappid.id", "in", (Object)units);
                    break;
                }
                case app: {
                    qFilter = new QFilter("bizappid.id", "=", (Object)nodeId);
                }
            }
            System.out.print("abcde getModelFilter done:" + (System.currentTimeMillis() - beginTime) + " |");
            QFilter qFilter2 = qFilter;
            return qFilter2;
        }
        finally {
            System.out.print("abcde getModelFilter finally:" + (System.currentTimeMillis() - beginTime) + " |");
            this.getView().hideLoading();
            System.out.print("abcde getModelFilter finally2:" + (System.currentTimeMillis() - beginTime) + " |");
        }
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        filters.add(new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel")));
        super.setFilter(e);
    }

    private JSONArray getAppIdsByCloudId(String bizCloudId) {
        JSONArray appIds = new JSONArray();
        List lstAppInfo = BizAppServiceHelp.getAppsDesigntimeInfo((String)bizCloudId);
        if (lstAppInfo != null) {
            for (String info : lstAppInfo) {
                Map app = (Map)SerializationUtils.fromJsonString((String)info, Map.class);
                String bizAppId = (String)app.get("id");
                appIds.add((Object)bizAppId);
            }
        }
        return appIds;
    }

    public void initialize() {
        super.initialize();
        ((ListView)this.getView()).setNeedRefreshTree(false);
        this.setTreeBarItemVisible(false);
    }

    public void initializeTree(EventObject e) {
        TreeNode root = this.getRootTreeNode();
        List<TreeNode> cloudNodes = this.cloudBuild.buildNodes(null);
        root.addChildren(cloudNodes);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.setTreeBarItemVisible(false);
    }

    private TreeNode getRootTreeNode() {
        TreeNode root = this.getTreeModel().getRoot();
        if (root != null && ROOT_NODE_ID.equalsIgnoreCase(root.getId())) {
            return root;
        }
        root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"AbstractEntityTreePlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setId(ROOT_NODE_ID);
        root.setIsOpened(true);
        root.setData((Object)TreeNodeType.root);
        this.getTreeModel().setRoot(root);
        return root;
    }

    protected List<TreeNode> getAllCloudNodes() {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pagetype");
        if (pageType != null && "extend".equals(pageType)) {
            String refAppId = (String)formShowParameter.getCustomParam("refappid");
            DynamicObject cloudObject = BizCloudServiceHelp.getBizCloudByAppID((String)refAppId);
            TreeNode node = new TreeNode(ROOT_NODE_ID, cloudObject.getString("id"), cloudObject.getLocaleString("name").getLocaleValue());
            node.setData((Object)TreeNodeType.cloud);
            cloudNode.add(node);
        } else {
            DynamicObjectCollection dynamicObjects = BizCloudServiceHelp.getAllBizClouds();
            for (DynamicObject dynamicObject : dynamicObjects) {
                TreeNode node = new TreeNode();
                node.setId(dynamicObject.getString("id"));
                node.setText(dynamicObject.getString("name"));
                node.setParentid(ROOT_NODE_ID);
                node.setData((Object)TreeNodeType.cloud);
                cloudNode.add(node);
            }
        }
        return cloudNode;
    }

    private TreeNode addChildNode(TreeNode pnode, List<TreeNode> childNodes) {
        for (int i = 0; i < childNodes.size(); ++i) {
            TreeNode cnode = childNodes.get(i);
            String parentId = cnode.getParentid();
            if (!pnode.getId().equals(parentId)) continue;
            pnode.addChild(this.addChildNode(cnode, childNodes));
        }
        return pnode;
    }

    protected List<TreeNode> getAppNodesByCloudId(String cloudId) {
        ArrayList<TreeNode> appNodes = new ArrayList<TreeNode>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pagetype");
        if (pageType != null && "extend".equals(pageType)) {
            String refAppId = (String)formShowParameter.getCustomParam("refappid");
            AppMetadata refAppMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)refAppId, (boolean)false);
            String refAppName = refAppMeta.getName().getLocaleValue();
            TreeNode node = new TreeNode(cloudId, refAppId, refAppName);
            node.setData((Object)TreeNodeType.app);
            appNodes.add(node);
        } else {
            DynamicObjectCollection dynamicObjects = BizAppServiceHelp.getAllBizAppsByCloudID((String)cloudId);
            for (DynamicObject dynamicObject : dynamicObjects) {
                TreeNode node = new TreeNode();
                String nodeId = dynamicObject.getString("id");
                node.setId(nodeId);
                node.setText(dynamicObject.getString("name"));
                node.setParentid(cloudId);
                node.setData((Object)TreeNodeType.app);
                appNodes.add(node);
            }
        }
        return appNodes;
    }

    private void setTreeBarItemVisible(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void refreshNode(RefreshNodeEvent nodeEvent) {
        super.refreshNode(nodeEvent);
        String nodeId = nodeEvent.getNodeId().toString();
        TreeListModel model = (TreeListModel)nodeEvent.getSource();
        TreeNode currentNode = model.getRoot().getTreeNode(nodeId);
        TreeNodeType type = TreeNodeType.valueOf(currentNode.getData());
        switch (type) {
            case root: {
                List<TreeNode> cloudNodes = this.cloudBuild.buildNodes(null);
                nodeEvent.setChildNodes(cloudNodes);
                break;
            }
            case cloud: {
                List<TreeNode> appNodes = this.appBuild.buildNodes(nodeId);
                nodeEvent.setChildNodes(appNodes);
                break;
            }
        }
    }

    class AppTreeNodeBuilder
    implements TreeNodeBuilder {
        AppTreeNodeBuilder() {
        }

        @Override
        public List<TreeNode> buildNodes(String parentNodeId) {
            return BizObjectTreeListPlugin.this.getAppNodesByCloudId(parentNodeId);
        }
    }

    class CloudTreeNodeBuilder
    implements TreeNodeBuilder {
        CloudTreeNodeBuilder() {
        }

        @Override
        public List<TreeNode> buildNodes(String parentNodeId) {
            List<TreeNode> cloudNodes = BizObjectTreeListPlugin.this.getAllCloudNodes();
            for (TreeNode treeNode : cloudNodes) {
                List<TreeNode> groupNodes = BizObjectTreeListPlugin.this.appBuild.buildNodes(treeNode.getId());
                BizObjectTreeListPlugin.this.addChildNode(treeNode, groupNodes);
            }
            return cloudNodes;
        }
    }

    public static interface TreeNodeBuilder {
        public List<TreeNode> buildNodes(String var1);
    }

    static enum TreeNodeType {
        root(0),
        cloud(1),
        app(2);

        private int value;

        private TreeNodeType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static TreeNodeType valueOf(Object value) {
            if (value == null) {
                return root;
            }
            if (value instanceof TreeNodeType) {
                return (TreeNodeType)((Object)value);
            }
            for (TreeNodeType item : TreeNodeType.values()) {
                if (value instanceof Integer) {
                    if (item.getValue() != ((Integer)value).intValue()) continue;
                    return item;
                }
                if (value instanceof String) {
                    if (!item.name().equalsIgnoreCase((String)value)) continue;
                    return item;
                }
                int ival = Integer.parseInt(value.toString());
                if (item.getValue() != ival) continue;
                return item;
            }
            return root;
        }
    }
}

