/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.newdevportal.util.QueryUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;

public class EntityCreatePlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public void afterCreateNewData(EventObject e) {
        this.setSelectEntityInfo();
        this.setCreateModeInfo();
        this.setCurrentPage("selectentity");
    }

    private void setCurrentPage(String page) {
        this.getView().getPageCache().put("currentPage", page);
        List<String> pageList = this.getPageList();
        int i = pageList.indexOf(page);
        this.setButtonText("btncancel", i == 0 ? ResManager.loadKDString((String)"\u53d6\u6d88", (String)"EntityCreatePlugin_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0a\u4e00\u6b65", (String)"EntityCreatePlugin_1", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        this.setButtonText("btnnext", i == pageList.size() - 1 ? ResManager.loadKDString((String)"\u5b8c\u6210\u521b\u5efa", (String)"EntityCreatePlugin_2", (String)"bos-devportal-new-plugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0b\u4e00\u6b65", (String)"EntityCreatePlugin_3", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        pageList.remove(page);
        this.getView().setVisible(Boolean.TRUE, new String[]{page});
        this.getView().setVisible(Boolean.FALSE, pageList.toArray(new String[0]));
        if ("selecttemplate".equals(page)) {
            this.setCommonTemplateInfo();
        }
        if ("information".equals(page)) {
            this.setInformationInfo();
        }
    }

    private List<String> getPageList() {
        ArrayList<String> pages = new ArrayList<String>(2);
        pages.add("selectentity");
        pages.add("createmode");
        pages.add("selecttemplate");
        pages.add("information");
        return pages;
    }

    private void setSelectEntityInfo() {
        this.getModel().beginInit();
        this.getModel().deleteEntryData("entryentity");
        List<Map<String, Object>> data = this.getSelectEntityTypeData();
        this.getModel().batchCreateNewEntryRow("entryentity", data.size());
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < data.size(); ++i) {
            ((DynamicObject)entryentity.get(i)).set("imageap", (Object)(this.getDomainContextUrl() + data.get(i).get("imageap")));
            ((DynamicObject)entryentity.get(i)).set("type", data.get(i).get("type"));
            ((DynamicObject)entryentity.get(i)).set("description", data.get(i).get("description"));
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void setCreateModeInfo() {
        this.getModel().beginInit();
        this.getModel().deleteEntryData("entryentity_c");
        List<Map<String, Object>> data = this.getCreateModeData();
        this.getModel().batchCreateNewEntryRow("entryentity_c", data.size());
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity_c");
        for (int i = 0; i < data.size(); ++i) {
            ((DynamicObject)entryentity.get(i)).set("imageap_c", (Object)(this.getDomainContextUrl() + data.get(i).get("imageap")));
            ((DynamicObject)entryentity.get(i)).set("type_c", data.get(i).get("type"));
            ((DynamicObject)entryentity.get(i)).set("description_c", data.get(i).get("description"));
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity_c");
    }

    private List<Map<String, Object>> getSelectEntityTypeData() {
        HashMap<String, String> basedataMap = new HashMap<String, String>(6);
        basedataMap.put("imageap", "private/bos/devplat/bos_basedata_62_52.png");
        basedataMap.put("type", ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"EntityCreatePlugin_4", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        basedataMap.put("id", "BaseFormModel");
        basedataMap.put("description", ResManager.loadKDString((String)"\u80fd\u4ee5\u4e00\u4e2a\u7f16\u7801\u4ee3\u8868\u67d0\u4e2a\u4e1a\u52a1\u5bf9\u8c61\uff0c\u7269\u6599\u3001\u5e01\u79cd\u3001\u79d1\u76ee\u90fd\u662f\u57fa\u7840\u8d44\u6599\u7684\u5178\u578b\u4ee3\u8868", (String)"EntityCreatePlugin_5", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        HashMap<String, String> billMap = new HashMap<String, String>(6);
        billMap.put("imageap", "private/bos/devplat/bos_bill_62_52.png");
        billMap.put("type", ResManager.loadKDString((String)"\u5355\u636e", (String)"EntityCreatePlugin_6", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        billMap.put("id", "BillFormModel");
        billMap.put("description", ResManager.loadKDString((String)"\u5e94\u7528\u6700\u4e3a\u5e7f\u6cdb\u7684\u4e1a\u52a1\u5bf9\u8c61\uff0c\u7528\u4e8e\u4fdd\u5b58\u6d41\u6c34\u6570\u636e\uff0c\u5b58\u50a8\u548c\u67e5\u8be2\u7531\u6846\u67b6\u63d0\u4f9b", (String)"EntityCreatePlugin_7", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        return Arrays.asList(basedataMap, billMap);
    }

    private List<Map<String, Object>> getCreateModeData() {
        HashMap<String, String> entityMap = new HashMap<String, String>(6);
        entityMap.put("imageap", "private/bos/devplat/bos_basedata_62_52.png");
        entityMap.put("type", ResManager.loadKDString((String)"\u65b0\u5efa\u5b9e\u4f53", (String)"EntityCreatePlugin_8", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        entityMap.put("id", "new");
        entityMap.put("description", ResManager.loadKDString((String)"\u57fa\u4e8e\u7a7a\u767d\u5b9e\u4f53\u6216\u8005\u5185\u7f6e\u6a21\u7248\u521b\u5efa\u5b9e\u4f53\u3002", (String)"EntityCreatePlugin_9", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        HashMap<String, String> inheritMap = new HashMap<String, String>(6);
        inheritMap.put("imageap", "private/bos/devplat/bos_basedata_62_52.png");
        inheritMap.put("type", ResManager.loadKDString((String)"\u901a\u8fc7\u7ee7\u627f\u521b\u5efa", (String)"EntityCreatePlugin_10", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        inheritMap.put("id", "inherit");
        inheritMap.put("description", ResManager.loadKDString((String)"\u57fa\u4e8e\u73b0\u6709\u5b9e\u4f53\u7ee7\u627f\u521b\u5efa\u5b9e\u4f53\u3002", (String)"EntityCreatePlugin_11", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        return Arrays.asList(entityMap, inheritMap);
    }

    public void registerListener(EventObject e) {
        CardEntry entryentity_bt = (CardEntry)this.getControl("entryentity_bt");
        CardEntry entryentity_ct = (CardEntry)this.getControl("entryentity_ct");
        entryentity_bt.addRowClickListener((RowClickEventListener)this);
        entryentity_ct.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"btnnext", "void"});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("void".equals(key)) {
            this.getPageCache().remove("templateId");
            this.getPageCache().remove("templateNumber");
            this.getPageCache().put("createmode", "new");
            this.setCurrentPage("information");
            return;
        }
        if ("btnnext".equals(key)) {
            String currentPage = this.getView().getPageCache().get("currentPage");
            if ("selectentity".equals(currentPage)) {
                CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
                int[] selectRows = cardEntry.getSelectRows();
                if (selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7c7b\u578b", (String)"EntityCreatePlugin_12", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
                    return;
                }
                int index = cardEntry.getSelectRows()[0];
                String id = (String)this.getSelectEntityTypeData().get(index).get("id");
                this.getView().getPageCache().put("entityType", id);
                this.setNextPage(currentPage);
                return;
            }
            if ("createmode".equals(currentPage)) {
                CardEntry cardEntry = (CardEntry)this.getControl("entryentity_c");
                int[] selectRows = cardEntry.getSelectRows();
                if (selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u521b\u5efa\u65b9\u5f0f\u3002", (String)"EntityCreatePlugin_13", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
                    return;
                }
                int index = cardEntry.getSelectRows()[0];
                String id = (String)this.getCreateModeData().get(index).get("id");
                this.getView().getPageCache().put("createmode", id);
                if ("new".equals(id)) {
                    this.setCurrentPage("selecttemplate");
                } else {
                    this.setCurrentPage("information");
                }
                return;
            }
            if ("selecttemplate".equals(currentPage)) {
                String template = this.getPageCache().get("templateId");
                if (StringUtils.isBlank((CharSequence)template)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f", (String)"EntityCreatePlugin_14", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
                    return;
                }
                this.getPageCache().put("createmode", "template");
                this.setCurrentPage("information");
                return;
            }
            if ("information".equals(currentPage)) {
                if (!this.checkValidateInformation()) {
                    return;
                }
                String createMode = this.getPageCache().get("createmode");
                if ("template".equals(createMode)) {
                    this.dealWithTemplate();
                }
                if ("new".equals(createMode)) {
                    this.dealWithNew();
                }
                if ("inherit".equals(createMode)) {
                    this.dealWithEntity();
                }
            }
        }
    }

    private void dealWithEntity() {
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("entity");
        this.getPageCache().put("templateId", dynamicObject.getPkValue().toString());
        this.getPageCache().put("templateNumber", dynamicObject.getString("number"));
        this.dealWithTemplate();
    }

    private void dealWithNew() {
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put("modelType", this.getPageCache().get("entityType"));
        map.put("id", this.getModel().getValue("number"));
        map.put("name", this.getModel().getValue("name"));
        String bizAppId = (String)((DynamicObject)this.getModel().getValue("bizapp")).getPkValue();
        map.put("bizappid", bizAppId);
        String bizUnitId = QueryUtils.getHomePageBizUnitId(bizAppId);
        map.put("bizunitid", bizUnitId);
        Map message = DevportalUtil.buildNewPage(map, (String)bizAppId, (String)bizUnitId, (IFormView)this.getView(), (boolean)false);
        if (StringUtils.isBlank(message.get("isvcheckresult"))) {
            String formId = (String)message.get("formid");
            DevportalUtil.gotoPageDesinger((IFormView)this.getView(), (String)formId, (String)"bos_devportal_bizpagelist");
            this.setCurrentPage("selectentity");
            this.getView().close();
        }
    }

    private void dealWithTemplate() {
        String number = this.getPageCache().get("templateNumber");
        DynamicObject templateFormObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"id, number, type", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        if (templateFormObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b", (String)"EntityCreatePlugin_15", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        if ("2".equals(templateFormObject.get("type").toString())) {
            map.put("devType", "2");
        }
        String templateFormId = templateFormObject.getString("id");
        map.put("modelType", this.getPageCache().get("entityType"));
        map.put("parentId", templateFormId);
        map.put("id", this.getModel().getValue("number"));
        map.put("name", this.getModel().getValue("name"));
        String bizAppId = (String)((DynamicObject)this.getModel().getValue("bizapp")).getPkValue();
        map.put("bizappid", bizAppId);
        String bizUnitId = QueryUtils.getHomePageBizUnitId(bizAppId);
        map.put("bizunitid", bizUnitId);
        Map message = DevportalUtil.buildNewPage(map, (String)bizAppId, (String)bizUnitId, (IFormView)this.getView(), (boolean)false);
        if (StringUtils.isBlank(message.get("isvcheckresult"))) {
            String formId = (String)message.get("formid");
            DevportalUtil.gotoPageDesinger((IFormView)this.getView(), (String)formId, (String)"bos_devportal_bizpagelist");
            this.setCurrentPage("selectentity");
            this.getView().close();
        }
    }

    private void setCommonTemplateInfo() {
        DynamicObjectCollection data = this.getCommonTemplateData();
        this.getModel().beginInit();
        this.getModel().deleteEntryData("entryentity_ct");
        this.getModel().batchCreateNewEntryRow("entryentity_ct", data.size());
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity_ct");
        String modelType = this.getPageCache().get("entityType");
        String imageUrl = "";
        if ("BaseFormModel".equals(modelType)) {
            imageUrl = "private/bos/devplat/bos_basedata_62_52.png";
        } else if ("BillFormModel".equals(modelType)) {
            imageUrl = "private/bos/devplat/bos_bill_62_52.png";
        }
        for (int i = 0; i < data.size(); ++i) {
            ((DynamicObject)entryentity.get(i)).set("imageap_ct", (Object)(this.getDomainContextUrl() + imageUrl));
            ((DynamicObject)entryentity.get(i)).set("type_ct", ((DynamicObject)data.get(i)).get("number"));
            ((DynamicObject)entryentity.get(i)).set("description_ct", ((DynamicObject)data.get(i)).get("name"));
            ((DynamicObject)entryentity.get(i)).set("id_ct", ((DynamicObject)data.get(i)).get("id"));
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity_ct");
    }

    private void setInformationInfo() {
        String createMode = this.getPageCache().get("createmode");
        boolean isInherit = "inherit".equals(createMode);
        this.getView().setVisible(Boolean.valueOf(isInherit), new String[]{"entity"});
        if (isInherit) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl("entity");
            basedataEdit.setQFilter(new QFilter("modeltype", "=", (Object)this.getPageCache().get("entityType")));
        }
    }

    private DynamicObjectCollection getCommonTemplateData() {
        String modelType = this.getPageCache().get("entityType");
        QFilter qFilter = new QFilter("bizappid", "=", (Object)"0a1f79d7000024ac");
        qFilter.and(new QFilter("istemplate", "=", (Object)Character.valueOf('1')));
        qFilter.and(new QFilter("modeltype", "=", (Object)modelType));
        return QueryUtils.getEntityMetas(new QFilter[]{qFilter});
    }

    private boolean checkValidateInformation() {
        DynamicObject entity;
        String number = (String)this.getModel().getValue("number");
        ILocaleString name = (ILocaleString)this.getModel().getValue("name");
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue("bizapp");
        if (StringUtils.isBlank((CharSequence)number)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4fe1\u606f", (String)"EntityCreatePlugin_16", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return false;
        }
        if (name == null || StringUtils.isBlank((CharSequence)name.getLocaleValue())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4fe1\u606f", (String)"EntityCreatePlugin_16", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return false;
        }
        if (bizApp == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e94\u7528", (String)"EntityCreatePlugin_17", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return false;
        }
        String createMode = this.getPageCache().get("createmode");
        if ("template".equals(createMode)) {
            return true;
        }
        if (!"new".equals(createMode) && "inherit".equals(createMode) && (entity = (DynamicObject)this.getModel().getValue("entity")) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b9e\u4f53", (String)"EntityCreatePlugin_18", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setNextPage(String currentPage) {
        List<String> pageList = this.getPageList();
        int i = pageList.indexOf(currentPage);
        if (i >= 0 && i < pageList.size() - 1) {
            this.setCurrentPage(pageList.get(i + 1));
        }
    }

    private void setButtonText(String key, String text) {
        HashMap<String, LocaleString> map = new HashMap<String, LocaleString>(2);
        map.put("text", new LocaleString(text));
        this.getView().updateControlMetadata(key, map);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String currentPage = this.getView().getPageCache().get("currentPage");
        List<String> pageList = this.getPageList();
        int i = pageList.indexOf(currentPage);
        if (i > 0) {
            e.setCancel(true);
            if (StringUtils.isBlank((CharSequence)this.getPageCache().get("templateId")) && pageList.get(i - 1).equals("selecttemplate")) {
                --i;
            }
            this.setCurrentPage(pageList.get(i - 1));
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry entryentity_ct = (CardEntry)this.getControl("entryentity_ct");
        CardEntry entryentity_bt = (CardEntry)this.getControl("entryentity_bt");
        ArrayList<CardEntry> allCardEntries = new ArrayList<CardEntry>(10);
        allCardEntries.add(entryentity_ct);
        allCardEntries.add(entryentity_bt);
        allCardEntries.remove(evt.getSource());
        for (CardEntry cardEntry : allCardEntries) {
            cardEntry.clearEntryState();
        }
        int row = evt.getRow();
        String key = ((Control)evt.getSource()).getKey();
        String suffix = key.substring(key.lastIndexOf(95));
        this.getPageCache().put("templateId", (String)this.getModel().getValue("id" + suffix, row));
        this.getPageCache().put("templateNumber", (String)this.getModel().getValue("type" + suffix, row));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("entity".equals(e.getProperty().getName())) {
            DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
            if (entity == null) {
                this.getModel().setValue("bizapp", null);
            } else {
                DynamicObject bizApp = BusinessDataServiceHelper.loadSingleFromCache((Object)entity.getString("bizappid_id"), (String)"bos_devportal_bizapp");
                this.getModel().setValue("bizapp", (Object)bizApp);
            }
        }
    }

    private String getDomainContextUrl() {
        String domainContextUrl = UrlService.getDomainContextUrl();
        if (!domainContextUrl.endsWith("/")) {
            domainContextUrl = domainContextUrl + "/";
        }
        return domainContextUrl;
    }
}

