/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.entity;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlParameter;
import kd.bos.decode.DecodeHandlerFactory;
import kd.bos.designer.ExchangeRateGroupCreateUIElemntListener;
import kd.bos.designer.ISubDesginer;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.designer.dao.EntityDesignerData;
import kd.bos.designer.property.BillListCDWDesignerPlugin;
import kd.bos.designer.property.MobBillDesignerPlugin;
import kd.bos.designer.property.alias.IPropertyConverter;
import kd.bos.designer.property.alias.PropertyConverterFactory;
import kd.bos.devportal.common.FieldsType;
import kd.bos.devportal.common.util.DesignerUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RaiseEventType;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.form.control.events.NameCombineCreateUIElemntListener;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.DesignerBarListener;
import kd.bos.form.control.DesignerCallListener;
import kd.bos.form.control.EntityDesigner;
import kd.bos.form.control.events.CreateUIElemntListener;
import kd.bos.form.control.events.DesignerBarEvent;
import kd.bos.form.control.events.DesignerCallEvent;
import kd.bos.form.control.events.KeyPressArgs;
import kd.bos.form.control.events.PropertyEvent;
import kd.bos.form.control.events.PropertyListener;
import kd.bos.form.control.events.ShortCutKeyListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.isv.ISVService;
import kd.bos.isv.IsvParamCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.DesignerMetas;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.metadata.dao.MetaType;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.converter.FormMetadataConverter;
import kd.bos.metadata.dao.converter.PrintMetadataConverter;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.rule.BizRule;
import kd.bos.metadata.entity.rule.BizRuleAction;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.extensible.ExtensibleDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.rule.FormRuleActionType;
import kd.bos.metadata.form.rule.FormRuleActionTypeCache;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.FormController;
import kd.bos.mvc.form.IFormController;
import kd.bos.newdevportal.app.my.PageType;
import kd.bos.newdevportal.entity.AbstractEntityDesignerPlugin;
import kd.bos.newdevportal.entity.IEntityDesignerMergeModel;
import kd.bos.newdevportal.form.designer.MetaIsvCheck;
import kd.bos.newdevportal.formula.FormulaValiate;
import kd.bos.newdevportal.page.BizObjectLayoutPageUtils;
import kd.bos.newdevportal.util.GotoDesignerUtils;
import kd.bos.newdevportal.util.RuleDesignMetaHelper;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.ExceptionUtils;

public class EntityDesignerPlugin
extends AbstractEntityDesignerPlugin
implements DesignerBarListener,
ShortCutKeyListener,
DesignerCallListener {
    private static Log LOG = LogFactory.getLog(EntityDesignerPlugin.class);
    private static final String ENTITY_DESIGNER = "entitydesigner";
    private static final String ENTITY_ID_KEY = "entityId";
    private static final String OPEN_FORM_ID = "openformid";
    private static final String MODE_TYPE = "modelType";
    private static final String DB_ROUTE = "dbroute";
    private static final String DB_ROUTE_R = "dbRoute";
    private static final String ONLY_ONE = "onlyOne";
    private static final String TAB_ID = "tabId";
    private static final String VALUE = "value";
    private static final String DESIGNER_PARAMS = "designerparams";
    private static final String FORM_ID = "formId";
    private static final String FORM_META = "formmeta";
    private static final String FORM = "form";
    private static final String BIZ_APPID = "bizappid";
    private static final String LOCALE_ITEMS = "localeItems";
    private static final String OLD_METADATA = "oldmetadata";
    private static final String ORIGIN_METADATA = "originmetadata";
    private static final String CURRENT_METADATA = "current_metadata";
    private static final String MODIFY_DATE = "modifyDate";
    private static final String ITEMS = "Items";
    private static final String ENTITY_META = "entitymeta";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String GET_USER_THEME = "getUserTheme";
    public static final String NUMBER = "number";
    public static final String ID = "id";
    public static final String SAVE = "save";
    public static final String META = "meta";
    public static final String EXTENSIBLE = "extensible";
    public static final String LIST_META = "ListMeta";
    public static final String MOB_META = "MobMeta";
    public static final String MOB_LIST_META = "MobListMeta";
    public static final String ISV_KINGDEE = "kingdee";
    public static final String FORM_EXT = "_ext";
    private static String mergeVersion = "mergeVersion";
    private static String showFormLangParam = "formConfigShowLang";
    private static final String ENTITY_AND_FIELD = "entityandfield";
    private static final String DATA_MODEL = "datamodel";
    private static final String BUSINESS_RULES = "businessrules";
    private static final String BUSINESS_OPERATION = "businessoperation";
    private static final String BUSINESS_CONTROL = "businesscontrol";
    private static final String PLUGINS = "plugins";
    private static final String PERM_CONTROL = "permcontrol";
    private static final String CURRENT_TAB_ID = "current_tab_id";
    private static final String PAGE_ID = "pageId";
    protected static final String SUCCESS = "success";
    protected static final String ERRORS = "errors";
    protected static final String WARN = "warn";
    private static final String METAS = "metas";
    private static final String READONLY = "readonly";
    private static final String RULES_DESIGN_META_ENTITY_META = "serviceType";
    private static final String RULES_DESIGN_META_FUNCTION_TYPES = "functionTypes";
    private static final String META_TYPE_ENTITY_META = "entitymeta";
    private static final String Pre_GroupNode = "grup.";
    private static final String Pre_FuncNode = "func.";
    protected static final String MESSAGES = "messages";
    protected static final String MESSAGE = "message";
    protected static final String ERROR = "error";
    protected static final String MESSAGE_TYPE = "type";
    private static final String CALL_ACTION_PARSE_RISE_EVENT_TYPES = "parseRiseEventTypes";
    private static final String CALL_ACTION_SET_RISE_EVENT_TYPES = "setRiseEventTypes";
    private static final String CALL_ACTION_PARSE_RISE_EVENT_VALUES = "parseRiseEventValues";
    private static final String CALL_ACTION_SET_RISE_EVENT_VALUES = "setRiseEventValues";
    private static final String CALL_ACTION_SHOW_FUNCTION_SETTING = "showFunctionSetting";
    private static final String CALL_ACTION_SHOW_CUSTOM_RULE_SERVICE_SETTING = "showCustomRuleServiceSetting";
    private static final String SET_CUSTOM_RULE_ACTION = "setCustomRuleAction";
    private static final String VALIDATE_FORMULA = "validateFormula";
    private static final String Key_FSParameter = "fs_parameter";
    private static final String CONTEXT = "context";
    private static final int ALL_RAISE_EVENT_TYPE = 255;

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        EntityDesigner designer = this.getEntityDesigner();
        designer.addPropertyButtonClickListener((PropertyListener)this);
        designer.addBarListener((DesignerBarListener)this);
        designer.addCallListener((DesignerCallListener)this);
        designer.addCreateUIElemntListener((CreateUIElemntListener)new NameCombineCreateUIElemntListener(this.getView()));
        designer.addShortCutKeyListener((ShortCutKeyListener)this);
        designer.addCreateUIElemntListener((CreateUIElemntListener)new ExchangeRateGroupCreateUIElemntListener());
    }

    private boolean isInValidIsv() {
        try {
            IsvParamCache.setIsvParam((boolean)true);
            ISVService.getISVInfo().getId();
        }
        catch (KDException kde) {
            this.getView().setEnable(Boolean.FALSE, new String[]{SAVE});
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u5f00\u53d1\u5546\u8d44\u8d28\u6587\u4ef6\u3002", (String)"MainPlugin_13", (String)"bos-devportal-plugin", (Object[])new Object[0]), kde.getMessage()));
            IsvParamCache.remove();
            return true;
        }
        return false;
    }

    public void afterCreateNewData(EventObject evt) {
        if (EnvTypeHelper.isDeploying()) {
            String msg = ResManager.loadKDString((String)"\u5e73\u53f0\u6b63\u5728\u8fdb\u884c\u7cfb\u7edf\u5347\u7ea7\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"EntityDesignerPlugin_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            this.getView().showMessage(msg);
        }
        if (this.isInValidIsv()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SAVE});
        }
    }

    public void afterBindData(EventObject e) {
        EntityDesigner designer = this.getEntityDesigner();
        String entityId = this.getEntityId();
        Map<String, Object> entityDesignerBar = this.getEntityDesignerBar();
        designer.setEntityDesignerBar(entityDesignerBar);
        String openFormId = "";
        String modelType = "";
        String dbRoute = "";
        EntityDesignerData designerData = new EntityDesignerData();
        Map<String, Object> designerMetadata = designerData.loadDesignerMetadata(entityId, RequestContext.get().getLang().toString());
        if (designerMetadata != null) {
            openFormId = (String)((Map)designerMetadata.get(FORM_META)).get("Key");
            this.getPageCache().put(OPEN_FORM_ID, openFormId);
            this.recordTimeAndAquireMutex(openFormId, designerMetadata);
            this.getPageCache().put(mergeVersion, (String)designerMetadata.get(mergeVersion));
            modelType = (String)designerMetadata.get(MODE_TYPE);
            Map entityMeta = (Map)designerMetadata.get("entitymeta");
            List entityItems = (List)entityMeta.get(ITEMS);
            Map mainEntity = (Map)entityItems.get(0);
            dbRoute = (String)mainEntity.get(DB_ROUTE_R);
            designerMetadata.put("subSystem", 1);
            designerMetadata.put("isv", ISVService.getISVInfo().getId());
            String bizappId = (String)this.getView().getFormShowParameter().getCustomParam(BIZ_APPID);
            if (StringUtils.isBlank((CharSequence)bizappId)) {
                bizappId = this.getAppIdByFormId(entityId);
            }
            designerMetadata.put("appNum", AppReader.getAppNumberById((String)bizappId));
            designerMetadata.put(BIZ_APPID, bizappId);
            String metaDataStr = SerializationUtils.toJsonString(designerMetadata);
            this.getPageCache().put(OLD_METADATA, metaDataStr);
            this.getPageCache().put(CURRENT_METADATA, metaDataStr);
            this.getPageCache().put(ORIGIN_METADATA, metaDataStr);
            if (!designerMetadata.isEmpty()) {
                this.resourceCheck(designerMetadata, this.getView(), null);
                this.getView().executeClientCommand("setCaption", new Object[]{MessageFormat.format(ResManager.loadKDString((String)"{0}(\u5b9e\u4f53)", (String)"EntityDesignerPlugin_1", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), designerMetadata.get("caption"))});
            }
            designer.open(modelType, designerMetadata);
            designer.sendFieldProsLock(DesignerUtils.getSpecialPropsExtensible((String)entityId));
        } else {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            Map newParam = (Map)showParameter.getCustomParam("newParam");
            if (newParam != null) {
                modelType = (String)newParam.get(MODE_TYPE);
                dbRoute = (String)newParam.get(DB_ROUTE);
                designerMetadata = this.createBlackTemplate(newParam);
                if (designerMetadata != null) {
                    entityId = (String)designerMetadata.get(ID);
                    openFormId = (String)((Map)designerMetadata.get(FORM_META)).get("Key");
                    this.getPageCache().put(OPEN_FORM_ID, openFormId);
                    this.getPageCache().put(ENTITY_ID_KEY, entityId);
                    Map entityMeta = (Map)designerMetadata.get("entitymeta");
                    List entityItems = (List)entityMeta.get(ITEMS);
                    Map mainEntity = (Map)entityItems.get(0);
                    dbRoute = (String)mainEntity.get(DB_ROUTE_R);
                }
                String metaDataStr = SerializationUtils.toJsonString(designerMetadata);
                this.getPageCache().put(OLD_METADATA, metaDataStr);
                this.getPageCache().put(CURRENT_METADATA, metaDataStr);
                this.getPageCache().put(ORIGIN_METADATA, metaDataStr);
                if (designerMetadata != null && !designerMetadata.isEmpty()) {
                    this.resourceCheck(designerMetadata, this.getView(), null);
                    this.getView().executeClientCommand("setCaption", new Object[]{(String)designerMetadata.get("caption")});
                }
                designer.open(modelType, designerMetadata);
                designer.sendFieldProsLock(DesignerUtils.getSpecialPropsExtensible((String)entityId));
            }
        }
        this.getPageCache().put(MODE_TYPE, modelType);
        this.getPageCache().put(DB_ROUTE, dbRoute);
        if (designerMetadata != null) {
            this.getPageCache().put(LOCALE_ITEMS, SerializationUtils.toJsonString((Object)designerMetadata.remove(LOCALE_ITEMS)));
        }
        this.getPageCache().put(CURRENT_TAB_ID, ENTITY_AND_FIELD);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        DecodeHandlerFactory.sendDesignerEncodingElements((String)ENTITY_DESIGNER, (IClientViewProxy)clientViewProxy);
    }

    private Map<String, Object> getEntityDesignerBar() {
        HashMap<String, Object> properties = new HashMap<String, Object>(3);
        ArrayList menuOptions = new ArrayList();
        HashMap<String, String> map_endtityandfield = new HashMap<String, String>();
        map_endtityandfield.put(ID, ENTITY_AND_FIELD);
        map_endtityandfield.put(VALUE, ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"EntityDesignerPlugin_2", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        menuOptions.add(map_endtityandfield);
        HashMap<String, String> map_datamodel = new HashMap<String, String>();
        map_datamodel.put(ID, DATA_MODEL);
        map_datamodel.put(VALUE, ResManager.loadKDString((String)"\u6570\u636e\u6a21\u578b", (String)"EntityDesignerPlugin_3", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        menuOptions.add(map_datamodel);
        HashMap<String, String> map_operation = new HashMap<String, String>();
        map_operation.put(ID, BUSINESS_OPERATION);
        map_operation.put(VALUE, ResManager.loadKDString((String)"\u4e1a\u52a1\u64cd\u4f5c", (String)"EntityDesignerPlugin_4", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        menuOptions.add(map_operation);
        HashMap<String, String> map_control = new HashMap<String, String>();
        map_control.put(ID, BUSINESS_CONTROL);
        map_control.put(VALUE, ResManager.loadKDString((String)"\u4e1a\u52a1\u63a7\u5236", (String)"EntityDesignerPlugin_5", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        menuOptions.add(map_control);
        HashMap<String, String> map_plugins = new HashMap<String, String>();
        map_plugins.put(ID, PLUGINS);
        map_plugins.put(VALUE, ResManager.loadKDString((String)"\u64cd\u4f5c\u63d2\u4ef6", (String)"EntityDesignerPlugin_6", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        menuOptions.add(map_plugins);
        HashMap<String, String> map_permControl = new HashMap<String, String>();
        map_permControl.put(ID, PERM_CONTROL);
        map_permControl.put(VALUE, ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236", (String)"EntityDesignerPlugin_7", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        menuOptions.add(map_permControl);
        HashMap<String, String> map_rules = new HashMap<String, String>();
        map_rules.put(ID, BUSINESS_RULES);
        map_rules.put(VALUE, ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219", (String)"EntityDesignerPlugin_8", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
        menuOptions.add(map_rules);
        properties.put("menuOptions", menuOptions);
        String currentIsv = ISVService.getISVInfo().getId();
        List isvList = DesignerUtils.ISV_LIST;
        String entityId = this.getEntityId();
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        String formIsv = formMetadata.getIsv();
        HashMap<String, Boolean> config = new HashMap<String, Boolean>(1);
        config.put("showExtensibleBtn", isvList.contains(formIsv) && StringUtils.equals((CharSequence)currentIsv, (CharSequence)formIsv));
        properties.put("config", config);
        return properties;
    }

    public void designerBarClick(DesignerBarEvent e) {
        String key = (String)e.getParam().get("key");
        String pageId = (String)e.getParam().get(PAGE_ID);
        this.mergeClientData2CurrentDesignMeta();
        switch (key) {
            case "save": {
                this.saveData();
                break;
            }
            case "meta": {
                this.openMeta(pageId);
                break;
            }
            case "extensible": {
                this.loadSubPage(EXTENSIBLE, "devpn_extensibility", pageId);
                break;
            }
            case "entityandfield": {
                break;
            }
            case "datamodel": {
                this.loadSubPage(DATA_MODEL, "bos_devpn_datamodel", pageId);
                break;
            }
            case "businessrules": {
                this.sendRuleDesignMeta();
                break;
            }
            case "businessoperation": {
                this.loadSubPage(BUSINESS_OPERATION, "bos_devpn_busoperation", pageId);
                break;
            }
            case "businesscontrol": {
                this.loadSubPage(BUSINESS_CONTROL, "bos_devpn_businesscontrol", pageId);
                break;
            }
            case "plugins": {
                this.loadSubPage(PLUGINS, "bos_devpn_plugin", pageId);
                break;
            }
            case "permcontrol": {
                this.loadSubPage(PERM_CONTROL, "bos_devpn_permcontrol", pageId);
                break;
            }
            case "gotolayout": {
                this.gotoLayoutDesigner();
                break;
            }
        }
    }

    private void gotoLayoutDesigner() {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_ID_KEY);
        List<String> refFormIds = BizObjectLayoutPageUtils.getExtFormIds(formId);
        if (refFormIds.size() <= 1) {
            GotoDesignerUtils.gotoDesigner(PageType.Page.getValue(), this.getView(), formId);
        } else {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("devpn_selectlayout");
            showParameter.setCustomParam(FORM_ID, (Object)formId);
            showParameter.setCustomParam("layoutIds", (Object)SerializationUtils.toJsonString(refFormIds));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    private void sendRuleDesignMeta() {
        Map<Object, Object> ret;
        IClientViewProxy clientViewProxy;
        ArrayList<Map<String, String>> messages;
        block4: {
            messages = new ArrayList<Map<String, String>>(10);
            Map<String, Object> currentContent = this.getCurrentMetaData();
            if (currentContent != null) {
                this.resourceCheck(currentContent, null, messages);
            }
            clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            String xmlFuncs = (String)this.getView().getFormShowParameter().getCustomParam("functiontypes");
            ret = new HashMap(16);
            try {
                ret = RuleDesignMetaHelper.getRuleDesignMeta("entitymeta", 1, this.getCurrentMetaData(), false, xmlFuncs);
            }
            catch (KDBizException e) {
                LOG.error((Throwable)e);
                if (!"ActionNotSupport".equalsIgnoreCase(e.getErrorCode().getCode())) break block4;
                this.getView().showErrorNotification(e.getMessage());
                return;
            }
        }
        if (messages.size() > 0) {
            ret.put(MESSAGES, messages);
        }
        clientViewProxy.invokeControlMethod(ENTITY_DESIGNER, "setDesignMeta", new Object[]{ret});
    }

    private void mergeClientData2CurrentDesignMeta() {
        Map<String, Object> currentContent = this.getCurrentContent();
        if (currentContent != null) {
            Object permissionDimension;
            Object operations;
            Map<String, Object> orgContent = this.getCurrentMetaData();
            Map curEntityMeta = (Map)currentContent.get("entitymeta");
            List curEntityItems = (List)curEntityMeta.get(ITEMS);
            Map curMainEntity = (Map)curEntityItems.get(0);
            Map orgEntityMeta = (Map)orgContent.get("entitymeta");
            List orgEntityItems = (List)orgEntityMeta.get(ITEMS);
            Map orgMainEntity = (Map)orgEntityItems.get(0);
            Object businessControl = orgMainEntity.get("BusinessControl");
            if (businessControl != null) {
                curMainEntity.put("BusinessControl", businessControl);
            }
            if ((operations = orgMainEntity.get("Operations")) != null) {
                curMainEntity.put("Operations", operations);
            }
            if ((permissionDimension = orgMainEntity.get("PermissionDimension")) != null) {
                curMainEntity.put("PermissionDimension", permissionDimension);
            }
            currentContent.put("entitymeta", curEntityMeta);
            Map formMeta = (Map)currentContent.get(FORM_META);
            if (formMeta == null) {
                formMeta = (Map)orgContent.get(FORM_META);
                currentContent.put(FORM_META, formMeta);
            }
            this.getPageCache().put(CURRENT_METADATA, SerializationUtils.toJsonString(currentContent));
            this.closeSubPage(META);
        }
    }

    private void loadSubPage(String tabId, String pageNumber, String pageId) {
        this.getPageCache().put(CURRENT_TAB_ID, tabId);
        if (StringUtils.isNotBlank((CharSequence)pageId) && StringUtils.isNotBlank((CharSequence)this.getPageCache().get(tabId))) {
            boolean needUpdateView;
            IEntityDesignerMergeModel modelMerger;
            Map<String, Object> currentContent = this.getCurrentContent();
            if (currentContent != null && (modelMerger = this.getModelMerger(tabId)) != null && (needUpdateView = modelMerger.entityMetadataChanged())) {
                IFormView view = modelMerger.getSubView();
                view.updateView();
                this.getView().sendFormAction(view);
            }
            return;
        }
        FormShowParameter parentFormShowParameter = this.getView().getFormShowParameter();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(pageNumber);
        showParameter.setCustomParam(ENTITY_ID_KEY, parentFormShowParameter.getCustomParam(ENTITY_ID_KEY));
        String dbRoute = this.getPageCache().get(DB_ROUTE);
        if (StringUtils.isNotBlank((CharSequence)dbRoute)) {
            showParameter.setCustomParam(DB_ROUTE, (Object)dbRoute);
        }
        showParameter.setCustomParam(ENTITY_ID_KEY, parentFormShowParameter.getCustomParam(ENTITY_ID_KEY));
        showParameter.setCustomParam(NUMBER, parentFormShowParameter.getCustomParam(NUMBER));
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(ENTITY_DESIGNER);
        HashMap<String, String> cusOpenStyleParam = new HashMap<String, String>();
        cusOpenStyleParam.put(ONLY_ONE, "false");
        cusOpenStyleParam.put(TAB_ID, tabId);
        showParameter.getOpenStyle().setCustParam(cusOpenStyleParam);
        if ("bos_devpn_businesscontrol".equals(pageNumber)) {
            this.lockBusinessControlPage(showParameter);
        }
        this.getPageCache().put(tabId, showParameter.getPageId());
        this.getView().showForm(showParameter);
    }

    private void lockBusinessControlPage(FormShowParameter parameter) {
        String masterId;
        String modelType;
        String entityId = this.getEntityId();
        EntityMetadata metadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        String lockType = ExtensibleDao.getExtLockType((AbstractMetadata)metadata, (String)"Field", (String)(modelType = metadata.getModelType()), (String)(masterId = metadata.getMasterId()), (String)"BusinessControl").toString();
        if ("lock".equals(lockType)) {
            parameter.setStatus(OperationStatus.VIEW);
        }
    }

    private Map<String, Object> createBlackTemplate(Map<String, Object> newParam) {
        Map designerMetadata = null;
        if (newParam != null) {
            EntityDesignerData designerData = new EntityDesignerData();
            designerMetadata = designerData.createBlankModel(newParam);
        }
        return designerMetadata;
    }

    private void recordTimeAndAquireMutex(String formId, Map<String, Object> designerMetadata) {
        Date date = (Date)designerMetadata.get(MODIFY_DATE);
        long modifyDate = date == null ? 0L : date.getTime();
        this.getPageCache().put(MODIFY_DATE, String.valueOf(modifyDate));
    }

    @Override
    public void getPropertyAlias(PropertyEvent e) {
        String formId;
        IPropertyConverter cv;
        Map openParameter = (Map)e.getParam().get(FORM);
        if (openParameter != null && (cv = PropertyConverterFactory.create((String)(formId = (String)openParameter.get(FORM_ID)))) != null) {
            cv.setContext(e.getParam().get(CONTEXT), e.getItemId());
            cv.setModelType(this.getPageCache().get(MODE_TYPE));
            Object value = e.getParam().get(VALUE);
            Object alias = cv.convert(value);
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put("itemId", e.getItemId());
            para.put("metaType", e.getMetaType());
            para.put(PROPERTY_NAME, e.getPropertName());
            para.put(VALUE, value);
            para.put("alias", alias);
            EntityDesigner designer = (EntityDesigner)e.getSource();
            designer.setProperty(para);
        }
    }

    private ISubDesginer getISubDesigner(String metaType) {
        BillListCDWDesignerPlugin plugin = null;
        if (LIST_META.equals(metaType) || MOB_LIST_META.equals(metaType)) {
            plugin = new BillListCDWDesignerPlugin();
        } else if (MOB_META.equals(metaType)) {
            plugin = new MobBillDesignerPlugin();
        }
        return plugin;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        IClientViewProxy clientViewProxy;
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if ("setaddresscallback".equals(actionId) && returnData != null) {
            String libAddress = (String)returnData;
            SessionManager.getCurrent().put("libaddress", libAddress);
        }
        if ("propertyEdit".equalsIgnoreCase(actionId) && returnData != null) {
            EntityDesigner designer = (EntityDesigner)this.getView().getControl(this.getDesignerKey());
            if (returnData instanceof List) {
                List returnList = (List)returnData;
                this.cacheRefField(returnList);
                designer.setProperty(returnList);
            } else {
                designer.setProperty((Map)returnData);
            }
            PropertyEditHelper.clearPropEventParamCache((IFormView)this.getView());
        }
        if ("showFunction".equals(actionId) && returnData != null) {
            String functionSetting = (String)e.getReturnData();
            clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.getDesignerKey(), "setFunctionParams", new Object[]{functionSetting});
        }
        if (CALL_ACTION_SHOW_CUSTOM_RULE_SERVICE_SETTING.equalsIgnoreCase(actionId)) {
            Map setting = (Map)returnData;
            clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.getDesignerKey(), SET_CUSTOM_RULE_ACTION, new Object[]{setting});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("createextendappandpage".equals(messageBoxClosedEvent.getCallBackId())) {
            String errorMsg = ResManager.loadKDString((String)"\u8d44\u6e90\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5f00\u53d1\u5546\uff0c\u8bf7\u901a\u8fc7\u5f00\u53d1\u5e73\u53f0\u5e94\u7528\u548c\u8d44\u6e90\u6269\u5c55\u6309\u94ae\u6269\u5c55\u540e\u518d\u8fdb\u884c\u7f16\u8f91\u3002", (String)"EntityDesignerPlugin_9", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
        } else if ("openeextendappandpage".equals(messageBoxClosedEvent.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                FormController srv = (FormController)this.getView().getService(IFormController.class);
                String extFormId = this.getPageCache().get("extNum");
                srv.showDesigner(extFormId);
            }
        } else if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"designerheader"});
        }
    }

    private void setInherit(List<?> items) {
        for (Object item : items) {
            ((AbstractElement)item).setInherit(true);
        }
    }

    private boolean checkMetaModifier(Map<String, Object> lastestMetadata, String modifyTimeStamp, StringBuilder errMsgBuilder) {
        if (modifyTimeStamp == null) {
            return true;
        }
        Date lastestModifyDate = (Date)lastestMetadata.get(MODIFY_DATE);
        String modifyId = (String)lastestMetadata.get("modifierId");
        if (!StringUtils.equals((CharSequence)RequestContext.get().getUserId(), (CharSequence)modifyId) && lastestModifyDate != null && lastestModifyDate.getTime() >= Long.parseLong(modifyTimeStamp) + 5000L) {
            if (StringUtils.isNotBlank((CharSequence)modifyId)) {
                Map userInfo = UserServiceHelper.getUserInfoByID((long)Long.parseLong(modifyId));
                if (userInfo != null) {
                    errMsgBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u5143\u6570\u636e\u5df2\u7ecf\u88ab{0}\u5728{1}\u4fdd\u5b58\uff0c\u53ef\u80fd\u5b58\u5728\u7248\u672c\u51b2\u7a81\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u4fee\u6539\u3002", (String)"EntityDesignerPlugin_10", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), userInfo.get("name"), DateFormat.getDateTimeInstance().format(lastestModifyDate)));
                }
            } else {
                errMsgBuilder.append(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u5143\u6570\u636e\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u4fdd\u5b58\uff0c\u53ef\u80fd\u5b58\u5728\u7248\u672c\u51b2\u7a81\u3002\u8bf7\u5237\u65b0\u9875\u9762\u540e\u4fee\u6539\u3002", (String)"EntityDesignerPlugin_11", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    private boolean checkMetadataVersion() {
        String newMergeVer;
        StringBuilder errMsgBuilder;
        String id = this.getPageCache().get(ID);
        if (StringUtils.isBlank((CharSequence)id)) {
            return true;
        }
        String modifyDate = this.getPageCache().get(MODIFY_DATE);
        Map lastestMetadata = MetadataDao.loadDesignerMetadata((String)id);
        if (!this.checkMetaModifier(lastestMetadata, modifyDate, errMsgBuilder = new StringBuilder())) {
            this.getView().showErrorNotification(errMsgBuilder.toString());
            return false;
        }
        String oldMergeVer = this.getPageCache().get(mergeVersion);
        if (!StringUtils.isBlank((CharSequence)oldMergeVer) && !oldMergeVer.equals(newMergeVer = (String)lastestMetadata.get(mergeVersion))) {
            LOG.info(MessageFormat.format(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u5143\u6570\u636e\u6216\u6e90\u9875\u9762\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u4fdd\u5b58\uff0c\u53ef\u80fd\u5b58\u5728\u7248\u672c\u51b2\u7a81\u3002\u8bf7\u5237\u65b0\u9875\u9762\u540e\u4fee\u6539\u3002\u8bbe\u8ba1\u5668\u7f13\u5b58\u7248\u672c\uff1a{0}\uff0c\u65b0\u7248\u672c\uff1a{1}\u3002", (String)"EntityDesignerPlugin_12", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), oldMergeVer, newMergeVer));
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u5143\u6570\u636e\u6216\u6e90\u9875\u9762\u5df2\u7ecf\u88ab\u5176\u4ed6\u7528\u6237\u4fdd\u5b58\uff0c\u53ef\u80fd\u5b58\u5728\u7248\u672c\u51b2\u7a81\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u4fee\u6539\u3002", (String)"EntityDesignerPlugin_13", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean resourceCheck(Map<String, Object> content, IFormView view, List<Map<String, String>> messages) {
        String formMetaIsv;
        String currentIsv = ISVService.getISVInfo().getId();
        if (StringUtils.isBlank((CharSequence)currentIsv)) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u8d26\u53f7\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"EntityDesignerPlugin_14", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            if (view != null) {
                view.showErrorNotification(errorMsg);
            }
            if (messages != null) {
                HashMap<String, String> message = new HashMap<String, String>(2);
                message.put(MESSAGE, errorMsg);
                message.put(MESSAGE_TYPE, ERROR);
                messages.add(message);
            }
            return false;
        }
        if (!this.checkBusinessRule(content)) {
            return false;
        }
        Boolean isDeveloper = (Boolean)content.get("isDeveloper");
        if (null != isDeveloper && !isDeveloper.booleanValue()) {
            return true;
        }
        Map entityMeta = (Map)content.get("entitymeta");
        Map formMeta = (Map)content.get(FORM_META);
        String string = formMetaIsv = formMeta == null ? null : (String)formMeta.get("Isv");
        if (entityMeta != null) {
            String metadataIsv = (String)entityMeta.get("Isv");
            if (StringUtils.isBlank((CharSequence)metadataIsv)) {
                if (ISV_KINGDEE.equalsIgnoreCase(currentIsv)) {
                    metadataIsv = currentIsv;
                } else {
                    if (formMeta != null) {
                        metadataIsv = (String)formMeta.get("Isv");
                    }
                    if (StringUtils.isBlank((CharSequence)metadataIsv)) {
                        metadataIsv = currentIsv;
                    }
                }
                entityMeta.put("Isv", metadataIsv);
            } else if (StringUtils.isNotBlank((CharSequence)formMetaIsv) && !StringUtils.equals((CharSequence)formMetaIsv, (CharSequence)metadataIsv)) {
                metadataIsv = formMetaIsv;
                entityMeta.put("Isv", metadataIsv);
            }
            if (StringUtils.equals((CharSequence)currentIsv, (CharSequence)metadataIsv)) {
                return true;
            }
        }
        String errorMsg = ResManager.loadKDString((String)"\u8d44\u6e90\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5f00\u53d1\u5546\uff0c\u8bf7\u901a\u8fc7\u5f00\u53d1\u5e73\u53f0\u5e94\u7528\u548c\u8d44\u6e90\u6269\u5c55\u6309\u94ae\u6269\u5c55\u540e\u518d\u8fdb\u884c\u7f16\u8f91\u3002", (String)"EntityDesignerPlugin_15", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
        if (view != null) {
            view.showErrorNotification(errorMsg);
        }
        if (messages != null) {
            HashMap<String, String> message = new HashMap<String, String>(2);
            message.put(MESSAGE, errorMsg);
            message.put(MESSAGE_TYPE, ERROR);
            messages.add(message);
        }
        return false;
    }

    private void saveData() {
        if (EnvTypeHelper.isProductEnv()) {
            String errorMsg = ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u73af\u5883\u7a33\u5b9a\uff0c\u751f\u4ea7\u73af\u5883\u6682\u4e0d\u5141\u8bb8\u7f16\u8f91\u5143\u6570\u636e\u3002", (String)"EntityDesignerPlugin_16", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return;
        }
        if (EnvTypeHelper.isDeploying()) {
            String errorMsg = ResManager.loadKDString((String)"\u5e73\u53f0\u6b63\u5728\u8fdb\u884c\u7cfb\u7edf\u5347\u7ea7\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"EntityDesignerPlugin_17", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return;
        }
        if (this.isInValidIsv()) {
            return;
        }
        EntityDesigner designer = this.getEntityDesigner();
        Map content = designer.getContent();
        if (content == null || !this.checkMetadataVersion()) {
            return;
        }
        if (!this.mergeCurrentContent(content, BUSINESS_CONTROL)) {
            return;
        }
        if (!this.mergeCurrentContent(content, BUSINESS_OPERATION)) {
            return;
        }
        if (!this.mergeCurrentContent(content, PERM_CONTROL)) {
            return;
        }
        EntityDesignerData designerData = new EntityDesignerData();
        if (!this.resourceCheck(content, this.getView(), null)) {
            return;
        }
        String talentCode = RequestContext.get().getTenantCode();
        if ("true".equals(System.getProperty(talentCode + "_validateEntryPrimary", "true")) && !this.validateEntryPrimaryKey(content)) {
            return;
        }
        String oldContent = this.getPageCache().get(OLD_METADATA);
        HashMap<String, Object> saveData = new HashMap<String, Object>(10);
        saveData.putAll(content);
        saveData.remove(FORM_META);
        Map allLocaleData = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(LOCALE_ITEMS), Map.class);
        Object oldFormLocale = allLocaleData.remove(FORM);
        String id = (String)content.get(ID);
        Map dbMetaData = MetadataDao.loadDesignerMetadata((String)id, (String)RequestContext.get().getLang().toString());
        if (oldFormLocale != null) {
            allLocaleData.put(FORM, ((Map)dbMetaData.get(LOCALE_ITEMS)).get(FORM));
        }
        content.put(LOCALE_ITEMS, allLocaleData);
        saveData.put(LOCALE_ITEMS, allLocaleData);
        Map formMetaData = (Map)dbMetaData.get(FORM_META);
        saveData.put(FORM_META, formMetaData);
        if (!this.mergeCurrentContent(content, EXTENSIBLE, formMetaData)) {
            return;
        }
        Map result = designerData.save(saveData, (Map)SerializationUtils.fromJsonString((String)oldContent, Map.class));
        Date date = (Date)result.get(MODIFY_DATE);
        this.getPageCache().put(MODIFY_DATE, String.valueOf(date == null ? System.currentTimeMillis() : date.getTime()));
        this.analyseSaveResult(saveData, result);
    }

    private void openMeta(String pageId) {
        if (StringUtils.isNotBlank((CharSequence)pageId) && StringUtils.isNotBlank((CharSequence)this.getPageCache().get(META))) {
            return;
        }
        Map<String, Object> currentMetaData = this.getCurrentMetaData();
        DesignerMetas metas = new DesignerMetas();
        EntityDesignerData designerData = new EntityDesignerData();
        metas.setItems(designerData.getDesignerMeatadata(currentMetaData));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ide_metadataxml");
        showParameter.setCustomParam(METAS, (Object)metas.toJsonString());
        showParameter.setCustomParam(READONLY, (Object)Boolean.TRUE);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(ENTITY_DESIGNER);
        HashMap<String, String> cusOpenStyleParam = new HashMap<String, String>();
        cusOpenStyleParam.put(ONLY_ONE, "false");
        cusOpenStyleParam.put(TAB_ID, META);
        showParameter.getOpenStyle().setCustParam(cusOpenStyleParam);
        this.getPageCache().put(META, showParameter.getPageId());
        this.getView().showForm(showParameter);
    }

    private IDataModel getSubModel(String subId) {
        String pageId = this.getPageCache().get(subId);
        if (StringUtils.isBlank((CharSequence)pageId)) {
            return null;
        }
        IFormView view = SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            return null;
        }
        return view.getModel();
    }

    private IEntityDesignerMergeModel getModelMerger(String subId) {
        String pageId = this.getPageCache().get(subId);
        if (StringUtils.isBlank((CharSequence)pageId)) {
            return null;
        }
        IFormView view = SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            return null;
        }
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        for (IFormPlugin plugIn : pluginProxy.getPlugIns()) {
            if (!(plugIn instanceof IEntityDesignerMergeModel)) continue;
            return (IEntityDesignerMergeModel)plugIn;
        }
        return null;
    }

    private void closeSubPage(String tabId) {
        String pageId = this.getPageCache().get(tabId);
        if (StringUtils.isBlank((CharSequence)pageId)) {
            return;
        }
        IFormView view = SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            return;
        }
        this.getPageCache().remove(tabId);
        view.close();
        this.getView().sendFormAction(view);
    }

    private Map<String, Object> getCurrentContent() {
        return ((EntityDesigner)this.getControl(ENTITY_DESIGNER)).getContent();
    }

    private Map<String, Object> getCurrentMetaData() {
        String oldContentStr = this.getPageCache().get(OLD_METADATA);
        String currentContentStr = this.getPageCache().get(CURRENT_METADATA);
        String contentStr = StringUtils.isNotBlank((CharSequence)currentContentStr) ? currentContentStr : oldContentStr;
        return (Map)SerializationUtils.fromJsonString((String)contentStr, Map.class);
    }

    private boolean mergeCurrentContent(Map<String, Object> context, String subId) {
        return this.mergeCurrentContent(context, subId, null);
    }

    private boolean mergeCurrentContent(Map<String, Object> context, String subId, Map<String, Object> formMeta) {
        IDataModel subModel = this.getSubModel(subId);
        if (subModel == null) {
            return true;
        }
        IEntityDesignerMergeModel modelMerger = this.getModelMerger(subId);
        if (modelMerger == null) {
            return true;
        }
        Map entityMeta = (Map)context.get("entitymeta");
        List items = (List)entityMeta.get(ITEMS);
        Map mainEntity = (Map)items.get(0);
        Map<String, Object> result = null;
        result = formMeta != null ? modelMerger.mergeModel(subModel, mainEntity, entityMeta, formMeta) : modelMerger.mergeModel(subModel, mainEntity, entityMeta);
        if (result == null) {
            return true;
        }
        String sErrors = (String)result.get(ERRORS);
        if (StringUtils.isNotBlank((CharSequence)sErrors)) {
            this.getView().showErrorNotification(sErrors);
            EntityDesigner entityDesigner = this.getEntityDesigner();
            entityDesigner.setTabFocus(subId);
            return false;
        }
        return true;
    }

    private void analyseSaveResult(Map<String, Object> content, Map<String, Object> result) {
        EntityDesigner designer = this.getEntityDesigner();
        boolean success = (Boolean)result.get(SUCCESS);
        if (success) {
            if (!"3".equals(FieldsType.getFieldCreateWay())) {
                this.saveFieldsMap(designer);
            }
            String originMetaData = this.getPageCache().get(ORIGIN_METADATA);
            Map oldMetaDataObj = (Map)SerializationUtils.fromJsonString((String)originMetaData, Map.class);
            MetaIsvCheck.checkEntity(this.getView(), content, oldMetaDataObj);
            String json = SerializationUtils.toJsonString(content);
            this.getPageCache().put(OLD_METADATA, json);
            this.getPageCache().put(CURRENT_METADATA, json);
            Map formMap = (Map)content.get(FORM_META);
            if (formMap != null) {
                String formNumber = (String)formMap.get("Key");
                String formId = (String)formMap.get("Id");
                this.writeLog(formId, formNumber);
            }
            if (Boolean.TRUE.equals(result.get("warning"))) {
                this.getView().showTipNotification((String)result.get(MESSAGE));
            } else {
                this.getView().showSuccessNotification((String)result.get(MESSAGE));
            }
            this.closeSubPage(DATA_MODEL);
            if (DATA_MODEL.equalsIgnoreCase(this.getPageCache().get(CURRENT_TAB_ID))) {
                this.loadSubPage(DATA_MODEL, "bos_devpn_datamodel", null);
            }
            this.closeSubPage(PLUGINS);
            if (PLUGINS.equalsIgnoreCase(this.getPageCache().get(CURRENT_TAB_ID))) {
                this.loadSubPage(PLUGINS, "bos_devpn_plugin", null);
            }
            this.closeSubPage(EXTENSIBLE);
            if (EXTENSIBLE.equalsIgnoreCase(this.getPageCache().get(CURRENT_TAB_ID))) {
                this.loadSubPage(EXTENSIBLE, "devpn_extensibility", null);
            }
            this.rebuildRelatedForm((String)content.getOrDefault(ID, ""));
        } else {
            List errorList = (List)result.get(ERRORS);
            String strError = SerializationUtils.toJsonString((Object)errorList);
            List errorMaps = SerializationUtils.fromJsonStringToList((String)strError, Map.class);
            designer.showErrors(errorMaps);
            this.getView().showErrorNotification(this.buildErrMsg(errorList));
        }
    }

    private void saveFieldsMap(EntityDesigner designer) {
        try {
            String entityId;
            MainEntityType entity;
            if (designer == null) {
                return;
            }
            Map designerContent = designer.getContent();
            if (designerContent == null || designerContent.size() == 0) {
                return;
            }
            Object entityMetaObject = designerContent.get("entitymeta");
            if (entityMetaObject == null) {
                return;
            }
            Object items = ((Map)entityMetaObject).get(ITEMS);
            if (items == null) {
                return;
            }
            ArrayList itemsList = (ArrayList)items;
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_devpn_field");
            String entityNumber = (String)((Map)entityMetaObject).get("Key");
            this.saveDeleteField2Db(entityNumber);
            if ("2".equalsIgnoreCase((String)designerContent.get("devType"))) {
                String parentId = (String)((Map)entityMetaObject).get("ParentId");
                entity = EntityMetadataCache.getDataEntityTypeById((String)parentId);
                entityId = entity.getName();
            } else {
                entity = EntityMetadataCache.getDataEntityType((String)entityNumber);
                entityId = entityNumber;
            }
            for (int i = 0; i < itemsList.size(); ++i) {
                Object refField;
                Map item = (Map)itemsList.get(i);
                if (!FieldsType.FIELD_TYPE_MAPPER.containsKey(item.get("_Type_")) || (refField = item.get("RefField")) == null) continue;
                Map refFieldMap = (Map)SerializationUtils.fromJsonString((String)((String)refField), Map.class);
                Object id = refFieldMap.get("Id");
                DynamicObject fieldData = BusinessDataReader.loadSingle(id, (DynamicObjectType)type);
                DynamicObjectCollection entryRows = fieldData.getDynamicObjectCollection("entryentity");
                boolean refContainCurrentEntity = false;
                String relationType = "R";
                for (DynamicObject row : entryRows) {
                    Object entryentity = row.get(ENTITY_ID_KEY);
                    if (!(entryentity instanceof DynamicObject)) continue;
                    relationType = (String)row.get(MESSAGE_TYPE);
                    if (entityId.equalsIgnoreCase((String)((DynamicObject)entryentity).get(NUMBER)) && "R".equalsIgnoreCase(relationType)) {
                        refContainCurrentEntity = true;
                        break;
                    }
                    if (!"A".equalsIgnoreCase(relationType)) continue;
                    row.set(MESSAGE_TYPE, (Object)"R");
                }
                if (refContainCurrentEntity) continue;
                if ("R".equalsIgnoreCase(relationType)) {
                    int startSeq = entryRows.size();
                    long[] ids = kd.bos.id.ID.genLongIds((int)1);
                    String fieldnumber = (String)item.get("Key");
                    IDataEntityProperty property = (IDataEntityProperty)entity.getAllFields().get(fieldnumber);
                    if (property == null) {
                        LOG.warn("EntityDesignerPlugin.saveFieldsMap property is null, refFieldKey is {}", (Object)fieldnumber);
                        return;
                    }
                    DynamicObject newRow = entryRows.addNew();
                    newRow.set(MESSAGE_TYPE, (Object)"R");
                    newRow.set("fieldkey", (Object)property.getName());
                    newRow.set("entityid_id", (Object)entityId);
                    newRow.set("fieldcaption", (Object)property.getDisplayName());
                    newRow.set("seq", (Object)startSeq++);
                    newRow.set(ID, (Object)ids[0]);
                    BusinessDataWriter.save((IDataEntityType)type, (Object[])new Object[]{fieldData});
                    continue;
                }
                BusinessDataWriter.update((IDataEntityType)type, (Object[])new Object[]{fieldData});
            }
            this.getPageCache().remove("cacherefields");
            this.getPageCache().remove("deleterefieldids");
            this.getPageCache().remove("deletefiledkey");
        }
        catch (Exception e) {
            LOG.error("EntityDesignerPlugin.saveFieldsMap throw excption : {}", (Object)e.getMessage());
        }
    }

    private void rebuildRelatedForm(String entityId) {
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return;
        }
        SqlBuilder builder = new SqlBuilder();
        builder.append("select fid from t_meta_formdesign where ftype != '2' and ", new Object[0]).appendIn("fentityid", new Object[]{entityId});
        List ids = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)builder, resultSet -> {
            ArrayList<String> formIds = new ArrayList<String>(3);
            while (resultSet.next()) {
                formIds.add(resultSet.getString("fid"));
            }
            return formIds;
        });
        for (String id : ids) {
            try {
                MetadataDao.rebuildRuntimeMetaById((String)id);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private String buildErrMsg(List<ErrorInfo> errorList) {
        ArrayList<String> list = new ArrayList<String>(10);
        for (ErrorInfo error : errorList) {
            list.add(error.getError());
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            String s = (String)list.get(i);
            if (i != list.size() - 1) {
                s = StringUtils.replace((String)s, (String)"\u3002", (String)"\uff0c");
            }
            str.append(s).append("\n");
        }
        return str.toString();
    }

    public void afterSetProperty(PropertyEvent e) {
        String propertyName = e.getPropertName();
        if ("Language".equals(propertyName)) {
            EntityDesigner designer = this.getEntityDesigner();
            Map content = designer.getContent();
            String lang = (String)e.getParam().get(VALUE);
            content.put(LOCALE_ITEMS, SerializationUtils.fromJsonString((String)this.getPageCache().get(LOCALE_ITEMS), Map.class));
            EntityDesignerData designerData = new EntityDesignerData();
            Map tMap = designerData.getMeatadata(content, lang);
            String modelType = (String)tMap.get(MODE_TYPE);
            this.fillInheritProperty(tMap, lang);
            designer.open(modelType, tMap);
            designer.sendFieldProsLock(DesignerUtils.getSpecialPropsExtensible((String)((String)tMap.get(ID))));
            this.getPageCache().put(LOCALE_ITEMS, SerializationUtils.toJsonString(tMap.remove(LOCALE_ITEMS)));
        }
    }

    private void fillInheritProperty(Map<String, Object> designMeta, String lang) {
        if (null == designMeta) {
            return;
        }
        String id = (String)designMeta.get(ID);
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        Map originDesignMeta = MetadataDao.loadDesignerMetadata((String)id, (String)lang);
        if (null == originDesignMeta) {
            return;
        }
        Map originEntityMeta = (Map)originDesignMeta.get("entitymeta");
        Map<String, Boolean> originEntityInheritMap = this.getInheritMap(originEntityMeta);
        Map entityMeta = (Map)designMeta.get("entitymeta");
        this.fillInherit(entityMeta, originEntityInheritMap);
    }

    private void fillInherit(Map<String, Object> meta, Map<String, Boolean> inheritMap) {
        if (null == meta) {
            return;
        }
        List items = (List)meta.get(ITEMS);
        if (null == items) {
            return;
        }
        for (Map item : items) {
            String id = (String)item.get("Id");
            if (!StringUtils.isNotBlank((CharSequence)id) || !inheritMap.containsKey(id)) continue;
            item.put("Inherit", inheritMap.get(id));
        }
    }

    private Map<String, Boolean> getInheritMap(Map<String, Object> meta) {
        HashMap<String, Boolean> inheritMap = new HashMap<String, Boolean>();
        if (null == meta) {
            return inheritMap;
        }
        List items = (List)meta.get(ITEMS);
        if (null == items) {
            return inheritMap;
        }
        for (Map item : items) {
            String id = (String)item.get("Id");
            Boolean inherit = (Boolean)item.get("Inherit");
            if (!StringUtils.isNotBlank((CharSequence)id) || null == inherit) continue;
            inheritMap.put(id, inherit);
        }
        return inheritMap;
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        Long userID = 0L;
        Long themeID = 0L;
        String userIDStr = null;
        String themeIDStr = null;
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        switch (key) {
            case "getUserTheme": {
                userIDStr = RequestContext.get().getUserId();
                try {
                    userID = Long.parseLong(userIDStr);
                }
                catch (Exception ex) {
                    return;
                }
                Map theme = UserServiceHelper.getUserTheme((Long)userID);
                clientViewProxy.invokeControlMethod(this.getView().getPageId(), GET_USER_THEME, new Object[]{theme});
                break;
            }
            case "setUserTheme": {
                userIDStr = RequestContext.get().getUserId();
                themeIDStr = e.getEventArgs();
                try {
                    userID = Long.parseLong(userIDStr);
                }
                catch (Exception ex) {
                    return;
                }
                try {
                    themeID = Long.parseLong(themeIDStr);
                }
                catch (Exception ex) {
                    themeID = 0L;
                }
                if (themeID == 0L) {
                    UserServiceHelper.setUserTheme((Long)userID, (String)themeIDStr);
                } else {
                    UserServiceHelper.setUserTheme((Long)userID, (Long)themeID);
                }
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("themeNum", themeIDStr);
                AppCache.get((String)"bos").put("theme" + userID, (Object)SerializationUtils.toJsonString(result));
                break;
            }
            case "getThemeCSS": {
                String themeNum = themeIDStr = e.getEventArgs();
                if (StringUtils.isEmpty((CharSequence)themeNum)) {
                    String errorMessage = ResManager.loadKDString((String)"\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff1a\u4e0d\u5b58\u5728\u53c2\u6570\u201cthemeNum\u201d\u3002", (String)"EntityDesignerPlugin_18", (String)"bos-devportal-new-plugin", (Object[])new Object[0]);
                    clientViewProxy.invokeControlMethod(this.getView().getPageId(), GET_USER_THEME, new Object[]{errorMessage});
                    return;
                }
                String css = UserServiceHelper.getThemeCSS((String)themeNum);
                clientViewProxy.invokeControlMethod(this.getView().getPageId(), "getThemeCSS", new Object[]{css});
                break;
            }
        }
    }

    public void keyDown(KeyPressArgs keys) {
        if (keys.isCtrlKey() && keys.getKeyCode() == 83) {
            this.saveData();
        }
    }

    private void writeLog(String formId, String formNumber) {
        try {
            long fid = DB.genGlobalLongId();
            MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
            logService.addMetaLog(formId, formNumber, (int)MetaLogType.FormDesign.getValue(), fid, (int)MetaType.Form.getValue());
        }
        catch (Exception e) {
            LOG.error(ResManager.loadKDString((String)"\u4fdd\u5b58\u5143\u6570\u636e\u65e5\u5fd7\u5931\u8d25\uff0cerr\uff1a", (String)"EntityDesignerPlugin_21", (String)"bos-devportal-new-plugin", (Object[])new Object[0]) + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    private EntityDesigner getEntityDesigner() {
        return (EntityDesigner)this.getView().getControl(ENTITY_DESIGNER);
    }

    private String getEntityId() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        return (String)showParameter.getCustomParam(ENTITY_ID_KEY);
    }

    private String getAppIdByFormId(String id) {
        String sql = String.format("select fbizappid from t_meta_formdesign where fid = '%s'", id);
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, null, rs -> {
            String id1 = "";
            if (rs.next()) {
                id1 = rs.getString(1);
            }
            return id1;
        });
    }

    @Override
    protected String getDesignerKey() {
        return ENTITY_DESIGNER;
    }

    public void doCall(DesignerCallEvent e) {
        String paramStr;
        List formRuleActionTypes = FormRuleActionTypeCache.getFormRuleActionTypesWithoutExt();
        if (CALL_ACTION_PARSE_RISE_EVENT_TYPES.equalsIgnoreCase(e.getActionId())) {
            List rets = (List)e.getParam();
            for (Map ret : rets) {
                String ServiceTypeId = (String)ret.get(MESSAGE_TYPE);
                Integer retVal = (Integer)ret.get("ret");
                List<Object> checkedList = new ArrayList(10);
                Optional<FormRuleActionType> first = formRuleActionTypes.stream().filter(f -> f.getId().equalsIgnoreCase(ServiceTypeId)).findFirst();
                if (first.isPresent()) {
                    FormRuleActionType ruleType = first.get();
                    checkedList = this.parseRet(ruleType, retVal);
                }
                ret.put("checked", checkedList);
            }
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SET_RISE_EVENT_TYPES, new Object[]{rets});
        } else if (CALL_ACTION_PARSE_RISE_EVENT_VALUES.equalsIgnoreCase(e.getActionId())) {
            List rets = (List)e.getParam();
            for (Map ret : rets) {
                String ServiceTypeId = (String)ret.get(MESSAGE_TYPE);
                List checkedList = (List)ret.get("checked");
                Optional<FormRuleActionType> first = formRuleActionTypes.stream().filter(f -> f.getId().equalsIgnoreCase(ServiceTypeId)).findFirst();
                if (!first.isPresent()) continue;
                FormRuleActionType ruleType = first.get();
                Integer raiseEventType = 255;
                boolean isFieldChanged = checkedList.contains(RaiseEventType.FieldChanged.name());
                raiseEventType = ruleType.isSupportFieldChanged() && isFieldChanged ? raiseEventType : raiseEventType - RaiseEventType.FieldChanged.getValue();
                boolean isLoad = checkedList.contains(RaiseEventType.Initialized.name());
                raiseEventType = ruleType.isSupportInitialized() && isLoad ? raiseEventType : raiseEventType - RaiseEventType.Initialized.getValue();
                boolean isAdd = checkedList.contains(RaiseEventType.ItemAdded.name());
                raiseEventType = ruleType.isSupportItemAdded() && isAdd ? raiseEventType : raiseEventType - RaiseEventType.ItemAdded.getValue();
                ret.put("ret", raiseEventType);
            }
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.getDesignerKey(), CALL_ACTION_SET_RISE_EVENT_VALUES, new Object[]{rets});
        } else if (CALL_ACTION_SHOW_FUNCTION_SETTING.equalsIgnoreCase(e.getActionId())) {
            Map param = (Map)e.getParam();
            String functionId = (String)param.get("fuctionId");
            String fieldTreeStr = (String)param.get("fieldTreeStr");
            String xmlFuncs = (String)this.getView().getFormShowParameter().getCustomParam("functiontypes");
            FunctionType functionType = RuleDesignMetaHelper.getFunctionType(functionId, xmlFuncs);
            if (functionType != null && StringUtils.isNotBlank((CharSequence)functionType.getSettingFormId())) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("bos_devp_function");
                showParameter.setCaption(functionType.getName().getLocaleValue());
                showParameter.getCustomParams().put("funcid", functionId);
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "showFunction");
                showParameter.setCloseCallBack(callBack);
                List designItems = null;
                Map curEntityMeta = (Map)this.getCurrentMetaData().get("entitymeta");
                if (curEntityMeta != null) {
                    designItems = (List)curEntityMeta.get(ITEMS);
                }
                showParameter.setCustomParam("entityItems", designItems);
                showParameter.setCustomParam("entitynumber", this.getView().getFormShowParameter().getCustomParam("entitynumber"));
                FunctionTypes functionTypes = FunctionTypes.get();
                String funcsXml = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
                showParameter.getCustomParams().put("functiontypes", funcsXml);
                showParameter.setCustomParam("vars", (Object)fieldTreeStr);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
            }
        } else if (VALIDATE_FORMULA.equalsIgnoreCase(e.getActionId())) {
            Map curEntityMeta = (Map)this.getCurrentMetaData().get("entitymeta");
            List designItems = (List)curEntityMeta.get(ITEMS);
            EntityMetadata entityMetadata = EntityMetadataUtil.getEntityMetadata((List)designItems);
            String formula = (String)e.getParam();
            FormulaValiate formulaValiate = new FormulaValiate(this, entityMetadata);
            StringBuilder parseResult = formulaValiate.parseFormula(formula);
            Map<String, StringBuilder> result = formulaValiate.checkFunction(parseResult);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.invokeControlMethod(this.getDesignerKey(), VALIDATE_FORMULA, new Object[]{result});
        } else if (CALL_ACTION_SHOW_CUSTOM_RULE_SERVICE_SETTING.equalsIgnoreCase(e.getActionId()) && StringUtils.isNotBlank((CharSequence)(paramStr = (String)e.getParam()))) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bos_devp_customserviceset");
            showParameter.getCustomParams().put("paramStr", paramStr);
            showParameter.setCustomParam("fromProDesigner", (Object)"true");
            showParameter.getCustomParams().put(CURRENT_METADATA, this.getPageCache().get(CURRENT_METADATA));
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, CALL_ACTION_SHOW_CUSTOM_RULE_SERVICE_SETTING);
            showParameter.setCloseCallBack(callBack);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    private List<String> parseRet(FormRuleActionType ruleType, Integer retVal) {
        ArrayList<String> checkedList = new ArrayList<String>(10);
        if (ruleType.isSupportFieldChanged() && (retVal & RaiseEventType.FieldChanged.getValue()) != 0) {
            checkedList.add(RaiseEventType.FieldChanged.name());
        }
        if (ruleType.isSupportInitialized() && (retVal & RaiseEventType.Initialized.getValue()) != 0) {
            checkedList.add(RaiseEventType.Initialized.name());
        }
        if (ruleType.isSupportItemAdded() && (retVal & RaiseEventType.ItemAdded.getValue()) != 0) {
            checkedList.add(RaiseEventType.ItemAdded.name());
        }
        return checkedList;
    }

    private boolean validateEntryPrimaryKey(Map<String, Object> content) {
        if (content.isEmpty()) {
            return Boolean.TRUE;
        }
        Map formMeta = (Map)content.get("entitymeta");
        if (formMeta == null || formMeta.size() == 0) {
            return Boolean.TRUE;
        }
        List items = (List)formMeta.get(ITEMS);
        if (items == null || items.size() == 0) {
            return Boolean.TRUE;
        }
        String routeKey = "";
        for (Map item : items) {
            String tableName;
            if (item.containsKey(DB_ROUTE_R)) {
                routeKey = (String)item.get(DB_ROUTE_R);
            }
            if (StringUtils.isEmpty((CharSequence)(tableName = (String)item.get("TableName")))) continue;
            String entryEntity = (String)item.get("Key");
            String primaryKey = "";
            String type = (String)item.get("_Type_");
            if ("LogBillEntity".equals(type)) {
                routeKey = "log";
            }
            if (item.containsKey("PkFieldName")) {
                primaryKey = (String)item.get("PkFieldName");
            } else if (item.containsKey("EntryPkFieldName")) {
                primaryKey = (String)item.get("EntryPkFieldName");
            } else if (item.containsKey("SubEntryPkFieldName")) {
                primaryKey = (String)item.get("SubEntryPkFieldName");
            } else {
                if (StringUtils.isEmpty((CharSequence)type) || type.contains("Field")) continue;
                switch (type) {
                    case "EntryEntity": 
                    case "TreeEntryEntity": {
                        primaryKey = "FEntryId";
                        break;
                    }
                    case "EmbedSubEntryEntity": 
                    case "TreeSubEntryEntity": 
                    case "SubEntryEntity": {
                        primaryKey = "FDetailID";
                        break;
                    }
                    default: {
                        primaryKey = "FId";
                    }
                }
            }
            if (StringUtils.isEmpty((CharSequence)primaryKey)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%1$s\u7684\u4e3b\u952e\u3002", (String)"EntityDesignerPlugin_22", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), entryEntity));
                return Boolean.FALSE;
            }
            if (StringUtils.isEmpty((CharSequence)routeKey)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u5355\u7684\u8def\u7531\u4e3a\u7a7a\uff0c\u8bf7\u7ed9\u672c\u5355\u6240\u5728\u5e94\u7528\u6307\u5b9a\u6570\u636e\u5e93\u3002", (String)"EntityDesignerPlugin_23", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
            List primaryFields = DB.getPrimaryKeys((DBRoute)DBRoute.of((String)routeKey), (String)tableName);
            if (primaryFields == null || primaryFields.size() == 0 || !StringUtils.isNotEmpty((CharSequence)primaryKey) || primaryKey.equalsIgnoreCase((String)primaryFields.get(0))) continue;
            if ("EntryEntity".equals(type) || "TreeEntryEntity".equals(type) || "SubEntryEntity".equalsIgnoreCase(type) || "TreeSubEntryEntity".equalsIgnoreCase(type) || "EmbedSubEntryEntity".equalsIgnoreCase(type)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5355\u636e\u4f53%1$s\u4e2d\uff0c\u8868%2$s\u5df2\u5b58\u5728\u4e3b\u952e%3$s\uff0c\u8bf7\u52ff\u4fee\u6539\u3002", (String)"EntityDesignerPlugin_24", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), entryEntity, tableName, primaryFields.get(0)));
            } else {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4e3b\u8868%1$s\u4e2d\uff0c\u5df2\u5b58\u5728\u4e3b\u952e%2$s\uff0c\u8bf7\u52ff\u4fee\u6539\u3002", (String)"EntityDesignerPlugin_25", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), tableName, primaryFields.get(0)));
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void cacheRefField(List<Map<String, Object>> cacheProperty) {
        for (int i = 0; i < cacheProperty.size(); ++i) {
            String entityNumber;
            Object entityMetaObject;
            Map designerContent;
            Map<String, Object> prop = cacheProperty.get(i);
            if (!"RefField".equalsIgnoreCase((String)prop.get(PROPERTY_NAME))) continue;
            String refEntityFieldKey = this.getPageCache().get("refEntityFieldKey");
            if (StringUtils.isNotBlank((CharSequence)refEntityFieldKey) && (designerContent = this.getEntityDesigner().getContent()) != null && designerContent.size() > 0 && (entityMetaObject = designerContent.get("entitymeta")) instanceof Map && StringUtils.isNotBlank((CharSequence)(entityNumber = (String)((Map)entityMetaObject).get("Key")))) {
                SqlBuilder sql = new SqlBuilder();
                sql.append("select fid from t_meta_fieldsentry", new Object[0]).appendIn("where fentityid", (Object[])new String[]{entityNumber}).append(" and ffieldkey = ?", new Object[]{new SqlParameter(":ffieldkey", 12, (Object)refEntityFieldKey)});
                Set fieldsIds = (Set)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sql, rs -> {
                    HashSet<Object> fids = new HashSet<Object>(16);
                    while (rs.next()) {
                        fids.add(rs.getObject("fid"));
                    }
                    return fids;
                });
                if (fieldsIds.size() > 0) {
                    this.addFieldId2DeleteFieldCache(fieldsIds);
                }
            }
            String refFieldValue = (String)prop.get(VALUE);
            Map refFieldMap = (Map)SerializationUtils.fromJsonString((String)refFieldValue, Map.class);
            long fieldId = (Long)refFieldMap.get("Id");
            this.addFieldId2CacheRefFieldCache(fieldId, refFieldMap);
        }
    }

    private void addFieldId2CacheRefFieldCache(long fieldId, Map<String, Object> refFieldMap) {
        String cacheRefFields = this.getPageCache().get("cacherefields");
        Map cacheRefFieldMap = StringUtils.isBlank((CharSequence)cacheRefFields) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)cacheRefFields, Map.class);
        cacheRefFieldMap.put(Long.toString(fieldId), refFieldMap);
        this.getPageCache().put("cacherefields", SerializationUtils.toJsonString(cacheRefFieldMap));
    }

    @Override
    protected void deleteRefField(PropertyEvent e) {
        boolean deleteRefFieldFromDb = true;
        long deleteFieldId = 0L;
        String cacheRefFields = this.getPageCache().get("cacherefields");
        if (StringUtils.isNotBlank((CharSequence)cacheRefFields)) {
            Map refFieldMap;
            Map cacheRefFieldMap = (Map)SerializationUtils.fromJsonString((String)cacheRefFields, Map.class);
            String refFieldValue = (String)e.getParam().get("RefField");
            if (StringUtils.isNotBlank((CharSequence)refFieldValue) && (refFieldMap = (Map)SerializationUtils.fromJsonString((String)refFieldValue, Map.class)) != null && refFieldMap.size() > 0 && cacheRefFieldMap.containsKey(Long.toString(deleteFieldId = ((Long)refFieldMap.get("Id")).longValue()))) {
                deleteRefFieldFromDb = false;
                cacheRefFieldMap.remove(Long.toString(deleteFieldId));
                this.getPageCache().put("cacherefields", SerializationUtils.toJsonString((Object)cacheRefFieldMap));
            }
        }
        HashMap<String, String> propMap = new HashMap<String, String>();
        propMap.put("itemId", e.getItemId());
        propMap.put("metaType", e.getMetaType());
        propMap.put(PROPERTY_NAME, "RefField");
        propMap.put(VALUE, "");
        EntityDesigner designer = (EntityDesigner)this.getView().getControl(this.getDesignerKey());
        designer.setProperty(propMap);
        if (deleteRefFieldFromDb && deleteFieldId == 0L) {
            Map refFieldMap;
            Object refFieldObject = e.getParam().get("RefField");
            if (refFieldObject instanceof String && StringUtils.isNotBlank(refFieldObject) && !"\"\"".equals(refFieldObject) && (refFieldMap = (Map)SerializationUtils.fromJsonString((String)((String)refFieldObject), Map.class)) != null && refFieldMap.size() > 0) {
                deleteFieldId = (Long)refFieldMap.get("Id");
            }
            HashSet<Object> deleteFields = new HashSet<Object>();
            deleteFields.add(deleteFieldId);
            this.addFieldId2DeleteFieldCache(deleteFields);
        }
    }

    private void addFieldId2DeleteFieldCache(Set<Object> deleteFieldId) {
        String deleteRefFieldStr = this.getPageCache().get("deleterefieldids");
        Set deleteIdsCache = StringUtils.isBlank((CharSequence)deleteRefFieldStr) ? new HashSet() : (Set)SerializationUtils.fromJsonString((String)deleteRefFieldStr, Set.class);
        deleteIdsCache.addAll(deleteFieldId);
        this.getPageCache().put("deleterefieldids", SerializationUtils.toJsonString(deleteIdsCache));
    }

    private void saveDeleteField2Db(String entityNumber) {
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            String deleteFieldStr;
            String deleteRefFieldStr = this.getPageCache().get("deleterefieldids");
            if (StringUtils.isNotBlank((CharSequence)deleteRefFieldStr)) {
                ArrayList<Object> fids = new ArrayList<Object>();
                Set deleteIdsCache = (Set)SerializationUtils.fromJsonString((String)deleteRefFieldStr, Set.class);
                for (Object id : deleteIdsCache) {
                    if (id instanceof String) {
                        fids.add(Long.valueOf((String)id));
                        continue;
                    }
                    fids.add(id);
                }
                if (fids.size() > 0) {
                    SqlBuilder sql = new SqlBuilder();
                    sql.append("delete from t_meta_fieldsentry ", new Object[0]).appendIn("where fid", fids).appendIn(" and fentityid", (Object[])new String[]{entityNumber}).append(" and ftype= 'R'", new Object[0]);
                    DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)sql);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(deleteFieldStr = this.getPageCache().get("deletefiledkey")))) {
                ArrayList fieldsNumbers = new ArrayList();
                Set cacheDeletField = (Set)SerializationUtils.fromJsonString((String)deleteFieldStr, Set.class);
                for (Object fieldNum : cacheDeletField) {
                    if (!(fieldNum instanceof String)) continue;
                    fieldsNumbers.add(fieldNum);
                }
                if (fieldsNumbers.size() > 0) {
                    SqlBuilder sql = new SqlBuilder();
                    sql.append("delete from t_meta_fieldsentry ", new Object[0]).appendIn("where fentityid", (Object[])new String[]{entityNumber}).appendIn("and ffieldkey", fieldsNumbers);
                    DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)sql);
                }
            }
        }
    }

    private boolean checkBusinessRule(Map<String, Object> content) {
        EntityMetadata entityMetadata;
        Map formMeta = (Map)content.get(FORM_META);
        String modelType = (String)formMeta.get("ModelType");
        PrintMetadataConverter converter = "PrintModel".equals(modelType) ? new PrintMetadataConverter() : new FormMetadataConverter();
        FormMetadata formMetadata = (FormMetadata)converter.convertTo(content);
        List formRuleActionTypes = FormRuleActionTypeCache.getFormRuleActionTypesWithoutExt();
        ArrayList<String> actionTypes = new ArrayList<String>(10);
        if (formRuleActionTypes != null) {
            for (FormRuleActionType formRuleActionType : formRuleActionTypes) {
                actionTypes.add(formRuleActionType.getId());
            }
        }
        if ((entityMetadata = formMetadata.getEntityMetadata()) != null) {
            List items = entityMetadata.getItems();
            List rootEntityRules = entityMetadata.getRootEntity().getRules();
            boolean check = this.checkBizRule(rootEntityRules, actionTypes, ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"RuleDesignMetaHelper_1", (String)"bos-devportal-new-plugin", (Object[])new Object[0]));
            if (!check) {
                return false;
            }
            for (EntityItem entityItem : items) {
                if (!(entityItem instanceof EntryEntity)) continue;
                ArrayList<BizRule> rules = new ArrayList<BizRule>(10);
                rules.addAll(((EntryEntity)entityItem).getRules());
                String desc = String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\uff1a%s", (String)"RuleDesignMetaHelper_2", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), entityItem.getKey());
                boolean entityCheck = this.checkBizRule(rules, actionTypes, desc);
                if (entityCheck) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkBizRule(List<BizRule> rules, List<String> actionTypes, String parentDesc) {
        if (rules == null) {
            return true;
        }
        for (BizRule rule : rules) {
            List falseAction;
            List trueAction = rule.getTrueActions();
            if (trueAction != null) {
                for (BizRuleAction action : trueAction) {
                    String actionType = action.getActionType();
                    if (!StringUtils.isNotBlank((CharSequence)actionType) || actionTypes.contains(actionType)) continue;
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e0a\u7684\u89c4\u5219\uff1a\u201c%2$s\u201d \u5b58\u5728\u4e0d\u652f\u6301\u7684Action\u7c7b\u578b\uff1a[%3$s]\uff0c\u8bf7\u524d\u5f80\u65e7\u7248\u5f00\u53d1\u5e73\u53f0\u8bbe\u8ba1\u5668\u8fdb\u884c\u914d\u7f6e\u3002", (String)"RuleDesignMetaHelper_3", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), parentDesc, rule.getDescription(), actionType));
                    return false;
                }
            }
            if ((falseAction = rule.getFalseActions()) == null) continue;
            for (BizRuleAction action : falseAction) {
                String actionType = action.getActionType();
                if (!StringUtils.isNotBlank((CharSequence)actionType) || actionTypes.contains(actionType)) continue;
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e0a\u7684\u89c4\u5219\uff1a\u201c%2$s\u201d \u5b58\u5728\u4e0d\u652f\u6301\u7684Action\u7c7b\u578b\uff1a[%3$s]\uff0c\u8bf7\u524d\u5f80\u65e7\u7248\u5f00\u53d1\u5e73\u53f0\u8bbe\u8ba1\u5668\u8fdb\u884c\u914d\u7f6e\u3002", (String)"RuleDesignMetaHelper_3", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), parentDesc, rule.getDescription(), actionType));
                return false;
            }
        }
        return true;
    }
}

