/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.entity;

import java.util.EventObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.newdevportal.entity.widget.EntityDetailBizRuleHolder;
import kd.bos.newdevportal.entity.widget.EntityDetailFieldHolder;
import kd.bos.newdevportal.entity.widget.EntityDetailPropertiesHolder;
import kd.bos.newdevportal.entity.widget.EntityDetailSummaryHolder;

public class EntityDetailPlugIn
extends AbstractFormPlugin
implements RowClickEventListener {
    private EntityDetailSummaryHolder summaryHolder;
    private EntityDetailPropertiesHolder propertiesHolder;
    private EntityDetailFieldHolder fieldHolder;
    private EntityDetailBizRuleHolder bizRuleHolder;

    public void initialize() {
        super.initialize();
        this.summaryHolder = new EntityDetailSummaryHolder(this.getView(), this.getModel());
        this.propertiesHolder = new EntityDetailPropertiesHolder(this.getView(), this.getModel());
        this.fieldHolder = new EntityDetailFieldHolder(this.getView(), this.getModel());
        this.bizRuleHolder = new EntityDetailBizRuleHolder(this.getView(), this.getModel());
    }

    public void afterCreateNewData(EventObject e) {
        String formNumber = this.getFormNumber();
        this.loadFormDesignMeta(formNumber);
    }

    private void loadFormDesignMeta(String formNumber) {
        String formId = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Form);
        String entityId = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Entity);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        formMeta.bindEntityMetadata(entityMeta);
        this.summaryHolder.assemble(formMeta, entityMeta);
        this.fieldHolder.assemble(formMeta, entityMeta);
        this.bizRuleHolder.assemble(formMeta, entityMeta);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String formId = MetadataDao.getIdByNumber((String)this.getFormNumber(), (MetaCategory)MetaCategory.Form);
        this.propertiesHolder.afterBindData(this.getBizAppId(), formId);
    }

    private String getFormNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam("formNumber");
    }

    private String getBizAppId() {
        return (String)this.getView().getFormShowParameter().getCustomParam("bizAppId");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry cardEntry = (CardEntry)this.getControl("table_list");
        cardEntry.addRowClickListener((RowClickEventListener)this);
        EntryGrid bizEntry = (EntryGrid)this.getControl("entry_rule");
        bizEntry.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        Control control = (Control)evt.getSource();
        if ("table_list".equals(control.getKey())) {
            int row = evt.getRow();
            String entityId = MetadataDao.getIdByNumber((String)this.getFormNumber(), (MetaCategory)MetaCategory.Entity);
            EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            this.fieldHolder.entryRowClick(row, entityMeta);
            return;
        }
        if ("entry_rule".equals(control.getKey())) {
            int row = evt.getRow();
            String entityId = MetadataDao.getIdByNumber((String)this.getFormNumber(), (MetaCategory)MetaCategory.Entity);
            EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            this.bizRuleHolder.entryRowClick(row, this.getFormNumber(), entityMeta);
            return;
        }
    }

    public static FormShowParameter show(String bizAppId, String formNumber) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bos_devpn_entitydetail");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCustomParam("formNumber", (Object)formNumber);
        param.setCustomParam("bizAppId", (Object)bizAppId);
        return param;
    }
}

