/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.entity;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;

public class EntityTreeListPlugin
extends StandardTreeListPlugin {
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        FormShowParameter showParameter = new FormShowParameter();
        ListSelectedRow selectedRow = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo();
        showParameter.setCustomParam("entityId", selectedRow.getPrimaryKeyValue());
        showParameter.setFormId("bos_devp_entitydesign");
        showParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        showParameter.setStatus(OperationStatus.VIEW);
        MainEntityType mainEntity = EntityMetadataCache.getDataEntityTypeById((String)selectedRow.getPrimaryKeyValue().toString());
        showParameter.setCaption(mainEntity.getDisplayName().toString());
        this.getView().getMainView().showForm(showParameter);
        this.getView().sendFormAction(this.getView().getMainView());
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent nodeEvent) {
        super.buildTreeListFilter(nodeEvent);
        String nodeId = nodeEvent.getNodeId().toString();
        QFilter modelFilter = this.getModelFilter(nodeId);
        modelFilter.and(new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel")));
        nodeEvent.addQFilter(modelFilter);
        nodeEvent.setCancel(true);
    }

    protected QFilter getModelFilter(String nodeId) {
        QFilter qFilter = null;
        ORM orm = ORM.create();
        boolean isCloud = orm.exists("bos_devportal_bizcloud", (Object)nodeId);
        if (nodeId.equals("-1")) {
            qFilter = new QFilter("bizappid.id", "is not null", (Object)"");
        } else if (isCloud) {
            JSONArray units = this.getAppIdsByCloudId(nodeId);
            qFilter = new QFilter("bizappid.id", "in", (Object)units);
        } else {
            qFilter = new QFilter("bizappid.id", "=", (Object)nodeId);
        }
        return qFilter;
    }

    private JSONArray getAppIdsByCloudId(String bizCloudId) {
        JSONArray appIds = new JSONArray();
        List lstAppInfo = BizAppServiceHelp.getAppsDesigntimeInfo((String)bizCloudId);
        if (lstAppInfo != null) {
            for (String info : lstAppInfo) {
                Map app = (Map)SerializationUtils.fromJsonString((String)info, Map.class);
                String bizAppId = (String)app.get("id");
                appIds.add((Object)bizAppId);
            }
        }
        return appIds;
    }

    public void initialize() {
        super.initialize();
        ((ListView)this.getView()).setNeedRefreshTree(false);
        this.setBarItemVisible(false);
    }

    public void initializeTree(EventObject e) {
        this.initTree();
    }

    private void initTree() {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"AbstractEntityTreePlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setId("-1");
        root.setIsOpened(true);
        List<TreeNode> cloudNodes = this.getAllCloudNodes();
        for (TreeNode treeNode : cloudNodes) {
            List<TreeNode> groupNodes = this.getAppNodesByCloudId(treeNode.getId());
            this.addChildNode(treeNode, groupNodes);
        }
        root.addChildren(cloudNodes);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.setBarItemVisible(false);
    }

    protected List<TreeNode> getAllCloudNodes() {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pagetype");
        if (pageType != null && "extend".equals(pageType)) {
            String refAppId = (String)formShowParameter.getCustomParam("refappid");
            DynamicObject cloudObject = BizCloudServiceHelp.getBizCloudByAppID((String)refAppId);
            TreeNode node = new TreeNode("-1", cloudObject.getString("id"), cloudObject.getLocaleString("name").getLocaleValue());
            cloudNode.add(node);
        } else {
            DynamicObjectCollection dynamicObjects = BizCloudServiceHelp.getAllBizClouds();
            for (DynamicObject dynamicObject : dynamicObjects) {
                TreeNode node = new TreeNode();
                node.setId(dynamicObject.getString("id"));
                node.setText(dynamicObject.getString("name"));
                node.setParentid("-1");
                cloudNode.add(node);
            }
        }
        return cloudNode;
    }

    private TreeNode addChildNode(TreeNode pnode, List<TreeNode> childNodes) {
        for (int i = 0; i < childNodes.size(); ++i) {
            TreeNode cnode = childNodes.get(i);
            String parentId = cnode.getParentid();
            if (!pnode.getId().equals(parentId)) continue;
            pnode.addChild(this.addChildNode(cnode, childNodes));
        }
        return pnode;
    }

    private void setBarItemVisible(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"btnnew", "btnedit", "btndel"});
    }

    protected List<TreeNode> getAppNodesByCloudId(String cloudId) {
        ArrayList<TreeNode> appNodes = new ArrayList<TreeNode>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pagetype");
        if (pageType != null && "extend".equals(pageType)) {
            String refAppId = (String)formShowParameter.getCustomParam("refappid");
            AppMetadata refAppMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)refAppId, (boolean)false);
            String refAppName = refAppMeta.getName().getLocaleValue();
            TreeNode node = new TreeNode(cloudId, refAppId, refAppName);
            appNodes.add(node);
        } else {
            DynamicObjectCollection dynamicObjects = BizAppServiceHelp.getAllBizAppsByCloudID((String)cloudId);
            for (DynamicObject dynamicObject : dynamicObjects) {
                TreeNode node = new TreeNode();
                String nodeId = dynamicObject.getString("id");
                node.setId(nodeId);
                node.setText(dynamicObject.getString("name"));
                node.setParentid(cloudId);
                appNodes.add(node);
            }
        }
        return appNodes;
    }
}

