/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.entity.bizmodel;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;

public class BusinessObjectDetailsPlugin
extends AbstractFormPlugin {
    private static final String OBJECT_NAME = "objectname";
    private static final String ENTITY_AND_FIELD = "entityandfield";
    private static final String DATA_MODEL = "datamodel";
    private static final String BUSINESS_RULES = "businessrules";
    private static final String BUSINESS_OPERATION = "businessoperation";
    private static final String BUSINESS_CONTROL = "businesscontrol";
    private static final String PERM_CONTROL = "permcontrol";
    private static final String PLUGINS = "plugins";
    private static final String PAGE_LAYOUT = "pagelayout";
    private static final String SEARCH_AP = "searchap";
    private static final String ENTITY_ID_KEY = "entityId";
    private static final String ACTIVE_TAB = "activeTab";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{ENTITY_AND_FIELD, DATA_MODEL, BUSINESS_RULES, BUSINESS_OPERATION, BUSINESS_CONTROL, PERM_CONTROL, PLUGINS, PAGE_LAYOUT, SEARCH_AP});
    }

    public void afterCreateNewData(EventObject e) {
        this.hiddenControls();
        this.loadTheCorrespondingPage(ENTITY_AND_FIELD, "bos_devpn_entityandfield");
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_ID_KEY);
        MainEntityType mainEntity = EntityMetadataCache.getDataEntityTypeById((String)entityId);
        String objectName = mainEntity.getDisplayName().toString();
        this.getModel().setValue(OBJECT_NAME, (Object)objectName);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "entityandfield": {
                this.loadTheCorrespondingPage(ENTITY_AND_FIELD, "bos_devpn_entityandfield");
                this.hiddenControls();
                break;
            }
            case "datamodel": {
                this.loadTheCorrespondingPage(DATA_MODEL, "bos_devpn_datamodel");
                this.hiddenControls();
                break;
            }
            case "businessrules": {
                this.loadTheCorrespondingPage(BUSINESS_RULES, "bos_devpn_businessrule");
                this.hiddenControls();
                break;
            }
            case "businessoperation": {
                this.loadTheCorrespondingPage(BUSINESS_OPERATION, "bos_devpn_businessop");
                this.hiddenControls();
                break;
            }
            case "businesscontrol": {
                this.loadTheCorrespondingPage(BUSINESS_CONTROL, "bos_devpn_businesscontrol");
                this.hiddenControls();
                break;
            }
            case "permcontrol": {
                this.loadTheCorrespondingPage(PERM_CONTROL, "bos_devpn_permcontrol");
                this.hiddenControls();
                break;
            }
            case "plugins": {
                this.loadTheCorrespondingPage(PLUGINS, "bos_devpn_plugin");
                this.hiddenControls();
                break;
            }
        }
    }

    private void loadTheCorrespondingPage(String tab, String pageNumber) {
        FormShowParameter parentFormShowParameter = this.getView().getFormShowParameter();
        if (BUSINESS_OPERATION.equals(tab)) {
            String string = (String)parentFormShowParameter.getCustomParam(ENTITY_ID_KEY);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(pageNumber);
        showParameter.setCustomParam(ENTITY_ID_KEY, parentFormShowParameter.getCustomParam(ENTITY_ID_KEY));
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("specificpage");
        this.getView().showForm(showParameter);
        this.setActiveTab(tab);
    }

    private void hiddenControls() {
        this.getView().setVisible(Boolean.FALSE, new String[]{SEARCH_AP});
    }

    private void pageLayoutHiddenControls() {
        this.getView().setVisible(Boolean.TRUE, new String[]{SEARCH_AP});
    }

    private void setActiveTab(String tab) {
        HashMap<String, String> paramMap;
        String oldTab = this.getView().getPageCache().get(ACTIVE_TAB);
        if (StringUtils.isNotBlank((CharSequence)oldTab)) {
            paramMap = new HashMap<String, String>();
            paramMap.put("fc", "#212121");
            this.getView().updateControlMetadata(oldTab, paramMap);
        }
        paramMap = new HashMap();
        paramMap.put("fc", "#0E5FD8");
        this.getView().updateControlMetadata(tab, paramMap);
        this.getView().getPageCache().put(ACTIVE_TAB, tab);
    }
}

