/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.entity.designer;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.domainmodel.Category;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.define.DomainModelTypeFactory;

public class AddFieldSelectorPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_BTNCANCEL = "btncancel";
    private static final String KEY_FIELDTYPE = "cmbfieldtype";
    private static final String KEY_FIELDNAME = "txtfieldname";
    private static final String KEY_FIELDNUMBER = "txtfieldnumber";
    protected static final String ENTITY_ID = "entityId";
    protected static final String IS_STD = "isStd";
    protected static final String FIELD_NUMBER = "fieldNumber";
    protected static final String FIELD_NAME = "fieldName";
    protected static final String FIELD_TYPE = "fieldType";
    protected static final String FROM_ITEM = "fromitem";
    private static final String[] NUMBERS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";

    public void initialize() {
        this.addClickListeners(new String[]{KEY_BTNOK, KEY_BTNCANCEL});
    }

    public void afterCreateNewData(EventObject evt) {
        ComboEdit comboFieldType = (ComboEdit)this.getControl(KEY_FIELDTYPE);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        DomainModelType domainModelType = DomainModelTypeFactory.getDomainModelType((String)this.getModelType(), (boolean)true);
        for (Category category : domainModelType.getCategories()) {
            if (!"Field".equalsIgnoreCase(category.getBaseType())) continue;
            for (ElementType elementType : category.getElementTypes()) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(elementType.getName());
                comboItem.setValue(elementType.getId());
                comboItems.add(comboItem);
            }
        }
        comboFieldType.setComboItems(comboItems);
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        switch (btn.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btnok": {
                this.doOk();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    private String getModelType() {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
        return modelType == null ? "BillFormModel" : modelType;
    }

    private void doOk() {
        String fieldNumber = (String)this.getModel().getValue(KEY_FIELDNUMBER);
        if (StringUtils.isBlank((CharSequence)fieldNumber)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6807\u8bc6\u3002", (String)"AddFieldSelectorPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.endsWithIgnoreCase((CharSequence)fieldNumber, (CharSequence)"_id")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6807\u8bc6\u4e0d\u80fd\u4ee5\u7279\u6b8a\u5b57\u7b26\u201c_id\u201d\u7ed3\u5c3e\u3002", (String)"AddFieldSelectorPlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (this.startWithNumber(fieldNumber)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6807\u8bc6\u4e0d\u80fd\u4ee5[0-9]\u6570\u5b57\u5f00\u5934\u3002", (String)"AddFieldSelectorPlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String fieldName = (String)this.getModel().getValue(KEY_FIELDNAME);
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\u3002", (String)"AddFieldSelectorPlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String fieldType = (String)this.getModel().getValue(KEY_FIELDTYPE);
        if (StringUtils.isBlank((CharSequence)fieldType)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5b57\u6bb5\u7c7b\u578b\u3002", (String)"AddFieldSelectorPlugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(FIELD_NUMBER, fieldNumber);
        data.put(FIELD_NAME, fieldName);
        data.put(FIELD_TYPE, fieldType);
        data.put(ENTITY_ID, formShowParameter.getCustomParam(ENTITY_ID));
        data.put(IS_STD, formShowParameter.getCustomParam(IS_STD));
        data.put(FROM_ITEM, formShowParameter.getCustomParam(FROM_ITEM));
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    private boolean startWithNumber(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        return StringUtils.startsWithAny((CharSequence)str.trim(), (CharSequence[])NUMBERS);
    }
}

