/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.entity.designer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.newdevportal.entity.designer.EntityTableDictUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

class DataExportUtil {
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static Log log = LogFactory.getLog(DataExportUtil.class);

    DataExportUtil() {
    }

    private static List<EntityTableDictUtil.EntityTableData> getTables(EntityMetadata meta) {
        ArrayList<EntityTableDictUtil.EntityTableData> tables = new ArrayList<EntityTableDictUtil.EntityTableData>();
        for (Entity it : meta.getEntitys()) {
            List<EntityTableDictUtil.EntityTableData> tableList = EntityTableDictUtil.getTableInfo(meta, it, false);
            tables.addAll(tableList);
        }
        return tables;
    }

    private static void fillExcel(XSSFSheet sheet, XSSFCellStyle cellStyle, int rowStartIndex, List<EntityTableDictUtil.EntityTableData> tables) {
        for (EntityTableDictUtil.EntityTableData info : tables) {
            int index;
            XSSFRow tableNameRow = sheet.createRow(rowStartIndex);
            tableNameRow.createCell(0).setCellValue(info.tableName);
            XSSFRow firstRow = sheet.createRow(++rowStartIndex);
            firstRow.createCell(0).setCellValue(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b57\u6bb5\u540d\u79f0", (String)"DataExportUtil_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            firstRow.createCell(1).setCellValue(ResManager.loadKDString((String)"\u5b57\u6bb5\u7f16\u7801", (String)"DataExportUtil_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            firstRow.createCell(2).setCellValue(ResManager.loadKDString((String)"\u5b57\u6bb5\u7c7b\u578b", (String)"DataExportUtil_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            firstRow.createCell(3).setCellValue(ResManager.loadKDString((String)"\u5fc5\u586b", (String)"DataExportUtil_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            firstRow.createCell(4).setCellValue(ResManager.loadKDString((String)"\u5b57\u6bb5\u957f\u5ea6", (String)"DataExportUtil_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            firstRow.createCell(5).setCellValue(ResManager.loadKDString((String)"\u662f\u5426\u4e3b\u952e", (String)"DataExportUtil_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            Iterator it = firstRow.cellIterator();
            for (index = 0; it.hasNext() && index < 6; ++index) {
                ((Cell)it.next()).setCellStyle((CellStyle)cellStyle);
            }
            for (EntityTableDictUtil.ColumnDesc column : info.cols) {
                XSSFRow row = sheet.createRow(++rowStartIndex);
                row.createCell(0).setCellValue(column.des);
                row.createCell(1).setCellValue(column.fieldName);
                row.createCell(2).setCellValue(column.typeName);
                row.createCell(3).setCellValue(column.mustInput);
                row.createCell(4).setCellValue(column.length);
                row.createCell(5).setCellValue(column.isPrimary);
                it = row.cellIterator();
                for (index = 0; it.hasNext() && index < 6; ++index) {
                    ((Cell)it.next()).setCellStyle((CellStyle)cellStyle);
                }
            }
            rowStartIndex += 3;
        }
    }

    protected static void exportExcelByTable(IFormView view, List<EntityTableDictUtil.EntityTableData> tables, String fileNamePrefix) throws IOException {
        DataExportUtil.exportExcelHandler(view, fileNamePrefix, tables);
    }

    protected static void exportExcel(IFormView view, List<String> entityIds, Set<String> outputTables, String fileNamePrefix) throws IOException {
        ArrayList<EntityTableDictUtil.EntityTableData> tables = new ArrayList<EntityTableDictUtil.EntityTableData>(16);
        for (String entityId : entityIds) {
            try {
                EntityMetadata meta = null;
                meta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
                tables.addAll(DataExportUtil.getTables(meta));
            }
            catch (Exception e) {}
        }
        List<EntityTableDictUtil.EntityTableData> outputTb = tables.stream().filter(DataExportUtil.distinctByKey(p -> p == null || p.tableName == null ? "" : p.tableName, outputTables)).collect(Collectors.toList());
        DataExportUtil.exportExcelHandler(view, fileNamePrefix, outputTb);
    }

    private static void exportExcelHandler(IFormView view, String fileNamePrefix, List<EntityTableDictUtil.EntityTableData> tables) throws IOException {
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            XSSFSheet sheet = workbook.createSheet("sheet1");
            XSSFCellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setBorderBottom(BorderStyle.THICK);
            cellStyle.setBorderLeft(BorderStyle.THICK);
            cellStyle.setBorderRight(BorderStyle.THICK);
            cellStyle.setBorderTop(BorderStyle.THICK);
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            int rowIndex = 0;
            DataExportUtil.fillExcel(sheet, cellStyle, rowIndex, tables);
            File temp = File.createTempFile(FilenameUtils.getName((String)(fileNamePrefix + "-")), ".xlsx");
            DataExportUtil.fileOutputHandler(temp, workbook, fileNamePrefix, view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fileOutputHandler(File temp, XSSFWorkbook workbook, String fileNamePrefix, IFormView view) throws IOException {
        FileOutputStream out = new FileOutputStream(temp);
        workbook.write((OutputStream)out);
        out.close();
        workbook.close();
        temp.deleteOnExit();
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        FileInputStream fis = new FileInputStream(temp);
        try {
            String url = cache.saveAsFullUrl(fileNamePrefix + ".xlsx", (InputStream)fis, 300);
            view.openUrl(url);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor, Set<String> outList) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        if (outList == null || outList.isEmpty()) {
            return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
        }
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null && outList.contains(keyExtractor.apply(t));
    }

    protected static void exportExcel(IFormView view, List<String> entityIds, String fileNamePrefix) throws IOException {
        DataExportUtil.exportExcel(view, entityIds, null, fileNamePrefix);
    }
}

