/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.entity.designer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.newdevportal.entity.designer.DataExportUtil;
import kd.bos.newdevportal.entity.designer.EntityTableDictUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DataTableDetailPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";

    public void afterCreateNewData(EventObject e) {
        String tableName = (String)this.getView().getFormShowParameter().getCustomParam("tablename");
        if (tableName == null) {
            tableName = "t_test2223333";
        }
        String sql = "select t1.fmainentityid from t_meta_tableref t1 inner join t_meta_tabledict t2 on t1.fid = t2.fid  where t2.ftablename = ? ";
        SqlBuilder sb = new SqlBuilder();
        sb.append(sql, new Object[]{new SqlParameter(":ftablename", 12, (Object)tableName)});
        List entityList = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sb, rs -> {
            ArrayList<String> result = new ArrayList<String>(10);
            while (rs.next()) {
                result.add(rs.getString("fmainentityid"));
            }
            return result;
        });
        this.getModel().setValue("caption", (Object)String.format(ResManager.loadKDString((String)"\u6570\u636e\u8868\u540d\uff1a%s", (String)"DataTableDetailPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), tableName));
        if (entityList.isEmpty()) {
            return;
        }
        this.getModel().deleteEntryData("refentity");
        this.getModel().batchCreateNewEntryRow("refentity", entityList.size());
        SqlBuilder metaBuild = new SqlBuilder();
        metaBuild.append("select fid, fbizappid from t_meta_entitydesign where ", new Object[0]).appendIn("fid", entityList);
        Map mapping = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)metaBuild, rs -> {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(16);
            while (rs.next()) {
                result.put(rs.getString("fid"), rs.getString("fbizappid"));
            }
            return result;
        });
        int i = 0;
        for (Map.Entry row : mapping.entrySet()) {
            this.getModel().setValue("entityid", row.getKey(), i);
            this.getModel().setValue("bizapp", row.getValue(), i);
            ++i;
        }
        EntityMetadata meta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)((String)mapping.keySet().iterator().next()), (MetaCategory)MetaCategory.Entity);
        ArrayList<EntityTableDictUtil.EntityTableData> infos = new ArrayList<EntityTableDictUtil.EntityTableData>();
        boolean found = false;
        block1: for (Entity entity : meta.getEntitys()) {
            if (found) break;
            for (EntityTableDictUtil.EntityTableData info : EntityTableDictUtil.getTableInfo(meta, entity, false)) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)info.tableName, (CharSequence)tableName)) continue;
                infos.add(info);
                found = true;
                continue block1;
            }
        }
        this.getModel().deleteEntryData("tabledic");
        if (infos.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("tabledic", ((EntityTableDictUtil.EntityTableData)infos.get((int)0)).cols.size());
        for (i = 0; i < ((EntityTableDictUtil.EntityTableData)infos.get((int)0)).cols.size(); ++i) {
            EntityTableDictUtil.ColumnDesc col = ((EntityTableDictUtil.EntityTableData)infos.get((int)0)).cols.get(i);
            this.getModel().setValue("fielddes", (Object)col.des, i);
            this.getModel().setValue("fieldname", (Object)col.fieldName, i);
            this.getModel().setValue("fieldtype", (Object)col.typeName, i);
            this.getModel().setValue("ismustinput", (Object)col.mustInput, i);
            this.getModel().setValue("fieldlength", (Object)col.length, i);
            this.getModel().setValue("isprimarykey", (Object)col.isPrimary, i);
        }
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbar"});
        EntryGrid grid = (EntryGrid)this.getControl("refentity");
        grid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        if ("export".equals(evt.getItemKey())) {
            try {
                this.doExport();
            }
            catch (IOException e) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25", (String)"DataTableDetailPlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            }
        }
    }

    private void doExport() throws IOException {
        int index;
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet("sheet1");
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        XSSFRow firstRow = sheet.createRow(0);
        cellStyle.setBorderBottom(BorderStyle.THICK);
        cellStyle.setBorderLeft(BorderStyle.THICK);
        cellStyle.setBorderRight(BorderStyle.THICK);
        cellStyle.setBorderTop(BorderStyle.THICK);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        firstRow.createCell(0).setCellValue(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b57\u6bb5\u540d", (String)"DataTableDetailPlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        firstRow.createCell(1).setCellValue(ResManager.loadKDString((String)"\u5b57\u6bb5\u7f16\u7801", (String)"DataTableDetailPlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        firstRow.createCell(2).setCellValue(ResManager.loadKDString((String)"\u5b57\u6bb5\u7c7b\u578b", (String)"DataTableDetailPlugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        firstRow.createCell(3).setCellValue(ResManager.loadKDString((String)"\u5fc5\u586b", (String)"DataTableDetailPlugin_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        firstRow.createCell(4).setCellValue(ResManager.loadKDString((String)"\u5b57\u6bb5\u957f\u5ea6", (String)"DataTableDetailPlugin_6", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        firstRow.createCell(5).setCellValue(ResManager.loadKDString((String)"\u662f\u5426\u4e3b\u952e", (String)"DataTableDetailPlugin_7", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        Iterator it = firstRow.cellIterator();
        for (index = 0; it.hasNext() && index < 6; ++index) {
            ((Cell)it.next()).setCellStyle((CellStyle)cellStyle);
        }
        DynamicObjectCollection cols = this.getModel().getEntryEntity("tabledic");
        int i = 1;
        for (DynamicObject obj : cols) {
            XSSFRow row = sheet.createRow(i);
            row.createCell(0).setCellValue(obj.getString("fielddes"));
            row.createCell(1).setCellValue(obj.getString("fieldname"));
            row.createCell(2).setCellValue(obj.getString("fieldtype"));
            row.createCell(3).setCellValue(obj.getBoolean("ismustinput"));
            row.createCell(4).setCellValue(obj.getString("fieldlength"));
            row.createCell(5).setCellValue(obj.getBoolean("isprimarykey"));
            ++i;
            it = row.cellIterator();
            for (index = 0; it.hasNext() && index < 6; ++index) {
                ((Cell)it.next()).setCellStyle((CellStyle)cellStyle);
            }
        }
        File temp = File.createTempFile(FilenameUtils.getName((String)(this.getModel().getValue("caption").toString() + "-")), ".xlsx");
        String fileNamePrefix = this.getModel().getValue("caption").toString();
        DataExportUtil.fileOutputHandler(temp, workbook, fileNamePrefix, this.getView());
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        int row = arg0.getRowIndex();
        this.getModel().getValue("refentity");
        Object data = this.getModel().getValue("entityid", row);
        String entityId = "";
        entityId = data instanceof DynamicObject ? ((DynamicObject)data).getString("id") : data.toString();
        FormShowParameter show = new FormShowParameter();
        show.setFormId("bos_devp_entitydesign");
        show.setCustomParam("entityId", (Object)entityId);
        show.getOpenStyle().setShowType(ShowType.NewTabPage);
        show.getOpenStyle().setTargetKey("_submaintab_");
        if (this.getView().getMainView() != null) {
            this.getView().getMainView().showForm(show);
            this.getView().sendFormAction(this.getView().getMainView());
        } else {
            show.getOpenStyle().setShowType(ShowType.NewWindow);
            show.getOpenStyle().setTargetKey("");
            this.getView().showForm(show);
        }
    }
}

