/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.entity.designer;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListHyperLinkClickEvent;
import kd.bos.list.events.ListHyperLinkClickListener;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.newdevportal.entity.designer.DataExportUtil;
import kd.bos.newdevportal.entity.designer.EntityTableDictUtil;
import kd.bos.newdevportal.entity.designer.EntityTableSyncTask;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class EntityTableDictListPlugin
extends StandardTreeListPlugin
implements ListHyperLinkClickListener,
HyperLinkClickListener,
IConfirmCallBack {
    private static String Key_BillListCtl = "billlistap";
    private static String Key_ToolBarCtl = "toolbarap";
    private static String Key_TableName = "tablename";
    private static String Key_ToolbarItem_Export = "export";
    private static String Key_ToolbarItem_Sync = "sync";
    private static String OpKey_Export = "export";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private Map<String, String> providerContext = new HashMap<String, String>();

    private Map<String, String> getProviderContext() {
        return this.providerContext;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new EntityTableListProvider(this.getProviderContext(), this.getView()));
    }

    public void initializeTree(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanel_treebtn"});
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, null, null, (String)"app");
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"EntityTableDictListPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        treeView.addNode(root);
        this.getTreeListView().getTreeModel().setRoot(root);
        this.getTreeListView().getTreeView().focusNode(root);
    }

    public void afterBindData(EventObject e) {
        if (StringUtils.isBlank((CharSequence)this.getPageCache().get("needNotifySync"))) {
            int refCount = (Integer)DB.query((DBRoute)DBRoute.meta, (String)"select count(1) from t_meta_tableref;", null, rs -> {
                int count = 0;
                while (rs.next()) {
                    count = rs.getInt(1);
                }
                return count;
            });
            int dictCount = (Integer)DB.query((DBRoute)DBRoute.meta, (String)"select count(1) from t_meta_tabledict;", null, rs -> {
                int count = 0;
                while (rs.next()) {
                    count = rs.getInt(1);
                }
                return count;
            });
            int entitycount = (Integer)DB.query((DBRoute)DBRoute.meta, (String)"select count(1) from t_meta_entityinfo ;", null, rs -> {
                int count = 0;
                while (rs.next()) {
                    count = rs.getInt(1);
                }
                return count;
            });
            if (refCount - entitycount < Integer.getInteger("tabledict.check.count", 0) || dictCount == 0) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("needsync", (IConfirmCallBack)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7cfb\u7edf\u68c0\u6d4b\u5230\u6709\u65b0\u589e\u6570\u636e\u8868\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u540c\u6b65\uff1f\u672c\u6b21\u540c\u6b65\u5927\u7ea6\u8017\u65f66\u5206\u949f\u3002", (String)"EntityTableDictListPlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
            }
            this.getPageCache().put("needNotifySync", "false");
        }
        TreeNode currNode = null;
        Map currNodeMap = this.getTreeListView().getTreeView().getTreeState().getFocusNode();
        currNode = currNodeMap == null ? this.getTreeModel().getRoot() : (TreeNode)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)currNodeMap), TreeNode.class);
        this.getTreeListView().getTreeView().focusNode(currNode);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        String nodeId = e.getNodeId() == null ? "rootNode" : e.getNodeId().toString();
        TreeNode node = this.getTreeListView().getTreeModel().getRoot().getTreeNode(nodeId, 10);
        Object type = node.getData();
        if (StringUtils.equalsIgnoreCase((CharSequence)"cloud", (CharSequence)String.valueOf(type))) {
            e.addQFilter(new QFilter("entryentity.mainentity.bizapp.bizcloud.id", "=", (Object)nodeId));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"app", (CharSequence)String.valueOf(type))) {
            e.addQFilter(new QFilter("entryentity.mainentity.bizapp.id", "in", this.getAppIdsBy(nodeId)));
        }
    }

    private List<String> getAppIdsBy(String appId) {
        DynamicObjectCollection allApps = BizAppServiceHelp.getAllBizApps();
        String masterId = allApps.stream().filter(obj -> StringUtils.equals((CharSequence)appId, (CharSequence)obj.getString("id"))).findFirst().map(app -> {
            String tType = app.getString("type");
            if (StringUtils.equals((CharSequence)"0", (CharSequence)tType)) {
                return app.getString("id");
            }
            return app.getString("masterid");
        }).orElse("");
        if (StringUtils.isBlank((CharSequence)masterId)) {
            return new ArrayList<String>();
        }
        return allApps.stream().filter(obj -> {
            String tId = obj.getString("id");
            String tMasterId = obj.getString("masterid");
            return StringUtils.equals((CharSequence)masterId, (CharSequence)tId) || StringUtils.equals((CharSequence)masterId, (CharSequence)tMasterId);
        }).map(obj -> obj.getString("id")).collect(Collectors.toList());
    }

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(Key_BillListCtl);
        billList.addPackageDataListener(t -> {
            Object src = t.getSource();
            if (src instanceof DynamicTextColumnDesc && "refnums".equals(((AbstractColumnDesc)src).getKey())) {
                String tableName = t.getRowData().getString(Key_TableName);
                String refEntityNums = this.getProviderContext().get(tableName);
                t.setFormatValue((Object)refEntityNums);
            }
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl(Key_BillListCtl);
        billList.addListHyperLinkClickListener((ListHyperLinkClickListener)this);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{Key_ToolBarCtl});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (Key_ToolbarItem_Export.equals(itemKey)) {
            String nodeId = this.getTreeListView().getTreeView().getTreeState().getFocusNodeId();
            if (!StringUtils.isBlank((CharSequence)nodeId)) {
                TreeNode node = this.getTreeModel().getRoot().getTreeNode(nodeId, 10);
                QFilter[] filters = null;
                QFilter[] tableFilter = null;
                switch (String.valueOf(node.getData())) {
                    case "cloud": {
                        filters = new QFilter[]{new QFilter("bizapp.bizcloud.id", "=", (Object)node.getId())};
                        tableFilter = new QFilter[]{new QFilter("entryentity.mainentity.bizapp.bizcloud.id", "=", (Object)node.getId())};
                        break;
                    }
                    case "app": {
                        filters = new QFilter[]{new QFilter("bizapp.id", "=", (Object)node.getId())};
                        tableFilter = new QFilter[]{new QFilter("entryentity.mainentity.bizapp.id", "in", this.getAppIdsBy(node.getId()))};
                        break;
                    }
                    default: {
                        filters = null;
                    }
                }
                DynamicObjectCollection col = QueryServiceHelper.query((String)"bos_entitymeta", (String)"id", (QFilter[])filters);
                ArrayList<String> entityId = new ArrayList<String>();
                for (DynamicObject row : col) {
                    entityId.add(row.getString("id"));
                }
                ORM orm = ORM.create();
                HashSet<String> tableNames = new HashSet<String>(16);
                try (DataSet dts = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "bos_devp_tabledict", "id,tablename", tableFilter, null, -1, (Distinctable)WithDistinctable.get());){
                    while (dts.hasNext()) {
                        Row row = dts.next();
                        tableNames.add(row.getString("tablename"));
                    }
                }
                try {
                    Date date = new Date();
                    SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
                    DataExportUtil.exportExcel(this.getView(), entityId, tableNames, String.format(ResManager.loadKDString((String)"\u6279\u91cf\u5bfc\u51fa-%d", (String)"EntityTableDictListPlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[]{df.format(date)}), new Object[0]));
                }
                catch (Exception e) {
                    this.getView().showErrorNotification(e.getMessage());
                }
            }
        } else if (Key_ToolbarItem_Sync.equals(itemKey)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("sync", (IConfirmCallBack)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u672c\u6b21\u540c\u6b65\u5927\u7ea6\u8017\u65f66\u5206\u949f\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u540c\u6b65\u3002", (String)"EntityTableDictListPlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent arg0) {
        if (arg0.getResult() == MessageBoxResult.No) {
            return;
        }
        if ("sync".equals(arg0.getCallBackId()) || "needsync".equals(arg0.getCallBackId())) {
            block17: {
                try (DLock lock = DLock.create((String)"entitydesignerplugin_tableinfo_sync");){
                    if (lock.tryLock(2000L)) {
                        break block17;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u540c\u6b65\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"EntityTableDictListPlugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                    return;
                }
            }
            this.doSyncData();
        }
    }

    private void doSyncData() {
        FormShowParameter show = new FormShowParameter();
        show.setFormId("bos_devpn_opprogress");
        JobInfo job = new JobInfo();
        job.setAppId("bos");
        job.setJobType(JobType.REALTIME);
        job.setTimeout(7200);
        job.setTaskClassname(EntityTableSyncTask.class.getName());
        HashMap<String, String> map = new HashMap<String, String>(1);
        String taskId = JobClient.dispatch((JobInfo)job);
        map.put("taskId", taskId);
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.Modal);
        show.setOpenStyle(style);
        show.setCustomParams(map);
        show.setShowTitle(false);
        CloseCallBack cb = new CloseCallBack((IFormPlugin)this, "synccallback");
        show.setCloseCallBack(cb);
        this.getView().showForm(show);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
    }

    public void closedCallBack(ClosedCallBackEvent arg0) {
        if ("synccallback".equals(arg0.getActionId())) {
            Object data = arg0.getReturnData();
            if (StringUtils.isNotBlank((Object)data)) {
                Map returnData = (Map)SerializationUtils.fromJsonString((String)data.toString(), Map.class);
                Object msg = returnData.get("msg");
                Object msgType = returnData.get("msgType");
                if (StringUtils.isBlank((Object)data) || StringUtils.isBlank(msgType)) {
                    return;
                }
                switch (msgType.toString()) {
                    case "error": {
                        this.getView().showErrorNotification(msg.toString());
                        break;
                    }
                    case "success": {
                        this.getView().showSuccessNotification(msg.toString());
                        break;
                    }
                }
            }
            this.getTreeListView().focusRootNode();
            this.getTreeModel().getRoot().setExpend(false);
            this.getView().invokeOperation("refresh");
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode parent = root.getTreeNode(nodeId, 20);
        TreeNode cnode = root.getTreeNode(nodeId, 5);
        e.setChildNodes(cnode.getChildren());
        if (parent != null) {
            this.getTreeListView().getTreeView().expand(nodeId);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent paramHyperLinkClickEvent) {
        FormShowParameter show = new FormShowParameter();
        BillList billList = (BillList)this.getControl(Key_BillListCtl);
        Object pk = billList.getFocusRowPkId();
        DynamicObject obj = BusinessDataReader.loadHead((Object)pk, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_devp_tabledict"));
        String tableName = obj.getString(Key_TableName);
        show.setFormId("bos_devpn_tabledetail");
        show.setCustomParam(Key_TableName, (Object)tableName);
        show.getOpenStyle().setShowType(ShowType.NewTabPage);
        show.getOpenStyle().setTargetKey("_submaintab_");
        if (this.getView().getMainView() != null) {
            this.getView().getMainView().showForm(show);
            this.getView().sendFormAction(this.getView().getMainView());
        } else {
            show.getOpenStyle().setShowType(ShowType.Modal);
            show.getOpenStyle().setTargetKey("");
            this.getView().showForm(show);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Donothing op;
        BillList billList = (BillList)this.getControl(Key_BillListCtl);
        if (args.getSource() instanceof Donothing && OpKey_Export.equals((op = (Donothing)args.getSource()).getOperateKey())) {
            Object pk = billList.getFocusRowPkId();
            DynamicObject obj = BusinessDataReader.loadHead((Object)pk, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_devp_tabledict"));
            String tableId = obj.getPkValue().toString();
            HashMap entityTableMapping = new HashMap();
            SqlBuilder sb = new SqlBuilder();
            SqlParameter pkValueParameter = new SqlParameter(":fid", 12, (Object)tableId);
            Object[] params = new SqlParameter[]{pkValueParameter};
            sb.append("select t1.ftablename, t2.FMAINENTITYID from t_meta_tabledict t1 inner join t_meta_tableref t2 on t1.fid = t2.fid  where t1.fid = ?", params);
            entityTableMapping.putAll((Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sb, rs -> {
                HashMap mapping = new HashMap();
                while (rs.next()) {
                    String tableName = rs.getString("FTABLENAME");
                    mapping.putIfAbsent(tableName, new ArrayList());
                    ((List)mapping.get(tableName)).add(rs.getString("FMAINENTITYID"));
                }
                return mapping;
            }));
            try {
                if (entityTableMapping.isEmpty()) {
                    return;
                }
                ArrayList<EntityTableDictUtil.EntityTableData> tbs = new ArrayList<EntityTableDictUtil.EntityTableData>();
                String fielName = "";
                block2: for (Map.Entry row : entityTableMapping.entrySet()) {
                    EntityMetadata meta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)((String)((List)row.getValue()).get(0)), (MetaCategory)MetaCategory.Entity);
                    String tableName = (String)row.getKey();
                    boolean found = false;
                    block3: for (Entity it : meta.getEntitys()) {
                        if (found) continue block2;
                        for (EntityTableDictUtil.EntityTableData tableInfo : EntityTableDictUtil.getTableInfo(meta, it, false)) {
                            if (!StringUtils.equalsIgnoreCase((CharSequence)tableInfo.tableName, (CharSequence)tableName)) continue;
                            tbs.add(tableInfo);
                            fielName = tableName;
                            found = true;
                            continue block3;
                        }
                    }
                }
                DataExportUtil.exportExcelByTable(this.getView(), tbs, fielName);
            }
            catch (IOException e) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25", (String)"EntityTableDictListPlugin_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            }
        }
    }

    public void hyperLinkClick(ListHyperLinkClickEvent e) {
    }

    static class EntityTableListProvider
    extends ListDataProvider {
        private Map<String, String> refEntityNums = new HashMap<String, String>(16);

        public EntityTableListProvider(Map<String, String> refEntityNums) {
            this.refEntityNums = refEntityNums;
        }

        public EntityTableListProvider(Map<String, String> refEntityNums, IFormView view) {
            this(refEntityNums);
        }

        public int getMaxReturnData() {
            return 10000;
        }

        public int getRealCount() {
            int id;
            ORM orm = ORM.create();
            try (DataSet dts = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), this.getQueryBuilder().getEntityName(), "id", this.getQueryBuilder().getFilters(), null, -1, (Distinctable)WithDistinctable.get());){
                id = dts.count("id", true);
            }
            return id;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            limit = Math.min(limit, 10000);
            start = Math.min(start, limit);
            DynamicObjectCollection cols = super.getData(start, limit);
            this.refEntityNums.clear();
            ArrayList<Object> pkIds = new ArrayList<Object>(cols.size());
            for (DynamicObject dyn : cols) {
                pkIds.add(dyn.getPkValue());
            }
            if (!pkIds.isEmpty()) {
                SqlBuilder sb = new SqlBuilder();
                sb.append(" select t1.ftablename tablename,t3.fnumber number from t_meta_tabledict t1 inner join t_meta_tableref t2 on t1.fid=t2.fid inner join t_meta_entitydesign t3 on t2.fmainentityid = t3.fid where  ", new Object[0]).appendIn("t1.fid", pkIds.toArray());
                DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sb, rs -> {
                    while (rs.next()) {
                        String tableName = rs.getString("tablename");
                        String old = this.refEntityNums.putIfAbsent(tableName, "");
                        if (old == null) {
                            this.refEntityNums.put(tableName, rs.getString("number"));
                            continue;
                        }
                        this.refEntityNums.put(tableName, String.join((CharSequence)",", old, rs.getString("number")));
                    }
                    return null;
                });
            }
            return cols;
        }
    }
}

