/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.entity.designer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.newdevportal.entity.designer.DataExportUtil;
import kd.bos.newdevportal.entity.designer.EntityTableDictUtil;

public class EntityTableDictPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(EntityTableDictPlugin.class);
    private static final String PREFIXKEY_ENTRYGRID = "mtb_gridview";
    private static final String PREFIXKEY_FIELDKEY = "mtb_fieldkey";
    private static final String PREFIXKEY_FIELDNAME = "mtb_fieldname";
    private static final String PREFIXKEY_FIELDNAMEDES = "mtb_fieldnamedes";
    private static final String PREFIXKEY_FIELDDBTYPE = "mtb_fielddbtype";
    private static final String PREFIXKEY_MUSTINPUT = "mtb_mustinput";
    private static final String PREFIXKEY_ISPRIMARY = "mtb_isprimary";
    private static final String PREFIXKEY_FIELDLENGHT = "mtb_fieldlenght";
    private static final String PREFIXKEY_ENTRYFLEX = "mtb_flex";
    private static final String PREFIXKEY_ENTRYNAMETAG = "mtb_entrynametag";
    private static final String LOCKVALUE = "new,edit,view";
    private static final String VISITVALUE = "init,new,edit,view,submit,audit";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private List<EntityTableDictUtil.EntityTableData> tables = null;

    private String getEntityId(FormShowParameter show) {
        String entityId = (String)show.getCustomParam("entityId");
        return StringUtils.isBlank((CharSequence)entityId) ? MetadataDao.getIdByNumber((String)"zytest_ttt111", (MetaCategory)MetaCategory.Entity) : entityId;
    }

    private List<EntityTableDictUtil.EntityTableData> getTables(String entityId) {
        if (this.tables != null) {
            return this.tables;
        }
        EntityMetadata meta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        this.tables = new ArrayList<EntityTableDictUtil.EntityTableData>();
        for (Entity it : meta.getEntitys()) {
            List<EntityTableDictUtil.EntityTableData> tableList = EntityTableDictUtil.getTableInfo(meta, it, false);
            this.tables.addAll(tableList);
        }
        return this.tables;
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        FormShowParameter show = (FormShowParameter)e.getSource();
        List<EntityTableDictUtil.EntityTableData> alltables = this.getTables(this.getEntityId(show));
        HashMap<String, Object> mapHead = new HashMap<String, Object>();
        mapHead.put("id", "advconchildpanelap");
        mapHead.put("items", this.createEntryMeta(alltables));
        e.getItems().add(mapHead);
    }

    private List<Map<String, Object>> createEntryMeta(List<EntityTableDictUtil.EntityTableData> alltables) {
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>(alltables.size());
        for (int i = 0; i < alltables.size(); ++i) {
            datas.add(this.createTableContainerAp(alltables.get(i), i).createControl());
        }
        return datas;
    }

    private void fillProp(Field<?> field, String key) {
        field.setKey(key);
    }

    private void fillFieldAp(FieldAp ap, String key, Field<?> field, LocaleString width, LocaleString name, String visit, String lock) {
        ap.setField(field);
        ap.setKey(key);
        ap.setWidth(width);
        ap.setName(name);
        ap.setVisible(visit);
        ap.setLock(lock);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormRoot root = (FormRoot)this.getView().getRootControl();
        List<EntityTableDictUtil.EntityTableData> datas = this.getTables(this.getEntityId(this.getView().getFormShowParameter()));
        root.getItems().addAll(this.creatControl(datas));
    }

    private List<Container> creatControl(List<EntityTableDictUtil.EntityTableData> datas) {
        ArrayList<Container> controls = new ArrayList<Container>(1);
        int max = datas.size();
        for (int index = 0; index < max; ++index) {
            Container container = (Container)this.createTableContainerAp(datas.get(index), index).buildRuntimeControl();
            this.setView((Control)container, this.getView());
            controls.add(container);
        }
        return controls;
    }

    private void setView(Control t, IFormView view) {
        t.setView(view);
        t.setModel(view.getModel());
        if (t instanceof EntryGrid) {
            ((EntryGrid)t).setEntryKey(t.getKey());
        }
        if (t instanceof Container) {
            for (Control ctl : ((Container)t).getItems()) {
                this.setView(ctl, view);
            }
        }
    }

    private FlexPanelAp createFlexPanel(String key, Style style) {
        FlexPanelAp flex = new FlexPanelAp();
        flex.setKey(key);
        if (style != null) {
            flex.setStyle(style);
        }
        flex.setAlignItems("stretch");
        flex.setJustifyContent("flex-start");
        flex.setDirection("column");
        flex.setWrap(false);
        return flex;
    }

    private ContainerAp<?> createTableContainerAp(EntityTableDictUtil.EntityTableData info, int i) {
        Style outerFlexStyle = new Style();
        Padding pad = new Padding();
        pad.setTop("10px");
        pad.setBottom("15px");
        outerFlexStyle.setPadding(pad);
        FlexPanelAp outerFlex = this.createFlexPanel("outerflex" + i, outerFlexStyle);
        FlexPanelAp labelFlex = this.createFlexPanel("labelflex" + i, null);
        labelFlex.setShrink(0);
        labelFlex.setGrow(0);
        FlexPanelAp entryFlex = this.createFlexPanel(PREFIXKEY_ENTRYFLEX + i, null);
        LabelAp captionAp = new LabelAp();
        captionAp.setKey("mtb_caption" + i);
        captionAp.setName(new LocaleString(info.tableName));
        captionAp.setFontSize(15);
        captionAp.setFontWeight("bold");
        Style captionStyle = new Style();
        Padding captionPad = new Padding();
        Border captionBorder = new Border();
        Margin margin = new Margin();
        margin.setBottom("5px");
        captionBorder.setLeft("4px_solid_#cccccc");
        captionStyle.setMargin(margin);
        captionAp.setStyle(captionStyle);
        captionPad.setLeft("10px");
        captionPad.setBottom("2px");
        captionStyle.setPadding(captionPad);
        captionStyle.setBorder(captionBorder);
        labelFlex.getItems().add(captionAp);
        EntryAp entryAp = new EntryAp();
        entryAp.setGrow(1);
        EntryFieldAp fieldKeyAp = new EntryFieldAp();
        TextField fieldKey = new TextField();
        this.fillProp((Field<?>)fieldKey, PREFIXKEY_FIELDKEY + i);
        this.fillFieldAp((FieldAp)fieldKeyAp, PREFIXKEY_FIELDKEY + i, (Field<?>)fieldKey, new LocaleString("16.6%"), new LocaleString(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b57\u6bb5\u6807\u8bc6", (String)"EntityTableDictPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0])), "", LOCKVALUE);
        EntryFieldAp fieldNameAp = new EntryFieldAp();
        TextField fieldName = new TextField();
        this.fillProp((Field<?>)fieldName, PREFIXKEY_FIELDNAME + i);
        this.fillFieldAp((FieldAp)fieldNameAp, PREFIXKEY_FIELDNAME + i, (Field<?>)fieldName, new LocaleString("16.6%"), new LocaleString(ResManager.loadKDString((String)"\u5b57\u6bb5\u7f16\u7801", (String)"EntityTableDictPlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0])), VISITVALUE, LOCKVALUE);
        EntryFieldAp fieldNameDesAp = new EntryFieldAp();
        TextField fieldNameDes = new TextField();
        this.fillProp((Field<?>)fieldNameDes, PREFIXKEY_FIELDNAMEDES + i);
        this.fillFieldAp((FieldAp)fieldNameDesAp, PREFIXKEY_FIELDNAMEDES + i, (Field<?>)fieldNameDes, new LocaleString("16.6%"), new LocaleString(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b57\u6bb5\u540d\u79f0", (String)"EntityTableDictPlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0])), VISITVALUE, LOCKVALUE);
        EntryFieldAp fieldDBTypeAp = new EntryFieldAp();
        TextField fieldDBType = new TextField();
        this.fillProp((Field<?>)fieldDBType, PREFIXKEY_FIELDDBTYPE + i);
        this.fillFieldAp((FieldAp)fieldDBTypeAp, PREFIXKEY_FIELDDBTYPE + i, (Field<?>)fieldDBType, new LocaleString("16.6%"), new LocaleString(ResManager.loadKDString((String)"\u5b57\u6bb5\u7c7b\u578b", (String)"EntityTableDictPlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0])), VISITVALUE, LOCKVALUE);
        EntryFieldAp mustInputAp = new EntryFieldAp();
        CheckBoxField mustInput = new CheckBoxField();
        this.fillProp((Field<?>)mustInput, PREFIXKEY_MUSTINPUT + i);
        this.fillFieldAp((FieldAp)mustInputAp, PREFIXKEY_MUSTINPUT + i, (Field<?>)mustInput, new LocaleString("16.6%"), new LocaleString(ResManager.loadKDString((String)"\u5fc5\u586b", (String)"EntityTableDictPlugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0])), VISITVALUE, LOCKVALUE);
        EntryFieldAp fieldLenghtAp = new EntryFieldAp();
        TextField fieldLenght = new TextField();
        this.fillProp((Field<?>)fieldLenght, PREFIXKEY_FIELDLENGHT + i);
        this.fillFieldAp((FieldAp)fieldLenghtAp, PREFIXKEY_FIELDLENGHT + i, (Field<?>)fieldLenght, new LocaleString("16.6%"), new LocaleString(ResManager.loadKDString((String)"\u5b57\u6bb5\u957f\u5ea6", (String)"EntityTableDictPlugin_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0])), VISITVALUE, LOCKVALUE);
        EntryFieldAp primaryAp = new EntryFieldAp();
        CheckBoxField primary = new CheckBoxField();
        this.fillProp((Field<?>)primary, PREFIXKEY_ISPRIMARY + i);
        this.fillFieldAp((FieldAp)primaryAp, PREFIXKEY_ISPRIMARY + i, (Field<?>)primary, new LocaleString("16.6%"), new LocaleString(ResManager.loadKDString((String)"\u662f\u5426\u4e3b\u952e", (String)"EntityTableDictPlugin_6", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0])), VISITVALUE, LOCKVALUE);
        entryAp.setKey(PREFIXKEY_ENTRYGRID + i);
        entryAp.getItems().add(fieldKeyAp);
        entryAp.getItems().add(fieldNameDesAp);
        entryAp.getItems().add(fieldNameAp);
        entryAp.getItems().add(fieldDBTypeAp);
        entryAp.getItems().add(fieldLenghtAp);
        entryAp.getItems().add(mustInputAp);
        entryAp.getItems().add(primaryAp);
        entryFlex.getItems().add(entryAp);
        outerFlex.getItems().add(labelFlex);
        outerFlex.getItems().add(entryFlex);
        return outerFlex;
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbar"});
    }

    public void afterCreateNewData(EventObject e) {
        List<EntityTableDictUtil.EntityTableData> alltables = this.getTables(this.getEntityId(this.getView().getFormShowParameter()));
        int i = 0;
        for (EntityTableDictUtil.EntityTableData tableInfo : alltables) {
            this.fillEntryInfo(tableInfo, i);
            ++i;
        }
        String entityId = this.getEntityId(this.getView().getFormShowParameter());
        this.getModel().setValue("caption", (Object)String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\uff1a %s", (String)"EntityTableDictPlugin_7", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), MetadataDao.getEntityNumberById((String)entityId)));
    }

    private void fillEntryInfo(EntityTableDictUtil.EntityTableData info, int index) {
        this.getModel().deleteEntryData(PREFIXKEY_ENTRYGRID + index);
        this.getModel().batchCreateNewEntryRow(PREFIXKEY_ENTRYGRID + index, info.cols.size());
        int i = 0;
        for (EntityTableDictUtil.ColumnDesc col : info.cols) {
            this.getModel().setValue(PREFIXKEY_FIELDKEY + index, (Object)col.key, i);
            this.getModel().setValue(PREFIXKEY_FIELDNAME + index, (Object)col.fieldName, i);
            this.getModel().setValue(PREFIXKEY_FIELDNAMEDES + index, (Object)col.des, i);
            this.getModel().setValue(PREFIXKEY_FIELDDBTYPE + index, (Object)col.typeName, i);
            this.getModel().setValue(PREFIXKEY_MUSTINPUT + index, (Object)col.mustInput, i);
            this.getModel().setValue(PREFIXKEY_ISPRIMARY + index, (Object)col.isPrimary, i);
            this.getModel().setValue(PREFIXKEY_FIELDLENGHT + index, (Object)col.length, i);
            ++i;
        }
        this.getView().updateView("tablecaption" + index);
        this.getView().updateView(PREFIXKEY_ENTRYGRID + index);
    }

    public void itemClick(ItemClickEvent evt) {
        if ("export".equals(evt.getItemKey())) {
            try {
                this.doExport();
            }
            catch (IOException e) {
                log.error((Throwable)e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25", (String)"EntityTableDictPlugin_16", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            }
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("DynamicCreateCardEntry", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    private void registDynamicProps(MainEntityType newMainType) {
        List<EntityTableDictUtil.EntityTableData> datas = this.getTables(this.getEntityId(this.getView().getFormShowParameter()));
        for (int i = 0; i < datas.size(); ++i) {
            EntryType entryType = (EntryType)newMainType.getAllEntities().get(PREFIXKEY_ENTRYGRID + i);
            if (entryType == null) {
                entryType = new EntryType();
                entryType.setName(PREFIXKEY_ENTRYGRID + i);
                entryType.setAlias("");
                entryType.setDbIgnore(true);
                EntryProp prop = new EntryProp(PREFIXKEY_ENTRYGRID + i, (DynamicObjectType)entryType);
                prop.setDefaultRows(0);
                newMainType.registerCollectionProperty((DynamicCollectionProperty)prop);
            }
            TextProp fieldkey = this.creatTextProp(PREFIXKEY_FIELDKEY + i, ResManager.loadKDString((String)"\u5b57\u6bb5\u7f16\u7801", (String)"EntityTableDictPlugin_8", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            entryType.registerSimpleProperty((DynamicSimpleProperty)fieldkey);
            TextProp fieldname = this.creatTextProp(PREFIXKEY_FIELDNAME + i, ResManager.loadKDString((String)"\u5b57\u6bb5\u540d", (String)"EntityTableDictPlugin_9", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            entryType.registerSimpleProperty((DynamicSimpleProperty)fieldname);
            TextProp fieldnamedes = this.creatTextProp(PREFIXKEY_FIELDNAMEDES + i, ResManager.loadKDString((String)"\u5b57\u6bb5\u63cf\u8ff0", (String)"EntityTableDictPlugin_10", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            entryType.registerSimpleProperty((DynamicSimpleProperty)fieldnamedes);
            TextProp fielddbtype = this.creatTextProp(PREFIXKEY_FIELDDBTYPE + i, ResManager.loadKDString((String)"\u5b57\u6bb5\u7c7b\u578b", (String)"EntityTableDictPlugin_11", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            entryType.registerSimpleProperty((DynamicSimpleProperty)fielddbtype);
            TextProp fieldlenght = this.creatTextProp(PREFIXKEY_FIELDLENGHT + i, ResManager.loadKDString((String)"\u5b57\u6bb5\u957f\u5ea6", (String)"EntityTableDictPlugin_12", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            entryType.registerSimpleProperty((DynamicSimpleProperty)fieldlenght);
            BooleanProp isprimary = this.creatBooleanProp(PREFIXKEY_ISPRIMARY + i, ResManager.loadKDString((String)"\u4e3b\u952e", (String)"EntityTableDictPlugin_13", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            entryType.registerSimpleProperty((DynamicSimpleProperty)isprimary);
            BooleanProp mustinput = this.creatBooleanProp(PREFIXKEY_MUSTINPUT + i, ResManager.loadKDString((String)"\u5fc5\u5f55", (String)"EntityTableDictPlugin_14", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            entryType.registerSimpleProperty((DynamicSimpleProperty)mustinput);
            BigIntProp seqProp = new BigIntProp();
            seqProp.setName("seq");
            seqProp.setDbIgnore(true);
            seqProp.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"EntityTableDictPlugin_15", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0])));
            seqProp.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)seqProp);
        }
    }

    private BooleanProp creatBooleanProp(String key, String name) {
        BooleanProp booleanProp = new BooleanProp();
        booleanProp.setName(key);
        booleanProp.setDisplayName(new LocaleString(name));
        booleanProp.setDbIgnore(true);
        booleanProp.setAlias("");
        return booleanProp;
    }

    private TextProp creatTextProp(String key, String name) {
        TextProp textProp = new TextProp();
        textProp.setName(key);
        textProp.setDisplayName(new LocaleString(name));
        textProp.setDbIgnore(true);
        textProp.setAlias("");
        return textProp;
    }

    private void doExport() throws IOException {
        ArrayList<String> entityList = new ArrayList<String>();
        entityList.add(this.getEntityId(this.getView().getFormShowParameter()));
        DataExportUtil.exportExcel(this.getView(), entityList, this.getEntityId(this.getView().getFormShowParameter()));
    }
}

