/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.entity.designer;

import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlParameter;
import kd.bos.entity.ca.CertRule;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.ShardingUtil;
import kd.bos.metadata.entity.BaseEntity;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.LinkEntryEntity;
import kd.bos.metadata.entity.LinkSetItem;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.SplitTable;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.IBasedataField;
import kd.bos.metadata.entity.businessfield.ItemClassField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.entity.commonfield.TimeField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.mservice.svc.attach.IAttachmentField;
import kd.bos.mservice.svc.picture.IPictureMetaProxy;
import kd.bos.service.ServiceFactory;

class EntityTableDictUtil {
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static Map<String, String> specialDefaultLength = new HashMap<String, String>();
    private static Map<String, String> typeDefaultLength = new HashMap<String, String>();

    EntityTableDictUtil() {
    }

    private static List<EntityTableData> getLinkSetSchema(EntityMetadata entityMetadata) {
        ArrayList<EntityTableData> list = new ArrayList<EntityTableData>();
        if (entityMetadata == null || !(entityMetadata.getRootEntity() instanceof BillEntity)) {
            return list;
        }
        boolean useSharding = ShardingUtil.isUseSharding((EntityMetadata)entityMetadata);
        BillEntity billEntity = (BillEntity)entityMetadata.getRootEntity();
        if (billEntity.getLinkSet() != null) {
            EntityMetadata trackMeta = billEntity.getLinkSet().createTrackerMetadata();
            if (trackMeta != null) {
                trackMeta.getRootEntity().setdbRoute(entityMetadata.getRootEntity().getdbRoute());
                for (Entity entity : trackMeta.getEntitys()) {
                    List<EntityTableData> trackTable = EntityTableDictUtil.getTableInfo(trackMeta, entity, useSharding);
                    trackTable.stream().forEach(e -> e.setSrcMainEntityId(entityMetadata.getRootEntity().getId()));
                    list.addAll(trackTable);
                }
            }
            for (LinkSetItem linkSetItem : billEntity.getLinkSet().getItems()) {
                LinkEntryEntity linkEntryEntity = linkSetItem.createLinkEntryEntity(entityMetadata);
                if (linkEntryEntity == null) continue;
                List<EntityTableData> linkTable = EntityTableDictUtil.getTableInfo(entityMetadata, linkEntryEntity, useSharding);
                linkTable.stream().forEach(e -> e.setSrcMainEntityId(entityMetadata.getRootEntity().getId()));
                list.addAll(linkTable);
            }
        }
        return list;
    }

    private boolean buildRefTable(EntityMetadata entityMetadata) {
        return entityMetadata != null && entityMetadata.getRootEntity() instanceof BaseEntity;
    }

    protected static void insertTableDict(ConcurrentHashMap<String, Map<String, Object>> tableNameMapping) {
        ArrayList<SqlParameter[]> insertList = new ArrayList<SqlParameter[]>(tableNameMapping.size());
        for (Map.Entry<String, Map<String, Object>> row : tableNameMapping.entrySet()) {
            if (StringUtils.isBlank(row.getValue())) continue;
            SqlParameter[] insertParams = new SqlParameter[5];
            insertParams[0] = new SqlParameter(":fid", 12, row.getValue().get("id"));
            insertParams[1] = new SqlParameter(":ftablename", 12, (Object)row.getKey());
            insertParams[2] = new SqlParameter(":fcreatedate", 91, (Object)new Date());
            insertParams[3] = new SqlParameter(":fmodifydate", 91, (Object)new Date());
            long userid = row.getValue().get("modifierid") == null ? 0L : Long.parseLong(row.getValue().get("modifierid").toString());
            insertParams[4] = new SqlParameter(":fmodifier", -5, (Object)userid);
            insertList.add(insertParams);
        }
        DB.executeBatch((DBRoute)DBRoute.meta, (String)" insert into T_META_TABLEDICT(fid,ftablename,fcreatedate,fmodifydate,fmodifier) values (?, ?,  ?, ?,?) ", insertList);
    }

    protected static void batchUpdateEntityTableDict(List<String> entityIds, ConcurrentMap<String, Map<String, Object>> tableNameMapping) {
        if (entityIds.isEmpty()) {
            return;
        }
        ArrayList datas = new ArrayList();
        for (String entityId : entityIds) {
            try {
                List<EntityTableData> data = EntityTableDictUtil.buildData((EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity));
                datas.addAll(data);
            }
            catch (Exception data) {}
        }
        String[] ids = DB.genStringIds((String)"t_meta_tabledict", (int)datas.size());
        int idIndex = 0;
        for (EntityTableData data : datas) {
            String tableName = data.getTableName();
            ConcurrentHashMap<String, Object> tableDetail = new ConcurrentHashMap<String, Object>();
            tableDetail.put("id", ids[idIndex++]);
            tableDetail.put("modifierid", data.getModifierid());
            tableNameMapping.putIfAbsent(tableName, tableDetail);
        }
        String insertSql = "insert into T_META_TABLEREF(fentryid,fid,fmainentityid) values (?, ?, ?)";
        ArrayList<SqlParameter[]> insertList = new ArrayList<SqlParameter[]>(datas.size());
        String[] entryPk = DB.genStringIds((String)"t_meta_tableref", (int)datas.size());
        int i = 0;
        for (EntityTableData data : datas) {
            SqlParameter[] insertParams = new SqlParameter[]{new SqlParameter(":fentryid", 12, (Object)entryPk[i++]), new SqlParameter(":fid", 12, ((Map)tableNameMapping.get(data.getTableName())).get("id")), new SqlParameter(":fmainentityid", 12, (Object)data.getSrcMainEntityId())};
            insertList.add(insertParams);
        }
        for (int index = 0; index <= insertList.size(); index += 2000) {
            DB.executeBatch((DBRoute)DBRoute.meta, (String)insertSql, insertList.subList(index, Math.min(index + 2000, insertList.size())));
        }
    }

    private static List<EntityTableData> buildData(EntityMetadata meta) {
        if (meta == null) {
            return Collections.emptyList();
        }
        if (!(meta.getRootEntity() instanceof BillEntity)) {
            return Collections.emptyList();
        }
        List entityList = meta.getEntitys();
        boolean useSharding = ShardingUtil.isUseSharding((EntityMetadata)meta);
        ArrayList<EntityTableData> datas = new ArrayList<EntityTableData>();
        for (Entity entity : entityList) {
            datas.addAll(EntityTableDictUtil.getTableInfo(meta, entity, useSharding));
        }
        if (datas.isEmpty()) {
            return Collections.emptyList();
        }
        datas.removeIf(it -> StringUtils.isBlank((CharSequence)it.tableName));
        return datas;
    }

    static void updateEntityTableDict(EntityMetadata entityMetadata) {
        List<EntityTableData> datas = EntityTableDictUtil.buildData(entityMetadata);
        if (datas.isEmpty()) {
            return;
        }
        HashMap<String, String> tableNames = new HashMap<String, String>(16);
        for (EntityTableData data : datas) {
            tableNames.put(data.getTableName(), "");
        }
        String selectTBsql = "select fid,ftablename from t_meta_tabledict where ";
        SqlBuilder tsb = new SqlBuilder();
        tsb.append(selectTBsql, new Object[0]).appendIn("ftablename", tableNames.keySet().toArray());
        Map idMapping = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)tsb, rs -> {
            HashMap<String, String> mapping = new HashMap<String, String>(16);
            while (rs.next()) {
                mapping.put(rs.getString("ftablename"), rs.getString("fid"));
            }
            return mapping;
        });
        if (idMapping.size() != tableNames.size()) {
            String[] tableIds = DB.genStringIds((String)"t_meta_tabledict", (int)(tableNames.size() - idMapping.size()));
            int i = 0;
            ArrayList<SqlParameter[]> insertList = new ArrayList<SqlParameter[]>(tableIds.length);
            for (Map.Entry row : tableNames.entrySet()) {
                if (!StringUtils.isBlank((CharSequence)((CharSequence)row.getValue()))) continue;
                String pk = null;
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)idMapping.get(row.getKey())))) {
                    idMapping.put(row.getKey(), tableIds[i]);
                    ++i;
                }
                pk = (String)idMapping.get(row.getKey());
                SqlParameter[] insertParams = new SqlParameter[5];
                insertParams[0] = new SqlParameter(":fid", 12, (Object)pk);
                insertParams[1] = new SqlParameter(":ftablename", 12, row.getKey());
                insertParams[2] = new SqlParameter(":fcreatedate", 91, (Object)new Date());
                insertParams[3] = new SqlParameter(":fmodifydate", 91, (Object)new Date());
                long modifier = 0L;
                try {
                    modifier = Long.parseLong(entityMetadata.getModifierId());
                    if (modifier == 0L) {
                        String formModifier = MetadataDao.readMeta((String)entityMetadata.getId(), (MetaCategory)MetaCategory.Form).getModifierId();
                        modifier = Long.parseLong(formModifier);
                    }
                }
                catch (Exception e) {
                    modifier = 0L;
                }
                insertParams[4] = new SqlParameter(":fmodifier", -5, (Object)modifier);
                insertList.add(insertParams);
            }
            DB.executeBatch((DBRoute)DBRoute.meta, (String)" insert into T_META_TABLEDICT(fid,ftablename,fcreatedate,fmodifydate,fmodifier) values (?, ?,  ?, ?,?) ", insertList);
        }
        String deleteSql = "delete from T_META_TABLEREF where fmainentityid = ? ";
        Object[] deleteParams = new SqlParameter[]{new SqlParameter(":fmainentityid", 12, (Object)entityMetadata.getId())};
        DB.execute((DBRoute)DBRoute.meta, (String)deleteSql, (Object[])deleteParams);
        String insertSql = "insert into T_META_TABLEREF(fentryid,fid,fmainentityid) values (?, ?, ?)";
        ArrayList<SqlParameter[]> insertList = new ArrayList<SqlParameter[]>(datas.size());
        String[] ids = DB.genStringIds((String)"t_meta_tableref", (int)datas.size());
        int i = 0;
        for (EntityTableData data : datas) {
            SqlParameter[] insertParams = new SqlParameter[]{new SqlParameter(":fentryid", 12, (Object)ids[i++]), new SqlParameter(":fid", 12, idMapping.get(data.getTableName())), new SqlParameter(":fmainentityid", 12, (Object)entityMetadata.getRootEntity().getId())};
            insertList.add(insertParams);
        }
        DB.executeBatch((DBRoute)DBRoute.meta, (String)insertSql, insertList);
    }

    protected static List<EntityTableData> getTableInfo(EntityMetadata entityMetadata, Entity<?, ?> entity, boolean useSharding) {
        List splitTables = entity.getSplitTables();
        if (StringUtils.isBlank((CharSequence)entity.getTableName())) {
            return Collections.emptyList();
        }
        ArrayList<String> suffixList = new ArrayList<String>();
        String suffix = null;
        for (SplitTable s : splitTables) {
            suffix = s.getSuffix();
            if (suffix == null || !StringUtils.isNotEmpty((CharSequence)suffix)) continue;
            suffixList.add(suffix);
        }
        ArrayList<String> tableNameSuffix = new ArrayList<String>();
        tableNameSuffix.add("");
        tableNameSuffix.addAll(suffixList);
        ArrayList<EntityTableData> tables = new ArrayList<EntityTableData>();
        String tableName = entity.getTableName();
        for (int i = 0; i < tableNameSuffix.size(); ++i) {
            String newTableName = tableName;
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)tableNameSuffix.get(i)))) {
                newTableName = String.format("%s_%s", tableName, tableNameSuffix.get(i));
            }
            EntityTableDictUtil.genAllTableInfo(entityMetadata, entity, newTableName, tables);
        }
        return tables;
    }

    private static void genAllTableInfo(EntityMetadata entityMetadata, Entity<?, ?> entity, String tableName, List<EntityTableData> tables) {
        List<EntityTableData> attTable;
        List<EntityTableData> mulBdTable;
        EntityTableData signTable;
        EntityTableData mulTable;
        EntityTableData tableInfo = new EntityTableData();
        tableInfo.setModifierid(EntityTableDictUtil.getModifierId(entityMetadata));
        tables.add(tableInfo);
        tableInfo.tableName = tableName;
        tableInfo.srcMainEntityId = entityMetadata.getRootEntity().getId();
        tableInfo.tableDisplayName = entity.getName().toString();
        List entityList = entityMetadata.getEntitys();
        String pkFieldName = null;
        String pkFieldType = null;
        for (Entity billEntity : entityList) {
            if (!(billEntity instanceof BillEntity)) continue;
            pkFieldName = ((BillEntity)billEntity).getPkFieldName();
            pkFieldType = ((BillEntity)billEntity).getPkType() == 0 ? JDBCType.NVARCHAR.getName() : JDBCType.BIGINT.getName();
            break;
        }
        if (entity instanceof SubEntryEntity || entity instanceof LinkEntryEntity) {
            EntityItem parentItem = entityMetadata.getItemById(entity.getParentId());
            if (!(parentItem instanceof BillEntity)) {
                if (parentItem instanceof EntryEntity) {
                    pkFieldName = ((EntryEntity)parentItem).getEntryPkFieldName();
                } else if (parentItem == null) {
                    return;
                }
            }
            tableInfo.cols.add(new ColumnDesc("id", pkFieldName, ResManager.loadKDString((String)"\u5916\u952e", (String)"EntityTableDictUtil_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), pkFieldType, true, EntityTableDictUtil.getDefaultLength(pkFieldType), false));
        }
        if (!(entity instanceof MainEntity) && !StringUtils.isEmpty((CharSequence)((EntryEntity)entity).getEntryPkFieldName())) {
            tableInfo.cols.add(new ColumnDesc("id", ((EntryEntity)entity).getEntryPkFieldName(), ResManager.loadKDString((String)"\u5206\u5f55\u4e3b\u952e", (String)"EntityTableDictUtil_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), pkFieldType, true, EntityTableDictUtil.getDefaultLength(pkFieldType), true));
        }
        if (!(entity instanceof MainEntity) && !StringUtils.isEmpty((CharSequence)entity.getKey()) && tableName.equalsIgnoreCase(entity.getTableName())) {
            tableInfo.cols.add(new ColumnDesc("seq", ((EntryEntity)entity).getSeqFieldName(), ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"EntityTableDictUtil_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), JDBCType.INTEGER.getName(), true, EntityTableDictUtil.getDefaultLength(JDBCType.INTEGER.getName()), false));
        }
        if (entity instanceof BillEntity) {
            String desc = ResManager.loadKDString((String)"\u4e3b\u952e", (String)"EntityTableDictUtil_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
            if (tableName.equalsIgnoreCase(entity.getTableName())) {
                tableInfo.cols.add(new ColumnDesc("id", pkFieldName, desc, JDBCType.VARCHAR.getName(), true, EntityTableDictUtil.getDefaultLength(JDBCType.VARCHAR.getName()), false));
            } else {
                tableInfo.cols.add(new ColumnDesc("", pkFieldName, desc, JDBCType.VARCHAR.getName(), true, EntityTableDictUtil.getDefaultLength(JDBCType.VARCHAR.getName()), false));
            }
        }
        ArrayList<MuliLangTextField> mulLangFields = new ArrayList<MuliLangTextField>(10);
        ArrayList<MulBasedataField> mulBDFields = new ArrayList<MulBasedataField>(10);
        ArrayList<IAttachmentField> attachmentFields = new ArrayList<IAttachmentField>(10);
        ArrayList<Field> listFields = new ArrayList<Field>(10);
        Field itemField = null;
        List entityItem = entity.getItems();
        for (EntityItem item : entityItem) {
            if (!(item instanceof Field)) continue;
            itemField = (Field)item;
            listFields.add(itemField);
        }
        for (Field field : listFields) {
            if (field instanceof MuliLangTextField) {
                mulLangFields.add((MuliLangTextField)(field instanceof MuliLangTextField ? field : null));
                if (!((MuliLangTextField)field).isGL()) continue;
            }
            if (field instanceof IAttachmentField) {
                attachmentFields.add((IAttachmentField)field);
                continue;
            }
            if (field instanceof MulBasedataField) {
                mulBDFields.add((MulBasedataField)(field instanceof MulBasedataField ? field : null));
                continue;
            }
            if (field instanceof TimeRangeField) {
                TimeRangeField timeRangeField = (TimeRangeField)field;
                TimeField startTimeField = new TimeField();
                TimeField endTimeField = new TimeField();
                if (StringUtils.isNotBlank((CharSequence)timeRangeField.getStartDateFieldName())) {
                    startTimeField.setFieldName(timeRangeField.getStartDateFieldName());
                    if (tableName.equalsIgnoreCase(field.getTableName(entity))) {
                        tableInfo.cols.add(new ColumnDesc(startTimeField.getKey(), startTimeField.getFieldName(), timeRangeField.getName().toString(), EntityTableDictUtil.getDBType(startTimeField.getFieldDBType()), startTimeField.isMustInput(), "", false));
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)timeRangeField.getEndDateFieldName())) continue;
                endTimeField.setFieldName(timeRangeField.getEndDateFieldName());
                if (!tableName.equalsIgnoreCase(field.getTableName(entity))) continue;
                tableInfo.cols.add(new ColumnDesc(endTimeField.getKey(), endTimeField.getFieldName(), timeRangeField.getName().toString(), EntityTableDictUtil.getDBType(endTimeField.getFieldDBType()), endTimeField.isMustInput(), "", false));
                continue;
            }
            if (field instanceof DateRangeField) {
                DateRangeField dateRangeField = (DateRangeField)field;
                DateTimeField startDateTimeField = new DateTimeField();
                DateTimeField endDateTimeField = new DateTimeField();
                if (StringUtils.isNotBlank((CharSequence)dateRangeField.getStartDateFieldName())) {
                    startDateTimeField.setKey(dateRangeField.getStartDateFieldKey());
                    startDateTimeField.setFieldName(dateRangeField.getStartDateFieldName());
                    tableInfo.cols.add(new ColumnDesc(startDateTimeField.getKey(), startDateTimeField.getFieldName(), dateRangeField.getStartDateFieldName(), EntityTableDictUtil.getDBType(startDateTimeField.getFieldDBType()), startDateTimeField.isMustInput(), "", false));
                }
                if (!StringUtils.isNotBlank((CharSequence)dateRangeField.getEndDateFieldName())) continue;
                endDateTimeField.setFieldName(dateRangeField.getEndDateFieldName());
                endDateTimeField.setKey(dateRangeField.getEndDateFieldKey());
                tableInfo.cols.add(new ColumnDesc(endDateTimeField.getKey(), endDateTimeField.getFieldName(), dateRangeField.getEndDateFieldName(), EntityTableDictUtil.getDBType(endDateTimeField.getFieldDBType()), endDateTimeField.isMustInput(), "", false));
                continue;
            }
            if (field instanceof AmountField && ((AmountField)field).isEncrypt() && !StringUtils.isEmpty((CharSequence)field.getFieldName()) && tableName.equalsIgnoreCase(field.getTableName(entity))) {
                AmountField amountField = (AmountField)field;
                String length = "(" + amountField.getPrecision() + "," + amountField.getScale() + ")";
                tableInfo.cols.add(new ColumnDesc(field.getKey(), field.getFieldName(), field.getName().toString(), EntityTableDictUtil.getDBType(field.getFieldDBType()), field.isMustInput(), length, false));
                tableInfo.cols.add(new ColumnDesc(field.getKey(), field.getFieldName() + "_enp", String.format(ResManager.loadKDString((String)"%s(\u52a0\u5bc6)", (String)"EntityTableDictUtil_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), field.getName().toString()), EntityTableDictUtil.getDBType(field.getFieldDBType()), field.isMustInput(), length, false));
                continue;
            }
            if (field instanceof TextField && ((TextField)field).isEncrypt() && !StringUtils.isEmpty((CharSequence)field.getFieldName()) && tableName.equalsIgnoreCase(field.getTableName(entity))) {
                String length = ((TextField)field).getMaxLength() == 0 ? EntityTableDictUtil.getDefaultLength(field) : ((TextField)field).getMaxLength() + "";
                tableInfo.cols.add(new ColumnDesc(field.getKey(), field.getFieldName() + "_enp", String.format(ResManager.loadKDString((String)"%s(\u52a0\u5bc6)", (String)"EntityTableDictUtil_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), field.getName().toString()), EntityTableDictUtil.getDBType(field.getFieldDBType()), field.isMustInput(), length, false));
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)field.getFieldName()) || !tableName.equalsIgnoreCase(field.getTableName(entity))) continue;
            tableInfo.cols.add(new ColumnDesc(field.getKey(), field.getFieldName(), field.getName().toString(), EntityTableDictUtil.getDBType(field.getFieldDBType()), field.isMustInput(), EntityTableDictUtil.getDefaultLength(field), false));
        }
        if (!mulLangFields.isEmpty() && tableName.equalsIgnoreCase(entity.getTableName()) && (mulTable = EntityTableDictUtil.genMulLangTableInfo(entityMetadata, entity, mulLangFields)) != null) {
            tables.add(mulTable);
        }
        if (entity instanceof BillEntity && !((BillEntity)entity).getSignField().isEmpty() && !((CertRule)((BillEntity)entity).getSignField().get(0)).getSignoperate().isEmpty() && (signTable = EntityTableDictUtil.getnSignTableInfo(entityMetadata, entity)) != null) {
            tables.add(signTable);
        }
        if (!mulBDFields.isEmpty() && tableName.equalsIgnoreCase(entity.getTableName()) && (mulBdTable = EntityTableDictUtil.genMulBDTableInfo(entityMetadata, entity, mulBDFields)) != null) {
            tables.addAll(mulBdTable);
        }
        if (!attachmentFields.isEmpty() && tableName.equalsIgnoreCase(entity.getTableName()) && (attTable = EntityTableDictUtil.genAttTableInfo(entityMetadata, entity, attachmentFields)) != null) {
            tables.addAll(attTable);
        }
    }

    private static long getModifierId(EntityMetadata entityMetadata) {
        long modifier = 0L;
        try {
            if (!StringUtils.isBlank((CharSequence)entityMetadata.getModifierId())) {
                modifier = Long.parseLong(entityMetadata.getModifierId());
            }
            if (modifier == 0L) {
                String formModifier = MetadataDao.readMeta((String)entityMetadata.getId(), (MetaCategory)MetaCategory.Form).getModifierId();
                modifier = Long.parseLong(formModifier);
            }
        }
        catch (Exception e) {
            modifier = 0L;
        }
        return modifier;
    }

    private static EntityTableData getnSignTableInfo(EntityMetadata entityMetadata, Entity<?, ?> entity) {
        String signTableName;
        EntityTableData tableInfo = new EntityTableData();
        tableInfo.setModifierid(EntityTableDictUtil.getModifierId(entityMetadata));
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return null;
        }
        tableInfo.tableName = signTableName = entity.getTableName() + "_SN";
        tableInfo.srcMainEntityId = entityMetadata.getRootEntity().getId();
        tableInfo.tableDisplayName = entity.getName().toString();
        return tableInfo;
    }

    private static EntityTableData genMulLangTableInfo(EntityMetadata entityMetadata, Entity<?, ?> entity, List<MuliLangTextField> multiLangFields) {
        String mulLangTableName;
        EntityTableData tableInfo = new EntityTableData();
        tableInfo.setModifierid(EntityTableDictUtil.getModifierId(entityMetadata));
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return null;
        }
        String mulLangTablePKField = "FPKID";
        String pkFieldName = null;
        String pkFieldType = null;
        String mulLangPkFieldType = null;
        for (Entity billEntity : entityMetadata.getEntitys()) {
            if (!(billEntity instanceof BillEntity)) continue;
            pkFieldName = ((BillEntity)billEntity).getPkFieldName();
            mulLangPkFieldType = JDBCType.NVARCHAR.getName();
            pkFieldType = ((BillEntity)billEntity).getPkType() == 0 ? JDBCType.NVARCHAR.getName() : JDBCType.BIGINT.getName();
            break;
        }
        tableInfo.tableName = mulLangTableName = entity.getTableName() + "_L";
        tableInfo.srcMainEntityId = entityMetadata.getRootEntity().getId();
        tableInfo.tableDisplayName = entity.getName().toString();
        String resMulKeyDesc = ResManager.loadKDString((String)"\u591a\u8bed\u8a00\u8868\u4e3b\u952e", (String)"EntityTableDictUtil_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
        tableInfo.cols.add(new ColumnDesc("", mulLangTablePKField, resMulKeyDesc, mulLangPkFieldType, true, EntityTableDictUtil.getDefaultLength(mulLangPkFieldType), true));
        tableInfo.cols.add(new ColumnDesc("", pkFieldName, resMulKeyDesc, pkFieldType, true, EntityTableDictUtil.getDefaultLength(pkFieldType), false));
        if (!(entity instanceof MainEntity) && !StringUtils.isEmpty((CharSequence)((EntryEntity)entity).getEntryPkFieldName())) {
            tableInfo.cols.add(new ColumnDesc("", ((EntryEntity)entity).getEntryPkFieldName(), ResManager.loadKDString((String)"\u591a\u8bed\u8a00\u8868\u5206\u5f55\u4e3b\u952e", (String)"EntityTableDictUtil_6", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), pkFieldType, true, EntityTableDictUtil.getDefaultLength(pkFieldType), false));
        }
        tableInfo.cols.add(new ColumnDesc("", "FLocaleID", ResManager.loadKDString((String)"\u8bed\u79cd", (String)"EntityTableDictUtil_7", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), JDBCType.VARCHAR.getName(), true, "10", false));
        for (MuliLangTextField field : multiLangFields) {
            if (StringUtils.isEmpty((CharSequence)field.getFieldName())) continue;
            String length = field.getMaxLength() == 0 ? EntityTableDictUtil.getDefaultLength(EntityTableDictUtil.getDBType(field.getFieldDBType())) : field.getMaxLength() + "";
            tableInfo.cols.add(new ColumnDesc(field.getKey(), field.getFieldName(), field.getName().toString(), EntityTableDictUtil.getDBType(field.getFieldDBType()), true, length, false));
        }
        return tableInfo;
    }

    private static List<EntityTableData> genMulBDTableInfo(EntityMetadata entityMetadata, Entity<?, ?> entity, List<MulBasedataField> mulBasedataFields) {
        ArrayList<EntityTableData> list = new ArrayList<EntityTableData>(10);
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return Collections.emptyList();
        }
        MainEntity rootEntity = entityMetadata.getRootEntity();
        if (rootEntity == null || !(rootEntity instanceof BillEntity)) {
            return Collections.emptyList();
        }
        String mulBsdTablePKField = "FPKID";
        String bsdFKField = "FBasedataId";
        String pkFieldName = ((BillEntity)rootEntity).getPkFieldName();
        String pkFieldType = ((BillEntity)rootEntity).getPkType() == 0 ? JDBCType.NVARCHAR.getName() : JDBCType.BIGINT.getName();
        String fkFieldName = pkFieldName;
        if (entity instanceof EntryEntity) {
            fkFieldName = ((EntryEntity)entity).getEntryPkFieldName();
        }
        if (StringUtils.isBlank((CharSequence)fkFieldName)) {
            return Collections.emptyList();
        }
        for (MulBasedataField mulBsdfield : mulBasedataFields) {
            String mulBsdTableName = mulBsdfield.getTableName();
            EntityTableData tableInfo = new EntityTableData();
            tableInfo.setModifierid(EntityTableDictUtil.getModifierId(entityMetadata));
            tableInfo.tableName = mulBsdTableName;
            tableInfo.srcMainEntityId = entityMetadata.getRootEntity().getId();
            tableInfo.tableDisplayName = mulBsdfield.getName().toString();
            tableInfo.cols.add(new ColumnDesc("", mulBsdTablePKField, ResManager.loadKDString((String)"\u591a\u9009\u57fa\u7840\u8d44\u6599\u8868\u4e3b\u952e", (String)"EntityTableDictUtil_8", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), pkFieldType, true, EntityTableDictUtil.getDefaultLength(pkFieldType), true));
            tableInfo.cols.add(new ColumnDesc("", fkFieldName, ResManager.loadKDString((String)"\u5916\u952e", (String)"EntityTableDictUtil_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), pkFieldType, true, EntityTableDictUtil.getDefaultLength(pkFieldType), false));
            tableInfo.cols.add(new ColumnDesc("", bsdFKField, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5b57\u6bb5", (String)"EntityTableDictUtil_9", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), JDBCType.valueOf(EntityTableDictUtil.getBasedataPkType((IBasedataField)mulBsdfield)).getName(), true, EntityTableDictUtil.getDefaultLength(JDBCType.valueOf(EntityTableDictUtil.getBasedataPkType((IBasedataField)mulBsdfield)).getName()), false));
            list.add(tableInfo);
        }
        return list;
    }

    private static List<EntityTableData> genAttTableInfo(EntityMetadata entityMetadata, Entity<?, ?> entity, List<IAttachmentField> attachmentFields) {
        ArrayList<EntityTableData> list = new ArrayList<EntityTableData>(10);
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return Collections.emptyList();
        }
        String attachmentTablePKField = "FPKID";
        String attFKField = "FBasedataId";
        String pkFieldName = null;
        String pkFieldType = null;
        for (Entity billEntity : entityMetadata.getEntitys()) {
            if (!(billEntity instanceof BillEntity)) continue;
            pkFieldName = ((BillEntity)billEntity).getPkFieldName();
            pkFieldType = ((BillEntity)billEntity).getPkType() == 0 ? JDBCType.NVARCHAR.getName() : JDBCType.BIGINT.getName();
            break;
        }
        for (IAttachmentField attfield : attachmentFields) {
            String attTableName;
            EntityTableData tableInfo = new EntityTableData();
            tableInfo.setModifierid(EntityTableDictUtil.getModifierId(entityMetadata));
            tableInfo.tableName = attTableName = attfield.getTableName();
            tableInfo.srcMainEntityId = entityMetadata.getRootEntity().getId();
            tableInfo.tableDisplayName = attfield.getName().toString();
            tableInfo.cols.add(new ColumnDesc("", attachmentTablePKField, ResManager.loadKDString((String)"\u5916\u952e", (String)"EntityTableDictUtil_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), pkFieldType, true, EntityTableDictUtil.getDefaultLength(pkFieldType), true));
            if (entity instanceof MainEntity) {
                tableInfo.cols.add(new ColumnDesc("", pkFieldName, ResManager.loadKDString((String)"\u5916\u952e", (String)"EntityTableDictUtil_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), pkFieldType, true, EntityTableDictUtil.getDefaultLength(pkFieldType), false));
            }
            if (!(entity instanceof MainEntity) && !StringUtils.isEmpty((CharSequence)((EntryEntity)entity).getEntryPkFieldName())) {
                tableInfo.cols.add(new ColumnDesc("", ((EntryEntity)entity).getEntryPkFieldName(), ResManager.loadKDString((String)"\u5916\u952e", (String)"EntityTableDictUtil_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), pkFieldType, true, EntityTableDictUtil.getDefaultLength(pkFieldType), false));
            }
            tableInfo.cols.add(new ColumnDesc("", attFKField, ResManager.loadKDString((String)"\u5206\u5f55\u9644\u4ef6\u8868\u4e3b\u952e", (String)"EntityTableDictUtil_10", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), pkFieldType, true, EntityTableDictUtil.getDefaultLength(pkFieldType), false));
            list.add(tableInfo);
        }
        return list;
    }

    private static int getBasedataPkType(IBasedataField field) {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)field.getBaseEntityId(), (MetaCategory)MetaCategory.Entity);
        int pkType = 0;
        for (Entity entity : entityMetadata.getEntitys()) {
            if (!(entity instanceof BillEntity)) continue;
            pkType = ((BillEntity)entity).getPkType() == 0 ? 12 : -5;
            break;
        }
        return pkType;
    }

    private static String getDBType(int dbType) {
        return JDBCType.valueOf(dbType).getName();
    }

    private static String getDefaultLength(Field<?> field) {
        String length = "";
        length = specialDefaultLength.get(field.getClass().getSimpleName() + "-" + EntityTableDictUtil.getDBType(field.getFieldDBType()));
        if (length != null) {
            return length;
        }
        length = typeDefaultLength.get(EntityTableDictUtil.getDBType(field.getFieldDBType()));
        if (length != null) {
            return length;
        }
        return "";
    }

    private static String getDefaultLength(String dbTypeName) {
        String length = typeDefaultLength.get(dbTypeName);
        if (length != null) {
            return length;
        }
        return "";
    }

    static {
        specialDefaultLength.put(ItemClassField.class.getSimpleName() + "-" + JDBCType.BIGINT.getName(), "20");
        specialDefaultLength.put(BasedataField.class.getSimpleName() + "-" + JDBCType.NVARCHAR.getName(), "36");
        IPictureMetaProxy pictureProxyService = (IPictureMetaProxy)ServiceFactory.getService(IPictureMetaProxy.class);
        specialDefaultLength.put(pictureProxyService.getPictureFieldClass().getSimpleName() + "-" + JDBCType.VARCHAR.getName(), "255");
        specialDefaultLength.put(ComboField.class.getSimpleName() + "-" + JDBCType.VARCHAR.getName(), "30");
        specialDefaultLength.put(pictureProxyService.getPictureFieldClass().getSimpleName() + "-" + JDBCType.NVARCHAR.getName(), "255");
        specialDefaultLength.put(ComboField.class.getSimpleName() + "-" + JDBCType.NVARCHAR.getName(), "30");
        typeDefaultLength.put(JDBCType.CHAR.getName(), "1");
        typeDefaultLength.put(JDBCType.VARCHAR.getName(), "50");
        typeDefaultLength.put(JDBCType.NVARCHAR.getName(), "50");
        typeDefaultLength.put(JDBCType.INTEGER.getName(), "20");
        typeDefaultLength.put(JDBCType.DECIMAL.getName(), "(23,10)");
        typeDefaultLength.put(JDBCType.BIGINT.getName(), "20");
    }

    static class ColumnDesc {
        String key;
        String fieldName;
        String des;
        String typeName;
        boolean mustInput;
        String length;
        boolean isPrimary;

        ColumnDesc() {
        }

        public static ColumnDesc fromMapData(Map<String, Object> data) {
            ColumnDesc col = new ColumnDesc();
            col.key = (String)data.get("key");
            col.fieldName = (String)data.get("fieldName");
            col.des = (String)data.get("des");
            col.typeName = (String)data.get("typeName");
            col.mustInput = (Boolean)data.get("mustInput");
            col.length = (String)data.get("length");
            col.isPrimary = (Boolean)data.get("isPrimary");
            return col;
        }

        public Map<String, Object> convertToMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("key", this.key);
            map.put("fieldName", this.fieldName);
            map.put("des", this.des);
            map.put("typeName", this.typeName);
            map.put("mustInput", this.mustInput);
            map.put("length", this.length);
            map.put("isPrimary", this.isPrimary);
            return map;
        }

        ColumnDesc(String key, String fieldName, String des, String typeName, boolean mustInput, String length, boolean isPrimary) {
            this.key = key;
            this.fieldName = fieldName;
            this.des = des;
            this.typeName = typeName;
            this.mustInput = mustInput;
            this.length = length;
            this.isPrimary = isPrimary;
        }
    }

    static class EntityTableData {
        String id = "";
        String tableName = "";
        String srcMainEntityId = "";
        String tableDisplayName = "";
        String srcEntityItemId = "";
        Date createDate;
        Date modifyDate;
        long modifierid;
        List<ColumnDesc> cols = new ArrayList<ColumnDesc>();

        public EntityTableData(String tableName, String srcMainEntityId) {
            this.tableName = tableName.toLowerCase();
            this.srcMainEntityId = srcMainEntityId;
        }

        public EntityTableData() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName.toLowerCase();
        }

        public String getSrcMainEntityId() {
            return this.srcMainEntityId;
        }

        public void setSrcMainEntityId(String srcMainEntityId) {
            this.srcMainEntityId = srcMainEntityId;
        }

        public String getTableDisplayName() {
            return this.tableDisplayName;
        }

        public void setTableDisplayName(String tableDisplayName) {
            this.tableDisplayName = tableDisplayName;
        }

        public String getSrcEntityItemId() {
            return this.srcEntityItemId;
        }

        public void setSrcEntityItemId(String srcEntityItemId) {
            this.srcEntityItemId = srcEntityItemId;
        }

        public Date getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(Date createDate) {
            this.createDate = createDate;
        }

        public Date getModifyDate() {
            return this.modifyDate;
        }

        public void setModifyDate(Date modifyDate) {
            this.modifyDate = modifyDate;
        }

        public List<ColumnDesc> getCols() {
            return this.cols;
        }

        public void setCols(List<ColumnDesc> cols) {
            this.cols = cols;
        }

        public long getModifierid() {
            return this.modifierid;
        }

        public void setModifierid(long modifierid) {
            this.modifierid = modifierid;
        }

        public Map<String, Object> convertToMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tableName", this.tableName);
            map.put("tableDisplayName", this.tableDisplayName);
            ArrayList<Map<String, Object>> listData = new ArrayList<Map<String, Object>>();
            map.put("list", listData);
            if (!this.cols.isEmpty()) {
                for (ColumnDesc info : this.cols) {
                    listData.add(info.convertToMap());
                }
            }
            return map;
        }

        public static EntityTableData fromMap(Map<String, Object> data) {
            EntityTableData tableInfo = new EntityTableData();
            tableInfo.tableName = data.get("tableName").toString();
            tableInfo.tableDisplayName = data.get("tableDisplayName").toString();
            if (StringUtils.isNotBlank((Object)data.get("list"))) {
                List listDatas = null;
                listDatas = data.get("list") instanceof List ? (List)data.get("list") : SerializationUtils.fromJsonStringToList((String)data.get("list").toString(), Map.class);
                for (Map col : listDatas) {
                    tableInfo.cols.add(ColumnDesc.fromMapData(col));
                }
            }
            return tableInfo;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntityTableData other = (EntityTableData)obj;
            if (this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName)) {
                return false;
            }
            return !(this.srcMainEntityId == null ? other.srcMainEntityId != null : !this.srcMainEntityId.equals(other.srcMainEntityId));
        }
    }
}

