/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.entity.designer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.newdevportal.entity.designer.EntityTableDictUtil;
import kd.bos.newdevportal.entity.designer.SyncTask;
import kd.bos.newdevportal.entity.designer.SyncTaskContext;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class EntityTableSyncTask
extends AbstractTask {
    private static Log log = LogFactory.getLog(EntityTableSyncTask.class);
    private static int concurrency = Math.max(Integer.getInteger("entityTableSync.maxThread", 5), 1);
    private static ThreadPool pool = ThreadPools.newCachedThreadPool((String)"entityTableSyncPool", (int)1, (int)concurrency);
    private long lastSyncTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(RequestContext paramRequestContext, Map<String, Object> paramMap) throws KDException {
        if (this.isCancel()) {
            return;
        }
        ArrayList<SyncTaskContext> contexts = new ArrayList<SyncTaskContext>();
        try (DLock lock = DLock.create((String)"entitydesignerplugin_tableinfo_sync");){
            if (!lock.tryLock(0L)) {
                log.info("EntityTableSyncTask.log : task is already running");
                return;
            }
            List mainEntityIds = (List)DB.query((DBRoute)DBRoute.meta, (String)" select t1.fid from t_meta_entitydesign t1 where t1.ftype != '2'", rs -> {
                ArrayList<String> idList = new ArrayList<String>(10);
                while (rs.next()) {
                    idList.add(rs.getString("fid"));
                }
                return idList;
            });
            this.clearAllData();
            ConcurrentHashMap<String, Map<String, Object>> mapping = new ConcurrentHashMap<String, Map<String, Object>>(mainEntityIds.size());
            List<SyncTask> tasks = this.buildTask(mainEntityIds, mapping, concurrency);
            for (SyncTask task : tasks) {
                pool.execute((Runnable)task, paramRequestContext);
                contexts.add(task.getContext());
            }
            this.lastSyncTime = System.currentTimeMillis();
            while (!this.isfinished(contexts) && !this.isCancel()) {
                this.feedBackTotalProgress(contexts);
                if (!this.isCancel()) continue;
                this.stopTask(tasks);
                mapping.clear();
                this.clearAllData();
                return;
            }
            if (this.isCancel()) {
                this.stopTask(tasks);
                mapping.clear();
                this.clearAllData();
                return;
            }
            EntityTableDictUtil.insertTableDict(mapping);
            return;
        }
        finally {
            Iterator iterator = contexts.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                }
                SyncTaskContext context = (SyncTaskContext)iterator.next();
                context.getFinished().compareAndSet(false, true);
            }
        }
    }

    private void clearAllData() {
        DB.execute((DBRoute)DBRoute.meta, (String)"TRUNCATE TABLE T_META_TABLEDICT;");
        DB.execute((DBRoute)DBRoute.meta, (String)"TRUNCATE TABLE T_META_TABLEREF;");
    }

    private List<SyncTask> buildTask(List<String> mainEntityIds, ConcurrentHashMap<String, Map<String, Object>> shareMapping, int maxConcurrency) {
        ArrayList<SyncTask> tasks = new ArrayList<SyncTask>(1);
        if (mainEntityIds.size() <= maxConcurrency) {
            SyncTaskContext taskContext = new SyncTaskContext(shareMapping, mainEntityIds);
            SyncTask task = new SyncTask();
            task.setContext(taskContext);
            tasks.add(task);
        } else {
            int singleTaskNums = mainEntityIds.size() / maxConcurrency + 1;
            for (int i = 0; i < mainEntityIds.size(); i += singleTaskNums) {
                SyncTaskContext context = new SyncTaskContext(shareMapping, mainEntityIds.subList(i, Math.min(i + singleTaskNums, mainEntityIds.size())));
                SyncTask task = new SyncTask();
                task.setContext(context);
                tasks.add(task);
            }
        }
        return tasks;
    }

    private void feedBackTotalProgress(List<SyncTaskContext> contexts) {
        int total = 0;
        int current = 0;
        for (SyncTaskContext context : contexts) {
            total += context.getEntityIds().size();
            current += context.getProgress().get();
        }
        int progress = current * 100 / (total == 0 ? 1 : total);
        long interval = System.currentTimeMillis() - this.lastSyncTime;
        if (progress < 100 && interval >= 15000L) {
            this.feedbackProgress(progress);
        }
    }

    private boolean isfinished(List<SyncTaskContext> contexts) {
        for (SyncTaskContext context : contexts) {
            if (context.getFinished().get()) continue;
            return false;
        }
        return true;
    }

    public static void cancelTask(String taskId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
        cache.put(String.format("%s_%s", RequestContext.get().getAccountId(), "entitytabledictsynctask"), (Object)taskId, 3600);
    }

    private boolean isCancel() {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
        String taskId = (String)cache.get(String.format("%s_%s", RequestContext.get().getAccountId(), "entitytabledictsynctask"));
        return this.taskId.equals(taskId);
    }

    private void stopTask(List<SyncTask> tasks) {
        for (SyncTask task : tasks) {
            task.getContext().getCancel().compareAndSet(false, true);
        }
    }
}

