/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.entity.designer.permission;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Button;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.BusinessControl;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.extensible.ExtLockTypeEnum;
import kd.bos.metadata.extensible.ExtensibleDao;
import kd.bos.newdevportal.entity.AbstractEntityDesignerSubPagePlugin;

public class BusinessControlPlugin
extends AbstractEntityDesignerSubPagePlugin {
    private static final String SAVE = "save";
    private static final String ENABLE_IMPORT = "enableimport";
    private static final String BOTP = "botp";
    private static final String IS_PRINT = "isprint";
    private static final String CODE_NUMBER = "codenumber";
    private static final String WORK_FLOW = "workflow";
    private static final String BILL_TYPE = "billtype";
    private static final String VOUCHER = "voucher";
    private static final String IS_QING_ANALYSIS = "isqinganalysis";
    private static final String NO_SEARCH_ENABLED = "nosearchenabled";
    private static final String KEY_ENABLE_IMPORT = "EnableImport";
    private static final String KEY_IS_QING_ANALYSIS = "IsQingAnalysis";
    private static final String KEY_NO_SEARCH_ENABLED = "NoSearchEnabled";
    private static final String KEY_VOUCHER = "Voucher";
    private static final String KEY_BOTP = "BOTP";
    private static final String KEY_BILL_TYPE = "BillType";
    private static final String KEY_CODE_NUMBER = "CodeNumber";
    private static final String KEY_WORK_FLOW = "WorkFlow";
    private static final String KEY_IS_PRINT = "IsPrint";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{SAVE});
    }

    public void afterCreateNewData(EventObject e) {
        EntityMetadata metadata = this.getEntityMetadata();
        String entityType = (String)((EntityItem)metadata.getItems().get(0)).createTreeNode().get("Type");
        this.getPageCache().put("entityType", entityType);
        BusinessControl businessControl = ((MainEntity)metadata.getItems().get(0)).getBusinessControl();
        if (businessControl == null) {
            return;
        }
        this.getModel().setValue(ENABLE_IMPORT, (Object)businessControl.isEnableImport());
        this.getModel().setValue(BOTP, (Object)businessControl.isBotp());
        this.getModel().setValue(IS_PRINT, (Object)businessControl.isIsprint());
        this.getModel().setValue(CODE_NUMBER, (Object)businessControl.isCodeNumber());
        this.getModel().setValue(BILL_TYPE, (Object)businessControl.isBillType());
        this.getModel().setValue(VOUCHER, (Object)businessControl.isVoucher());
        this.getModel().setValue(IS_QING_ANALYSIS, (Object)businessControl.isQingAnalysis());
        this.getModel().setValue(NO_SEARCH_ENABLED, (Object)businessControl.isNoSearchEnabled());
    }

    public void afterBindData(EventObject e) {
        String type = this.getPageCache().get("entityType");
        if (type.equals("BaseEntity")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BILL_TYPE, VOUCHER, "labelap23", "labelap24"});
        }
        this.lockNotEditableBizControl();
    }

    private void lockNotEditableBizControl() {
        String entityId = this.getEntityMetadata().getRootEntity().getId();
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        if (entityMetadata == null) {
            return;
        }
        ExtLockTypeEnum lockType = ExtensibleDao.getExtLockType((AbstractMetadata)entityMetadata, (String)"Field", (String)entityMetadata.getModelType(), (String)entityId, (String)"BusinessControl");
        Set businessControl = ExtensibleDao.getBasePropIds((IPageCache)this.getPageCache(), (MetaCategory)MetaCategory.Entity, (String)entityId, (String)entityMetadata.getParentId(), (String)"BusinessControl", (boolean)false, o -> {
            HashSet<String> strings = new HashSet<String>(8);
            strings.add(String.format("%1$s_%2$s", ENABLE_IMPORT, String.valueOf(((BusinessControl)o).isEnableImport())));
            strings.add(String.format("%1$s_%2$s", BOTP, String.valueOf(((BusinessControl)o).isBotp())));
            strings.add(String.format("%1$s_%2$s", IS_PRINT, String.valueOf(((BusinessControl)o).isIsprint())));
            strings.add(String.format("%1$s_%2$s", CODE_NUMBER, String.valueOf(((BusinessControl)o).isCodeNumber())));
            strings.add(String.format("%1$s_%2$s", BILL_TYPE, String.valueOf(((BusinessControl)o).isBillType())));
            strings.add(String.format("%1$s_%2$s", VOUCHER, String.valueOf(((BusinessControl)o).isVoucher())));
            strings.add(String.format("%1$s_%2$s", IS_QING_ANALYSIS, String.valueOf(((BusinessControl)o).isQingAnalysis())));
            return strings;
        });
        if (ExtLockTypeEnum.speciallock.equals((Object)lockType)) {
            for (String bc : businessControl) {
                if (!bc.contains("true")) continue;
                this.getView().setEnable(Boolean.FALSE, new String[]{bc.split("_")[0]});
            }
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if (SAVE.equalsIgnoreCase(btn.getKey())) {
            IDataModel model = this.getModel();
            String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
            EntityMetadata metadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            BusinessControl businessControl = ((BillEntity)metadata.getItems().get(0)).getBusinessControl();
            businessControl.setEnableImport(((Boolean)model.getValue(ENABLE_IMPORT)).booleanValue());
            businessControl.setBotp(((Boolean)model.getValue(BOTP)).booleanValue());
            businessControl.setIsprint(((Boolean)model.getValue(IS_PRINT)).booleanValue());
            businessControl.setCodeNumber(((Boolean)model.getValue(CODE_NUMBER)).booleanValue());
            businessControl.setBillType(((Boolean)model.getValue(BILL_TYPE)).booleanValue());
            businessControl.setVoucher(((Boolean)model.getValue(VOUCHER)).booleanValue());
            businessControl.setQingAnalysis(((Boolean)model.getValue(IS_QING_ANALYSIS)).booleanValue());
            businessControl.setNoSearchEnabled(((Boolean)model.getValue(NO_SEARCH_ENABLED)).booleanValue());
            MetadataWriter writer = new MetadataWriter(metadata.getModelType());
            Map saveInfo = writer.save(new AbstractMetadata[]{metadata});
            if (Boolean.TRUE.equals(saveInfo.get("success"))) {
                this.getView().showSuccessNotification(saveInfo.get("message").toString());
            } else {
                this.getView().showErrorNotification(saveInfo.get("message").toString());
            }
        }
    }

    @Override
    public Map<String, Object> mergeModel(IDataModel subModel, Map<String, Object> mainEntityContext, Map<String, Object> entityMeta) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        HashMap<String, Boolean> businessControl = (HashMap<String, Boolean>)mainEntityContext.get("BusinessControl");
        if (businessControl == null) {
            businessControl = new HashMap<String, Boolean>(16);
            mainEntityContext.put("BusinessControl", businessControl);
        }
        Boolean enableImport = (Boolean)subModel.getValue(ENABLE_IMPORT);
        if (businessControl.containsKey(KEY_ENABLE_IMPORT)) {
            businessControl.remove(KEY_ENABLE_IMPORT);
        }
        if (!enableImport.booleanValue()) {
            businessControl.put(KEY_ENABLE_IMPORT, false);
        }
        Boolean isQingAnalysis = (Boolean)subModel.getValue(IS_QING_ANALYSIS);
        if (businessControl.containsKey(KEY_IS_QING_ANALYSIS)) {
            businessControl.remove(KEY_IS_QING_ANALYSIS);
        }
        if (!isQingAnalysis.booleanValue()) {
            businessControl.put(KEY_IS_QING_ANALYSIS, false);
        }
        Boolean noSearchEnabled = (Boolean)subModel.getValue(NO_SEARCH_ENABLED);
        if (businessControl.containsKey(KEY_NO_SEARCH_ENABLED)) {
            businessControl.remove(KEY_NO_SEARCH_ENABLED);
        }
        if (noSearchEnabled.booleanValue()) {
            businessControl.put(KEY_NO_SEARCH_ENABLED, true);
        }
        Boolean isVoucher = (Boolean)subModel.getValue(VOUCHER);
        if (businessControl.containsKey(KEY_VOUCHER)) {
            businessControl.remove(KEY_VOUCHER);
        }
        if (isVoucher.booleanValue()) {
            businessControl.put(KEY_VOUCHER, true);
        }
        Boolean isBotp = (Boolean)subModel.getValue(BOTP);
        if (businessControl.containsKey(KEY_BOTP)) {
            businessControl.remove(KEY_BOTP);
        }
        if (isBotp.booleanValue()) {
            businessControl.put(KEY_BOTP, true);
        }
        Boolean isBillType = (Boolean)subModel.getValue(BILL_TYPE);
        if (businessControl.containsKey(KEY_BILL_TYPE)) {
            businessControl.remove(KEY_BILL_TYPE);
        }
        if (isBillType.booleanValue()) {
            businessControl.put(KEY_BILL_TYPE, true);
        }
        Boolean isCodeNumber = (Boolean)subModel.getValue(CODE_NUMBER);
        if (businessControl.containsKey(KEY_CODE_NUMBER)) {
            businessControl.remove(KEY_CODE_NUMBER);
        }
        if (isCodeNumber.booleanValue()) {
            businessControl.put(KEY_CODE_NUMBER, true);
        }
        Boolean isWorkFlow = (Boolean)subModel.getValue(WORK_FLOW);
        if (businessControl.containsKey(KEY_WORK_FLOW)) {
            businessControl.remove(KEY_WORK_FLOW);
        }
        if (isWorkFlow.booleanValue()) {
            businessControl.put(KEY_WORK_FLOW, true);
        }
        Boolean isPrint = (Boolean)subModel.getValue(IS_PRINT);
        if (businessControl.containsKey(KEY_IS_PRINT)) {
            businessControl.remove(KEY_IS_PRINT);
        }
        if (isPrint.booleanValue()) {
            businessControl.put(KEY_IS_PRINT, true);
        }
        return result;
    }
}

