/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.entity.designer.rules;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.metadata.domainmodel.define.DomainModelTypeFactory;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.rule.BizRule;
import kd.bos.metadata.form.cardentry.CardEntryAp;
import kd.bos.metadata.form.cardentry.CardEntryRowAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.rule.FormRuleActionType;
import kd.bos.metadata.form.rule.FormRuleActionTypeCache;
import kd.bos.metadata.list.CardRowPanelAp;
import kd.bos.metadata.list.ListCardViewAp;
import kd.bos.metadata.list.ListGridViewAp;
import kd.bos.newdevportal.designer.DesignerTabReLoadEvent;
import kd.bos.newdevportal.designer.DesignerTabRefreshEvent;
import kd.bos.newdevportal.designer.MergeDesignerTabDataEvent;
import kd.bos.newdevportal.designer.SwitchDesignerTabEvent;
import kd.bos.newdevportal.entity.AbstractEntityDesignerSubPagePlugin;

public class BusinessRulesPlugin
extends AbstractEntityDesignerSubPagePlugin
implements ClickListener,
RowClickEventListener,
HyperLinkClickListener,
TreeNodeClickListener {
    private static final Log log = LogFactory.getLog(BusinessRulesPlugin.class);
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_TRUE_ENTRY = "trueentryentity";
    private static final String KEY_FALSE_ENTRY = "falseentryentity";
    private static final String TRUE_ADD = "trueadd";
    private static final String TRUE_UPDATE = "trueupdate";
    private static final String FALSE_ADD = "falseadd";
    private static final String FALSE_UPDATE = "falseupdate";
    private static final String PRE_DESCRIPTION = "predescription";
    private static final String VALUE = "value";
    private static final String DESCRIPTION = "description";
    private static final String DESCRIPTION1 = "Description";
    private static final String PRECONDITION = "precondition";
    private static final String PRE_DESCRIPTION1 = "PreDescription";
    private static final String ENABLED = "enabled";
    private static final String ENABLED1 = "Enabled";
    private static final String TRUE_ACTIONS = "trueactions";
    private static final String TRUE_ACTIONS1 = "TrueActions";
    private static final String FALSE_ACTIONS = "falseactions";
    private static final String FALSE_ACTIONS1 = "FalseActions";
    private static final String CONTEXT = "context";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String META_TYPE = "metaType";
    private static final String EXPRESSION = "Expression";
    private static final String TRUE_RULE_ID = "trueruleid";
    private static final String TRUE_RULE_NAME = "truerulename";
    private static final String TRUE_EXPRESSION = "trueexpression";
    private static final String TRUE_RAISE_EVENT_TYPE = "trueraiseeventtype";
    private static final String RAISE_EVENT_TYPE = "RaiseEventType";
    private static final String FALSE_RULE_NAME = "falserulename";
    private static final String FALSE_RULE_ID = "falseruleid";
    private static final String FALSE_RAISE_EVENT_TYPE = "falseraiseeventtype";
    private static final String FALSE_EXPRESSION = "falseexpression";
    private static final String ENTITY_RULES_CACHEID = "entityRulesCacheId";
    private static final String KEY_TREE_VIEW = "treeviewap";
    private static final String KEY_CURR_NODE_ID = "currNodeId";
    private static final String KEY_ENTITY_META = "entitymeta";
    private static final String KEY_RULES = "Rules";
    private static final String KEY_ITEMS = "Items";
    private static final String KEY_TYPE = "_Type_";
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_BIZ_RULES = "bizRules";
    private int serviceType = 1;
    private TreeNode rootNode = null;

    private static String getString() {
        return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u89c4\u5219", (String)"BusinessRulesPlugin_12", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
    }

    public int getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(int serviceType) {
        this.serviceType = serviceType;
    }

    private void addEntryGridRowClickListener(String entryKey) {
        EntryGrid falseEntryGrid = (EntryGrid)this.getControl(entryKey);
        falseEntryGrid.addRowClickListener((RowClickEventListener)this);
        falseEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    private boolean isEntryGridExist(String entryKey) {
        EntryGrid falseEntryGrid = (EntryGrid)this.getControl(entryKey);
        return falseEntryGrid != null;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"add", "update", "delete", "up", "down", "save", "detail", TRUE_ADD, "truedelete", TRUE_UPDATE, FALSE_ADD, "falsedelete", FALSE_UPDATE, PRE_DESCRIPTION});
        this.addEntryGridRowClickListener(KEY_ENTRY_ENTITY);
        this.addEntryGridRowClickListener(KEY_TRUE_ENTRY);
        if (this.isEntryGridExist(KEY_FALSE_ENTRY)) {
            this.addEntryGridRowClickListener(KEY_FALSE_ENTRY);
        }
        this.addItemClickListeners(new String[]{"advcontoolbarap", "advcontoolbarap1", "advcontoolbarap2"});
        TreeView tView = (TreeView)this.getControl(KEY_TREE_VIEW);
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    private void getCustomParams() {
        EntityMetadata entityMetadata = this.getEntityMetadata();
        String modelType = entityMetadata.getModelType();
        String elementType = ((EntityItem)entityMetadata.getItems().get(0)).getClass().getSimpleName();
        DomainModelType type = DomainModelTypeFactory.getDomainModelType((String)modelType, (boolean)true);
        List props = type.getElementType(elementType).getProperties();
        Property rules = null;
        for (Property prop : props) {
            if (!KEY_RULES.equals(prop.getPropertyName())) continue;
            rules = prop;
            break;
        }
        if (rules == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5c5e\u6027\u5b9a\u4e49", (String)"BusinessRulesPlugin_13", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
        MetadataSerializer ser = new MetadataSerializer(modelType);
        DomainModelBinder binder = (DomainModelBinder)ser.getBinder();
        binder.setLCId("zh_CN");
        binder.setWriteInheritFlag(true);
        Map data = ser.serializeToMap((Object)entityMetadata);
        List items = (List)data.get(KEY_ITEMS);
        LinkedHashMap<String, Map> itemMaps = new LinkedHashMap<String, Map>(items.size());
        for (Map it : items) {
            itemMaps.put(it.get("Id").toString(), it);
        }
        ArrayList context = new ArrayList(2);
        ArrayList contextEntity = new ArrayList(itemMaps.values());
        ArrayList contextForm = new ArrayList(1);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(2);
        String apType = (String)((Map)contextEntity.get(0)).get(KEY_TYPE);
        String apId = (String)((Map)contextEntity.get(0)).get("Id");
        map.put(KEY_TYPE, apType);
        map.put("Id", apId);
        contextForm.add(map);
        context.add(contextEntity);
        context.add(contextForm);
        String contextStr = SerializationUtils.toJsonString(context);
        this.getPageCache().put("context_cache", contextStr);
    }

    public void afterCreateNewData(EventObject e) {
        this.getCustomParams();
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        this.loadRules(false);
        this.getPageCache().put(KEY_CURR_NODE_ID, entityId);
    }

    private void loadRules(boolean reload) {
        String rulesString = this.initEntityTree(reload);
        Map map = (Map)SerializationUtils.fromJsonString((String)rulesString, Map.class);
        String entityId = this.getEntityMetadata().getId();
        Object rules = map.get(entityId);
        this.renderRules(rules);
    }

    private void renderRules(Object value) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_ENTRY_ENTITY);
        rows.clear();
        DynamicObjectCollection trueRows = this.getModel().getEntryEntity(KEY_TRUE_ENTRY);
        trueRows.clear();
        DynamicObjectCollection falseRows = this.getModel().getEntryEntity(KEY_FALSE_ENTRY);
        falseRows.clear();
        this.getModel().deleteEntryData(KEY_ENTRY_ENTITY);
        this.getModel().deleteEntryData(KEY_TRUE_ENTRY);
        this.getModel().deleteEntryData(KEY_FALSE_ENTRY);
        if (StringUtils.isBlank((Object)value) || ((List)value).size() < 1) {
            return;
        }
        List rules = (List)value;
        DataEntityPropertyCollection props = this.getModel().getEntryEntity(KEY_ENTRY_ENTITY).getDynamicObjectType().getProperties();
        for (Map rule : rules) {
            int rowKey = this.getModel().createNewEntryRow(KEY_ENTRY_ENTITY);
            if (this.getModel().getProperty("id") != null) {
                this.getModel().setValue("id", rule.get("Id"), rowKey);
            }
            if (props.get((Object)DESCRIPTION) != null) {
                this.getModel().setValue(DESCRIPTION, rule.get(DESCRIPTION1), rowKey);
            }
            this.getModel().setValue(PRECONDITION, rule.get("PreCondition"), rowKey);
            this.getModel().setValue(PRE_DESCRIPTION, rule.get(PRE_DESCRIPTION1), rowKey);
            if (props.get((Object)ENABLED) != null) {
                this.getModel().setValue(ENABLED, (Object)(rule.get(ENABLED1) == null ? Boolean.valueOf(true) : rule.get(ENABLED1)), rowKey);
            }
            this.getModel().setValue(TRUE_ACTIONS, (Object)(rule.get(TRUE_ACTIONS1) == null ? "[]" : SerializationUtils.toJsonString(rule.get(TRUE_ACTIONS1))), rowKey);
            if (this.getModel().getDataEntityType().getProperties().get((Object)KEY_FALSE_ENTRY) == null) continue;
            this.getModel().setValue(FALSE_ACTIONS, (Object)(rule.get(FALSE_ACTIONS1) == null ? "[]" : SerializationUtils.toJsonString(rule.get(FALSE_ACTIONS1))), rowKey);
        }
        EntryGrid grid = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY);
        int currentRow = grid.getEntryState().getFocusRow();
        if (currentRow <= 0) {
            currentRow = 0;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        IDataModel model = this.getModel();
        map.put(TRUE_ACTIONS1, model.getValue(TRUE_ACTIONS, currentRow));
        if (this.getModel().getDataEntityType().getProperties().get((Object)KEY_FALSE_ENTRY) != null) {
            map.put(FALSE_ACTIONS1, model.getValue(FALSE_ACTIONS, currentRow));
        }
        this.createConditionData(map);
        this.getView().updateView();
    }

    public void afterBindData(EventObject e) {
        EntryGrid grid = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY);
        int currentRow = grid.getEntryState().getFocusRow();
        if (currentRow <= 0) {
            currentRow = 0;
            int[] selectRow = new int[]{currentRow};
            grid.selectRows(selectRow, currentRow);
        } else {
            int[] selectRow = new int[]{currentRow};
            grid.selectRows(selectRow, currentRow);
        }
    }

    private String initEntityTree(boolean reload) {
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREE_VIEW);
        EntityMetadata entityMetadata = this.getEntityMetadata();
        String name = entityMetadata.getRootEntity().getName().toString();
        TreeNode root = new TreeNode();
        root.setId(entityMetadata.getId());
        root.setText(name);
        root.setParentid("");
        root.setIsOpened(true);
        ArrayList<TreeNode> children = new ArrayList<TreeNode>(10);
        List items = entityMetadata.getItems();
        HashMap map = new HashMap(10);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(BizRule.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        for (EntityItem item : items) {
            List rules;
            if (!(item instanceof Entity)) continue;
            String id = item.getId();
            if (item instanceof EntryEntity) {
                TreeNode childrenRoot = new TreeNode();
                childrenRoot.setId(id);
                childrenRoot.setText(item.getName().toString());
                children.add(childrenRoot);
            }
            if ((rules = ((Entity)item).getRules()) == null) continue;
            ArrayList<Map> newRules = new ArrayList<Map>(rules.size());
            for (BizRule rule : rules) {
                newRules.add(ser.serializeToMap((Object)rule, null));
            }
            map.put(id, newRules);
        }
        root.addChildren(children);
        if (reload) {
            tree.updateNode(root);
        } else {
            tree.addNode(root);
        }
        tree.focusNode(root);
        String rulesString = SerializationUtils.toJsonString(map);
        this.getPageCache().put(ENTITY_RULES_CACHEID, rulesString);
        return rulesString;
    }

    private TreeNode buildTree() {
        if (this.rootNode != null) {
            return this.rootNode;
        }
        EntityMetadata entityMetadata = this.getEntityMetadata();
        String name = entityMetadata.getRootEntity().getName().toString();
        TreeNode root = new TreeNode();
        root.setId(entityMetadata.getId());
        root.setText(name);
        root.setParentid("");
        root.setIsOpened(true);
        ArrayList<TreeNode> children = new ArrayList<TreeNode>(10);
        List items = entityMetadata.getItems();
        for (EntityItem item : items) {
            if (!(item instanceof Entity)) continue;
            String id = item.getId();
            if (!(item instanceof EntryEntity)) continue;
            TreeNode childrenRoot = new TreeNode();
            childrenRoot.setId(id);
            childrenRoot.setText(item.getName().toString());
            children.add(childrenRoot);
        }
        root.addChildren(children);
        this.rootNode = root;
        return this.rootNode;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        Map<String, Object> result = this.saveRulesData();
        String oldNodeId = this.getPageCache().get(KEY_CURR_NODE_ID);
        if (StringUtils.isBlank((CharSequence)oldNodeId)) {
            oldNodeId = this.getEntityMetadata().getId();
        }
        if (!((Boolean)result.get(KEY_SUCCESS)).booleanValue()) {
            String errorInfo = (String)result.get("errors");
            this.getView().showErrorNotification(errorInfo);
            e.setCancel(true);
            if (!oldNodeId.equals(e.getNodeId())) {
                TreeNode root = this.buildTree();
                TreeNode oldNode = root.getTreeNode(oldNodeId, 10);
                ((TreeView)e.getSource()).focusNode(oldNode);
            }
            return;
        }
        List bizrules = (List)result.get(KEY_BIZ_RULES);
        String nodeId = (String)e.getNodeId();
        String rulesString = this.getPageCache().get(ENTITY_RULES_CACHEID);
        Map map = (Map)SerializationUtils.fromJsonString((String)rulesString, Map.class);
        map.put(oldNodeId, bizrules);
        this.getPageCache().put(ENTITY_RULES_CACHEID, SerializationUtils.toJsonString((Object)map));
        this.renderRules(map.get(nodeId));
        this.getPageCache().put(KEY_CURR_NODE_ID, nodeId);
    }

    private void updateRuleCahce() {
        Map<String, Object> result = this.saveRulesData();
        ArrayList bizrules = (ArrayList)result.get(KEY_BIZ_RULES);
        if (bizrules == null) {
            bizrules = new ArrayList(1);
        }
        String rulesString = this.getPageCache().get(ENTITY_RULES_CACHEID);
        Map map = (Map)SerializationUtils.fromJsonString((String)rulesString, Map.class);
        String currNodeId = this.getPageCache().get(KEY_CURR_NODE_ID);
        map.put(currNodeId, bizrules);
        this.getPageCache().put(ENTITY_RULES_CACHEID, SerializationUtils.toJsonString((Object)map));
    }

    protected void attachParameter(FormShowParameter parameter) {
        this.getCustomParams();
        String contextCache = this.getPageCache().get("context_cache");
        List contextList = (List)SerializationUtils.fromJsonString((String)contextCache, List.class);
        Object context = contextList.get(0);
        String controlId = ((Map)((List)contextList.get(contextList.size() - 1)).get(0)).get("Id").toString();
        String clzName = ((Map)((List)contextList.get(contextList.size() - 1)).get(0)).get(KEY_TYPE).toString();
        parameter.setCustomParam(CONTEXT, context);
        String prefix = null;
        switch (clzName) {
            case "EntryAp": {
                prefix = "kd.bos.metadata.form.control.";
                break;
            }
            case "ListGridViewAp": 
            case "CardRowPanelAp": 
            case "ListCardViewAp": {
                prefix = "kd.bos.metadata.list.";
                break;
            }
            case "CardEntryRowAp": 
            case "CardEntryAp": 
            case "SubCardEntryAp": {
                prefix = "kd.bos.metadata.form.cardentry.";
                break;
            }
            default: {
                return;
            }
        }
        try {
            Class<?> clz = Class.forName(prefix + clzName);
            Object newInst = clz.newInstance();
            if (newInst instanceof EntryAp || newInst instanceof ListCardViewAp || newInst instanceof ListGridViewAp || newInst instanceof CardRowPanelAp || newInst instanceof CardEntryAp || newInst instanceof CardEntryRowAp) {
                parameter.setCustomParam("controlId", (Object)controlId);
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u89c4\u5219\u51fa\u73b0\u9519\u8bef\u3002", (String)"BusinessRulesPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void add() {
        int rowKey = this.getModel().createNewEntryRow(KEY_ENTRY_ENTITY);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        grid.getEntryState().selectRow(rowKey);
        this.getModel().deleteEntryData(KEY_TRUE_ENTRY);
        if (this.isEntryGridExist(KEY_FALSE_ENTRY)) {
            this.getModel().deleteEntryData(KEY_FALSE_ENTRY);
        }
    }

    protected void ruleAdd(String key) {
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "ide_serviceedit");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        showParameter.setParentFormId(this.getView().getFormShowParameter().getParentFormId());
        this.attachParameter(showParameter);
        showParameter.setCustomParam(META_TYPE, (Object)KEY_ENTITY_META);
        showParameter.setCustomParam("serviceType", (Object)this.getServiceType());
        showParameter.setCustomParam("isEntityDesign", (Object)"true");
        showParameter.setCustomParam("itemId", (Object)this.getPageCache().get(KEY_CURR_NODE_ID));
        this.getView().showForm(showParameter);
    }

    protected void ruleUpdate(String update, String entryKey, String ruleName, String ruleId, String expression, String ret) {
        HashMap<String, Object> currentRow = new HashMap<String, Object>();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(entryKey);
        if (grid == null) {
            return;
        }
        int selectRows = grid.getEntryState().getFocusRow();
        int count = this.getModel().getEntryRowCount(entryKey);
        if (selectRows > -1 && count > 0) {
            IDataModel rowData = this.getModel();
            if (rowData != null) {
                currentRow.put("RuleName", rowData.getValue(ruleName, selectRows));
                currentRow.put("RuleId", rowData.getValue(ruleId, selectRows));
                currentRow.put(EXPRESSION, rowData.getValue(expression, selectRows));
                currentRow.put("RET", rowData.getValue(ret, selectRows));
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setFormId("ide_serviceedit");
                parameter.setCustomParam(VALUE, currentRow);
                parameter.setParentFormId(this.getView().getFormShowParameter().getParentFormId());
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, update + "&" + selectRows));
                this.attachParameter(parameter);
                parameter.setCustomParam(META_TYPE, (Object)KEY_ENTITY_META);
                parameter.setCustomParam("serviceType", (Object)this.getServiceType());
                parameter.setCustomParam("isEntityDesign", (Object)"true");
                parameter.setCustomParam("itemId", (Object)this.getPageCache().get(KEY_CURR_NODE_ID));
                this.getView().showForm(parameter);
            } else {
                this.getView().showTipNotification(BusinessRulesPlugin.getString());
            }
        } else {
            this.getView().showTipNotification(BusinessRulesPlugin.getString());
        }
    }

    protected void delete() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        int[] selectRows = grid.getEntryState().getSelectedRows();
        if (selectRows != null && selectRows.length > 0) {
            this.getModel().deleteEntryData(KEY_TRUE_ENTRY);
            if (this.isEntryGridExist(KEY_FALSE_ENTRY)) {
                this.getModel().deleteEntryData(KEY_FALSE_ENTRY);
            }
            this.getModel().deleteEntryRows(KEY_ENTRY_ENTITY, selectRows);
        } else {
            this.getView().showTipNotification(BusinessRulesPlugin.getString());
        }
        int count = this.getModel().getEntryRowCount(KEY_ENTRY_ENTITY);
        if (count > 0) {
            this.selRowEvent(0);
        }
    }

    protected void delete(String entryKey) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(entryKey);
        int[] selectRows = grid.getEntryState().getSelectedRows();
        if (selectRows != null && selectRows.length > 0) {
            this.getModel().deleteEntryRows(entryKey, selectRows);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u89c4\u5219", (String)"BusinessRulesPlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void up(String entryKey) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(entryKey);
        if (grid == null) {
            return;
        }
        int[] rowsIndex = grid.getEntryState().getSelectedRows();
        if (rowsIndex.length < 1 || rowsIndex[0] < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u4f53\u9879\u3002", (String)"BusinessRulesPlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (rowsIndex.length > 0 && rowsIndex[0] == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u4e3a\u7b2c\u4e00\u884c\u3002", (String)"BusinessRulesPlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), Integer.valueOf(1000));
            return;
        }
        this.getModel().moveEntryRowsUp(entryKey, rowsIndex);
    }

    private void down(String entryKey) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(entryKey);
        if (grid == null) {
            return;
        }
        int[] rowsIndex = grid.getEntryState().getSelectedRows();
        int rowLength = this.getModel().getEntryRowCount(entryKey);
        if (rowsIndex.length < 1 || rowLength <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u4f53\u9879", (String)"BusinessRulesPlugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), Integer.valueOf(1000));
            return;
        }
        if (rowsIndex.length > 0 && rowsIndex[0] == rowLength - 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u4e3a\u6700\u540e\u4e00\u884c", (String)"BusinessRulesPlugin_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), Integer.valueOf(1000));
            return;
        }
        this.getModel().moveEntryRowsDown(entryKey, rowsIndex);
    }

    private FormShowParameter getRulesFormShowParameter(String condition) {
        HashMap<String, String> map2;
        AbstractGrid entryGrid = (AbstractGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        int entrySelRow = entryGrid.getEntryState().getFocusRow();
        EntityMetadata entityMetadata = this.getEntityMetadata();
        String modelType = entityMetadata.getModelType();
        String elementType = ((EntityItem)entityMetadata.getItems().get(0)).getClass().getSimpleName();
        DomainModelType type = DomainModelTypeFactory.getDomainModelType((String)modelType, (boolean)true);
        List props = type.getElementType(elementType).getProperties();
        Property rules = null;
        for (Property prop : props) {
            if (!KEY_RULES.equals(prop.getPropertyName())) continue;
            rules = prop;
            break;
        }
        if (rules == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5c5e\u6027\u5b9a\u4e49", (String)"BusinessRulesPlugin_13", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
        MetadataSerializer ser = new MetadataSerializer(modelType);
        DomainModelBinder binder = (DomainModelBinder)ser.getBinder();
        binder.setLCId("zh_CN");
        binder.setWriteInheritFlag(true);
        Map data = ser.serializeToMap((Object)entityMetadata);
        String itemId = this.getPageCache().get(KEY_CURR_NODE_ID) != null ? this.getPageCache().get(KEY_CURR_NODE_ID) : entityMetadata.getRootEntity().getId();
        List items = (List)data.get(KEY_ITEMS);
        LinkedHashMap<String, Map> itemMaps = new LinkedHashMap<String, Map>(items.size());
        for (Map it : items) {
            itemMaps.put(it.get("Id").toString(), it);
        }
        ArrayList context = new ArrayList(2);
        ArrayList contextEntity = new ArrayList(itemMaps.values());
        String id = this.getPageCache().get(KEY_CURR_NODE_ID);
        String apType = "";
        for (HashMap<String, String> map2 : contextEntity) {
            if (!id.equals(map2.get("Id"))) continue;
            apType = (String)map2.get(KEY_TYPE);
        }
        ArrayList contextForm = new ArrayList(1);
        map2 = new HashMap<String, String>(2);
        map2.put(KEY_TYPE, apType);
        map2.put("Id", id);
        contextForm.add(map2);
        context.add(contextEntity);
        context.add(contextForm);
        HashMap<String, String> para = new HashMap<String, String>();
        HashMap<String, Object> currentPreDate = new HashMap<String, Object>();
        currentPreDate.put("RuleDescription", this.getModel().getValue(PRE_DESCRIPTION, entrySelRow));
        currentPreDate.put("RuleCondition", this.getModel().getValue(PRECONDITION, entrySelRow));
        para.put("formId", "ide_preconditiondesign");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, condition + "&" + entrySelRow));
        showParameter.setCustomParam("itemId", (Object)itemId);
        showParameter.setCustomParam(META_TYPE, (Object)KEY_ENTITY_META);
        showParameter.setCustomParam(VALUE, currentPreDate);
        showParameter.setCustomParam(CONTEXT, context);
        showParameter.setCustomParam("ruleFormId", (Object)"ide_rules");
        showParameter.setCustomParam("isEntityDesign", (Object)"true");
        return showParameter;
    }

    protected void ruleCondition(String condition) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty("TextAreaField", "text", (Object)"");
        FormShowParameter showParameter = this.getRulesFormShowParameter(condition);
        this.getView().showForm(showParameter);
    }

    private void createConditionData(Map<String, Object> ops) {
        if (ops != null && ops.size() > 0) {
            List falseList;
            List trueList = (List)SerializationUtils.fromJsonString((String)ops.get(TRUE_ACTIONS1).toString(), List.class);
            if (trueList != null && !trueList.isEmpty()) {
                this.initEntity(trueList, KEY_TRUE_ENTRY, TRUE_RULE_ID, TRUE_RULE_NAME, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE);
            }
            if (this.getModel().getDataEntityType().getProperties().get((Object)KEY_FALSE_ENTRY) != null && (falseList = (List)SerializationUtils.fromJsonString((String)ops.get(FALSE_ACTIONS1).toString(), List.class)) != null && !falseList.isEmpty()) {
                this.initEntity(falseList, KEY_FALSE_ENTRY, "FalseRuleId", "FalseRuleName", "FalseExpression", "falseRaiseEventType");
            }
        }
    }

    private void initEntity(List<Map<String, Object>> trueList, String entityName, String ruleId, String ruleName, String expName, String retName) {
        if (!this.isEntryGridExist(entityName)) {
            return;
        }
        for (int i = 0; i < trueList.size(); ++i) {
            int rowKey = this.getModel().createNewEntryRow(entityName);
            FormRuleActionType tempMetaData = FormRuleActionTypeCache.geFormRuleActionType((String)trueList.get(i).get("ActionType").toString());
            if (tempMetaData != null) {
                this.getModel().setValue(ruleId, (Object)tempMetaData.getId(), rowKey);
                this.getModel().setValue(ruleName, (Object)(trueList.get(i).get(DESCRIPTION1) == null ? "" : trueList.get(i).get(DESCRIPTION1).toString()), rowKey);
                this.getModel().setValue(retName, (Object)(trueList.get(i).get("RET") == null ? "" : trueList.get(i).get("RET").toString()), rowKey);
            }
            this.getModel().setValue(expName, (Object)SerializationUtils.toJsonString(trueList.get(i)), rowKey);
        }
    }

    protected Map<String, Object> saveRulesData() {
        Map<String, Object> map;
        ArrayList<Map<String, Object>> ruleMapList = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection collection = this.getModel().getEntryEntity(KEY_ENTRY_ENTITY);
        int mustInput = -1;
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put(KEY_SUCCESS, true);
        String mustContext = ResManager.loadKDString((String)"\u89c4\u5219\u63cf\u8ff0", (String)"BusinessRulesPlugin_6", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
        for (DynamicObject obj : collection) {
            Object falseactions;
            map = new HashMap<String, Object>();
            Object trueactions = obj.get(TRUE_ACTIONS);
            if (!StringUtils.isBlank((Object)trueactions)) {
                map.put(TRUE_ACTIONS1, SerializationUtils.fromJsonString((String)obj.get(TRUE_ACTIONS).toString(), List.class));
            }
            if (obj.getDataEntityType().getProperties().get((Object)FALSE_ACTIONS) != null && !StringUtils.isBlank((Object)(falseactions = obj.get(FALSE_ACTIONS)))) {
                map.put(FALSE_ACTIONS1, SerializationUtils.fromJsonString((String)obj.get(FALSE_ACTIONS).toString(), List.class));
            }
            if (obj.getDataEntityType().getProperties().get((Object)DESCRIPTION) != null && StringUtils.isBlank((Object)obj.get(DESCRIPTION)) || StringUtils.isBlank((Object)obj.get(PRE_DESCRIPTION))) {
                if (obj.getDataEntityType().getProperties().get((Object)DESCRIPTION) != null && !StringUtils.isBlank((Object)obj.get(DESCRIPTION))) {
                    mustContext = ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e", (String)"BusinessRulesPlugin_7", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                }
                mustInput = obj.getInt("seq");
                break;
            }
            if (obj.getDataEntityType().getProperties().get((Object)DESCRIPTION) != null) {
                map.put(DESCRIPTION1, obj.get(DESCRIPTION));
            }
            if (this.getModel().getProperty("id") != null) {
                String id = (String)obj.get("id");
                if (StringUtils.isEmpty((CharSequence)id)) {
                    id = Uuid16.create().toString();
                }
                map.put("Id", id);
            }
            map.put("PreCondition", obj.get(PRECONDITION));
            map.put(PRE_DESCRIPTION1, obj.get(PRE_DESCRIPTION));
            if (obj.getDataEntityType().getProperties().get((Object)ENABLED1) != null) {
                map.put(ENABLED1, obj.get(ENABLED) == null ? Boolean.valueOf(true) : obj.get(ENABLED));
            } else {
                map.put(ENABLED1, true);
            }
            ruleMapList.add(map);
        }
        if (mustInput > -1) {
            result.put(KEY_SUCCESS, false);
            result.put("errors", String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u201d%s\u201c\u5fc5\u586b", (String)"BusinessRulesPlugin_8", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), mustInput, mustContext));
            return result;
        }
        result.put(KEY_BIZ_RULES, ruleMapList);
        String rulesString = this.getPageCache().get(ENTITY_RULES_CACHEID);
        String currNodeId = this.getPageCache().get(KEY_CURR_NODE_ID);
        map = (Map)SerializationUtils.fromJsonString((String)rulesString, Map.class);
        map.put(currNodeId, ruleMapList);
        this.getPageCache().put(ENTITY_RULES_CACHEID, SerializationUtils.toJsonString(map));
        return result;
    }

    protected Object getRuleAlias(List<Map<String, Object>> ruleMapList) {
        if (ruleMapList == null || ruleMapList.isEmpty()) {
            return "";
        }
        List<Map<String, Object>> ops = ruleMapList;
        StringBuilder alias = new StringBuilder();
        for (Map<String, Object> op : ops) {
            String description;
            boolean enabled = Boolean.parseBoolean(op.get(ENABLED1).toString());
            String string = description = op.get(DESCRIPTION1) == null ? op.get(PRE_DESCRIPTION1).toString() : op.get(DESCRIPTION1).toString();
            if (!enabled) continue;
            alias.append(alias.length() == 0 ? alias.toString() : "; ").append(description);
        }
        return alias.toString();
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("save")) {
            this.saveRulesData();
        } else if (key.equals(PRE_DESCRIPTION)) {
            this.ruleCondition(PRE_DESCRIPTION);
        } else if (key.equals("detail")) {
            this.getView().showErrorNotification("sd");
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        Map ruleMap = (Map)e.getReturnData();
        if (this.getView().getControl(KEY_TRUE_ENTRY) != null) {
            this.getView().updateView(KEY_TRUE_ENTRY);
        }
        if (this.getView().getControl(KEY_FALSE_ENTRY) != null) {
            this.getView().updateView(KEY_FALSE_ENTRY);
        }
        if (e.getActionId().startsWith(PRE_DESCRIPTION)) {
            int rowKey = Integer.parseInt(e.getActionId().split("&")[1]);
            this.getModel().setValue(PRE_DESCRIPTION, ruleMap.get("RuleDescription"), rowKey);
            this.getModel().setValue(PRECONDITION, ruleMap.get("RuleCondition"), rowKey);
            return;
        }
        if (TRUE_ADD.equalsIgnoreCase(e.getActionId())) {
            int rowKey = this.getModel().createNewEntryRow(KEY_TRUE_ENTRY);
            this.getModel().setValue(TRUE_RULE_NAME, ruleMap.get(DESCRIPTION1), rowKey);
            this.getModel().setValue(TRUE_RULE_ID, ruleMap.get("Id"), rowKey);
            this.getModel().setValue(TRUE_RAISE_EVENT_TYPE, ruleMap.get(RAISE_EVENT_TYPE), rowKey);
            this.getModel().setValue(TRUE_EXPRESSION, (Object)ruleMap.get(EXPRESSION).toString(), rowKey);
            this.saveColumnData(ruleMap);
            this.saveActions(e.getActionId(), KEY_TRUE_ENTRY, ruleMap, TRUE_ACTIONS, TRUE_RULE_NAME, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE);
        } else if (FALSE_ADD.equalsIgnoreCase(e.getActionId())) {
            int rowKey = this.getModel().createNewEntryRow(KEY_FALSE_ENTRY);
            this.getModel().setValue(FALSE_RULE_NAME, ruleMap.get(DESCRIPTION1), rowKey);
            this.getModel().setValue(FALSE_RULE_ID, ruleMap.get("Id"), rowKey);
            this.getModel().setValue(FALSE_RAISE_EVENT_TYPE, ruleMap.get(RAISE_EVENT_TYPE), rowKey);
            this.getModel().setValue(FALSE_EXPRESSION, (Object)ruleMap.get(EXPRESSION).toString(), rowKey);
            this.saveColumnData(ruleMap);
            this.saveActions(e.getActionId(), KEY_FALSE_ENTRY, ruleMap, FALSE_ACTIONS, FALSE_RULE_NAME, FALSE_EXPRESSION, FALSE_RAISE_EVENT_TYPE);
        } else if (e.getActionId().startsWith(TRUE_UPDATE)) {
            int rowKey = Integer.parseInt(e.getActionId().split("&")[1]);
            this.getModel().setValue(TRUE_RULE_NAME, ruleMap.get(DESCRIPTION1), rowKey);
            this.getModel().setValue(TRUE_RULE_ID, ruleMap.get("Id"), rowKey);
            this.getModel().setValue(TRUE_RAISE_EVENT_TYPE, ruleMap.get(RAISE_EVENT_TYPE), rowKey);
            this.getModel().setValue(TRUE_EXPRESSION, (Object)ruleMap.get(EXPRESSION).toString(), rowKey);
            this.saveActions(e.getActionId(), KEY_TRUE_ENTRY, ruleMap, TRUE_ACTIONS, TRUE_RULE_NAME, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE);
        } else if (e.getActionId().startsWith(FALSE_UPDATE)) {
            int rowKey = Integer.parseInt(e.getActionId().split("&")[1]);
            this.getModel().setValue(FALSE_RULE_NAME, ruleMap.get(DESCRIPTION1), rowKey);
            this.getModel().setValue(FALSE_RULE_ID, ruleMap.get("Id"), rowKey);
            this.getModel().setValue(FALSE_RAISE_EVENT_TYPE, ruleMap.get(RAISE_EVENT_TYPE), rowKey);
            this.getModel().setValue(FALSE_EXPRESSION, (Object)ruleMap.get(EXPRESSION).toString(), rowKey);
            this.saveActions(e.getActionId(), KEY_FALSE_ENTRY, ruleMap, FALSE_ACTIONS, FALSE_RULE_NAME, FALSE_EXPRESSION, FALSE_RAISE_EVENT_TYPE);
        }
        this.updateRuleCahce();
    }

    private Map<String, Object> saveColumnData(Map<String, Object> ruleMap) {
        Object actions = ruleMap.get(EXPRESSION);
        Map actionMap = null;
        if (!StringUtils.isBlank((Object)actions)) {
            actionMap = (Map)SerializationUtils.fromJsonString((String)actions.toString(), Map.class);
            if (!StringUtils.isBlank((Object)ruleMap.get(DESCRIPTION1))) {
                actionMap.put(DESCRIPTION1, ruleMap.get(DESCRIPTION1));
            }
            if (!StringUtils.isBlank((Object)ruleMap.get(RAISE_EVENT_TYPE))) {
                actionMap.put("RET", ruleMap.get(RAISE_EVENT_TYPE));
            }
        }
        return actionMap;
    }

    void saveActions(String key, String actionEntryKey, Map<String, Object> ruleMap, String actionKey, String ruleName, String expression, String ret) {
        ArrayList<Map> actionList = new ArrayList<Map>();
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY);
        if (entryGrid == null) {
            return;
        }
        int entryIndex = entryGrid.getEntryState().getFocusRow();
        int rowCount = this.getModel().getEntryRowCount(actionEntryKey);
        for (int i = 0; i < rowCount; ++i) {
            int rowKey;
            DynamicObject trueObj = this.getModel().getEntryRowEntity(actionEntryKey, i);
            if (key.split("&").length > 1 && i == (rowKey = Integer.parseInt(key.split("&")[1]))) {
                actionList.add(this.saveColumnData(ruleMap));
                continue;
            }
            Object trueactions = trueObj.get(expression);
            if (StringUtils.isBlank((Object)trueactions)) continue;
            Map trueMap = (Map)SerializationUtils.fromJsonString((String)trueactions.toString(), Map.class);
            if (!StringUtils.isBlank((Object)trueObj.get(ruleName))) {
                trueMap.put(DESCRIPTION1, trueObj.get(ruleName));
            }
            if (!StringUtils.isBlank((Object)trueObj.get(ret))) {
                trueMap.put("RET", trueObj.get(ret));
            }
            actionList.add(trueMap);
        }
        this.getModel().setValue(actionKey, (Object)SerializationUtils.toJsonString(actionList), entryIndex);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY);
        int index = entryGrid.getEntryState().getFocusRow();
        int count = this.getModel().getEntryRowCount(KEY_ENTRY_ENTITY);
        if (!"add".equals(key)) {
            if (count < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u89c4\u5219\u6761\u4ef6\u3002", (String)"BusinessRulesPlugin_9", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                return;
            }
            if (index < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u89c4\u5219\u884c\u3002", (String)"BusinessRulesPlugin_10", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                return;
            }
        }
        if ("add".equals(key)) {
            this.add();
        } else if (TRUE_ADD.equals(key) || FALSE_ADD.equals(key)) {
            this.ruleAdd(key);
        } else if ("delete".equals(key)) {
            this.delete();
        } else if ("truedelete".equals(key)) {
            this.delete(KEY_TRUE_ENTRY);
            HashMap<String, Object> ruleMap = new HashMap<String, Object>();
            this.saveActions(key, KEY_TRUE_ENTRY, ruleMap, TRUE_ACTIONS, TRUE_RULE_NAME, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE);
        } else if ("falsedelete".equals(key)) {
            this.delete(KEY_FALSE_ENTRY);
            HashMap<String, Object> ruleMap = new HashMap<String, Object>();
            this.saveActions(key, KEY_FALSE_ENTRY, ruleMap, FALSE_ACTIONS, FALSE_RULE_NAME, FALSE_EXPRESSION, FALSE_RAISE_EVENT_TYPE);
        } else if (TRUE_UPDATE.equalsIgnoreCase(key)) {
            this.ruleUpdate(key, KEY_TRUE_ENTRY, TRUE_RULE_NAME, TRUE_RULE_ID, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE);
        } else if (FALSE_UPDATE.equalsIgnoreCase(key)) {
            this.ruleUpdate(key, KEY_FALSE_ENTRY, FALSE_RULE_NAME, FALSE_RULE_ID, FALSE_EXPRESSION, FALSE_RAISE_EVENT_TYPE);
        } else if ("up".equals(key)) {
            this.up(KEY_ENTRY_ENTITY);
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
            int[] rowsIndex = grid.getEntryState().getSelectedRows();
            this.selRowEvent(rowsIndex[0] - 1);
        } else if ("trueup".equalsIgnoreCase(key)) {
            this.up(KEY_TRUE_ENTRY);
        } else if ("falseup".equalsIgnoreCase(key)) {
            this.up(KEY_FALSE_ENTRY);
        } else if ("down".equals(key)) {
            this.down(KEY_ENTRY_ENTITY);
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
            int[] rowsIndex = grid.getEntryState().getSelectedRows();
            this.selRowEvent(rowsIndex[0] + 1);
        } else if ("truedown".equalsIgnoreCase(key)) {
            this.down(KEY_TRUE_ENTRY);
        } else if ("falsedown".equalsIgnoreCase(key)) {
            this.down(KEY_FALSE_ENTRY);
        }
        this.updateRuleCahce();
    }

    private void selRowEvent(int selectRows) {
        List trueList;
        Object trueactions;
        if (selectRows < 0) {
            return;
        }
        IDataModel rowData = this.getModel();
        this.getModel().deleteEntryData(KEY_TRUE_ENTRY);
        if (this.isEntryGridExist(KEY_FALSE_ENTRY)) {
            List falseList;
            this.getModel().deleteEntryData(KEY_FALSE_ENTRY);
            Object falseactions = rowData.getValue(FALSE_ACTIONS, selectRows);
            if (falseactions == null || StringUtils.isBlank((Object)falseactions)) {
                falseactions = "[]";
            }
            if ((falseList = (List)SerializationUtils.fromJsonString((String)falseactions.toString(), List.class)) != null && !falseList.isEmpty()) {
                this.initEntity(falseList, KEY_FALSE_ENTRY, FALSE_RULE_ID, FALSE_RULE_NAME, FALSE_EXPRESSION, FALSE_RAISE_EVENT_TYPE);
            }
        }
        if ((trueactions = rowData.getValue(TRUE_ACTIONS, selectRows)) == null || StringUtils.isBlank((Object)trueactions)) {
            trueactions = "[]";
        }
        if ((trueList = (List)SerializationUtils.fromJsonString((String)trueactions.toString(), List.class)) != null && !trueList.isEmpty()) {
            this.initEntity(trueList, KEY_TRUE_ENTRY, TRUE_RULE_ID, TRUE_RULE_NAME, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE);
        }
    }

    public void entryRowClick(RowClickEvent e) {
        EntryGrid entryGrid;
        if (e.getSource() != null && KEY_ENTRY_ENTITY.equals((entryGrid = (EntryGrid)e.getSource()).getKey())) {
            this.selRowEvent(e.getRow());
        }
    }

    public void entryRowDoubleClick(RowClickEvent e) {
        if (e.getSource() != null) {
            EntryGrid entryGrid = (EntryGrid)e.getSource();
            if (KEY_ENTRY_ENTITY.equals(entryGrid.getKey())) {
                this.selRowEvent(e.getRow());
            } else if (KEY_TRUE_ENTRY.equals(entryGrid.getKey())) {
                this.ruleUpdate(TRUE_UPDATE, KEY_TRUE_ENTRY, TRUE_RULE_NAME, TRUE_RULE_ID, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE);
            } else if (KEY_FALSE_ENTRY.equals(entryGrid.getKey())) {
                this.ruleUpdate(FALSE_UPDATE, KEY_FALSE_ENTRY, FALSE_RULE_NAME, FALSE_RULE_ID, FALSE_EXPRESSION, FALSE_RAISE_EVENT_TYPE);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab("rule_action");
    }

    @Override
    public Map<String, Object> mergeModel(IDataModel subModel, Map<String, Object> mainEntityContext, Map<String, Object> entityMeta) {
        ArrayList rules;
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        Map<String, Object> saveInfo = this.saveRulesData();
        String oldNodeId = this.getPageCache().get(KEY_CURR_NODE_ID);
        if (StringUtils.isBlank((CharSequence)oldNodeId)) {
            oldNodeId = this.getEntityMetadata().getId();
        }
        String rulesString = this.getPageCache().get(ENTITY_RULES_CACHEID);
        HashMap<String, Object> bizRules = new HashMap<String, Object>(16);
        if (StringUtils.isNotBlank((CharSequence)rulesString)) {
            bizRules.putAll((Map)SerializationUtils.fromJsonString((String)rulesString, Map.class));
        }
        if ((rules = (ArrayList)mainEntityContext.get(KEY_RULES)) == null) {
            rules = new ArrayList(16);
            mainEntityContext.put(KEY_RULES, rules);
        }
        String entityId = (String)mainEntityContext.get("Id");
        this.mergeRule(bizRules, entityId, rules);
        List items = (List)entityMeta.get(KEY_ITEMS);
        if (items != null) {
            for (Map item : items) {
                String simpleName = (String)item.get(KEY_TYPE);
                if (!"EntryEntity".equals(simpleName) && !"SubEntryEntity".equals(simpleName) && !"TreeEntryEntity".equals(simpleName)) continue;
                String id = (String)item.get("Id");
                ArrayList entryRules = (ArrayList)item.get(KEY_RULES);
                if (entryRules == null) {
                    entryRules = new ArrayList(16);
                    item.put(KEY_RULES, entryRules);
                }
                this.mergeRule(bizRules, id, entryRules);
            }
        }
        if (!((Boolean)saveInfo.get(KEY_SUCCESS)).booleanValue()) {
            StringBuilder sb = new StringBuilder();
            sb.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\uff1a", (String)"BusinessRulesPlugin_11", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            sb.append((String)saveInfo.get("errors"));
            result.put("errors", sb.toString());
        }
        return result;
    }

    private void mergeRule(Map<String, Object> bizRules, String id, List rules) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        for (Map.Entry<String, Object> entry : bizRules.entrySet()) {
            if (!entry.getKey().equals(id)) continue;
            rules.clear();
            rules.addAll((List)entry.getValue());
            break;
        }
    }

    @Override
    public boolean entityMetadataChanged() {
        super.entityMetadataChanged();
        this.loadRules(true);
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        this.getPageCache().put(KEY_CURR_NODE_ID, entityId);
        this.getView().updateView(KEY_TREE_VIEW);
        return true;
    }

    @Override
    protected void fireRefreshTabEvent(DesignerTabRefreshEvent e) {
        super.fireRefreshTabEvent(e);
    }

    @Override
    protected void fireTabReloadEvent(DesignerTabReLoadEvent e) {
        super.fireTabReloadEvent(e);
    }

    @Override
    protected void fireMergeTabDataEvent(MergeDesignerTabDataEvent e) {
        StringBuilder errBuild = new StringBuilder();
        List<Map<String, Object>> propActions = this.buildSetPropActionDatas(errBuild);
        if (errBuild.length() > 0) {
            e.setCancel(true, errBuild.toString());
            return;
        }
        this.mergeFormMeta(e.getProDesignerContent(), propActions);
    }

    @Override
    protected void fireSwitchTabEvent(SwitchDesignerTabEvent e) {
        StringBuilder errBuild = new StringBuilder();
        List<Map<String, Object>> propActions = this.buildSetPropActionDatas(errBuild);
        if (errBuild.length() > 0) {
            e.setCancel(true, errBuild.toString());
        } else {
            e.addSetPropActionData(propActions);
        }
    }

    private List<Map<String, Object>> buildSetPropActionDatas(StringBuilder errBuild) {
        HashMap<String, Object> mainEntityContext = new HashMap<String, Object>(10);
        ArrayList<Map<String, Object>> paras = new ArrayList<Map<String, Object>>(10);
        Map<String, Object> result = this.mergeModel(this.getModel(), mainEntityContext, new HashMap<String, Object>(3));
        if (result.get("errors") != null) {
            errBuild.append(result.get("errors"));
            return paras;
        }
        String itemId = this.getEntityMetadata().getRootEntity().getId();
        HashMap<String, String> rule = new HashMap<String, String>(5);
        rule.put("itemId", itemId);
        rule.put(META_TYPE, KEY_ENTITY_META);
        rule.put("propertyName", KEY_RULES);
        rule.put(VALUE, (String)mainEntityContext.get(KEY_RULES));
        rule.put("designerMetaTypeId", "formmeta");
        paras.add(rule);
        return paras;
    }
}

