/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.entity.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.newdevportal.entity.bo.FieldBo;
import kd.bos.newdevportal.entity.helper.IFieldHandler;
import kd.bos.newdevportal.entity.helper.impl.AbstractBasedataFieldHelper;
import kd.bos.newdevportal.entity.helper.impl.AdminDivisionFieldHelper;
import kd.bos.newdevportal.entity.helper.impl.CheckboxFieldHelper;
import kd.bos.newdevportal.entity.helper.impl.DateRangeFieldHelper;
import kd.bos.newdevportal.entity.helper.impl.DateTimeFieldHelper;
import kd.bos.newdevportal.entity.helper.impl.DecimalFieldHelper;
import kd.bos.newdevportal.entity.helper.impl.EmailFieldHelper;
import kd.bos.newdevportal.entity.helper.impl.TelephoneFieldHelper;
import kd.bos.newdevportal.entity.helper.impl.TextFieldHelper;
import kd.bos.newdevportal.entity.helper.impl.TimeFieldHelper;
import kd.bos.newdevportal.entity.helper.impl.TimeRangeFieldHelper;

public class FieldHelper {
    private static List<IFieldHandler> handlers = new ArrayList<IFieldHandler>();

    public static void handle(Field<?> field, List<FieldBo> results) {
        for (IFieldHandler handler : handlers) {
            if (!handler.support(field)) continue;
            handler.handle(field, results);
        }
    }

    static {
        handlers.add(new AbstractBasedataFieldHelper());
        handlers.add(new AdminDivisionFieldHelper());
        handlers.add(new CheckboxFieldHelper());
        handlers.add(new DateRangeFieldHelper());
        handlers.add(new DateTimeFieldHelper());
        handlers.add(new DecimalFieldHelper());
        handlers.add(new EmailFieldHelper());
        handlers.add(new TelephoneFieldHelper());
        handlers.add(new TextFieldHelper());
        handlers.add(new TimeFieldHelper());
        handlers.add(new TimeRangeFieldHelper());
    }
}

