/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.entity.widget;

import java.util.List;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.rule.BizRule;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.newdevportal.entity.BizRuleDetailPlugIn;

public class EntityDetailBizRuleHolder {
    public static final String ENTRY_RULE = "entry_rule";
    private static final String RULE_NAME = "rule_name";
    private static final String RULE_DESC = "rule_desc";
    private static final String RULE_ENABLE = "rule_enable";
    private IFormView view;
    private IDataModel model;

    public EntityDetailBizRuleHolder(IFormView view, IDataModel model) {
        this.view = view;
        this.model = model;
    }

    public void assemble(FormMetadata formMeta, EntityMetadata entityMeta) {
        MainEntity mainEntity = entityMeta.getRootEntity();
        List rules = mainEntity.getRules();
        if (rules.isEmpty()) {
            return;
        }
        this.model.batchCreateNewEntryRow(ENTRY_RULE, rules.size());
        for (int i = 0; i < rules.size(); ++i) {
            BizRule rule = (BizRule)rules.get(i);
            this.model.setValue(RULE_NAME, (Object)rule.getDescription(), i);
            this.model.setValue(RULE_DESC, (Object)rule.getPreDescription(), i);
            this.model.setValue(RULE_ENABLE, (Object)rule.isEnabled(), i);
        }
    }

    public void entryRowClick(int row, String formNumber, EntityMetadata entityMeta) {
        MainEntity mainEntity = entityMeta.getRootEntity();
        List rules = mainEntity.getRules();
        if (rules.isEmpty()) {
            return;
        }
        BizRule rule = (BizRule)rules.get(row);
        FormShowParameter showParameter = BizRuleDetailPlugIn.show(formNumber, rule.getPreCondition(), rule.getDescription().getLocaleValue());
        this.view.showForm(showParameter);
    }
}

