/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.entity.widget;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.newdevportal.entity.bo.FieldBo;
import kd.bos.newdevportal.entity.helper.FieldHelper;

public class EntityDetailFieldHolder {
    private static final String ENTRY_FIELD = "entry_field";
    private static final String FIELD_NAME = "field_name";
    private static final String FIELD_TYPE = "field_type";
    private static final String FIELD_LENGTH = "field_length";
    private static final String FIELD_MUST = "field_must";
    private static final String FIELD_DEFAULT = "field_default";
    public static final String TABLE_LIST = "table_list";
    private IDataModel model;

    public EntityDetailFieldHolder(IFormView view, IDataModel model) {
        this.model = model;
    }

    public void assemble(FormMetadata formMeta, EntityMetadata entityMeta) {
        List entities = entityMeta.getEntitys();
        if (null == entities || entities.isEmpty()) {
            return;
        }
        ArrayList<Tuple> tables = new ArrayList<Tuple>();
        for (Entity e : entities) {
            if (!StringUtils.isNotBlank((CharSequence)e.getTableName())) continue;
            tables.add(new Tuple((Object)e.getId(), (Object)e.getTableName()));
        }
        if (null == tables || tables.isEmpty()) {
            return;
        }
        this.model.deleteEntryData(TABLE_LIST);
        this.model.batchCreateNewEntryRow(TABLE_LIST, tables.size());
        DynamicObjectCollection list = this.model.getEntryEntity(TABLE_LIST);
        for (int i = 0; i < tables.size(); ++i) {
            Tuple tuple = (Tuple)tables.get(i);
            DynamicObject target = (DynamicObject)list.get(i);
            target.set("id_table", tuple.item1);
            target.set("table_name", tuple.item2);
        }
        Tuple firstTable = (Tuple)tables.get(0);
        this.assembleTable((String)firstTable.item1, entityMeta);
    }

    private void assembleTable(String id, EntityMetadata entityMeta) {
        List entities = entityMeta.getEntitys();
        Entity entity = entities.stream().filter(e -> id.equals(e.getId())).findFirst().orElse(null);
        if (null == entity) {
            return;
        }
        List items = entity.getItems();
        List fields = items.stream().filter(o -> o instanceof Field && kd.bos.util.StringUtils.isNotEmpty((String)((Field)o).getFieldName())).map(o -> (Field)o).collect(Collectors.toList());
        LinkedList<FieldBo> results = new LinkedList<FieldBo>();
        for (Field field : fields) {
            FieldHelper.handle(field, results);
        }
        if (results.isEmpty()) {
            return;
        }
        this.model.deleteEntryData(ENTRY_FIELD);
        this.model.batchCreateNewEntryRow(ENTRY_FIELD, results.size());
        for (int i = 0; i < results.size(); ++i) {
            FieldBo bo = (FieldBo)results.get(i);
            this.model.setValue(FIELD_NAME, (Object)bo.getName(), i);
            this.model.setValue(FIELD_TYPE, (Object)bo.getType(), i);
            this.model.setValue(FIELD_LENGTH, (Object)bo.getLength(), i);
            this.model.setValue(FIELD_MUST, (Object)bo.isMust(), i);
            this.model.setValue(FIELD_DEFAULT, (Object)bo.getDefaultValue(), i);
        }
    }

    public void entryRowClick(int row, EntityMetadata entityMeta) {
        String id = (String)this.model.getValue("id_table", row);
        this.assembleTable(id, entityMeta);
    }
}

