/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.entity.widget;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.FormDesigner;
import kd.bos.isv.ISVService;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.util.StringUtils;

public class EntityDetailPropertiesHolder {
    private static final String ENTRY_PROPERTY = "entry_property";
    private static final String PROPERTY_NO = "property_no";
    private static final String PROPERTY_NAME = "property_name";
    private static final String PROPERTY_TYPE = "property_type";
    private static final String PROPERTY_FIELD = "property_field";
    private static final String FORM_DESINGER = "form_designer";
    private IFormView view;
    private IDataModel model;

    public EntityDetailPropertiesHolder(IFormView view, IDataModel model) {
        this.view = view;
        this.model = model;
    }

    public void afterBindData(String bizAppId, String formId) {
        FormDesigner designer = (FormDesigner)this.view.getControl(FORM_DESINGER);
        String lang = RequestContext.get().getLang().toString();
        Map designerMetadata = MetadataDao.loadDesignerMetadata((String)formId, (String)lang);
        String modelType = (String)designerMetadata.get("modelType");
        designerMetadata.put("subSystem", 1);
        designerMetadata.put("isv", ISVService.getISVInfo().getId());
        designerMetadata.put("bizappid", bizAppId);
        designerMetadata.put("isEntityEditor", true);
        designerMetadata.put("designerType", "entityDesigner");
        designer.open(modelType, designerMetadata);
    }

    public void assemble(FormMetadata formMeta, EntityMetadata entityMeta) {
        String modelType = formMeta.getModelType();
        DomainModelType type = DomainModelType.getDomainModelType((String)modelType, (boolean)false);
        Map elementTypeMap = type.getElementTypes();
        HashMap typeNameMap = new HashMap();
        elementTypeMap.forEach((k, v) -> {
            String canonicalName = StringUtils.trim((String)v.getPackageName()) + "." + StringUtils.trim((String)v.getId());
            typeNameMap.put(canonicalName, v.getName());
        });
        List items = entityMeta.getItems();
        List fields = items.stream().filter(o -> o instanceof Field).map(o -> (Field)o).collect(Collectors.toList());
        if (fields.isEmpty()) {
            return;
        }
        this.model.batchCreateNewEntryRow(ENTRY_PROPERTY, fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            Field field = (Field)fields.get(i);
            LocaleString typeName = (LocaleString)typeNameMap.get(field.getClass().getCanonicalName());
            typeName = typeName == null ? new LocaleString("") : typeName;
            this.model.setValue(PROPERTY_NO, (Object)field.getKey(), i);
            this.model.setValue(PROPERTY_NAME, (Object)field.getName(), i);
            this.model.setValue(PROPERTY_TYPE, (Object)typeName, i);
            this.model.setValue(PROPERTY_FIELD, (Object)field.getFieldName(), i);
        }
    }
}

