/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.fields;

import java.util.EventObject;
import java.util.Locale;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.isv.ISVService;
import kd.bos.newdevportal.fields.XmlSerializerUtil;

public class FieldsEditPlugin
extends AbstractBasePlugIn {
    private static final String KEY_ISV = "isv";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String isv = ISVService.getISVInfo().getId();
        this.getModel().setValue(KEY_ISV, (Object)isv);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("save".equals(operate.getOperateKey())) {
            IFormView view = this.getPropertyView();
            if (view != null) {
                DynamicObject data = view.getModel().getDataEntity(true);
                String fieldType = (String)this.getModel().getValue("fieldtype");
                this.getModel().setValue("xml_tag", (Object)XmlSerializerUtil.toXml(fieldType, data));
            } else {
                this.getModel().setValue("xml_tag", (Object)"");
            }
        }
    }

    private IFormView getPropertyView() {
        String propertyViewPageId = this.getPropertyViewPageId();
        if (null == propertyViewPageId) {
            return null;
        }
        IFormView view = this.getView().getView(propertyViewPageId);
        return view;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("number".equals(propertyName)) {
            String number = (String)e.getChangeSet()[0].getNewValue();
            String isv = ISVService.getISVInfo().getId();
            number = DevportalUtil.autoIsvNumber((String)number, (String)isv);
            this.getModel().beginInit();
            this.getModel().setValue("number", (Object)number);
            this.getModel().endInit();
            this.setFieldName(number, isv);
        }
        if ("fieldtype".equalsIgnoreCase(propertyName)) {
            this.showPropForm((String)e.getChangeSet()[0].getNewValue(), "");
        }
    }

    private void setFieldName(String number, String isv) {
        IFormView view = this.getPropertyView();
        if (view == null) {
            return;
        }
        String fieldName = (String)view.getModel().getValue("fieldname");
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            fieldName = "f";
            if (!"kingdee".equalsIgnoreCase(isv) && StringUtils.isNotBlank((CharSequence)isv)) {
                fieldName = fieldName + "k_";
                if (!number.startsWith(isv.toLowerCase(Locale.ENGLISH) + "_")) {
                    fieldName = fieldName + isv + "_";
                }
            }
            fieldName = fieldName + number;
            view.getModel().setValue("fieldname", (Object)fieldName);
            view.updateView("fieldname");
            this.getView().sendFormAction(view);
        }
    }

    private void showPropForm(String fieldType, String initXml) {
        IFormView view;
        String formId = "";
        switch (fieldType) {
            case "TextProp": 
            case "TextAreaProp": 
            case "MuliLangTextProp": {
                formId = "bos_devpn_proptext";
                break;
            }
            case "LargeTextProp": 
            case "DateProp": 
            case "DateTimeProp": 
            case "TimeProp": {
                formId = "bos_devpn_proplargetext";
                break;
            }
            case "BooleanProp": {
                formId = "bos_devpn_propcheckbox";
                break;
            }
            case "ComboProp": {
                formId = "bos_devpn_propcombo";
                break;
            }
            case "MulComboProp": {
                formId = "bos_devpn_propmulcombo";
                break;
            }
            case "IntegerProp": 
            case "BigIntProp": {
                formId = "bos_devpn_propinteger";
                break;
            }
            case "DecimalProp": {
                formId = "bos_devpn_propdecimal";
            }
        }
        String newPageId = "prop_" + formId + this.getView().getPageId();
        String pageId = this.getPropertyViewPageId();
        if (newPageId.equals(pageId)) {
            return;
        }
        if (pageId != null && (view = this.getView().getView(pageId)) != null) {
            view.close();
            this.getView().sendFormAction(view);
        }
        if ("".equals(formId)) {
            this.getPageCache().put("propviewpageid", null);
            return;
        }
        this.getPageCache().put("propviewpageid", newPageId);
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(formId);
        fsp.setPageId(newPageId);
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        fsp.getOpenStyle().setTargetKey("techpanel");
        if (!"".equals(initXml)) {
            fsp.setCustomParam("initxml", (Object)initXml);
        }
        fsp.setCustomParam("number", this.getModel().getValue("number"));
        BillOperationStatus curOptStatus = BillOperationStatus.ADDNEW;
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
            curOptStatus = BillOperationStatus.VIEW;
        } else {
            String value = (String)this.getModel().getValue("status");
            if ("A".equals(value)) {
                boolean bFromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
                curOptStatus = bFromDb ? BillOperationStatus.EDIT : BillOperationStatus.ADDNEW;
            } else if ("B".equals(value)) {
                curOptStatus = BillOperationStatus.SUBMIT;
            } else if ("C".equals(value)) {
                curOptStatus = BillOperationStatus.AUDIT;
            }
        }
        fsp.setCustomParam("billstatus", (Object)curOptStatus.getValue());
        this.getView().showForm(fsp);
    }

    private String getPropertyViewPageId() {
        String pageId = this.getPageCache().get("propviewpageid");
        return pageId;
    }

    public void afterLoadData(EventObject e) {
        this.getModel().setValue("mapcount", (Object)this.getModel().getEntryRowCount("entryentity"));
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String fieldType = (String)this.getModel().getValue("fieldtype");
        String xml = (String)this.getModel().getValue("xml_tag");
        if (StringUtils.isNotBlank((CharSequence)fieldType)) {
            this.showPropForm(fieldType, xml);
        }
    }
}

