/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.fields;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.newdevportal.fields.XmlSerializerUtil;

public class FieldsPropertyEditPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit ctl = (TextEdit)this.getControl("items");
        if (ctl != null) {
            ctl.addClickListener((ClickListener)this);
        }
    }

    public void createNewData(BizDataEventArgs e) {
        DynamicObject o;
        super.createNewData(e);
        String xml = (String)this.getView().getFormShowParameter().getCustomParam("initxml");
        if (!StringUtils.isBlank((CharSequence)xml) && (o = XmlSerializerUtil.toDynamicObject((DynamicObjectType)this.getModel().getDataEntityType(), xml)) != null) {
            e.setDataEntity((Object)o);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.removeAction("setFormStatus");
        clientViewProxy.addAction("setFormStatus", this.getView().getFormShowParameter().getCustomParam("billstatus"));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        if ("items".equals(ctl.getKey())) {
            this.showComboItemsEdit();
        }
    }

    private void showComboItemsEdit() {
        FormShowParameter fsp = new FormShowParameter();
        String value = (String)this.getModel().getValue("items");
        if (StringUtils.isNotBlank((CharSequence)value)) {
            Object o = SerializationUtils.fromJsonString((String)value, Object.class);
            fsp.setCustomParam("value", o);
        }
        ArrayList list = new ArrayList(16);
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("Id", "33BZQFLLQ817");
        list.add(map);
        fsp.setCustomParam("itemId", (Object)"");
        fsp.setCustomParam("context", list);
        fsp.setFormId("ide_comboitemsedit");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "items"));
        this.getView().showForm(fsp);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String fieldName = (String)this.getModel().getValue("fieldname");
        String number = (String)this.getView().getFormShowParameter().getCustomParam("number");
        if (StringUtils.isBlank((CharSequence)fieldName) && StringUtils.isNotBlank((CharSequence)number)) {
            String isv = ISVService.getISVInfo().getId();
            fieldName = "f";
            if (!"kingdee".equalsIgnoreCase(isv) && StringUtils.isNotBlank((CharSequence)isv)) {
                fieldName = fieldName + "k_";
                if (!number.startsWith(isv.toLowerCase(Locale.ENGLISH) + "_")) {
                    fieldName = fieldName + isv + "_";
                }
            }
            fieldName = fieldName + number;
            this.getModel().setValue("fieldname", (Object)fieldName);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map returnData;
        Object value;
        super.closedCallBack(evt);
        if ("items".equals(evt.getActionId()) && evt.getReturnData() != null && (value = (returnData = (Map)evt.getReturnData()).get("value")) != null) {
            this.getModel().setValue("items", (Object)SerializationUtils.toJsonString(value));
        }
    }
}

