/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.fields;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.newdevportal.fields.XmlSerializerUtil;

public class FieldsSaveValidator
extends AbstractValidator {
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String[] NUMBERS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static final String regex = "[a-z0-9A-Z_]+";
    private static final String SCOPE_REGEX = "^[\\[\\(](-?\\d+),(-?\\d+)[\\]\\)]$";

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            String number = dataEntity.getBillNo();
            if (!Pattern.matches(regex, number)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"FieldsSaveValidator_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), ErrorLevel.Error);
            } else if (this.startWithNumber(number)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4ee5[0-9]\u6570\u5b57\u5f00\u5934\u3002", (String)"FieldsSaveValidator_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), ErrorLevel.Error);
            }
            String xml = dataEntity.getDataEntity().getString("xml_tag");
            if (StringUtils.isBlank((CharSequence)xml)) {
                return;
            }
            this.validate_prop(dataEntity, xml);
        }
    }

    private void validate_prop(ExtendedDataEntity dataEntity, String xml) {
        String fieldType;
        DynamicObject propData = XmlSerializerUtil.toDynamicObject(xml, "fieldname", "minlength", "maxlength", "items", "datascope", "scale", "precision");
        String fieldName = propData.getString("fieldname");
        if (!Pattern.matches(regex, fieldName)) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u5e93\u5b57\u6bb5\u540d\u79f0\u5fc5\u987b\u4ee5f\u5f00\u5934\u4e14\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"FieldsSaveValidator_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), ErrorLevel.Error);
        } else {
            if (this.startWithNumber(fieldName)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u5e93\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4ee5[0-9]\u6570\u5b57\u5f00\u5934\u3002", (String)"FieldsSaveValidator_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), ErrorLevel.Error);
            }
            if (!fieldName.toLowerCase(Locale.ENGLISH).startsWith("f")) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\u6570\u636e\u5e93\u5b57\u6bb5\u540d\u79f0\u5fc5\u987b\u4ee5f\u5f00\u5934\u4e14\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"FieldsSaveValidator_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), ErrorLevel.Warning);
            }
        }
        int maxlength = propData.getInt("maxlength");
        int minlength = propData.getInt("minlength");
        if (maxlength < minlength) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\"\u6700\u5927\u957f\u5ea6\"\u4e0d\u80fd\u5c0f\u4e8e\"\u6700\u5c0f\u957f\u5ea6\"\u3002", (String)"FieldsSaveValidator_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), ErrorLevel.Error);
        }
        if ((fieldType = dataEntity.getDataEntity().getString("fieldtype")).equals("ComboProp") || fieldType.equals("MulComboProp")) {
            this.validateCombo(dataEntity, propData);
        }
        if (fieldType.equals("BigIntProp") || fieldType.equals("IntegerProp")) {
            this.validateInteger(dataEntity, propData, fieldType);
        }
        if (fieldType.equals("DecimalProp")) {
            this.validateDecimal(dataEntity, propData);
        }
    }

    private void validateDecimal(ExtendedDataEntity dataEntity, DynamicObject data) {
        int precision;
        int scale = data.getInt("scale");
        if (scale >= (precision = data.getInt("precision"))) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5c0f\u6570\u7cbe\u5ea6\u5e94\u5c0f\u4e8e\u6574\u4f53\u7cbe\u5ea6\u3002", (String)"FieldsSaveValidator_10", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), ErrorLevel.Error);
        }
    }

    private void validateInteger(ExtendedDataEntity dataEntity, DynamicObject data, String fieldType) {
        String dataScope = data.getString("datascope");
        if (!StringUtils.isBlank((CharSequence)dataScope)) {
            dataScope = dataScope.trim();
            Pattern pattern = Pattern.compile(SCOPE_REGEX);
            Matcher matcher = pattern.matcher(dataScope);
            if (!matcher.find()) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u503c\u8303\u56f4\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"FieldsSaveValidator_7", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), ErrorLevel.Error);
            } else {
                BigDecimal min = new BigDecimal(matcher.group(1));
                if (dataScope.startsWith("(")) {
                    min = min.add(BigDecimal.ONE);
                }
                BigDecimal max = new BigDecimal(matcher.group(2));
                if (dataScope.endsWith(")")) {
                    max = max.subtract(BigDecimal.ONE);
                }
                if (min.compareTo(max) > 0) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u6570\u503c\u8303\u56f4\u201d\u6700\u5c0f\u503c\u5e94\u5c0f\u4e8e\u6700\u5927\u503c\u3002", (String)"FieldsSaveValidator_8", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), ErrorLevel.Error);
                } else if (this.validateScope(dataEntity, min, fieldType)) {
                    this.validateScope(dataEntity, max, fieldType);
                }
            }
        }
    }

    private boolean validateScope(ExtendedDataEntity dataEntity, BigDecimal curVal, String fieldType) {
        boolean valid;
        BigDecimal max;
        BigDecimal min;
        DecimalFormat df = new DecimalFormat("#");
        if (fieldType.equals("BigIntProp")) {
            min = new BigDecimal(Long.MIN_VALUE);
            max = new BigDecimal(Long.MAX_VALUE);
        } else {
            min = new BigDecimal(Integer.MIN_VALUE);
            max = new BigDecimal(Integer.MAX_VALUE);
        }
        boolean bl = valid = min.compareTo(curVal) < 0 && max.compareTo(curVal) > 0;
        if (!valid) {
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6570\u503c\u8303\u56f4\u5fc5\u987b\u4f4d\u4e8e%1$s ~ %2$s\u4e4b\u95f4\u3002", (String)"FieldsSaveValidator_9", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), df.format(min), df.format(max)), ErrorLevel.Error);
            return false;
        }
        return true;
    }

    private void validateCombo(ExtendedDataEntity dataEntity, DynamicObject data) {
        if (StringUtils.isBlank((Object)data.get("items")) || "[]".equals(data.getString("items"))) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u4e0b\u62c9\u9879\u3002", (String)"FieldsSaveValidator_6", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), ErrorLevel.Error);
        }
    }

    private boolean startWithNumber(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        return StringUtils.startsWithAny((CharSequence)str.trim(), (CharSequence[])NUMBERS);
    }
}

