/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.fields;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.F7SelectedList;
import kd.bos.newdevportal.fields.FieldsUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class FieldsSelectF7Plugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeQueryListener {
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String PREFIX_APP = "app_";
    private static final String PREFIX_CLOUD = "cloud_";
    private Set<String> existFields = new HashSet<String>(16);

    public void registerListener(EventObject e) {
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        final EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        final F7SelectedList f7selectedlistap = (F7SelectedList)this.getControl("f7selectedlistap");
        f7selectedlistap.addF7SelectedListRemoveAllListener(evt -> {
            grid.selectRows(new int[0], -1);
            this.clearSelectCache();
        });
        f7selectedlistap.addF7SelectedListRemoveListener(evt -> {
            int rowCount;
            int[] selectRows = grid.getSelectRows();
            String key = (String)evt.getParam();
            String[] values = key.split("\\|");
            int removeRowIndex = Integer.parseInt(values[0]);
            if (removeRowIndex < (rowCount = this.getModel().getEntryRowCount("entryentity"))) {
                String entityId = (String)this.getModel().getValue("entity_id", removeRowIndex);
                String fieldnumber = (String)this.getModel().getValue("fieldnumber", removeRowIndex);
                if (values[2].equals(entityId) && values[1].equals(fieldnumber)) {
                    for (int i = 0; i < selectRows.length; ++i) {
                        if (selectRows[i] != removeRowIndex) continue;
                        selectRows[i] = selectRows[selectRows.length - 1];
                        grid.selectRows(Arrays.copyOf(selectRows, selectRows.length - 1), -1);
                        break;
                    }
                }
            }
            this.removeSelectCache((String)evt.getParam());
        });
        grid.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                IDataModel model = FieldsSelectF7Plugin.this.getModel();
                int[] selectRows = grid.getSelectRows();
                List<ValueTextItem> list = new ArrayList(16);
                for (int selectRow : selectRows) {
                    String key = selectRow + "|" + model.getValue("fieldnumber", selectRow) + "|" + model.getValue("entity_id", selectRow);
                    list.add(new ValueTextItem(key, model.getValue("fieldnumber", selectRow) + " " + model.getValue("fieldname", selectRow)));
                }
                list = FieldsSelectF7Plugin.this.addSelectCache(list);
                f7selectedlistap.addItems(list);
            }
        });
        this.addClickListeners(new String[]{"btnok"});
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(evt -> {
            if (StringUtils.isBlank((CharSequence)evt.getText())) {
                String focusNodeId = treeView.getTreeState().getFocusNodeId();
                if (StringUtils.isNotBlank((CharSequence)focusNodeId)) {
                    this.refreshGrid(focusNodeId, "");
                }
            } else {
                String bizcloud = (String)this.getModel().getValue("bizcloud");
                if (StringUtils.isBlank((CharSequence)bizcloud)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u4e91\u3002", (String)"FieldsSelectF7Plugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                this.refreshGrid(PREFIX_CLOUD + bizcloud, evt.getText());
            }
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ComboEdit bizcloudList = (ComboEdit)this.getControl("bizcloud");
        TreeNode cloudNode = this.getRuntimeSubsysTree(null, null, null, "cloud");
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(10);
        for (TreeNode child : cloudNode.getChildren()) {
            itemList.add(new ComboItem(new LocaleString(child.getText()), child.getId()));
        }
        bizcloudList.setComboItems(itemList);
        if (!itemList.isEmpty()) {
            this.getModel().setValue("bizcloud", (Object)((ComboItem)itemList.get(0)).getValue());
            this.getView().updateView("bizcloud");
            this.initTree();
        }
    }

    private void clearSelectCache() {
        String key = F7SelectedList.class.getName() + "_selected";
        this.getPageCache().remove(key);
    }

    private void removeSelectCache(String row) {
        List<ValueTextItem> list = this.getSelectCache();
        list.removeIf(o -> o.getValue().equals(row));
        this.clearSelectCache();
        if (!list.isEmpty()) {
            this.addSelectCache(list);
        }
    }

    private List<ValueTextItem> addSelectCache(List<ValueTextItem> list) {
        String key = F7SelectedList.class.getName() + "_selected";
        List<ValueTextItem> listCache = this.getSelectCache();
        HashSet set = new HashSet(listCache.size());
        listCache.forEach(o -> set.add(o.getValue()));
        for (ValueTextItem valueTextItem : list) {
            if (set.contains(valueTextItem.getValue())) continue;
            listCache.add(valueTextItem);
        }
        this.getPageCache().put(key, SerializationUtils.toJsonString(listCache));
        return listCache;
    }

    private List<ValueTextItem> getSelectCache() {
        String key = F7SelectedList.class.getName() + "_selected";
        String cache = this.getPageCache().get(key);
        ArrayList<ValueTextItem> list = new ArrayList<ValueTextItem>();
        if (StringUtils.isNotBlank((CharSequence)cache)) {
            List listCache = (List)SerializationUtils.fromJsonString((String)cache, List.class);
            for (Object o : listCache) {
                Map map = (Map)o;
                list.add(new ValueTextItem((String)map.get("value"), (String)map.get("text")));
            }
        }
        return list;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        this.refreshGrid(nodeId, "");
    }

    private void refreshGrid(String nodeId, String searchText) {
        List<FieldModel> fieldsList;
        int i;
        String[] entityNumber;
        this.getModel().deleteEntryData("entryentity");
        if (nodeId.startsWith(PREFIX_APP) || nodeId.startsWith(PREFIX_CLOUD)) {
            List<EntityModel> entityList = this.getEntityList(nodeId);
            if (entityList.isEmpty()) {
                return;
            }
            entityNumber = new String[entityList.size()];
            i = 0;
            for (EntityModel entityModel : entityList) {
                entityNumber[i] = entityModel.number;
                ++i;
            }
        } else {
            entityNumber = new String[]{nodeId};
        }
        if ((fieldsList = this.getFieldsList(entityNumber, searchText)).isEmpty()) {
            return;
        }
        this.getModel().beginInit();
        this.getModel().batchCreateNewEntryRow("entryentity", fieldsList.size());
        i = 0;
        for (FieldModel fieldModel : fieldsList) {
            this.getModel().setValue("fieldname", (Object)fieldModel.name, i);
            this.getModel().setValue("fieldnumber", (Object)fieldModel.number, i);
            this.getModel().setItemValueByNumber("entity", fieldModel.entityNumber, i);
            this.getModel().setItemValueByID("bizapp", (Object)fieldModel.bizAppId, i);
            ++i;
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void initTree() {
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        treeView.deleteAllNodes();
        List<TreeNode> cloudNodes = this.getCloudNodes();
        if (!cloudNodes.isEmpty()) {
            TreeNode rootNode = cloudNodes.get(0);
            rootNode.setIsOpened(true);
            rootNode.setParentid("");
            treeView.addNode(rootNode);
            if (rootNode.getChildren() != null && !rootNode.getChildren().isEmpty()) {
                TreeNode firstChild = (TreeNode)rootNode.getChildren().get(0);
                treeView.focusNode(firstChild);
                this.refreshGrid(firstChild.getId(), "");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("bizcloud".equals(e.getProperty().getName())) {
            try {
                this.getView().showLoading(new LocaleString(""));
                this.initTree();
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }

    protected TreeNode getRuntimeSubsysTree(String[] bizCloudIds, String[] bizAppIds, String industryId, String leafType) {
        return (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree((String[])bizCloudIds, (String[])bizAppIds, (String)industryId, (String)leafType);
    }

    private List<TreeNode> getCloudNodes() {
        String bizCloudId = (String)this.getModel().getValue("bizcloud");
        if (StringUtils.isBlank((CharSequence)bizCloudId)) {
            return new ArrayList<TreeNode>(0);
        }
        TreeNode root = this.getRuntimeSubsysTree(new String[]{bizCloudId}, null, null, "app");
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null) {
            return new ArrayList<TreeNode>(0);
        }
        Iterator cloudIterator = clouds.iterator();
        while (cloudIterator.hasNext()) {
            TreeNode cloud = (TreeNode)cloudIterator.next();
            String cloudNodeId = PREFIX_CLOUD + cloud.getId();
            cloud.setId(cloudNodeId);
            cloud.setData((Object)"cloud");
            List apps = cloud.getChildren();
            if (apps == null) {
                cloudIterator.remove();
                continue;
            }
            for (TreeNode app : apps) {
                String appNodeId = PREFIX_APP + app.getId();
                app.setId(appNodeId);
                app.setParentid(cloudNodeId);
                app.setData((Object)"app");
                app.setChildren(new ArrayList(0));
            }
        }
        return clouds;
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        TreeView treeView = (TreeView)evt.getSource();
        String nodeId = (String)evt.getNodeId();
        if (nodeId.startsWith(PREFIX_APP)) {
            List<EntityModel> entityList = this.getEntityList(nodeId);
            ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(entityList.size());
            if (entityList.isEmpty()) {
                TreeNode treeNode = new TreeNode(nodeId, nodeId + ".1", ResManager.loadKDString((String)"\u65e0", (String)"FieldsSelectF7Plugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                treeNode.setChildren(null);
                nodeList.add(treeNode);
            } else {
                entityList.forEach(o -> nodeList.add(new TreeNode(nodeId, o.number, o.name)));
            }
            treeView.addNodes(nodeList);
        }
    }

    private List<Object> loadAppIds(String appId) {
        String sql = "SELECT FID FROM t_meta_bizapp WHERE FMasterId = ? AND FType = ? ";
        Object[] param = new SqlParameter[]{new SqlParameter(":FMasterId", 12, (Object)appId), new SqlParameter(":FType", 12, (Object)"2")};
        ResultSetHandler action = rs -> {
            ArrayList<String> tempIdList = new ArrayList<String>(10);
            while (rs.next()) {
                tempIdList.add(rs.getString("FID"));
            }
            return tempIdList;
        };
        List appIds = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])param, (ResultSetHandler)action);
        appIds.add(appId);
        return appIds;
    }

    private List<Object> loadAppIdsByCloudId(String cloudId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT B.FID FROM t_meta_bizcloud A INNER JOIN t_meta_bizapp B ON A.FID = B.FBIZCLOUDID ", new Object[0]).append(" WHERE  b.FDeployStatus ='2' and b.fvisible = '1' ", new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)cloudId)) {
            sql.append(" and A.FID = ? ", new Object[]{cloudId});
        }
        ResultSetHandler action = rs -> {
            ArrayList<String> tempIdList = new ArrayList<String>(10);
            while (rs.next()) {
                tempIdList.add(rs.getString("FID"));
            }
            return tempIdList;
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sql, (ResultSetHandler)action);
    }

    protected Map<Object, DynamicObject> loadFromCache(String entityName, String selectProperties, QFilter[] filters) {
        return BusinessDataReader.loadFromCache((String)entityName, (String)selectProperties, (QFilter[])filters);
    }

    private List<EntityModel> getEntityList(String nodeId) {
        List<Object> appIds;
        if (nodeId.startsWith(PREFIX_CLOUD)) {
            String cloudId = StringUtils.substringAfter((String)nodeId, (String)"_");
            appIds = this.loadAppIdsByCloudId(cloudId);
        } else if (nodeId.startsWith(PREFIX_APP)) {
            String appId = StringUtils.substringAfter((String)nodeId, (String)"_");
            appIds = this.loadAppIds(appId);
        } else {
            appIds = new ArrayList<Object>(0);
        }
        if (appIds.isEmpty()) {
            return new ArrayList<EntityModel>(0);
        }
        QFilter qFilter = new QFilter("bizappid", "in", appIds);
        QFilter qFilterModelType = new QFilter("modeltype", "in", (Object)new Object[]{"BillFormModel", "BaseFormModel"});
        QFilter[] qFilters = new QFilter[]{qFilter, qFilterModelType};
        Map<Object, DynamicObject> data = this.loadFromCache("bos_entityobject", "number,name,bizappid,dentityid", qFilters);
        ArrayList<EntityModel> list = new ArrayList<EntityModel>(data.size());
        data.forEach((k, v) -> list.add(new EntityModel((DynamicObject)v)));
        return list;
    }

    private void initExistFields(String[] entityNumbers) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select ffieldkey,fentityid from t_meta_fieldsentry", new Object[0]);
        sql.appendIn(" where fentityid ", (Object[])entityNumbers);
        this.existFields.clear();
        DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sql, rs -> {
            while (rs.next()) {
                this.existFields.add(rs.getString("ffieldkey") + "|" + rs.getString("fentityid"));
            }
            return null;
        });
    }

    private boolean filter(IDataEntityProperty property, String searchText, String entityNumber) {
        boolean result;
        boolean bl = result = StringUtils.isBlank((CharSequence)searchText) || property.getName().contains(searchText) || property.getDisplayName().containsValue((Object)searchText);
        if (result) {
            String fieldType = (String)this.getView().getFormShowParameter().getCustomParam("fieldtype");
            result = FieldsUtil.matchFieldType(property, fieldType);
        }
        if (result) {
            result = !this.existFields.contains(property.getName() + "|" + entityNumber);
        }
        return result;
    }

    private List<FieldModel> getFieldsList(String[] entityNumbers, String searchText) {
        this.initExistFields(entityNumbers);
        ArrayList<FieldModel> list = new ArrayList<FieldModel>(16);
        for (String entityNumber : entityNumbers) {
            try {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                Map allFields = dataEntityType.getAllFields();
                allFields.forEach((k, v) -> {
                    if (this.filter((IDataEntityProperty)v, searchText, dataEntityType.getName())) {
                        list.add(new FieldModel((IDataEntityProperty)v, entityNumber));
                    }
                });
            }
            catch (Exception dataEntityType) {
                // empty catch block
            }
        }
        HashMap map = new HashMap();
        list.forEach(o -> {
            List fieldModels = map.computeIfAbsent(o.entityNumber, k -> new ArrayList());
            fieldModels.add(o);
        });
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "in", new ArrayList(map.keySet()))};
        Map<Object, DynamicObject> entityobjects = this.loadFromCache("bos_entityobject", "number,name,bizappid,dentityid", qFilters);
        for (Map.Entry<Object, DynamicObject> entityobject : entityobjects.entrySet()) {
            List listFieldModel = (List)map.get(entityobject.getValue().getString("number"));
            for (FieldModel fieldModel : listFieldModel) {
                fieldModel.bizAppId = entityobject.getValue().getString("bizappid_id");
            }
        }
        return list;
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            List<ValueTextItem> list = this.getSelectCache();
            if (list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"FieldsSelectF7Plugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                return;
            }
            ArrayList result = new ArrayList(16);
            for (ValueTextItem valueTextItem : list) {
                HashMap<String, String> map = new HashMap<String, String>(10);
                String[] keys = valueTextItem.getValue().split("\\|");
                map.put("fieldnumber", keys[1]);
                map.put("entity", keys[2]);
                result.add(map);
            }
            this.getView().returnDataToParent(result);
            this.getView().close();
        }
    }

    private static class FieldModel {
        public String entityNumber;
        public String number;
        public String name;
        public String bizAppId;

        public FieldModel(IDataEntityProperty property, String entityNumber) {
            this.number = property.getName();
            this.name = property.getDisplayName() == null ? "" : property.getDisplayName().toString();
            this.entityNumber = entityNumber;
        }
    }

    private static class EntityModel {
        public String id;
        public String number;
        public String name;

        public EntityModel(DynamicObject data) {
            this.id = data.getString("dentityid");
            this.number = data.getString("number");
            this.name = data.getString("name");
        }
    }
}

