/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.fields;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.LargeTextField;
import kd.bos.metadata.entity.commonfield.MulComboField;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.entity.commonfield.TextAreaField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.entity.commonfield.TimeField;

class XmlSerializerUtil {
    protected static Map<String, Class<?>> fieldTypeMapper = new HashMap();

    XmlSerializerUtil() {
    }

    private static String toXml(List<IDataEntityType> dts, Object entity, Object base) {
        ListDcxmlBinder binder = new ListDcxmlBinder(true, dts);
        DcxmlSerializer ser = new DcxmlSerializer((DcBinder)binder);
        ser.setIndent(true);
        ser.setNewlines(true);
        ser.setIsLocaleValueFull(false);
        return ser.serializeToString(entity, base);
    }

    public static Object toObject(String xml, Object base) {
        ArrayList dts = new ArrayList(16);
        fieldTypeMapper.forEach((k, v) -> {
            dts.add(OrmUtils.getDataEntityType((Class)v));
            dts.add(OrmUtils.getDataEntityType(ComboItem.class));
        });
        ListDcxmlBinder binder = new ListDcxmlBinder(true, dts);
        DcxmlSerializer ser = new DcxmlSerializer((DcBinder)binder);
        return ser.deserializeFromString(xml, base);
    }

    public static DynamicObject toDynamicObject(String xml, String ... propNames) {
        DynamicObjectType type = new DynamicObjectType();
        for (String propName : propNames) {
            type.registerProperty(propName, Object.class, (Object)"", false);
        }
        return XmlSerializerUtil.toDynamicObject(type, xml);
    }

    public static DynamicObject toDynamicObject(DynamicObjectType dataEntityType, String xml) {
        Object field = XmlSerializerUtil.toObject(xml, null);
        DynamicObject data = new DynamicObject(dataEntityType);
        IDataEntityType fieldEntityType = OrmUtils.getDataEntityType(field.getClass());
        HashMap<String, IDataEntityProperty> map = new HashMap<String, IDataEntityProperty>(16);
        for (IDataEntityProperty property : fieldEntityType.getProperties()) {
            map.put(property.getName().toLowerCase(), property);
        }
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>(16);
        dts.add(OrmUtils.getDataEntityType(ComboItem.class));
        for (IDataEntityProperty property : dataEntityType.getProperties()) {
            String name = property.getName();
            IDataEntityProperty fieldProp = (IDataEntityProperty)map.get(name);
            if (fieldProp == null) continue;
            if (fieldProp instanceof ISimpleProperty) {
                property.setValue((Object)data, fieldProp.getValue(field));
                continue;
            }
            property.setValue((Object)data, (Object)XmlSerializerUtil.toJsonList(dts, (List)fieldProp.getValue(field)));
        }
        return data;
    }

    public static String toXml(String fieldType, DynamicObject data) {
        Field<?> field = XmlSerializerUtil.getField(fieldType);
        IDataEntityType dataEntityType = data.getDataEntityType();
        IDataEntityType fieldEntityType = OrmUtils.getDataEntityType(field.getClass());
        HashMap<String, IDataEntityProperty> map = new HashMap<String, IDataEntityProperty>(16);
        for (IDataEntityProperty property : fieldEntityType.getProperties()) {
            map.put(property.getName().toLowerCase(), property);
        }
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(fieldEntityType);
        dts.add(OrmUtils.getDataEntityType(ComboItem.class));
        for (IDataEntityProperty property : dataEntityType.getProperties()) {
            String name = property.getName();
            if ("items".equals(name)) {
                String value = (String)property.getValueFast((Object)data);
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                List<Object> o = XmlSerializerUtil.fromJsonList(dts, value);
                ((IDataEntityProperty)map.get(name)).setValue(field, o);
                continue;
            }
            ((IDataEntityProperty)map.get(name)).setValue(field, property.getValue((Object)data));
        }
        return XmlSerializerUtil.toXml(dts, field, null);
    }

    private static String toJsonList(List<IDataEntityType> dts, List<Object> list) {
        ListDcxmlBinder binder = new ListDcxmlBinder(true, dts);
        ArrayList<Map> listData = new ArrayList<Map>(16);
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        ser.setIsLocaleValueFull(false);
        for (Object o : list) {
            listData.add(ser.serializeToMap(o, null));
        }
        return SerializationUtils.toJsonString(listData);
    }

    private static List<Object> fromJsonList(List<IDataEntityType> dts, String jsonValue) {
        ListDcxmlBinder binder = new ListDcxmlBinder(true, dts);
        JSONArray list = JSON.parseArray((String)jsonValue);
        ArrayList<Object> listData = new ArrayList<Object>(16);
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        ser.setIsLocaleValueFull(false);
        for (Object o : list) {
            listData.add(ser.deserializeFromMap((Map)o, null));
        }
        return listData;
    }

    public static Field<?> getField(String fieldType) {
        Class<?> claz = fieldTypeMapper.get(fieldType);
        try {
            return (Field)claz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        fieldTypeMapper.put("BigIntProp", BigIntField.class);
        fieldTypeMapper.put("BooleanProp", CheckBoxField.class);
        fieldTypeMapper.put("ComboProp", ComboField.class);
        fieldTypeMapper.put("DecimalProp", DecimalField.class);
        fieldTypeMapper.put("DateProp", DateField.class);
        fieldTypeMapper.put("DateTimeProp", DateTimeField.class);
        fieldTypeMapper.put("IntegerProp", IntegerField.class);
        fieldTypeMapper.put("LargeTextProp", LargeTextField.class);
        fieldTypeMapper.put("MuliLangTextProp", MuliLangTextField.class);
        fieldTypeMapper.put("MulComboProp", MulComboField.class);
        fieldTypeMapper.put("TextProp", TextField.class);
        fieldTypeMapper.put("TextAreaProp", TextAreaField.class);
        fieldTypeMapper.put("TimeProp", TimeField.class);
    }
}

