/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.form.designer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.designer.dao.FormTemplateFactory;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.FieldProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.lang.Lang;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.mvc.form.IFormController;
import kd.bos.newdevportal.designer.AbstractFormDesignerTabPlugin;
import kd.bos.newdevportal.designer.DesignerTabCloseEvent;
import kd.bos.newdevportal.designer.DesignerTabReLoadEvent;
import kd.bos.newdevportal.designer.DesignerTabRefreshEvent;
import kd.bos.newdevportal.designer.MergeDesignerTabDataEvent;
import kd.bos.newdevportal.designer.SwitchDesignerTabEvent;
import kd.bos.newdevportal.form.designer.propedit.IFormPropEditor;
import kd.bos.newdevportal.form.designer.propedit.PropEditorFactory;
import kd.bos.newdevportal.form.designer.propedit.event.BeforBindEditorDataEvent;
import kd.bos.newdevportal.form.designer.propedit.event.CreateEditorDateEvent;
import kd.bos.newdevportal.form.designer.propedit.event.GetEditorControlEvent;
import kd.bos.newdevportal.form.designer.propedit.event.GetEditorEntityTypeEvent;
import kd.bos.newdevportal.form.designer.propedit.event.LoadEditorMetaEvent;
import kd.bos.newdevportal.form.designer.propedit.event.RegisterEditorClickListenerEvent;

public class BaseInfoPagePlugin
extends AbstractFormDesignerTabPlugin {
    private static final String ITEM_ID = "itemId";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String VALUE = "value";
    private static final String CACHE_KEY_CURRENTDATA = "currentdata";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private Map<String, Map<String, Object>> elementItemDatas = null;
    private Map<String, ElementType> propElementDict = null;
    private Map<String, String> ctlPropMapping = new HashMap<String, String>(16);
    private boolean switchFailure = false;

    private Map<String, Map<String, Object>> getOriFormItemData(FormShowParameter showParameter) {
        HashMap<String, Map<String, Object>> data = new HashMap<String, Map<String, Object>>();
        IFormTemplate template = FormTemplateFactory.createTemplate((String)this.getFormModelType(showParameter));
        FormMetadata formMetadata = this.getFormMeta(showParameter, this.getMetaViewId(showParameter));
        EntityMetadata entityMetadata = this.getEntityMeta(showParameter);
        template.getBinder().setLCId(this.getEditLang().toString());
        data.put(formMetadata.getRootAp().getClass().getSimpleName(), template.serializeToMap((Object)formMetadata.getRootAp()));
        template = FormTemplateFactory.createTemplate((String)this.getEntityModelType(showParameter));
        data.put(entityMetadata.getRootEntity().getClass().getSimpleName(), template.serializeToMap((Object)entityMetadata.getRootEntity()));
        return data;
    }

    private Map<String, Object> getItemData(FormShowParameter showParameter, String elementId) {
        if (this.getPageCache() != null && StringUtils.isNotBlank((CharSequence)this.getPageCache().get(CACHE_KEY_CURRENTDATA))) {
            this.elementItemDatas = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_KEY_CURRENTDATA), Map.class);
        }
        if (this.elementItemDatas != null) {
            return this.elementItemDatas.get(elementId);
        }
        this.elementItemDatas = this.getOriFormItemData(showParameter);
        return this.elementItemDatas.get(elementId);
    }

    private ElementType getElementByPageProp(FormShowParameter fsp, Property prop) {
        if (this.propElementDict == null) {
            this.propElementDict = new HashMap<String, ElementType>();
            this.getCurrentPageProps(this.getEditElementTypes(fsp), this.propElementDict);
        }
        return this.propElementDict.get(prop.getPropertyName());
    }

    private List<Property> getCurrentPageProps() {
        return this.getCurrentPageProps(this.getElementType(), null);
    }

    private List<Property> getCurrentPageProps(List<ElementType> elementTypes, Map<String, ElementType> propElementDict) {
        LinkedHashMap<String, Property> data = new LinkedHashMap<String, Property>(10);
        for (ElementType elementType : elementTypes) {
            for (Property prop : elementType.getProperties()) {
                if (!StringUtils.equals((CharSequence)"13", (CharSequence)prop.getGroupId()) && !StringUtils.equals((CharSequence)"14", (CharSequence)prop.getGroupId()) || data.containsKey(prop.getPropertyName())) continue;
                data.put(prop.getPropertyName(), prop);
                if (propElementDict == null) continue;
                propElementDict.put(prop.getPropertyName(), elementType);
            }
        }
        return new ArrayList<Property>(data.values());
    }

    private List<ElementType> getElementType(FormShowParameter showParameter) {
        ArrayList<ElementType> data = new ArrayList<ElementType>(2);
        String modelType = this.getFormModelType(showParameter);
        DomainModelType domainModelType = DomainModelType.getDomainModelType((String)modelType);
        String[] elementIds = StringUtils.equals((CharSequence)"DynamicFormModel", (CharSequence)modelType) || StringUtils.equals((CharSequence)"WidgetFormModel", (CharSequence)modelType) ? new String[]{this.getFormMeta(showParameter, this.getMetaViewId(showParameter)).getRootAp().getClass().getSimpleName(), this.getEntityMeta(showParameter).getRootEntity().getClass().getSimpleName()} : new String[]{this.getFormMeta(showParameter, this.getMetaViewId(showParameter)).getRootAp().getClass().getSimpleName()};
        for (String id : elementIds) {
            data.add(domainModelType.getElementType(id));
        }
        return data;
    }

    private List<ElementType> getElementType() {
        return this.getElementType(this.getView().getFormShowParameter());
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        IFormPropEditor editor;
        ElementType srcElement;
        FormShowParameter param = (FormShowParameter)e.getSource();
        if (param.getParentPageId() == null) {
            param.setParentPageId(param.getRootPageId());
        }
        ArrayList<Property> baseProps = new ArrayList<Property>();
        ArrayList<Property> advProps = new ArrayList<Property>();
        List<Property> baseNavBarProps = this.getCurrentPageProps(this.getElementType((FormShowParameter)e.getSource()), null);
        for (Property prop : baseNavBarProps) {
            if (StringUtils.equals((CharSequence)"13", (CharSequence)prop.getGroupId())) {
                baseProps.add(prop);
                continue;
            }
            advProps.add(prop);
        }
        List sortedBaseProps = baseProps.stream().sorted((a, b) -> {
            int aseq = a.getGroupSubSeq();
            int bseq = b.getGroupSubSeq();
            return aseq - bseq;
        }).collect(Collectors.toList());
        List sortedAdvProps = advProps.stream().sorted((a, b) -> {
            int aseq = a.getGroupSubSeq();
            int bseq = b.getGroupSubSeq();
            return aseq - bseq;
        }).collect(Collectors.toList());
        HashMap<String, Object> baseHead = new HashMap<String, Object>();
        HashMap<String, Object> advHead = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> baseFlexItem = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> advFlexItem = new ArrayList<Map<String, Object>>(10);
        baseHead.put("id", "basefieldset");
        baseHead.put("items", baseFlexItem);
        advHead.put("id", "advpropfieldset");
        advHead.put("items", advFlexItem);
        e.getItems().add(baseHead);
        e.getItems().add(advHead);
        LoadEditorMetaEvent metaEvent = new LoadEditorMetaEvent(this, e);
        FormShowParameter fsp = (FormShowParameter)e.getSource();
        for (Property prop : sortedBaseProps) {
            srcElement = this.getElementByPageProp(fsp, prop);
            editor = PropEditorFactory.getPropEditor(this.getView(), srcElement, prop, this.getItemData(fsp, srcElement.getId()), this.getEntityMeta(fsp), this.getFormMeta(fsp, this.getMetaViewId(fsp)));
            editor.fireEditorEvent(metaEvent);
            baseFlexItem.add(metaEvent.getMeta());
        }
        for (Property prop : sortedAdvProps) {
            srcElement = this.getElementByPageProp((FormShowParameter)e.getSource(), prop);
            editor = PropEditorFactory.getPropEditor(this.getView(), srcElement, prop, this.getItemData((FormShowParameter)e.getSource(), srcElement.getId()), this.getEntityMeta((FormShowParameter)e.getSource()), this.getFormMeta(fsp, this.getMetaViewId(fsp)));
            editor.fireEditorEvent(metaEvent);
            advFlexItem.add(metaEvent.getMeta());
        }
    }

    public void initialize() {
        super.initialize();
        this.fillFromShowParameter();
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("DynamicCreateCardEntry", exp.getMessage()), new Object[0]);
        }
        e.setNewEntityType(newMainType);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        for (Property prop : this.getCurrentPageProps()) {
            ElementType srcElement = this.getElementByPageProp(fsp, prop);
            IFormPropEditor editor = PropEditorFactory.getPropEditor(this.getView(), srcElement, prop, this.getItemData(fsp, srcElement.getId()), this.getEntityMeta(fsp), this.getFormMeta(fsp, this.getMetaViewId(fsp)));
            editor.fireEditorEvent(new GetEditorEntityTypeEvent(this, e));
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        for (Property prop : this.getCurrentPageProps()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)e.getKey(), (CharSequence)prop.getPropertyName().toLowerCase())) continue;
            ElementType srcElement = this.getElementByPageProp(fsp, prop);
            IFormPropEditor editor = PropEditorFactory.getPropEditor(this.getView(), srcElement, prop, this.getItemData(fsp, srcElement.getId()), this.getEntityMeta(fsp), this.getFormMeta());
            GetEditorControlEvent controlEvent = new GetEditorControlEvent(this, e);
            editor.fireEditorEvent(controlEvent);
            if (controlEvent.getControl() != null) {
                e.setControl(controlEvent.getControl());
            }
            return;
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormShowParameter show = this.getView().getFormShowParameter();
        for (Property prop : this.getCurrentPageProps()) {
            ElementType srcElement = this.getElementByPageProp(this.getView().getFormShowParameter(), prop);
            IFormPropEditor editor = PropEditorFactory.getPropEditor(this.getView(), srcElement, prop, this.getItemData(this.getView().getFormShowParameter(), srcElement.getId()), this.getEntityMeta(show), this.getFormMeta());
            editor.fireEditorEvent(new RegisterEditorClickListenerEvent(this));
        }
    }

    public void afterCreateNewData(EventObject e) {
        String title;
        FormShowParameter show = this.getView().getFormShowParameter();
        for (Property prop : this.getCurrentPageProps()) {
            ElementType srcElement = this.getElementByPageProp(show, prop);
            IFormPropEditor editor = PropEditorFactory.getPropEditor(this.getView(), srcElement, prop, this.getItemData(show, srcElement.getId()), this.getEntityMeta(show), this.getFormMeta());
            editor.fireEditorEvent(new CreateEditorDateEvent(this));
            this.ctlPropMapping.put(prop.getPropertyName().toLowerCase(), prop.getPropertyName());
        }
        this.getPageCache().put("ctlPropMapping", SerializationUtils.toJsonString(this.ctlPropMapping));
        LocaleString localeTitle = ResManager.getLocaleString((String)"PC\u8868\u5355\u5e03\u5c40", (String)"BaseInfoPagePlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN);
        if ("listmeta".equals(this.getMetaViewId())) {
            localeTitle = ResManager.getLocaleString((String)"PC\u5217\u8868\u5e03\u5c40", (String)"BaseInfoPagePlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN);
        }
        if (StringUtils.isBlank((CharSequence)(title = (String)localeTitle.get((Object)this.getEditLang().toString())))) {
            title = localeTitle.toString();
        }
        this.getModel().setValue("textfield", (Object)title);
        this.getView().getPageCache().put("synchronized", "true");
        this.getPageCache().put("initialized", "true");
        this.cacheCurrentPageData();
    }

    public void beforeBindData(EventObject e) {
        this.getPageCache().remove(CACHE_KEY_CURRENTDATA);
        FormRoot root = (FormRoot)this.getView().getRootControl();
        FormShowParameter show = this.getView().getFormShowParameter();
        BeforBindEditorDataEvent bindEvent = new BeforBindEditorDataEvent(this);
        bindEvent.setContainer((Container)root);
        for (Property prop : this.getCurrentPageProps()) {
            ElementType srcElement = this.getElementByPageProp(show, prop);
            IFormPropEditor editor = PropEditorFactory.getPropEditor(this.getView(), srcElement, prop, this.getItemData(this.getView().getFormShowParameter(), srcElement.getId()), this.getEntityMeta(show), this.getFormMeta());
            editor.fireEditorEvent(bindEvent);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("propertyedit".equals(closedCallBackEvent.getActionId())) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            String propName = null;
            if (returnData instanceof List) {
                List data = (List)returnData;
                if (data.isEmpty()) {
                    return;
                }
                propName = ((Map)data.get(0)).get(PROPERTY_NAME).toString();
            } else if (returnData instanceof Map) {
                propName = ((Map)returnData).get(PROPERTY_NAME).toString();
            }
            if (StringUtils.isBlank(propName)) {
                return;
            }
            FormShowParameter fsp = this.getView().getFormShowParameter();
            for (Property prop : this.getCurrentPageProps()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)propName, (CharSequence)prop.getPropertyName())) continue;
                ElementType srcElement = this.getElementByPageProp(fsp, prop);
                IFormPropEditor editor = PropEditorFactory.getPropEditor(this.getView(), srcElement, prop, this.getItemData(fsp, srcElement.getId()), this.getEntityMeta(fsp), this.getFormMeta());
                editor.fireEditorEvent((EventObject)closedCallBackEvent);
                return;
            }
        }
    }

    public void click(EventObject evt) {
        this.fillFromShowParameter();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        if (evt.getSource() instanceof Control) {
            for (Property prop : this.getCurrentPageProps()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)prop.getPropertyName(), (CharSequence)((Control)evt.getSource()).getKey())) continue;
                ElementType srcElement = this.getElementByPageProp(fsp, prop);
                IFormPropEditor editor = PropEditorFactory.getPropEditor(this.getView(), srcElement, prop, this.getItemData(fsp, srcElement.getId()), this.getEntityMeta(fsp), this.getFormMeta());
                editor.fireEditorEvent(evt);
                return;
            }
        }
    }

    private String getPropNameByCtlKey(String ctlKey) {
        if (this.ctlPropMapping.isEmpty()) {
            String str = this.getPageCache().get("ctlPropMapping");
            this.ctlPropMapping.putAll((Map)SerializationUtils.fromJsonString((String)str, Map.class));
        }
        return this.ctlPropMapping.get(ctlKey);
    }

    public void afterBindData(EventObject e) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"key"});
    }

    private void cacheCurrentPageData() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        List<ElementType> elementTypes = this.getElementType(showParameter);
        Map<String, Map<String, Object>> currentData = this.elementItemDatas == null ? this.getOriFormItemData(showParameter) : this.elementItemDatas;
        for (ElementType elementType : elementTypes) {
            currentData.put(elementType.getId(), new HashMap());
            for (Property prop : elementType.getProperties()) {
                IFormPropEditor editor = PropEditorFactory.getPropEditor(this.getView() == null ? showParameter.createView() : this.getView(), elementType, prop, this.elementItemDatas.get(elementType.getId()), this.getEntityMeta(showParameter), this.getFormMeta(showParameter, this.getMetaViewId(showParameter)));
                Object value = editor.getValue();
                if (!StringUtils.isNotBlank((Object)value)) continue;
                currentData.get(elementType.getId()).put(prop.getPropertyName(), value);
            }
        }
        this.getPageCache().put(CACHE_KEY_CURRENTDATA, SerializationUtils.toJsonString(currentData));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        boolean result;
        this.setSynchronized(false);
        this.cacheCurrentPageData();
        if ("Language".equalsIgnoreCase(e.getProperty().getName()) && !this.switchFailure && !(result = this.switchLang(Lang.valueOf((String)this.getModel().getValue("Language").toString())))) {
            this.switchFailure = true;
            this.getModel().beginInit();
            this.getModel().setValue(e.getProperty().getName(), e.getChangeSet()[0].getOldValue());
            this.getModel().endInit();
            this.getView().updateView(e.getProperty().getName());
        }
    }

    private boolean check(StringBuilder errBuild) {
        if (this.isSynchronized()) {
            return true;
        }
        MainEntityType type = this.getModel().getDataEntityType();
        HashMap<String, FieldProp> props = new HashMap<String, FieldProp>(10);
        HashSet<String> mustInputKeys = new HashSet<String>();
        if ("listmeta".equals(this.getMetaViewId(this.getView().getFormShowParameter()))) {
            mustInputKeys.add("name");
        } else {
            mustInputKeys.add("name");
            mustInputKeys.add("key");
        }
        for (Property p : this.getCurrentPageProps()) {
            IDataEntityProperty prop = type.findProperty(p.getPropertyName().toLowerCase());
            if (!(prop instanceof FieldProp) || !((FieldProp)prop).isMustInput() && !mustInputKeys.contains(prop.getName())) continue;
            mustInputKeys.add(prop.getName());
            props.put(prop.getName(), (FieldProp)prop);
        }
        for (String key : mustInputKeys) {
            Object propValue;
            if (type.findProperty(key) == null || !StringUtils.isBlank((Object)(propValue = this.getModel().getValue(key)))) continue;
            FieldProp property = (FieldProp)props.get(key);
            if (property != null) {
                String name = property.getDisplayName() == null ? "" : property.getDisplayName().getLocaleValue();
                errBuild.append("\u201c").append(name).append("\u201d").append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseInfoPagePlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    private List<Map<String, Object>> getTabPageData() {
        ArrayList<Map<String, Object>> paras = new ArrayList<Map<String, Object>>(10);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        List<ElementType> types = this.getEditElementTypes(this.getView().getFormShowParameter());
        HashMap<String, ElementType> entityElements = new HashMap<String, ElementType>(2);
        for (ElementType type : types) {
            String className = type.getClassName();
            Object elementInstance = TypesContainer.createInstance((String)className);
            if (!EntityItem.class.isAssignableFrom(elementInstance.getClass())) continue;
            entityElements.put(type.getId(), type);
        }
        for (Property prop : this.getCurrentPageProps()) {
            if (this.getModel().getDataEntityType().findProperty(prop.getPropertyName()) == null) continue;
            HashMap<String, Object> data = new HashMap<String, Object>(5);
            data.put(ITEM_ID, this.getItemData(fsp, this.getElementByPageProp(fsp, prop).getId()).get("Id"));
            data.put(META_TYPE, entityElements.get(this.getElementByPageProp(this.getView().getFormShowParameter(), prop).getId()) == null ? "formmeta" : "entitymeta");
            data.put(PROPERTY_NAME, prop.getPropertyName());
            if ("Language".equals(prop.getPropertyName())) {
                data.put(VALUE, this.getEditLang());
            } else {
                data.put(VALUE, this.getModel().getValue(prop.getPropertyName()));
            }
            data.put("designerMetaTypeId", this.getMetaViewId());
            paras.add(data);
        }
        return paras;
    }

    private List<Map<String, Object>> getUnsynchronizedData() {
        if (this.isSynchronized()) {
            return Collections.emptyList();
        }
        return this.getTabPageData();
    }

    private List<ElementType> getEditElementTypes(FormShowParameter showParameter) {
        String modelType = this.getFormModelType(showParameter);
        DomainModelType domainModelType = DomainModelType.getDomainModelType((String)modelType);
        ArrayList<ElementType> types = new ArrayList<ElementType>(2);
        String[] elementIds = StringUtils.equals((CharSequence)"DynamicFormModel", (CharSequence)modelType) || StringUtils.equals((CharSequence)"WidgetFormModel", (CharSequence)modelType) ? new String[]{this.getFormMeta(showParameter, this.getMetaViewId(showParameter)).getRootAp().getClass().getSimpleName(), this.getEntityMeta(showParameter).getRootEntity().getClass().getSimpleName()} : new String[]{this.getFormMeta(showParameter, this.getMetaViewId(showParameter)).getRootAp().getClass().getSimpleName()};
        for (String id : elementIds) {
            types.add(domainModelType.getElementType(id));
        }
        return types;
    }

    @Override
    protected void fireRefreshTabEvent(DesignerTabRefreshEvent e) {
        IFormController formController = (IFormController)this.getView().getService(IFormController.class);
        if (formController == null) {
            return;
        }
        this.getPageCache().put("initialized", "false");
        formController.loadData();
        e.getMainDesignView().sendFormAction(this.getView());
    }

    @Override
    protected void fireTabCloseEvent(DesignerTabCloseEvent e) {
        if (!this.isCurrentMenuType(e.getMetaMenuId())) {
            return;
        }
        StringBuilder errBuils = new StringBuilder();
        if (!this.check(errBuils)) {
            e.setCancel(true, errBuils.toString());
            return;
        }
        if (this.isSynchronized()) {
            return;
        }
        e.addSetPropActionData(this.getUnsynchronizedData());
        this.setSynchronized(true);
        IFormView tabView = this.getView();
        e.getMainDesignView().sendFormAction(tabView);
    }

    @Override
    protected void fireMergeTabDataEvent(MergeDesignerTabDataEvent e) {
        if (!this.isCurrentMenuType(e.getMetaMenuId())) {
            return;
        }
        if (!this.getView().getModel().isDataLoaded()) {
            return;
        }
        StringBuilder errBuils = new StringBuilder();
        if (!this.check(errBuils)) {
            e.setCancel(true, errBuils.toString());
            return;
        }
        this.mergeFormMeta(e.getProDesignerContent(), this.getTabPageData());
        this.afterMergeFormMeta(e.getProDesignerContent());
    }

    @Override
    protected void fireTabReloadEvent(DesignerTabReLoadEvent e) {
    }

    @Override
    protected void fireSwitchTabEvent(SwitchDesignerTabEvent e) {
        if (!this.isCurrentMenuType(e.getMetaMenuId())) {
            return;
        }
        StringBuilder errBuils = new StringBuilder();
        if (!this.check(errBuils)) {
            e.setCancel(true, errBuils.toString());
            return;
        }
        if (this.isSynchronized()) {
            return;
        }
        e.addSetPropActionData(this.getUnsynchronizedData());
        this.setSynchronized(true);
    }

    private boolean isSynchronized() {
        return this.getView() == null || Boolean.parseBoolean(this.getView().getPageCache().get("synchronized")) || !this.getView().getModel().isDataLoaded();
    }

    private void setSynchronized(boolean sign) {
        this.getView().getPageCache().put("synchronized", String.valueOf(sign));
        this.getView().getPageCache().saveChanges();
    }

    private void afterMergeFormMeta(Map<String, Object> allMetaMenuData) {
        String metaMenuId = this.getMetaViewId();
        Map content = (Map)allMetaMenuData.get(metaMenuId);
        if (content == null) {
            return;
        }
        Map formMetaMap = (Map)content.get("formmeta");
        MainEntityType type = this.getModel().getDataEntityType();
        if (type.findProperty("name") != null) {
            formMetaMap.put("Name", this.getModel().getValue("name"));
        }
        if (type.findProperty("key") != null) {
            formMetaMap.put("Key", this.getModel().getValue("Key"));
        }
    }

    @Override
    protected String getTabId() {
        return "baseinfo";
    }

    private void fillFromShowParameter() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            String formId = this.getView().getFormShowParameter().getFormId();
            String subFormShowParameterStr = parentView.getPageCache().get(String.format("%s_%s", formId, "subFormShowParameter"));
            if (StringUtils.isNotBlank((CharSequence)subFormShowParameterStr)) {
                Map subFormShowParameter = (Map)SerializationUtils.fromJsonString((String)subFormShowParameterStr, Map.class);
                this.getView().getFormShowParameter().getCustomParams().putAll(subFormShowParameter);
            }
            String json = parentView.getPageCache().get("proformdesigner.designerbar.page");
            HashMap<String, String> designerBarPage = null;
            designerBarPage = StringUtils.isNotBlank((CharSequence)json) ? (HashMap<String, String>)SerializationUtils.fromJsonString((String)json, Map.class) : new HashMap<String, String>(1);
            String metaMenuId = (String)this.getView().getFormShowParameter().getCustomParam("metaMenuId");
            String pageKey = String.format("baseinfo_%s", metaMenuId);
            designerBarPage.put(pageKey, this.getView().getPageId());
            parentView.getPageCache().put("proformdesigner.designerbar.page", SerializationUtils.toJsonString(designerBarPage));
        }
    }

    private String getBaseInfoFormId(String metaMenutId) {
        if (StringUtils.isBlank((CharSequence)metaMenutId)) {
            metaMenutId = this.getPageCache().get("metaMenuId");
        }
        String formId = "devpn_baseinfo";
        if (StringUtils.isBlank((CharSequence)metaMenutId)) {
            metaMenutId = "formmeta";
        }
        if ("listmeta".equals(metaMenutId)) {
            formId = "devpn_baseinfo_list";
        }
        return formId;
    }

    private boolean isCurrentMenuType(String metaMenueId) {
        if (StringUtils.isBlank((CharSequence)metaMenueId) && this.getView().getParentView() != null) {
            metaMenueId = this.getView().getParentView().getPageCache().get("metaMenuId");
        }
        String formId = this.getBaseInfoFormId(metaMenueId);
        String currentFormId = this.getView().getFormShowParameter().getFormId();
        return currentFormId.equals(formId);
    }

    private boolean isDefaultLayout() {
        String formId = "";
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            formId = parentView.getPageCache().get("id");
        }
        if (StringUtils.isBlank((CharSequence)formId)) {
            formId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        }
        if (StringUtils.isBlank((CharSequence)formId)) {
            return false;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,fentityid,fmodeltype from t_meta_formdesign where fid = ?", new Object[]{new SqlParameter(":fid", 12, (Object)formId)});
        Map form = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, rs -> {
            HashMap<String, String> map = new HashMap<String, String>(2);
            if (rs.next()) {
                String entityId = rs.getString("fentityid");
                String modelType = rs.getString("fmodeltype");
                map.put("entityId", entityId);
                map.put("modelType", modelType);
            }
            return map;
        });
        if (form != null && !form.isEmpty()) {
            String entityId = (String)form.get("entityId");
            String modelType = (String)form.get("modelType");
            if (entityId.equals(formId) && (modelType.equals("BillFormModel") || modelType.equals("BaseFormModel"))) {
                return true;
            }
        }
        return false;
    }
}

