/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.form.designer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.EntryGridColAllCheckedEvent;
import kd.bos.form.control.events.EntryGridColAllCheckedListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.FlatFieldAp;
import kd.bos.mvc.form.IFormController;
import kd.bos.newdevportal.designer.AbstractFormDesignerTabPlugin;
import kd.bos.newdevportal.designer.DesignerTabCloseEvent;
import kd.bos.newdevportal.designer.DesignerTabRefreshEvent;
import kd.bos.newdevportal.designer.MergeDesignerTabDataEvent;
import kd.bos.newdevportal.designer.SwitchDesignerTabEvent;

public class BatchEditFieldPlugin
extends AbstractFormDesignerTabPlugin
implements ClickListener,
SearchEnterListener,
EntryGridBindDataListener,
EntryGridColAllCheckedListener {
    private static final String KEY_FIELD_KEY = "fieldkey";
    private static final String KEY_FIELD_NAME = "fieldname";
    private static final String KEY_FIELD_ID = "fieldid";
    private static final String[] VISIBLE_STATUS = new String[]{"vinit", "vnew", "vedit", "vview", "vsubmit", "vaudit"};
    private static final String[] LOCK_STATUS = new String[]{"lnew", "ledit", "lsubmit", "laudit"};
    private static final String CHANGE_ROWS = "changeRows";
    private static final String ITEM_ID = "itemId";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String VALUE = "value";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    String entryKey = "entryap";
    private static final String ENTRY_FIELD_TYPE = "fieldtype";
    private static String CACHE_KEY_MODELDATA = "entrydata";

    public void initialize() {
        Search searchEdit = (Search)this.getControl("searchap");
        searchEdit.addEnterListener((SearchEnterListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(this.entryKey);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(this.entryKey);
        entryGrid.addColAllCheckedListener((EntryGridColAllCheckedListener)this);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("ModifierField", "CreateDateField", "ModifyDateField", "UserAvatarField", "BasedataPropField", "BaseUnitqtyField", "PrintCountField", "BillStatusField", "CreaterField"));
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(this.entryKey);
        if (dynamicObjects == null || dynamicObjects.isEmpty()) {
            return;
        }
        int row = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            String fieldType;
            boolean isFieldAp = dynamicObject.getBoolean("isfieldap");
            if (isFieldAp) {
                this.setLockMapCache("lview", row);
            }
            if (list.contains(fieldType = dynamicObject.getString(ENTRY_FIELD_TYPE))) {
                this.setLockMapCache("lnew", row);
                this.setLockMapCache("ledit", row);
                this.setLockMapCache("lview", row);
                this.setLockMapCache("lsubmit", row);
                this.setLockMapCache("laudit", row);
            }
            if ("RadioGroupField".equals(fieldType)) {
                this.setLockMapCache("lnew", row);
                this.setLockMapCache("ledit", row);
                this.setLockMapCache("lview", row);
                this.setLockMapCache("lsubmit", row);
                this.setLockMapCache("laudit", row);
                this.setLockMapCache("vinit", row);
                this.setLockMapCache("vnew", row);
                this.setLockMapCache("vedit", row);
                this.setLockMapCache("vview", row);
                this.setLockMapCache("vsubmit", row);
                this.setLockMapCache("vaudit", row);
            }
            ++row;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.entryKey);
        String lock = this.getPageCache().get("lockMap");
        if (StringUtils.isNotBlank((CharSequence)lock)) {
            Map lockMap = (Map)SerializationUtils.fromJsonString((String)lock, Map.class);
            Map data = e.getData();
            Map dataIndex = (Map)data.get("dataindex");
            Integer intcprop = (Integer)dataIndex.get("cprop");
            List rows = (List)data.get("rows");
            for (int i = 0; i < rows.size(); ++i) {
                List rowObjList = (List)rows.get(i);
                Map cpropMap = (Map)rowObjList.get(intcprop);
                for (Map.Entry entry : lockMap.entrySet()) {
                    if (entry.getValue() == null || !((List)entry.getValue()).contains(i)) continue;
                    ArrayList blankList = (ArrayList)cpropMap.get("blank");
                    if (blankList == null) {
                        blankList = new ArrayList();
                        cpropMap.put("blank", blankList);
                    }
                    blankList.add(entry.getKey());
                }
            }
            e.getData().put("rows", rows);
            for (Map.Entry lockEntryMap : lockMap.entrySet()) {
                if (row == ((List)lockEntryMap.getValue()).size()) {
                    String search = this.getPageCache().get("search");
                    if (!StringUtils.isBlank((CharSequence)search)) continue;
                    entryGrid.setColumnProperty((String)lockEntryMap.getKey(), "vi", (Object)false);
                    continue;
                }
                entryGrid.setColumnProperty((String)lockEntryMap.getKey(), "vi", (Object)true);
            }
        }
    }

    private void setLockMapCache(String feature, int i) {
        Map<String, HashSet<Integer>> lockMap = new HashMap(16);
        HashSet<Integer> rows = new HashSet<Integer>(10);
        String lock = this.getPageCache().get("lockMap");
        if (StringUtils.isNotBlank((CharSequence)lock) && (lockMap = (Map)SerializationUtils.fromJsonString((String)lock, Map.class)).get(feature) != null) {
            rows = new HashSet((Collection)lockMap.get(feature));
        }
        rows.add(i);
        lockMap.put(feature, rows);
        this.getPageCache().put("lockMap", SerializationUtils.toJsonString(lockMap));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String columnName = e.getProperty().getName();
        String changeRows = this.getPageCache().get(CHANGE_ROWS);
        HashSet<Integer> changeRowsSet = null;
        if (StringUtils.isNotBlank((CharSequence)changeRows)) {
            changeRowsSet = (HashSet<Integer>)SerializationUtils.fromJsonString((String)changeRows, Set.class);
        }
        if (changeRowsSet == null) {
            changeRowsSet = new HashSet<Integer>();
        }
        changeRowsSet.add(rowIndex);
        this.getPageCache().put(CHANGE_ROWS, SerializationUtils.toJsonString(changeRowsSet));
        this.setSynchronized(false);
        this.markColumnSelectAllStatus(columnName);
    }

    private void setGridColAllValue(String entrygrid, String colKey, boolean checked) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> ret = new HashMap<String, Object>(2);
        ret.put("c", colKey);
        ret.put("v", checked);
        clientViewProxy.invokeControlMethod(entrygrid, "setGridColAllValue", new Object[]{ret});
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        this.getPageCache().put("lockMap", null);
        this.getPageCache().put("filterValue", searchEnterEvent.getText());
        this.getPageCache().put("search", "true");
        this.refreshEntryData(false);
        this.getView().updateView(this.entryKey);
        this.getPageCache().put("search", null);
    }

    private void cachePageData() {
        int count = this.getModel().getEntryRowCount(this.entryKey);
        if (count > 0) {
            String cacheDataStr = this.getPageCache().get(CACHE_KEY_MODELDATA);
            Map data = StringUtils.isNotBlank((CharSequence)cacheDataStr) ? (Map)SerializationUtils.fromJsonString((String)cacheDataStr, Map.class) : new HashMap(count);
            for (int i = 0; i < count; ++i) {
                DynamicObject obj = this.getModel().getEntryRowEntity(this.entryKey, i);
                HashMap<String, String> para = new HashMap<String, String>();
                String id = obj.getString(KEY_FIELD_ID);
                String visible = this.buildProperty(obj, false);
                String lock = this.buildProperty(obj, true);
                para.put("visible", visible);
                para.put("lock", lock);
                data.put(id, para);
            }
            this.getPageCache().put(CACHE_KEY_MODELDATA, SerializationUtils.toJsonString(data));
        }
    }

    private Map<String, String> getCacheData(String itemId) {
        String cacheDataStr = this.getPageCache().get(CACHE_KEY_MODELDATA);
        Map data = StringUtils.isNotBlank((CharSequence)cacheDataStr) ? (Map)SerializationUtils.fromJsonString((String)cacheDataStr, Map.class) : new HashMap(3);
        return (Map)data.get(itemId);
    }

    private void cleatCachePageData() {
        this.getPageCache().remove(CACHE_KEY_MODELDATA);
    }

    public void closeAndReturn() {
        this.getView().returnDataToParent(this.getTabPageData());
        this.getView().close();
    }

    private List<Map<String, Object>> getTabPageData() {
        String lock;
        String visible;
        String itemId;
        HashMap<String, String> para;
        ArrayList<Map<String, Object>> paras = new ArrayList<Map<String, Object>>(10);
        String changeRows = this.getPageCache().get(CACHE_KEY_MODELDATA);
        Map cacheDatas = new HashMap(10);
        if (StringUtils.isNotBlank((CharSequence)changeRows)) {
            cacheDatas = (Map)SerializationUtils.fromJsonString((String)changeRows, Map.class);
        }
        DynamicObjectCollection entryDatas = this.getModel().getEntryEntity(this.entryKey);
        for (DynamicObject obj : entryDatas) {
            para = new HashMap<String, String>();
            itemId = obj.getString(KEY_FIELD_ID);
            cacheDatas.remove(itemId);
            para.put(ITEM_ID, itemId);
            para.put(META_TYPE, "formmeta");
            para.put(PROPERTY_NAME, "Visible");
            visible = "";
            visible = this.buildProperty(obj, false);
            para.put(VALUE, visible);
            paras.add(para);
            para = new HashMap();
            para.put(ITEM_ID, itemId);
            para.put(META_TYPE, "formmeta");
            para.put(PROPERTY_NAME, "Lock");
            lock = this.buildProperty(obj, true);
            para.put(VALUE, lock);
            paras.add(para);
        }
        for (Map.Entry it : cacheDatas.entrySet()) {
            para = new HashMap();
            itemId = (String)it.getKey();
            para.put(ITEM_ID, itemId);
            para.put(META_TYPE, "formmeta");
            para.put(PROPERTY_NAME, "Visible");
            visible = (String)((Map)it.getValue()).get("visible");
            para.put(VALUE, visible);
            paras.add(para);
            para = new HashMap(16);
            para.put(ITEM_ID, itemId);
            para.put(META_TYPE, "formmeta");
            para.put(PROPERTY_NAME, "Lock");
            lock = (String)((Map)it.getValue()).get("lock");
            para.put(VALUE, lock);
            paras.add(para);
        }
        return paras;
    }

    private FormMetadata getEditMeta() {
        return this.getFormMeta(this.getView().getFormShowParameter(), this.getMetaViewId());
    }

    public void afterCreateNewData(EventObject arg0) {
        this.getPageCache().put("filterValue", "");
        this.refreshEntryData(true);
        this.markColumnSelectAllStatus(null);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (StringUtils.equals((CharSequence)"DynamicFormModel", (CharSequence)this.getFormModelType(this.getView().getFormShowParameter()))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"lview", "lsubmit", "laudit", "vsubmit", "vaudit"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"lview", "lsubmit", "laudit", "vsubmit", "vaudit"});
        }
    }

    private void fillEntryData(ContainerAp containerAp, String prefix) {
        List controlAps = containerAp.getItems();
        ArrayList<ContainerAp> containerAps = new ArrayList<ContainerAp>(10);
        ArrayList<EntryAp> entryAps = new ArrayList<EntryAp>(10);
        if (containerAp instanceof FormAp) {
            prefix = "";
        } else if (containerAp instanceof EntryAp) {
            prefix = ResManager.loadKDString((String)"\u5355\u636e\u4f53\u00b7", (String)"BatchEditFieldPlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
            String entryPrefix = ResManager.loadKDString((String)"\u5355\u636e\u4f53\u540d\u00b7", (String)"BatchEditFieldPlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
            if (this.showControlData((ControlAp<?>)containerAp, entryPrefix)) {
                this.fieldRule(containerAp.getId(), entryPrefix + containerAp.getName().toString(), containerAp.getKey(), containerAp.getVisible(), containerAp.getLock(), (ControlAp)containerAp);
            }
        }
        for (ControlAp item : controlAps) {
            String checkPrefix = prefix;
            if (item instanceof FlatFieldAp) {
                checkPrefix = ResManager.loadKDString((String)"\u5e73\u94fa\u89c6\u56fe\u00b7", (String)"BatchEditFieldPlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
            }
            if (item instanceof FieldAp && this.showControlData(item, checkPrefix)) {
                this.fieldRule(item.getId(), checkPrefix + item.getName().toString(), item.getKey(), item.getVisible(), item.getLock(), item);
            }
            if (item instanceof EntryAp) {
                entryAps.add((EntryAp)item);
                continue;
            }
            if (!(item instanceof ContainerAp)) continue;
            containerAps.add((ContainerAp)item);
        }
        for (ContainerAp cap : containerAps) {
            this.fillEntryData(cap, prefix);
        }
        for (EntryAp eap : entryAps) {
            this.fillEntryData((ContainerAp)eap, prefix);
        }
    }

    private void refreshEntryData(boolean init) {
        if (init) {
            this.cleatCachePageData();
        } else {
            this.cachePageData();
        }
        this.getModel().deleteEntryData(this.entryKey);
        FormMetadata formMetadata = this.getEditMeta();
        formMetadata.createIndex();
        this.fillEntryData((ContainerAp)formMetadata.getRootAp(), "");
    }

    private void markColumnSelectAllStatus(String columnName) {
        DynamicObjectCollection cols = this.getModel().getEntryEntity(this.entryKey);
        EntryProp entryProp = (EntryProp)this.getModel().getDataEntityType().findProperty(this.entryKey);
        ConcurrentHashMap<String, String> allCheckedCol = new ConcurrentHashMap<String, String>();
        for (IDataEntityProperty prop : entryProp.getDynamicCollectionItemPropertyType().getProperties()) {
            if (!(prop instanceof BooleanProp)) continue;
            allCheckedCol.put(prop.getName(), prop.getName());
        }
        for (Map.Entry ctlKey : allCheckedCol.entrySet()) {
            if (columnName != null) {
                if (!columnName.equals(ctlKey.getKey())) continue;
                this.setGridColAllValue(this.entryKey, columnName, false);
                continue;
            }
            this.setGridColAllValue(this.entryKey, (String)ctlKey.getKey(), false);
        }
        for (DynamicObject dym : cols) {
            allCheckedCol.forEach((k, v) -> {
                if (!dym.getBoolean(k.toLowerCase())) {
                    allCheckedCol.remove(k);
                }
            });
        }
        if (cols.size() > 0) {
            for (Map.Entry ctlKey : allCheckedCol.entrySet()) {
                this.setGridColAllValue(this.entryKey, (String)ctlKey.getKey(), true);
            }
        }
    }

    private boolean showControlData(ControlAp<?> controlAp, String prefix) {
        String filterValue = this.getPageCache().get("filterValue");
        if (StringUtils.isBlank((CharSequence)filterValue)) {
            return true;
        }
        return filterValue.equalsIgnoreCase(controlAp.getKey()) || controlAp.getName() != null && (controlAp.getName().toString().toLowerCase().contains(filterValue.toLowerCase()) || (prefix + controlAp.getName().toString().toLowerCase()).contains(filterValue.toLowerCase()));
    }

    private void fieldRule(String id, String name, String key, String visible, String lock, ControlAp controlAp) {
        FormMetadata formMetadata = this.getEditMeta();
        ControlAp item = formMetadata.getItem(id);
        String fieldType = "";
        fieldType = item instanceof FieldAp ? ((FieldAp)item).getField().getClass().getSimpleName() : item.getClass().getSimpleName();
        this.getModel().beginInit();
        int rowIndex = this.getModel().createNewEntryRow(this.entryKey);
        this.getModel().setValue(KEY_FIELD_ID, (Object)id, rowIndex);
        this.getModel().setValue(KEY_FIELD_NAME, (Object)name, rowIndex);
        this.getModel().setValue(KEY_FIELD_KEY, (Object)key, rowIndex);
        this.getModel().setValue(ENTRY_FIELD_TYPE, (Object)fieldType, rowIndex);
        Map<String, String> cacheData = this.getCacheData(id);
        if (cacheData != null) {
            visible = cacheData.get("visible");
            lock = cacheData.get("lock");
        }
        if (StringUtils.isNotBlank((CharSequence)visible)) {
            String[] visibleStatus;
            for (String status : visibleStatus = visible.split(",")) {
                this.getModel().setValue(BatchEditFieldPlugin.buildVisibleKey(status), (Object)true, rowIndex);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)lock)) {
            String[] lockStatus;
            for (String status : lockStatus = lock.split(",")) {
                String lockType = BatchEditFieldPlugin.buildLockKey(status);
                if (this.getModel().getProperty(lockType) == null) continue;
                this.getModel().setValue(lockType, (Object)true, rowIndex);
            }
        }
        boolean isFieldAp = false;
        if (controlAp instanceof FieldAp) {
            isFieldAp = true;
        }
        this.getModel().setValue("isfieldap", (Object)isFieldAp, rowIndex);
        this.getModel().endInit();
    }

    private static String buildVisibleKey(String status) {
        return String.format("v%s", status);
    }

    private static String buildLockKey(String status) {
        return String.format("l%s", status);
    }

    private static String getStatus(String fieldKey) {
        return fieldKey.substring(1);
    }

    private String buildProperty(DynamicObject propEditRow, boolean isLock) {
        ArrayList<String> status = new ArrayList<String>();
        String[] statusKeys = null;
        statusKeys = isLock ? LOCK_STATUS : VISIBLE_STATUS;
        for (String statusKey : statusKeys) {
            if (!propEditRow.getBoolean(statusKey)) continue;
            status.add(BatchEditFieldPlugin.getStatus(statusKey));
        }
        return status.stream().collect(Collectors.joining(","));
    }

    @Override
    protected void fireSwitchTabEvent(SwitchDesignerTabEvent e) {
        if (this.isSynchronized()) {
            return;
        }
        e.addSetPropActionData(this.getUnsynchronizedData());
        this.setSynchronized(true);
    }

    @Override
    protected void fireRefreshTabEvent(DesignerTabRefreshEvent e) {
        IFormController formController = (IFormController)this.getView().getService(IFormController.class);
        if (formController == null) {
            return;
        }
        formController.loadData();
        e.getMainDesignView().sendFormAction(this.getView());
    }

    @Override
    protected void fireTabCloseEvent(DesignerTabCloseEvent e) {
        if (e.isForce() || !this.isFocusCurrentTab()) {
            super.fireTabCloseEvent(e);
            return;
        }
        if (this.isSynchronized()) {
            return;
        }
        e.addSetPropActionData(this.getUnsynchronizedData());
        this.setSynchronized(true);
    }

    @Override
    protected void fireMergeTabDataEvent(MergeDesignerTabDataEvent e) {
        if (!this.isFocusCurrentTab()) {
            return;
        }
        this.mergeFormMeta(e.getProDesignerContent(), this.getTabPageData());
    }

    private boolean isSynchronized() {
        return Boolean.parseBoolean(this.getView().getPageCache().get("synchronized")) || !this.getView().getModel().isDataLoaded();
    }

    private void setSynchronized(boolean sign) {
        this.getView().getPageCache().put("synchronized", String.valueOf(sign));
        this.getView().getPageCache().saveChanges();
    }

    private List<Map<String, Object>> getUnsynchronizedData() {
        if (this.isSynchronized()) {
            return Collections.emptyList();
        }
        return this.getTabPageData();
    }

    @Override
    protected String getTabId() {
        return "batchedit";
    }

    public void entryGridColAllChecked(EntryGridColAllCheckedEvent e) {
        boolean oldValue;
        int i;
        e.setCancel(true);
        EntryGrid entryGrid = (EntryGrid)this.getControl(this.entryKey);
        int startIndex = 0;
        int endIndex = entryGrid.getModel().getEntryRowCount(this.entryKey);
        String locks = this.getPageCache().get("lockMap");
        Map lockMap = (Map)SerializationUtils.fromJsonString((String)locks, Map.class);
        List rows = (List)lockMap.get(e.getColKey());
        HashSet<Integer> rowSet = new HashSet<Integer>(16);
        if (rows != null) {
            for (i = startIndex; i < endIndex; ++i) {
                if (rows.contains(i) || (oldValue = ((Boolean)this.getModel().getValue(e.getColKey(), i)).booleanValue()) == e.isChecked()) continue;
                this.getModel().setValue(e.getColKey(), (Object)e.isChecked(), i);
                rowSet.add(i);
            }
        } else {
            for (i = startIndex; i < endIndex; ++i) {
                oldValue = (Boolean)this.getModel().getValue(e.getColKey(), i);
                if (oldValue == e.isChecked()) continue;
                this.getModel().setValue(e.getColKey(), (Object)e.isChecked(), i);
                rowSet.add(i);
            }
        }
        String changeRows = this.getPageCache().get(CHANGE_ROWS);
        HashSet<Integer> changeRowsSet = null;
        if (StringUtils.isNotBlank((CharSequence)changeRows)) {
            changeRowsSet = (HashSet<Integer>)SerializationUtils.fromJsonString((String)changeRows, Set.class);
        }
        if (changeRowsSet == null) {
            changeRowsSet = new HashSet<Integer>();
        }
        changeRowsSet.addAll(rowSet);
        this.getPageCache().put(CHANGE_ROWS, SerializationUtils.toJsonString(changeRowsSet));
        this.getView().updateView(this.entryKey);
        this.setGridColAllValue(this.entryKey, e.getColKey(), e.isChecked());
    }
}

