/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.form.designer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.plugin.manager.EventAction;
import kd.bos.entity.plugin.manager.EventMethod;
import kd.bos.entity.plugin.manager.EventMethodTypes;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.metadata.extensible.ExtLockTypeEnum;
import kd.bos.metadata.extensible.ExtensibleDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.newdevportal.designer.AbstractFormDesignerTabPlugin;
import kd.bos.newdevportal.designer.DesignerTabCloseEvent;
import kd.bos.newdevportal.designer.MergeDesignerTabDataEvent;
import kd.bos.newdevportal.designer.SwitchDesignerTabEvent;

public class FormPluginsPlugin
extends AbstractFormDesignerTabPlugin
implements RowClickEventListener {
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String PLUGIN_CLASS_NAME = "ClassName";
    public static final String PLUGIN_ENABLE_NAME = "Enabled";
    public static final String PLUGIN_DESCRIPTION_NAME = "Description";
    public static final String PLUGIN_DISPLAYNAME_NAME = "DisplayName";
    public static final String PLUGIN_TYPE_NAME = "Type";
    public static final String PLUGIN_FPK_NAME = "FPK";
    public static final String PLUGIN_BIZAPPID_NAME = "BizAppId";
    public static final String PLUGIN_ISINHERIT = "Inherit";
    public static final String ENTRY_CLASS_NAME = "classname";
    public static final String ENTRY_ENABLE_NAME = "enabled";
    public static final String ENTRY_DESCRIPTION_NAME = "description";
    public static final String ENTRY_DISPLAYNAME_NAME = "displayname";
    public static final String ENTRY_TYPE_NAME = "type";
    public static final String ENTRY_FPK_NAME = "fpk";
    public static final String ENTRY_BIZAPPID_NAME = "bizappid";
    public static final String ENTRY_ISINHERIT = "isinherit";
    public static final String ROW_KEY_NAME = "RowKey";
    private static final String BTN_REGISTER = "register";
    private static final String BTN_REGISTERJS = "registerjs";
    private static final String VALUE = "value";
    private static final String[] ITEMS = new String[]{"edit", "moveup", "movedown", "unregister", "delete"};
    private static final String PARENTPLUGINSDISABLE = "parentPluginsDisable.on";
    private static final String ENTRY_KEY = "EntryEntity";
    private static final String PLUGIN_EVENTS = "Events";
    private static final String PLUGIN_EVENT_ID = "Id";
    private static final String PLUGIN_EVENT_ACTION = "Action";
    private static final String PLUGIN_EVENT_PARAM_CONDITION = "ParamCondition";
    private static final String PLUGIN_EVENT_SIMPLE_EXPR = "SimpleExpr";
    private static final String PLUGIN_EVENT_EXPRESSION = "Expression";
    private static final String PLUGIN_EVENT_REMARK = "Remark";
    private static final String ENTRY_EVENT_ENTRY_KEY = "entryentity1";
    private static final String ENTRY_EVENT_CLASS_NAME = "classnamecombo";
    private static final String ENTRY_EVENT_NAME = "eventname";
    private static final String ENTRY_EVENT_ID = "eventid";
    private static final String ENTRY_EVENT_SIMPLE_EXPR = "simpleexpr";
    private static final String ENTRY_EVENT_EXPRESSION = "expression";
    private static final String ENTRY_EVENT_ACTION = "eventaction";
    private static final String ENTRY_EVENT_REMARK = "remark";
    private static final String FROM_PRO_FORM_DESIGNER = "fromProFormDesigner";
    private static final String BTN_REGISTERTS = "registerts";
    private static final String BTN_SELECTTS = "selectts";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AbstractGrid grid = (AbstractGrid)this.getControl("entryentity");
        grid.addRowClickListener((RowClickEventListener)this);
        Tab tab = (Tab)this.getControl("tabap");
        if (Objects.nonNull(tab)) {
            tab.addItemClickListener((ItemClickListener)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        if (e.getActionId().equals(BTN_REGISTERJS)) {
            List plugins = (List)e.getReturnData();
            for (Map plugin : plugins) {
                List<Map<String, Object>> currents = this.getPluginsFromEntryEntity();
                boolean bExist = false;
                for (Map<String, Object> current : currents) {
                    if (!plugin.get(PLUGIN_CLASS_NAME).equals(current.get(PLUGIN_CLASS_NAME))) continue;
                    bExist = true;
                    break;
                }
                if (bExist) continue;
                this.addToModel(plugin);
            }
        } else if (e.getActionId().equals(BTN_REGISTER)) {
            Map plugin = (Map)e.getReturnData();
            int iTestType = 0;
            plugin.put(ROW_KEY_NAME, iTestType);
            this.addToModel(plugin);
        } else if (BTN_REGISTERTS.equalsIgnoreCase(e.getActionId())) {
            Map plugin = (Map)e.getReturnData();
            this.addToModel(plugin);
        } else if ("edit".equals(e.getActionId())) {
            Map plugin = (Map)e.getReturnData();
            int rowKey = (Integer)plugin.get(ROW_KEY_NAME);
            this.getModel().setValue(ENTRY_CLASS_NAME, plugin.get(PLUGIN_CLASS_NAME), rowKey);
            this.getModel().setValue(ENTRY_ENABLE_NAME, plugin.get(PLUGIN_ENABLE_NAME), rowKey);
            this.getModel().setValue(ENTRY_DESCRIPTION_NAME, plugin.get(PLUGIN_DESCRIPTION_NAME), rowKey);
            this.getModel().setValue(ENTRY_DISPLAYNAME_NAME, plugin.get(PLUGIN_DISPLAYNAME_NAME), rowKey);
            this.getModel().setValue(ENTRY_TYPE_NAME, plugin.get(PLUGIN_TYPE_NAME), rowKey);
            this.getModel().setValue(ENTRY_FPK_NAME, plugin.get(PLUGIN_FPK_NAME), rowKey);
            this.getModel().setValue(ENTRY_BIZAPPID_NAME, plugin.get(PLUGIN_BIZAPPID_NAME), rowKey);
        } else if ("addevent".equals(e.getActionId())) {
            this.addToEventModel((Map)e.getReturnData());
        } else if ("editevent".equals(e.getActionId())) {
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_EVENT_ENTRY_KEY);
            this.editEventModel((Map)e.getReturnData(), grid.getEntryState().getFocusRow());
        }
    }

    private void addToModel(Map<String, Object> plugin) {
        plugin.put("_Type_", "Plugin");
        int rowIndex = this.getModel().createNewEntryRow(ENTRY_KEY);
        this.getModel().setValue(ENTRY_CLASS_NAME, plugin.get(PLUGIN_CLASS_NAME), rowIndex);
        this.getModel().setValue(ENTRY_ENABLE_NAME, plugin.get(PLUGIN_ENABLE_NAME), rowIndex);
        this.getModel().setValue(ENTRY_ISINHERIT, (Object)"1", rowIndex);
        this.getModel().setValue(ENTRY_DESCRIPTION_NAME, plugin.get(PLUGIN_DESCRIPTION_NAME), rowIndex);
        this.getModel().setValue(ENTRY_DISPLAYNAME_NAME, plugin.get(PLUGIN_DISPLAYNAME_NAME), rowIndex);
        this.getModel().setValue(ENTRY_TYPE_NAME, plugin.get(PLUGIN_TYPE_NAME), rowIndex);
        this.getModel().setValue(ENTRY_FPK_NAME, plugin.get(PLUGIN_FPK_NAME), rowIndex);
        this.getModel().setValue(ENTRY_BIZAPPID_NAME, plugin.get(PLUGIN_BIZAPPID_NAME), rowIndex);
        plugin.put(ROW_KEY_NAME, rowIndex);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        grid.clearEntryState();
    }

    private List<Map<String, Object>> getPluginsFromEntryEntity() {
        ArrayList<Map<String, Object>> newPlugins = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection doc = this.getModel().getEntryEntity(ENTRY_KEY);
        boolean hasIsInheritProp = doc.getDynamicObjectType().getProperties().containsKey((Object)ENTRY_ISINHERIT);
        int rowIndex = 0;
        for (DynamicObject obj : doc) {
            String isInheritValue;
            HashMap<String, Object> mapPlugin = new HashMap<String, Object>(16);
            mapPlugin.put(ROW_KEY_NAME, rowIndex++);
            mapPlugin.put(PLUGIN_ENABLE_NAME, obj.getBoolean(ENTRY_ENABLE_NAME));
            mapPlugin.put(PLUGIN_CLASS_NAME, obj.getString(ENTRY_CLASS_NAME));
            mapPlugin.put(PLUGIN_DESCRIPTION_NAME, obj.getString(ENTRY_DESCRIPTION_NAME));
            mapPlugin.put(PLUGIN_DISPLAYNAME_NAME, obj.getString(ENTRY_DISPLAYNAME_NAME));
            mapPlugin.put(PLUGIN_TYPE_NAME, obj.getInt(ENTRY_TYPE_NAME));
            mapPlugin.put(PLUGIN_FPK_NAME, obj.getString(ENTRY_FPK_NAME));
            mapPlugin.put(PLUGIN_BIZAPPID_NAME, obj.getString(ENTRY_BIZAPPID_NAME));
            if (hasIsInheritProp && (isInheritValue = (String)this.getModel().getValue(ENTRY_ISINHERIT, rowIndex - 1)) != null) {
                Boolean ish = "0".equals(isInheritValue);
                mapPlugin.put(PLUGIN_ISINHERIT, ish);
            }
            newPlugins.add(mapPlugin);
        }
        return newPlugins;
    }

    private void register() {
        this.openPluginJavaClass(BTN_REGISTER);
    }

    private void registerTs() {
        String bizAppId = (String)this.getView().getParentView().getFormShowParameter().getCustomParams().get(ENTRY_BIZAPPID_NAME);
        String id = this.getView().getParentView().getPageCache().get("id");
        String modelType = this.getView().getParentView().getPageCache().get("modelType");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setShowTitle(false);
        parameter.setShowClose(false);
        parameter.setFormId("ide_register_ts_plugin");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("id", (Object)id);
        parameter.setCustomParam("bizpagenumber", (Object)this.getPageNumber());
        parameter.setCustomParam("bizPageId", (Object)this.getView().getParentView().getPageId());
        parameter.setCustomParam("modelType", (Object)modelType);
        parameter.setCustomParam("scripttypefilter", (Object)"page");
        parameter.setCustomParam(FROM_PRO_FORM_DESIGNER, this.getView().getParentView().getFormShowParameter().getCustomParam(FROM_PRO_FORM_DESIGNER));
        if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
            parameter.setCustomParam(ENTRY_BIZAPPID_NAME, (Object)bizAppId);
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_REGISTERTS));
        this.getView().showForm(parameter);
    }

    private void registerTsNew() {
        String bizAppId = (String)this.getView().getParentView().getFormShowParameter().getCustomParams().get(ENTRY_BIZAPPID_NAME);
        String id = this.getView().getParentView().getPageCache().get("id");
        String modelType = this.getView().getParentView().getPageCache().get("modelType");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setShowTitle(false);
        parameter.setShowClose(false);
        parameter.setFormId("ide_register_kingscript");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_REGISTERTS));
        parameter.setCustomParam("id", (Object)id);
        parameter.setCustomParam("bizpagenumber", (Object)this.getPageNumber());
        parameter.setCustomParam("bizPageId", (Object)this.getView().getParentView().getPageId());
        parameter.setCustomParam("modelType", (Object)modelType);
        parameter.setCustomParam("scripttypefilter", (Object)"page");
        parameter.setCustomParam(FROM_PRO_FORM_DESIGNER, this.getView().getParentView().getFormShowParameter().getCustomParam(FROM_PRO_FORM_DESIGNER));
        if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
            parameter.setCustomParam(ENTRY_BIZAPPID_NAME, (Object)bizAppId);
        }
        parameter.setCustomParam(VALUE, (Object)SerializationUtils.toJsonString(this.getPluginsFromEntryEntity()));
        this.getView().showForm(parameter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String modelType = this.getModelType();
        if (Plugin.enableKingScript((String)modelType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_REGISTERTS});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_SELECTTS});
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_REGISTERJS});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_REGISTERTS});
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SELECTTS});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_REGISTERJS});
        }
    }

    private String getFormId() {
        String formId = null;
        PropertyEditHelper propertyEditHelper = new PropertyEditHelper();
        IFormView designerView = propertyEditHelper.getDesignFormView(this.getView());
        if (designerView != null) {
            formId = (String)designerView.getFormShowParameter().getCustomParam("number");
        }
        if (StringUtils.isBlank(formId)) {
            formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        }
        if (StringUtils.isBlank(formId)) {
            formId = this.getView().getFormShowParameter().getParentFormId();
        }
        return formId;
    }

    private void openPluginJavaClass(String sCallBackFlag) {
        HashMap<String, String> para = new HashMap<String, String>(16);
        para.put("formId", "ide_registerplugin");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.setCustomParam("id", (Object)this.getFormMeta(this.getView().getFormShowParameter(), this.getMetaViewId()).getId());
        showParameter.setCustomParam("plugins", this.getPluginsFromEntryEntity());
        showParameter.setCustomParam(FROM_PRO_FORM_DESIGNER, (Object)"true");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sCallBackFlag));
        this.getView().showForm(showParameter);
    }

    private void registerjs() {
        this.openPluginJavaScript(BTN_REGISTERJS, BTN_REGISTERJS);
    }

    private void openPluginJavaScript(String sCallBackFlag, String type) {
        String modelType = this.getFormModelType(this.getView().getFormShowParameter());
        String scriptTypeFilter = (String)this.getView().getFormShowParameter().getCustomParams().get("scriptfiltertype");
        String bizAppId = this.getEntityMeta(this.getView().getFormShowParameter()).getBizappId();
        if (StringUtils.isBlank((CharSequence)scriptTypeFilter)) {
            scriptTypeFilter = "MobileFormModel".equals(modelType) || "MobUserGuideFormModel".equals(modelType) || "MobileBillFormModel".equals(modelType) ? "mobpage" : ("PrintModel".equals(modelType) ? "printpage" : "page");
        }
        String engineType = BTN_REGISTERTS.equals(type) ? "1" : "0";
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCaption(ResManager.getLocaleString((String)"\u9009\u62e9\u811a\u672c", (String)"PluginsPlugin_10", (String)"bos-designer-plugin").getLocaleValue());
        parameter.setFormId("ide_register_ks_plugin");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sCallBackFlag));
        parameter.setCustomParam("engineType", (Object)engineType);
        if ("1".equals(engineType)) {
            parameter.setCustomParam("modelType", (Object)modelType);
        }
        parameter.setCustomParam("bizpagenumber", (Object)this.getPageNumber());
        parameter.setCustomParam("bizPageId", (Object)this.getView().getParentView().getPageId());
        parameter.setCustomParam("scripttypefilter", (Object)scriptTypeFilter);
        parameter.setCustomParam(FROM_PRO_FORM_DESIGNER, this.getView().getFormShowParameter().getCustomParam(FROM_PRO_FORM_DESIGNER));
        if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
            parameter.setCustomParam(ENTRY_BIZAPPID_NAME, (Object)bizAppId);
        }
        parameter.setCustomParam(VALUE, (Object)SerializationUtils.toJsonString(this.getPluginsFromEntryEntity()));
        this.getView().showForm(parameter);
    }

    private String getPageNumber() {
        FormMetadata formMeta = this.getFormMeta(this.getView().getFormShowParameter(), "formmeta");
        return formMeta.getKey();
    }

    private void unRegister() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int entryRowKey = grid.getEntryState().getFocusRow();
        if (StringUtils.isNotBlank((Object)entryRowKey) && entryRowKey != -1) {
            this.getModel().deleteEntryRow(ENTRY_KEY, entryRowKey);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u63d2\u4ef6\u3002", (String)"FormPluginsPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void closeAndreturnData() {
        this.getView().returnDataToParent(this.buildPagePropData());
        this.getView().close();
    }

    private Map<String, Object> buildPagePropData() {
        HashMap<String, Object> para = new HashMap<String, Object>(16);
        para.put("itemId", this.getFormMeta(this.getView().getFormShowParameter(), this.getMetaViewId()).getRootAp().getId());
        para.put("metaType", "formmeta");
        para.put("propertyName", "Plugins");
        List<Map<String, Object>> plugins = this.getPluginsFromEntryEntity();
        this.addEvents(plugins);
        para.put(VALUE, plugins);
        para.put("alias", "");
        return para;
    }

    public void click(EventObject evt) {
        Control ctl = (Control)evt.getSource();
        if ("ok".equalsIgnoreCase(ctl.getKey())) {
            this.closeAndreturnData();
        } else if ("exit".equalsIgnoreCase(ctl.getKey())) {
            this.getView().close();
        }
    }

    private void lockAddItem() {
        String id = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        FormMetadata metadata = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
        if (metadata == null) {
            return;
        }
        ExtLockTypeEnum lockType = ExtensibleDao.getExtLockType((AbstractMetadata)metadata, (String)"Field", (String)metadata.getModelType(), (String)id, (String)"Plugins");
        if (lockType == ExtLockTypeEnum.lock) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_REGISTER, BTN_REGISTERJS, BTN_REGISTERTS, BTN_SELECTTS, "edit", "moveup", "movedown", "delete"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.lockAddItem();
        Object value = this.getFormItemMetaList(this.getView().getFormShowParameter(), this.getMetaViewId()).get(0).get("Plugins");
        List plugins = value == null ? Collections.emptyList() : (List)value;
        this.sortPlugins(plugins);
        DynamicObjectCollection doc = this.getModel().getEntryEntity(ENTRY_KEY);
        boolean hasIsInheritProp = doc.getDynamicObjectType().getProperties().containsKey((Object)ENTRY_ISINHERIT);
        for (Map plugin : plugins) {
            int rowIndex = this.getModel().createNewEntryRow(ENTRY_KEY);
            this.getModel().setValue(ENTRY_CLASS_NAME, plugin.get(PLUGIN_CLASS_NAME), rowIndex);
            if (plugin.get(PLUGIN_ENABLE_NAME) == null) {
                this.getModel().setValue(ENTRY_ENABLE_NAME, (Object)false, rowIndex);
            } else {
                this.getModel().setValue(ENTRY_ENABLE_NAME, plugin.get(PLUGIN_ENABLE_NAME), rowIndex);
            }
            this.getModel().setValue(ENTRY_DESCRIPTION_NAME, plugin.get(PLUGIN_DESCRIPTION_NAME), rowIndex);
            this.getModel().setValue(ENTRY_DISPLAYNAME_NAME, plugin.get(PLUGIN_DISPLAYNAME_NAME), rowIndex);
            this.getModel().setValue(ENTRY_TYPE_NAME, plugin.get(PLUGIN_TYPE_NAME), rowIndex);
            this.getModel().setValue(ENTRY_FPK_NAME, plugin.get(PLUGIN_FPK_NAME), rowIndex);
            this.getModel().setValue(ENTRY_BIZAPPID_NAME, plugin.get(PLUGIN_BIZAPPID_NAME), rowIndex);
            if (!hasIsInheritProp) continue;
            Object obj = plugin.get(PLUGIN_ISINHERIT);
            if (obj != null) {
                boolean inherit = (Boolean)obj;
                String str = inherit ? "0" : "1";
                this.getModel().setValue(ENTRY_ISINHERIT, (Object)str, rowIndex);
                if (!inherit || !this.getParentPluginsDisable()) continue;
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{ENTRY_ENABLE_NAME});
                continue;
            }
            this.getModel().setValue(ENTRY_ISINHERIT, (Object)"1", rowIndex);
        }
        this.loadEvents(plugins);
        String metaTypeId = this.getMetaViewId();
        this.setEventTabVisible(!"listmeta".equals(metaTypeId));
    }

    private void sortPlugins(List<Map<String, Object>> plugins) {
        Collections.sort(plugins, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                Integer rowkey1 = 0;
                Integer rowkey2 = 0;
                if (StringUtils.isNotBlank((Object)o1.get(FormPluginsPlugin.ROW_KEY_NAME))) {
                    rowkey1 = (Integer)o1.get(FormPluginsPlugin.ROW_KEY_NAME);
                }
                if (StringUtils.isNotBlank((Object)o2.get(FormPluginsPlugin.ROW_KEY_NAME))) {
                    rowkey2 = (Integer)o2.get(FormPluginsPlugin.ROW_KEY_NAME);
                }
                return rowkey1.compareTo(rowkey2);
            }
        });
    }

    private void editPlugin() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int rowKey = grid.getEntryState().getFocusRow();
        if (this.getModel().getEntryRowCount(ENTRY_KEY) > 0 && rowKey >= 0) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            Map<String, Object> currentPlugin = this.getCurrentPlugin(rowKey);
            parameter.setCustomParam("rowKey", (Object)rowKey);
            parameter.setCustomParam("plugin", currentPlugin);
            parameter.setCustomParam("formnumber", (Object)this.getPageNumber());
            parameter.setCustomParam(FROM_PRO_FORM_DESIGNER, (Object)"true");
            int type = 0;
            if (currentPlugin.get(PLUGIN_TYPE_NAME) != null) {
                type = (Integer)currentPlugin.get(PLUGIN_TYPE_NAME);
            }
            switch (type) {
                case 1: {
                    parameter.setFormId("ide_edit_ks_plugin");
                    break;
                }
                case 4: {
                    String modelType = this.getModelType();
                    if (!Plugin.enableKingScript((String)modelType)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u5f00\u53d1\u5e73\u53f0\u672a\u542f\u7528\uff0c\u6682\u4e0d\u652f\u6301\u7f16\u8f91\u3002", (String)"FormPluginsPlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                        return;
                    }
                    String id = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
                    parameter.setShowTitle(false);
                    parameter.setShowClose(false);
                    parameter.setCustomParam("id", (Object)id);
                    parameter.setCustomParam("bizpagenumber", (Object)this.getPageNumber());
                    parameter.setCustomParam("bizPageId", (Object)this.getView().getParentView().getPageId());
                    parameter.setFormId("ide_register_ts_plugin");
                    break;
                }
                default: {
                    parameter.setFormId("ide_registerplugin");
                }
            }
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "edit"));
            this.getView().showForm(parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u63d2\u4ef6\u3002", (String)"FormPluginsPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
    }

    private Map<String, Object> getCurrentPlugin(int rowKey) {
        List<Map<String, Object>> plugins = this.getPluginsFromEntryEntity();
        return plugins.get(rowKey);
    }

    public void itemClick(ItemClickEvent evt) {
        String opKey = evt.getOperationKey();
        if (BTN_REGISTER.equalsIgnoreCase(opKey)) {
            this.register();
        } else if (BTN_REGISTERJS.equalsIgnoreCase(opKey)) {
            this.registerjs();
        } else if (BTN_SELECTTS.equalsIgnoreCase(opKey)) {
            this.openPluginJavaScript(BTN_REGISTERJS, BTN_REGISTERTS);
        } else if (BTN_REGISTERTS.equalsIgnoreCase(opKey)) {
            this.registerTsNew();
        } else if ("edit".equalsIgnoreCase(opKey)) {
            this.editPlugin();
        } else if ("unRegister".equalsIgnoreCase(opKey)) {
            this.unRegister();
        }
        if ("eventadd".equalsIgnoreCase(opKey)) {
            this.eventAdd();
        } else if ("eventedit".equalsIgnoreCase(opKey)) {
            this.eventEdit();
        }
    }

    private boolean isFocusPluginTab() {
        Tab tab = (Tab)this.getView().getControl("tabap");
        String current = tab.getCurrentTab();
        return "plugintab".equals(current);
    }

    public void entryRowClick(RowClickEvent evt) {
        if (!this.isFocusPluginTab() || !this.getParentPluginsDisable()) {
            return;
        }
        int index = evt.getRow();
        String value = (String)this.getModel().getValue(ENTRY_ISINHERIT, index);
        this.lockTabOpItem(this.getParentPluginsDisable() && "0".equals(value), ITEMS);
    }

    private void lockTabOpItem(boolean status, String ... items) {
        String id = MetadataDao.getIdByNumber((String)"devpn_formplugin", (MetaCategory)MetaCategory.Form);
        FormMetadata metadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)metadata.getEntityId(), (MetaCategory)MetaCategory.Entity);
        metadata.bindEntityMetadata(entityMetadata);
        metadata.createIndex();
        TabPageAp tabAp = null;
        for (ControlAp it : metadata.getItems()) {
            if (!(it instanceof TabPageAp) || !StringUtils.equals((CharSequence)"plugintab", (CharSequence)it.getKey())) continue;
            tabAp = (TabPageAp)it;
            break;
        }
        if (tabAp == null) {
            throw new KDBizException("not found control,key is 'plugintab' ");
        }
        HashSet opItem = new HashSet(items.length);
        Collections.addAll(opItem, items);
        List menus = tabAp.getTabPageOperationItems();
        ArrayList<Map> menuData = new ArrayList<Map>(menus.size());
        for (DropdownItem item : menus) {
            Map ddit = item.createControl();
            if (opItem.contains(item.getKey())) {
                ddit.put("l", status ? "63" : "0");
            }
            menuData.add(ddit);
        }
        HashMap<String, ArrayList<Map>> menuMeta = new HashMap<String, ArrayList<Map>>();
        menuMeta.put("menus", menuData);
        this.getView().updateControlMetadata("plugintab", menuMeta);
    }

    private boolean getParentPluginsDisable() {
        return Boolean.parseBoolean(System.getProperty(PARENTPLUGINSDISABLE, "true"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_KEY);
        entryGrid.selectRows(-1);
    }

    private void loadEvents(List<Map<String, Object>> plugins) {
        LinkedHashMap eventListMap = new LinkedHashMap();
        for (Map<String, Object> map : plugins) {
            List events = map.get(PLUGIN_EVENTS) != null ? (List)map.get(PLUGIN_EVENTS) : new ArrayList();
            ArrayList eventList = (ArrayList)eventListMap.get(map.get(PLUGIN_CLASS_NAME));
            for (Object event : events) {
                if (Objects.isNull(eventList)) {
                    eventList = new ArrayList();
                }
                eventList.add(event);
            }
            eventListMap.putIfAbsent(map.get(PLUGIN_CLASS_NAME), eventList);
        }
        for (Map.Entry entry : eventListMap.entrySet()) {
            Object className = entry.getKey();
            List events = (List)entry.getValue();
            if (!Objects.nonNull(events) || events.isEmpty()) continue;
            for (Object event : events) {
                Map eventMap = (Map)event;
                int rowIndex = this.getModel().createNewEntryRow(ENTRY_EVENT_ENTRY_KEY);
                this.getModel().setValue(ENTRY_EVENT_CLASS_NAME, className, rowIndex);
                this.getModel().setValue(ENTRY_EVENT_ID, eventMap.get(PLUGIN_EVENT_ID), rowIndex);
                EventMethod eventMethod = EventMethodTypes.getEventMethod((String)String.valueOf(eventMap.get(PLUGIN_EVENT_ID)));
                this.getModel().setValue(ENTRY_EVENT_NAME, (Object)eventMethod.getMethodName(), rowIndex);
                if (eventMap.get(PLUGIN_EVENT_PARAM_CONDITION) instanceof Map) {
                    Map paramMap = (Map)eventMap.get(PLUGIN_EVENT_PARAM_CONDITION);
                    this.getModel().setValue(ENTRY_EVENT_SIMPLE_EXPR, paramMap.get(PLUGIN_EVENT_SIMPLE_EXPR), rowIndex);
                    this.getModel().setValue(ENTRY_EVENT_EXPRESSION, paramMap.get(PLUGIN_EVENT_EXPRESSION), rowIndex);
                }
                this.getModel().setValue(ENTRY_EVENT_ACTION, eventMap.get(PLUGIN_EVENT_ACTION), rowIndex);
                this.getModel().setValue(ENTRY_EVENT_REMARK, eventMap.get(PLUGIN_EVENT_REMARK), rowIndex);
            }
        }
    }

    private void addEvents(List<Map<String, Object>> plugins) {
        for (Map<String, Object> mapPlugin : plugins) {
            for (Map<String, Object> eventMap : this.getEventsFromEntryEntity()) {
                if (!Objects.equals(eventMap.get(ENTRY_EVENT_CLASS_NAME), mapPlugin.get(PLUGIN_CLASS_NAME))) continue;
                ArrayList events = mapPlugin.get(PLUGIN_EVENTS);
                if (Objects.isNull(events)) {
                    events = new ArrayList();
                }
                ((List)events).add(eventMap);
                mapPlugin.putIfAbsent(PLUGIN_EVENTS, events);
            }
        }
    }

    private List<Map<String, Object>> getEventsFromEntryEntity() {
        ArrayList<Map<String, Object>> events = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection eventDoc = this.getModel().getEntryEntity(ENTRY_EVENT_ENTRY_KEY);
        if (Objects.nonNull(eventDoc) && !eventDoc.isEmpty()) {
            for (DynamicObject obj : eventDoc) {
                HashMap<String, Object> eventMap = new HashMap<String, Object>(16);
                eventMap.put(ENTRY_EVENT_CLASS_NAME, obj.getString(ENTRY_EVENT_CLASS_NAME));
                eventMap.put(PLUGIN_EVENT_ID, obj.getString(ENTRY_EVENT_ID));
                eventMap.put(ENTRY_EVENT_NAME, obj.getString(ENTRY_EVENT_NAME));
                if (StringUtils.isNotBlank((CharSequence)obj.getString(ENTRY_EVENT_EXPRESSION))) {
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    paramMap.put(PLUGIN_EVENT_SIMPLE_EXPR, obj.getString(ENTRY_EVENT_SIMPLE_EXPR));
                    paramMap.put(PLUGIN_EVENT_EXPRESSION, obj.getString(ENTRY_EVENT_EXPRESSION));
                    eventMap.put(PLUGIN_EVENT_PARAM_CONDITION, paramMap);
                }
                eventMap.put(PLUGIN_EVENT_ACTION, StringUtils.isBlank((CharSequence)obj.getString(ENTRY_EVENT_ACTION)) ? EventAction.OVERRIDE.name() : obj.getString(ENTRY_EVENT_ACTION));
                eventMap.put(PLUGIN_EVENT_REMARK, obj.getString(ENTRY_EVENT_REMARK));
                events.add(eventMap);
            }
        }
        return events;
    }

    private void addToEventModel(Map<String, Object> eventMap) {
        for (Map<String, Object> eventPluginMap : this.getEventsFromEntryEntity()) {
            if (!Objects.equals(eventMap.get(ENTRY_EVENT_ID), eventPluginMap.get(PLUGIN_EVENT_ID)) || !Objects.equals(eventMap.get(ENTRY_EVENT_CLASS_NAME), eventPluginMap.get(ENTRY_EVENT_CLASS_NAME))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0\u4e8b\u4ef6\u3002", (String)"FormPluginsPlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        int rowIndex = this.getModel().createNewEntryRow(ENTRY_EVENT_ENTRY_KEY);
        this.editEventModel(eventMap, rowIndex);
    }

    private void editEventModel(Map<String, Object> eventMap, int rowIndex) {
        this.getModel().setValue(ENTRY_EVENT_NAME, eventMap.get(ENTRY_EVENT_NAME), rowIndex);
        this.getModel().setValue(ENTRY_EVENT_ID, eventMap.get(ENTRY_EVENT_ID), rowIndex);
        this.getModel().setValue(ENTRY_EVENT_SIMPLE_EXPR, eventMap.get(ENTRY_EVENT_SIMPLE_EXPR), rowIndex);
        this.getModel().setValue(ENTRY_EVENT_EXPRESSION, eventMap.get(ENTRY_EVENT_EXPRESSION), rowIndex);
        this.getModel().setValue(ENTRY_EVENT_ACTION, (Object)EventAction.OVERRIDE.name(), rowIndex);
        this.getModel().setValue(ENTRY_EVENT_CLASS_NAME, eventMap.get(ENTRY_EVENT_CLASS_NAME), rowIndex);
        this.getModel().setValue(ENTRY_EVENT_REMARK, eventMap.get(ENTRY_EVENT_REMARK), rowIndex);
    }

    private void eventAdd() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_addevent");
        parameter.setCustomParam("id", (Object)this.getFormMeta().getId());
        parameter.setCustomParam("plugins", this.getPluginsFromEntryEntity());
        List<Map<String, Object>> events = this.getEventsFromEntryEntity();
        parameter.setCustomParam("events", events);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addevent"));
        this.getView().showForm(parameter);
    }

    private void eventEdit() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_EVENT_ENTRY_KEY);
        int rowIndex = grid.getEntryState().getFocusRow();
        if (this.getModel().getEntryRowCount(ENTRY_EVENT_ENTRY_KEY) > 0 && rowIndex >= 0) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("ide_addevent");
            parameter.setCustomParam("id", (Object)this.getFormMeta().getId());
            parameter.setCustomParam("plugins", this.getPluginsFromEntryEntity());
            List<Map<String, Object>> events = this.getEventsFromEntryEntity();
            parameter.setCustomParam("events", events);
            parameter.setCustomParam("curevent", events.get(rowIndex));
            parameter.setCustomParam("rowIndex", (Object)rowIndex);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "editevent"));
            this.getView().showForm(parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e8b\u4ef6\u3002", (String)"FormPluginsPlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void setEventTabVisible(boolean visible) {
        HashMap<String, Integer> prop = new HashMap<String, Integer>(1);
        prop.put("vi", visible ? 63 : 0);
        this.getView().updateControlMetadata("eventtab", prop);
    }

    @Override
    protected void fireSwitchTabEvent(SwitchDesignerTabEvent e) {
        e.addSetPropActionData(this.getTabPageData());
    }

    @Override
    protected void fireMergeTabDataEvent(MergeDesignerTabDataEvent e) {
        this.mergeFormMeta(e.getProDesignerContent(), this.getTabPageData());
    }

    @Override
    protected void fireTabCloseEvent(DesignerTabCloseEvent e) {
        if (e.isForce()) {
            super.fireTabCloseEvent(e);
            return;
        }
        e.addSetPropActionData(this.getTabPageData());
    }

    private List<Map<String, Object>> getTabPageData() {
        Map<String, Object> data = this.buildPagePropData();
        if (data.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(data);
    }

    @Override
    protected String getTabId() {
        return "pluginmanage";
    }

    private String getModelType() {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
        String scriptfiltertype = (String)this.getView().getFormShowParameter().getCustomParam("scriptfiltertype");
        if ("writebackplugin".equalsIgnoreCase(scriptfiltertype)) {
            modelType = "WriteBackRuleModel";
            return modelType;
        }
        if (StringUtils.isBlank((CharSequence)modelType) && StringUtils.isBlank((CharSequence)(modelType = (String)this.getView().getFormShowParameter().getCustomParam("formModelType")))) {
            PropertyEditHelper propertyEditHelper = new PropertyEditHelper();
            modelType = propertyEditHelper.getModelType(this.getView());
        }
        return modelType;
    }
}

