/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.form.designer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.PropertyEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.entity.rule.BizRule;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.cardentry.CardEntryAp;
import kd.bos.metadata.form.cardentry.CardEntryFlexPanelAp;
import kd.bos.metadata.form.cardentry.CardEntryRowAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.rule.FormRuleActionType;
import kd.bos.metadata.form.rule.FormRuleActionTypeCache;
import kd.bos.metadata.list.CardRowPanelAp;
import kd.bos.metadata.list.ListCardViewAp;
import kd.bos.metadata.list.ListGridViewAp;
import kd.bos.newdevportal.designer.AbstractFormDesignerTabPlugin;
import kd.bos.newdevportal.designer.DesignerTabCloseEvent;
import kd.bos.newdevportal.designer.MergeDesignerTabDataEvent;
import kd.bos.newdevportal.designer.SwitchDesignerTabEvent;
import kd.bos.newdevportal.entity.designer.rules.BusinessRulesPlugin;

public class FormRulesPlugin
extends AbstractFormDesignerTabPlugin
implements ClickListener,
RowClickEventListener,
HyperLinkClickListener,
TreeNodeClickListener {
    private static final Log log = LogFactory.getLog(BusinessRulesPlugin.class);
    private static final String KEY_ENTITY = "entryentity";
    private static final String KEY_TUREENTRY = "trueentryentity";
    private static final String KEY_FALSEENTRY = "falseentryentity";
    private static final String KEY_TRUEADD = "trueadd";
    private static final String KEY_TRUEUPDATE = "trueupdate";
    private static final String KEY_FALSEADD = "falseadd";
    private static final String KEY_FALSEUPDATE = "falseupdate";
    private static final String KEY_PRE_DESCRIPTION = "predescription";
    private static final String VALUE = "value";
    private static final String KEY_DESCRIPTION = "description";
    private static final String PROP_DESCRIPTION = "Description";
    private static final String KEY_PRECONDITION = "precondition";
    private static final String PROP_PRE_DESCRIPTION = "PreDescription";
    private static final String KEY_ENABLED = "enabled";
    private static final String PROP_ENABLED = "Enabled";
    private static final String KEY_TRUEACTIONS = "trueactions";
    private static final String PROP_TRUEACTIONS = "TrueActions";
    private static final String KEY_FALSEACTIONS = "falseactions";
    private static final String PROP_FALSEACTIONS = "FalseActions";
    private static final String CONTEXT = "context";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final String META_TYPE = "metaType";
    private static final String EXPRESSION = "Expression";
    private static final String RULES_PLUGIN_1 = "RulesPlugin_1";
    private static final String TRUE_RULE_ID = "trueruleid";
    private static final String TRUE_RULE_NAME = "truerulename";
    private static final String TRUE_EXPRESSION = "trueexpression";
    private static final String TRUE_RAISE_EVENT_TYPE = "trueraiseeventtype";
    private static final String RAISE_EVENT_TYPE = "RaiseEventType";
    private static final String FALSE_RULE_NAME = "falserulename";
    private static final String FALSE_RULE_ID = "falseruleid";
    private static final String FALSE_RAISE_EVENT_TYPE = "falseraiseeventtype";
    private static final String FALSE_EXPRESSION = "falseexpression";
    private static final String KEY_TREEVIEW = "treeviewap";
    private static final String KEY_TYPE = "type";
    private static final String KEY_CURRNODEID = "currNodeId";
    private static final String CACHEKEY_TREENODE = "nodecachekey";
    private static final String KEY_RULEROOLBAR = "ruletoolbar";
    private static final String KEY_TRUEACTIONTOOLBAR = "trueactiontoolbar";
    private static final String KEY_FALSEACTIONTOOLBAR = "falseactiontoolbar";
    private TreeNode root;

    private static String getString() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u89c4\u5219", (String)"FormRulesPlugin_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
    }

    private void addEntryGridRowClickListener(String entryKey) {
        EntryGrid falseEntryGrid = (EntryGrid)this.getControl(entryKey);
        falseEntryGrid.addRowClickListener((RowClickEventListener)this);
        falseEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    private boolean isEntryGridExist(String entryKey) {
        EntryGrid falseEntryGrid = (EntryGrid)this.getControl(entryKey);
        return falseEntryGrid != null;
    }

    public void initialize() {
        this.addClickListeners(new String[]{"add", "update", "delete", "up", "down", "save", "detail", KEY_TRUEADD, "truedelete", KEY_TRUEUPDATE, KEY_FALSEADD, "falsedelete", KEY_FALSEUPDATE, KEY_PRE_DESCRIPTION});
        this.addEntryGridRowClickListener(KEY_ENTITY);
        this.addEntryGridRowClickListener(KEY_TUREENTRY);
        if (this.isEntryGridExist(KEY_FALSEENTRY)) {
            this.addEntryGridRowClickListener(KEY_FALSEENTRY);
        }
        this.addItemClickListeners(new String[]{KEY_RULEROOLBAR, KEY_TRUEACTIONTOOLBAR, KEY_FALSEACTIONTOOLBAR});
        TreeView tView = (TreeView)this.getControl(KEY_TREEVIEW);
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    private Map<String, Object> getCustomParams() {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        FormMetadata formMetadata = this.getFormMeta();
        MetadataSerializer ser = new MetadataSerializer(formMetadata.getModelType());
        DomainModelBinder binder = (DomainModelBinder)ser.getBinder();
        binder.setLCId("zh_CN");
        binder.setWriteInheritFlag(true);
        Map data = ser.serializeToMap((Object)formMetadata);
        List items = (List)data.get("Items");
        String itemId = this.getPageCache().get(KEY_CURRNODEID) != null ? this.getPageCache().get(KEY_CURRNODEID) : formMetadata.getRootAp().getId();
        Map item = ser.serializeToMap((Object)formMetadata.getItem(itemId));
        String entityItemId = itemId;
        ControlAp controlAp = this.getFormMeta().getItem(itemId);
        customParams.put("includeParentEntity", "true");
        String propertyName = "ClientRules";
        if (controlAp instanceof EntryAp) {
            propertyName = "Rules";
            entityItemId = ((EntryAp)controlAp).getEntryId();
        } else if (controlAp instanceof FormAp) {
            propertyName = "Rules";
        } else if (controlAp instanceof CardEntryRowAp) {
            EntryAp parent = null;
            String parentId = controlAp.getParentId();
            customParams.put("includeParentEntity", "true");
            while (parent == null && StringUtils.isNotBlank((CharSequence)parentId)) {
                ControlAp p = this.getFormMeta().getItem(parentId);
                if (p instanceof EntryAp) {
                    parent = (EntryAp)p;
                    break;
                }
                if (p != null) {
                    parentId = p.getParentId();
                    continue;
                }
                parentId = "";
            }
            if (parent != null) {
                entityItemId = parent.getEntryId();
            }
        }
        customParams.put("itemId", itemId);
        customParams.put("entityItemId", entityItemId);
        customParams.put("designerPageId", this.getView().getPageId());
        customParams.put("modelType", formMetadata.getModelType());
        customParams.put(META_TYPE, "formmeta");
        ArrayList<List> contextvalue = new ArrayList<List>();
        contextvalue.add(items);
        List entityItems = (List)ser.serializeToMap((Object)this.getEntityMeta(this.getView().getFormShowParameter())).get("Items");
        contextvalue.add(entityItems);
        ArrayList<Map> cons3 = new ArrayList<Map>();
        cons3.add(item);
        contextvalue.add(cons3);
        customParams.put(CONTEXT, contextvalue);
        customParams.put("isproformdesign", "true");
        List<Map<String, Object>> formItems = this.getFormItemMetaList(this.getView().getFormShowParameter(), "formmeta");
        customParams.put("proFormStr", SerializationUtils.toJsonString(formItems));
        customParams.put("proEntityStr", SerializationUtils.toJsonString(ser.serializeToMap((Object)this.getEntityMeta(this.getView().getFormShowParameter())).get("Items")));
        String metaType = this.getFormModelType(this.getView().getFormShowParameter());
        LinkedHashMap<String, Cloneable> map = new LinkedHashMap<String, Cloneable>();
        map.put(CONTEXT, contextvalue);
        LinkedHashMap<String, String> formParams = new LinkedHashMap<String, String>(3);
        formParams.put("formId", this.getView().getFormShowParameter().getFormId());
        map.put("form", formParams);
        PropertyEvent propertyEvent = new PropertyEvent((Object)this, itemId, metaType, propertyName, map);
        PropertyEditHelper.cachePropEventParam((IFormView)this.getView(), (PropertyEvent)propertyEvent);
        return customParams;
    }

    private TreeNode getRootTreeNode() {
        if (this.root != null) {
            return this.root;
        }
        String rootNodeStr = this.getPageCache().get(CACHEKEY_TREENODE);
        if (rootNodeStr == null) {
            return null;
        }
        this.root = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
        return this.root;
    }

    private void updateRootNode(TreeNode root) {
        this.getPageCache().put(CACHEKEY_TREENODE, SerializationUtils.toJsonString((Object)root));
        this.root = null;
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put("designerPageId", this.getView().getPageId());
        this.getPageCache().put("modelType", this.getFormModelType(this.getView().getFormShowParameter()));
        this.initEntityTree();
        this.renderRules(this.getRootTreeNode());
    }

    private void renderRules(TreeNode root) {
        if (root == null) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"splitpanelap", "splitpanelap1"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_RULEROOLBAR, KEY_TRUEACTIONTOOLBAR, KEY_FALSEACTIONTOOLBAR});
            return;
        }
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"splitpanelap", "splitpanelap1"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_RULEROOLBAR, KEY_TRUEACTIONTOOLBAR, KEY_FALSEACTIONTOOLBAR});
        List value = (List)root.getData();
        DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_ENTITY);
        rows.clear();
        DynamicObjectCollection trueRows = this.getModel().getEntryEntity(KEY_TUREENTRY);
        trueRows.clear();
        DynamicObjectCollection falseRows = this.getModel().getEntryEntity(KEY_FALSEENTRY);
        falseRows.clear();
        this.getModel().deleteEntryData(KEY_ENTITY);
        this.getModel().deleteEntryData(KEY_TUREENTRY);
        this.getModel().deleteEntryData(KEY_FALSEENTRY);
        String itemId = root.getId();
        ControlAp ctl = this.getFormMeta().getItem(itemId);
        if (ctl instanceof CardEntryRowAp || ctl instanceof CardEntryFlexPanelAp || ctl instanceof ListGridViewAp) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"id"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"falseactionflex", KEY_PRECONDITION, KEY_DESCRIPTION});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"falseactionflex", KEY_PRECONDITION, KEY_ENABLED, KEY_DESCRIPTION});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"id"});
        }
        if (StringUtils.isBlank((Object)value) || value.isEmpty()) {
            return;
        }
        DataEntityPropertyCollection props = this.getModel().getEntryEntity(KEY_ENTITY).getDynamicObjectType().getProperties();
        for (Map rule : value) {
            int rowKey = this.getModel().createNewEntryRow(KEY_ENTITY);
            if (this.getModel().getProperty("id") != null) {
                this.getModel().setValue("id", rule.get("Id"), rowKey);
            }
            this.getModel().setValue(KEY_TYPE, rule.get("_Type_"), rowKey);
            if (props.get((Object)KEY_DESCRIPTION) != null) {
                this.getModel().setValue(KEY_DESCRIPTION, rule.get(PROP_DESCRIPTION), rowKey);
            }
            this.getModel().setValue(KEY_PRECONDITION, rule.get("PreCondition"), rowKey);
            this.getModel().setValue(KEY_PRE_DESCRIPTION, rule.get(PROP_PRE_DESCRIPTION), rowKey);
            if (props.get((Object)KEY_ENABLED) != null) {
                this.getModel().setValue(KEY_ENABLED, (Object)(rule.get(PROP_ENABLED) == null ? Boolean.valueOf(true) : rule.get(PROP_ENABLED)), rowKey);
            }
            this.getModel().setValue(KEY_TRUEACTIONS, (Object)(rule.get(PROP_TRUEACTIONS) == null ? "[]" : SerializationUtils.toJsonString(rule.get(PROP_TRUEACTIONS))), rowKey);
            if (this.getModel().getDataEntityType().getProperties().get((Object)KEY_FALSEENTRY) == null) continue;
            this.getModel().setValue(KEY_FALSEACTIONS, (Object)(rule.get(PROP_FALSEACTIONS) == null ? "[]" : SerializationUtils.toJsonString(rule.get(PROP_FALSEACTIONS))), rowKey);
        }
        EntryGrid grid = (EntryGrid)this.getControl(KEY_ENTITY);
        int currentRow = grid.getEntryState().getFocusRow();
        if (currentRow <= 0) {
            currentRow = 0;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        IDataModel model = this.getModel();
        map.put(PROP_TRUEACTIONS, model.getValue(KEY_TRUEACTIONS, currentRow));
        if (this.getModel().getDataEntityType().getProperties().get((Object)KEY_FALSEENTRY) != null) {
            map.put(PROP_FALSEACTIONS, model.getValue(KEY_FALSEACTIONS, currentRow));
        }
        this.createConditionData(map);
        this.getView().updateView();
    }

    public void afterBindData(EventObject e) {
        EntryGrid grid = (EntryGrid)this.getControl(KEY_ENTITY);
        int currentRow = grid.getEntryState().getFocusRow();
        if (currentRow <= 0) {
            currentRow = 0;
            int[] selectRow = new int[]{currentRow};
            grid.selectRows(selectRow, currentRow);
        } else {
            int[] selectRow = new int[]{currentRow};
            grid.selectRows(selectRow, currentRow);
        }
    }

    private TreeNode initEntityTree() {
        FormMetadata formMetadata = this.getFormMeta();
        TreeNode root = null;
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(BizRule.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        String metaTypeId = this.getMetaViewId();
        if ("formmeta".equals(metaTypeId)) {
            ArrayList<Map> childRules;
            List rules;
            TreeNode childrenNode;
            root = new TreeNode("", formMetadata.getRootAp().getId(), formMetadata.getRootAp().getName().toString());
            root.setIsOpened(true);
            List rootApRules = formMetadata.getRootAp().getRules();
            if (rootApRules != null) {
                ArrayList<Map> rootRules = new ArrayList<Map>(rootApRules.size());
                Iterator iterator = rootApRules.iterator();
                while (iterator.hasNext()) {
                    BizRule rule = (BizRule)iterator.next();
                    rootRules.add(ser.serializeToMap((Object)rule, null));
                }
                root.setData(rootRules);
            }
            ArrayList<String> cardEntryRowIds = new ArrayList<String>(3);
            for (ControlAp item : formMetadata.getItems()) {
                if (item instanceof FormAp) continue;
                if (item instanceof EntryAp) {
                    String id = item.getId();
                    childrenNode = new TreeNode();
                    childrenNode.setId(id);
                    childrenNode.setText(item.getName().toString());
                    root.addChild(childrenNode);
                    rules = ((EntryAp)item).getRules();
                    if (rules == null) continue;
                    childRules = new ArrayList(rules.size());
                    for (BizRule rule : rules) {
                        childRules.add(ser.serializeToMap((Object)rule, null));
                    }
                    childrenNode.setData(childRules);
                    continue;
                }
                if (!(item instanceof CardEntryRowAp)) continue;
                cardEntryRowIds.add(item.getId());
            }
            formMetadata.createIndex();
            for (String rowId : cardEntryRowIds) {
                TreeNode parentNode;
                CardEntryRowAp rowAp = (CardEntryRowAp)formMetadata.getItem(rowId);
                childrenNode = new TreeNode();
                childrenNode.setId(rowId);
                childrenNode.setText(rowAp.getName().toString());
                rules = rowAp.getClientRules();
                if (rules != null) {
                    childRules = new ArrayList<Map>(rules.size());
                    for (BizRule rule : rules) {
                        childRules.add(ser.serializeToMap((Object)rule, null));
                    }
                    childrenNode.setData(childRules);
                }
                String entryId = null;
                ControlAp parent = formMetadata.getItem(rowAp.getParentId());
                while (parent != null) {
                    if (parent instanceof EntryAp) {
                        entryId = parent.getId();
                        break;
                    }
                    parent = formMetadata.getItem(parent.getParentId());
                }
                List<TreeNode> childs = (parentNode = root.getTreeNode(entryId, 5)).getChildren() == null ? new ArrayList(3) : parentNode.getChildren();
                childs.add(childrenNode);
                parentNode.setChildren(childs);
            }
        } else if ("listmeta".equals(metaTypeId)) {
            for (ControlAp ctl : formMetadata.getItems()) {
                if (!(ctl instanceof ListGridViewAp)) continue;
                root = new TreeNode("", ctl.getId(), ctl.getName().toString());
                root.setIsOpened(true);
                List rootApRules = ((ListGridViewAp)ctl).getClientRules();
                if (rootApRules == null) break;
                ArrayList<Map> rootRules = new ArrayList<Map>(rootApRules.size());
                for (BizRule rule : rootApRules) {
                    rootRules.add(ser.serializeToMap((Object)rule, null));
                }
                root.setData(rootRules);
                break;
            }
        }
        if (root == null) {
            return null;
        }
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        tree.deleteAllNodes();
        tree.addNode(root);
        this.getPageCache().put(KEY_CURRNODEID, root.getId());
        this.updateRootNode(root);
        tree.focusNode(root);
        return root;
    }

    private List<Map<String, Object>> getDetailPageRules(StringBuilder errMsg) {
        ArrayList<Map<String, Object>> ruleMapList = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection collection = this.getModel().getEntryEntity(KEY_ENTITY);
        int mustInput = -1;
        String mustContext = ResManager.loadKDString((String)"\u89c4\u5219\u63cf\u8ff0", (String)"FormRulesPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
        for (DynamicObject obj : collection) {
            Object falseactions;
            HashMap<String, Object> map = new HashMap<String, Object>();
            Object trueactions = obj.get(KEY_TRUEACTIONS);
            if (!StringUtils.isBlank((Object)trueactions)) {
                map.put(PROP_TRUEACTIONS, SerializationUtils.fromJsonString((String)obj.get(KEY_TRUEACTIONS).toString(), List.class));
            }
            if (obj.getDataEntityType().getProperties().get((Object)KEY_FALSEACTIONS) != null && !StringUtils.isBlank((Object)(falseactions = obj.get(KEY_FALSEACTIONS)))) {
                map.put(PROP_FALSEACTIONS, SerializationUtils.fromJsonString((String)obj.get(KEY_FALSEACTIONS).toString(), List.class));
            }
            if (obj.getDataEntityType().getProperties().get((Object)KEY_PRE_DESCRIPTION) != null && StringUtils.isBlank((Object)obj.get(KEY_PRE_DESCRIPTION))) {
                mustContext = ResManager.loadKDString((String)"\u524d\u7f6e\u63cf\u8ff0", (String)"FormRulesPlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                mustInput = obj.getInt("seq");
                break;
            }
            if (obj.getDataEntityType().getProperties().get((Object)KEY_DESCRIPTION) != null) {
                Object description = obj.get(KEY_DESCRIPTION);
                map.put(PROP_DESCRIPTION, description);
                if ("FormRule".equals(obj.get(KEY_TYPE)) && StringUtils.isBlank((Object)description)) {
                    ResManager.loadKDString((String)"\u89c4\u5219\u63cf\u8ff0", (String)"FormRulesPlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
                    mustInput = obj.getInt("seq");
                    break;
                }
            }
            if (this.getModel().getProperty("id") != null) {
                String id = (String)obj.get("id");
                if (StringUtils.isEmpty((CharSequence)id)) {
                    id = Uuid16.create().toString();
                }
                map.put("Id", id);
            }
            map.put("PreCondition", obj.get(KEY_PRECONDITION));
            map.put(PROP_PRE_DESCRIPTION, obj.get(KEY_PRE_DESCRIPTION));
            map.put("_Type_", obj.get(KEY_TYPE));
            if (obj.getDataEntityType().getProperties().get((Object)PROP_ENABLED) != null) {
                map.put(PROP_ENABLED, obj.get(KEY_ENABLED) == null ? Boolean.valueOf(true) : obj.get(KEY_ENABLED));
            } else {
                map.put(PROP_ENABLED, true);
            }
            ruleMapList.add(map);
        }
        if (mustInput > -1) {
            errMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u201c%2$s\u201d\u5fc5\u586b", (String)"FormRulesPlugin_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), mustInput, mustContext));
            return null;
        }
        return ruleMapList;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (KEY_ENTITY.equals(e.getEntryProp().getName())) {
            TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
            String nodeId = treeView.getTreeState().getFocusNodeId();
            ControlAp ctl = this.getFormMeta().getItem(nodeId);
            if (ctl instanceof EntryAp || ctl instanceof FormAp) {
                this.getModel().setValue(KEY_TYPE, (Object)"FormRule", e.getRowDataEntities()[0].getRowIndex());
            } else {
                this.getModel().setValue(KEY_TYPE, (Object)"ClientRule", e.getRowDataEntities()[0].getRowIndex());
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = (String)e.getNodeId();
        String rootNodeStr = this.getPageCache().get(CACHEKEY_TREENODE);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
        StringBuilder err = new StringBuilder();
        List<Map<String, Object>> rules = this.getDetailPageRules(err);
        String msg = err.toString();
        String currentId = this.getPageCache().get(KEY_CURRNODEID);
        TreeNode currentNode = root.getTreeNode(currentId, 3);
        if (rules == null && err.length() > 0) {
            this.getView().showErrorNotification(msg);
            TreeView tView = (TreeView)this.getControl(KEY_TREEVIEW);
            tView.focusNode(currentNode);
            return;
        }
        TreeNode node = root.getTreeNode(nodeId, 3);
        currentNode.setData(rules);
        this.getPageCache().put(CACHEKEY_TREENODE, SerializationUtils.toJsonString((Object)root));
        this.renderRules(node);
        this.getPageCache().put(KEY_CURRNODEID, nodeId);
    }

    protected void attachParameter(FormShowParameter parameter) {
        String prefix;
        List contextList = (List)this.getCustomParams().get(CONTEXT);
        Object context = contextList.get(0);
        String controlId = ((Map)((List)contextList.get(contextList.size() - 1)).get(0)).get("Id").toString();
        String clzName = ((Map)((List)contextList.get(contextList.size() - 1)).get(0)).get("_Type_").toString();
        parameter.setCustomParam(CONTEXT, context);
        switch (clzName) {
            case "EntryAp": {
                prefix = "kd.bos.metadata.form.control.";
                break;
            }
            case "ListGridViewAp": 
            case "CardRowPanelAp": 
            case "ListCardViewAp": {
                prefix = "kd.bos.metadata.list.";
                break;
            }
            case "CardEntryRowAp": 
            case "CardEntryAp": 
            case "SubCardEntryAp": {
                prefix = "kd.bos.metadata.form.cardentry.";
                break;
            }
            default: {
                Object prefix2 = null;
                return;
            }
        }
        try {
            Class<?> clz = Class.forName(prefix + clzName);
            Object newInst = clz.newInstance();
            if (newInst instanceof EntryAp || newInst instanceof ListCardViewAp || newInst instanceof ListGridViewAp || newInst instanceof CardRowPanelAp || newInst instanceof CardEntryAp || newInst instanceof CardEntryRowAp) {
                parameter.setCustomParam("controlId", (Object)controlId);
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u89c4\u5219\u51fa\u73b0\u9519\u8bef\u3002", (String)"FormRulesPlugin_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void add() {
        int rowKey = this.getModel().createNewEntryRow(KEY_ENTITY);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(KEY_ENTITY);
        grid.getEntryState().selectRow(rowKey);
        this.getModel().deleteEntryData(KEY_TUREENTRY);
        if (this.isEntryGridExist(KEY_FALSEENTRY)) {
            this.getModel().deleteEntryData(KEY_FALSEENTRY);
        }
    }

    protected void ruleAdd(String key) {
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "ide_serviceedit");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        showParameter.setParentFormId(this.getView().getFormShowParameter().getParentFormId());
        this.attachParameter(showParameter);
        showParameter.setCustomParam(META_TYPE, (Object)"formmeta");
        showParameter.setCustomParam("serviceType", (Object)this.getServiceType());
        showParameter.setCustomParam("designerPageId", (Object)this.getView().getPageId());
        this.getView().showForm(showParameter);
    }

    private int getServiceType() {
        String nodeId = this.getPageCache().get(KEY_CURRNODEID);
        ControlAp ctl = this.getFormMeta().getItem(nodeId);
        if (ctl instanceof EntryAp || ctl instanceof FormAp) {
            return 1;
        }
        if (ctl instanceof ListGridViewAp) {
            return 8;
        }
        return 2;
    }

    protected void ruleUpdate(String update, String entryKey, String ruleName, String ruleId, String expression, String ret) {
        HashMap<String, Object> currentRow = new HashMap<String, Object>();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(entryKey);
        if (grid == null) {
            return;
        }
        int selectRows = grid.getEntryState().getFocusRow();
        int count = this.getModel().getEntryRowCount(entryKey);
        if (selectRows > -1 && count > 0) {
            IDataModel rowData = this.getModel();
            if (rowData != null) {
                currentRow.put("RuleName", rowData.getValue(ruleName, selectRows));
                currentRow.put("RuleId", rowData.getValue(ruleId, selectRows));
                currentRow.put(EXPRESSION, rowData.getValue(expression, selectRows));
                currentRow.put("RET", rowData.getValue(ret, selectRows));
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setFormId("ide_serviceedit");
                parameter.setCustomParam(VALUE, currentRow);
                parameter.setParentFormId(this.getView().getFormShowParameter().getParentFormId());
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, update + "&" + selectRows));
                this.attachParameter(parameter);
                parameter.setCustomParam(META_TYPE, (Object)this.getFormModelType(this.getView().getFormShowParameter()));
                parameter.setCustomParam("serviceType", (Object)this.getServiceType());
                parameter.setCustomParam("designerPageId", (Object)this.getView().getPageId());
                this.getView().showForm(parameter);
            } else {
                this.getView().showTipNotification(FormRulesPlugin.getString());
            }
        } else {
            this.getView().showTipNotification(FormRulesPlugin.getString());
        }
    }

    protected void delete() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTITY);
        int[] selectRows = grid.getEntryState().getSelectedRows();
        if (selectRows != null && selectRows.length > 0) {
            this.getModel().deleteEntryData(KEY_TUREENTRY);
            if (this.isEntryGridExist(KEY_FALSEENTRY)) {
                this.getModel().deleteEntryData(KEY_FALSEENTRY);
            }
            this.getModel().deleteEntryRows(KEY_ENTITY, selectRows);
        } else {
            this.getView().showTipNotification(FormRulesPlugin.getString());
        }
        int count = this.getModel().getEntryRowCount(KEY_ENTITY);
        if (count > 0) {
            this.selRowEvent(0);
        }
    }

    protected void delete(String entryKey) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(entryKey);
        int[] selectRows = grid.getEntryState().getSelectedRows();
        if (selectRows != null && selectRows.length > 0) {
            this.getModel().deleteEntryRows(entryKey, selectRows);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u89c4\u5219", (String)"FormRulesPlugin_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void up(String entryKey) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(entryKey);
        if (grid == null) {
            return;
        }
        int[] rowsIndex = grid.getEntryState().getSelectedRows();
        if (rowsIndex.length < 1 || rowsIndex[0] < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u4f53\u9879\u3002", (String)"FormRulesPlugin_6", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (rowsIndex[0] == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u4e3a\u7b2c\u4e00\u884c\u3002", (String)"FormRulesPlugin_7", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), Integer.valueOf(1000));
            return;
        }
        this.getModel().moveEntryRowsUp(entryKey, rowsIndex);
    }

    private void down(String entryKey) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(entryKey);
        if (grid == null) {
            return;
        }
        int[] rowsIndex = grid.getEntryState().getSelectedRows();
        int rowLength = this.getModel().getEntryRowCount(entryKey);
        if (rowsIndex.length < 1 || rowLength <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u4f53\u9879", (String)"FormRulesPlugin_8", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), Integer.valueOf(1000));
            return;
        }
        if (rowsIndex[0] == rowLength - 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u4e3a\u6700\u540e\u4e00\u884c", (String)"FormRulesPlugin_9", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), Integer.valueOf(1000));
            return;
        }
        this.getModel().moveEntryRowsDown(entryKey, rowsIndex);
    }

    protected FormShowParameter getFormShowParameter(String condition) {
        AbstractGrid entryGrid = (AbstractGrid)this.getView().getControl(KEY_ENTITY);
        int entrySelRow = entryGrid.getEntryState().getFocusRow();
        Map<String, Object> clientParams = this.getCustomParams();
        HashMap<String, String> para = new HashMap<String, String>();
        HashMap<String, Object> currentPreDate = new HashMap<String, Object>();
        currentPreDate.put("RuleDescription", this.getModel().getValue(KEY_PRE_DESCRIPTION, entrySelRow));
        currentPreDate.put("RuleCondition", this.getModel().getValue(KEY_PRECONDITION, entrySelRow));
        para.put("formId", "ide_preconditiondesign");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, condition + "&" + entrySelRow));
        showParameter.setCustomParam(VALUE, currentPreDate);
        showParameter.setCustomParam(CONTEXT, clientParams.get(CONTEXT));
        showParameter.setCustomParam(META_TYPE, clientParams.get(META_TYPE));
        showParameter.setCustomParam("proFormStr", clientParams.get("proFormStr"));
        showParameter.setCustomParam("proEntityStr", clientParams.get("proEntityStr"));
        showParameter.setCustomParam("isproformdesign", (Object)"true");
        showParameter.setCustomParam("itemId", clientParams.get("itemId"));
        showParameter.setCustomParam("entityItemId", clientParams.get("entityItemId"));
        showParameter.setCustomParam("includeParentEntity", clientParams.get("includeParentEntity"));
        showParameter.setCustomParam(META_TYPE, clientParams.get(META_TYPE));
        showParameter.setCustomParam("ruleFormId", (Object)this.getView().getFormShowParameter().getFormId());
        showParameter.setCustomParam("designerPageId", (Object)this.getView().getPageId());
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        String itemId = treeView.getTreeState().getFocusNodeId();
        ControlAp ctl = this.getFormMeta().getItem(itemId);
        if (!(ctl instanceof EntryAp) && !(ctl instanceof FormAp)) {
            showParameter.setCustomParam("triggerContainer", (Object)2);
        }
        return showParameter;
    }

    protected void ruleCondition(String condition) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty("TextAreaField", "text", (Object)"");
        FormShowParameter showParameter = this.getFormShowParameter(condition);
        this.getView().showForm(showParameter);
    }

    private void createConditionData(Map<String, Object> ops) {
        if (ops != null && ops.size() > 0) {
            List falseList;
            List trueList = (List)SerializationUtils.fromJsonString((String)ops.get(PROP_TRUEACTIONS).toString(), List.class);
            if (trueList != null && trueList.size() > 0) {
                this.initEntity(trueList, KEY_TUREENTRY, TRUE_RULE_ID, TRUE_RULE_NAME, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE);
            }
            if (this.getModel().getDataEntityType().getProperties().get((Object)KEY_FALSEENTRY) != null && (falseList = (List)SerializationUtils.fromJsonString((String)ops.get(PROP_FALSEACTIONS).toString(), List.class)) != null && falseList.size() > 0) {
                this.initEntity(falseList, KEY_FALSEENTRY, "FalseRuleId", "FalseRuleName", "FalseExpression", "falseRaiseEventType");
            }
        }
    }

    private void initEntity(List<Map<String, Object>> trueList, String entityName, String ruleId, String ruleName, String expName, String retName) {
        if (!this.isEntryGridExist(entityName)) {
            return;
        }
        for (int i = 0; i < trueList.size(); ++i) {
            int rowKey = this.getModel().createNewEntryRow(entityName);
            FormRuleActionType tempMetaData = FormRuleActionTypeCache.geFormRuleActionType((String)trueList.get(i).get("ActionType").toString());
            if (tempMetaData != null) {
                this.getModel().setValue(ruleId, (Object)tempMetaData.getId(), rowKey);
                this.getModel().setValue(ruleName, (Object)(trueList.get(i).get(PROP_DESCRIPTION) == null ? "" : trueList.get(i).get(PROP_DESCRIPTION).toString()), rowKey);
                this.getModel().setValue(retName, (Object)(trueList.get(i).get("RET") == null ? "" : trueList.get(i).get("RET").toString()), rowKey);
            }
            this.getModel().setValue(expName, (Object)SerializationUtils.toJsonString(trueList.get(i)), rowKey);
        }
    }

    protected String getRuleAlias(List<Map<String, Object>> ruleMapList) {
        if (ruleMapList == null || ruleMapList.isEmpty()) {
            return "";
        }
        List<Map<String, Object>> ops = ruleMapList;
        StringBuilder alias = new StringBuilder();
        for (Map<String, Object> op : ops) {
            String description;
            boolean enabled = Boolean.parseBoolean(op.get(PROP_ENABLED) == null ? "true" : op.get(PROP_ENABLED).toString());
            String string = description = op.get(PROP_DESCRIPTION) == null ? op.get(PROP_PRE_DESCRIPTION).toString() : op.get(PROP_DESCRIPTION).toString();
            if (!enabled) continue;
            alias.append(alias.length() == 0 ? alias.toString() : "; ").append(description);
        }
        return alias.toString();
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(KEY_PRE_DESCRIPTION)) {
            this.ruleCondition(KEY_PRE_DESCRIPTION);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        Map ruleMap = (Map)e.getReturnData();
        if (this.getView().getControl(KEY_TUREENTRY) != null) {
            this.getView().updateView(KEY_TUREENTRY);
        }
        if (this.getView().getControl(KEY_FALSEENTRY) != null) {
            this.getView().updateView(KEY_FALSEENTRY);
        }
        if (e.getActionId().startsWith(KEY_PRE_DESCRIPTION)) {
            int rowKey = Integer.parseInt(e.getActionId().split("&")[1]);
            this.getModel().setValue(KEY_PRE_DESCRIPTION, ruleMap.get("RuleDescription"), rowKey);
            this.getModel().setValue(KEY_PRECONDITION, ruleMap.get("RuleCondition"), rowKey);
            return;
        }
        if (KEY_TRUEADD.equalsIgnoreCase(e.getActionId())) {
            int rowKey = this.getModel().createNewEntryRow(KEY_TUREENTRY);
            this.getModel().setValue(TRUE_RULE_NAME, ruleMap.get(PROP_DESCRIPTION), rowKey);
            this.getModel().setValue(TRUE_RULE_ID, ruleMap.get("Id"), rowKey);
            this.getModel().setValue(TRUE_RAISE_EVENT_TYPE, ruleMap.get(RAISE_EVENT_TYPE), rowKey);
            this.getModel().setValue(TRUE_EXPRESSION, (Object)ruleMap.get(EXPRESSION).toString(), rowKey);
            this.saveColumnData(ruleMap);
            this.saveActions(e.getActionId(), KEY_TUREENTRY, ruleMap, KEY_TRUEACTIONS, TRUE_RULE_NAME, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE);
        } else if (KEY_FALSEADD.equalsIgnoreCase(e.getActionId())) {
            int rowKey = this.getModel().createNewEntryRow(KEY_FALSEENTRY);
            this.getModel().setValue(FALSE_RULE_NAME, ruleMap.get(PROP_DESCRIPTION), rowKey);
            this.getModel().setValue(FALSE_RULE_ID, ruleMap.get("Id"), rowKey);
            this.getModel().setValue(FALSE_RAISE_EVENT_TYPE, ruleMap.get(RAISE_EVENT_TYPE), rowKey);
            this.getModel().setValue(FALSE_EXPRESSION, (Object)ruleMap.get(EXPRESSION).toString(), rowKey);
            this.saveColumnData(ruleMap);
            this.saveActions(e.getActionId(), KEY_FALSEENTRY, ruleMap, KEY_FALSEACTIONS, FALSE_RULE_NAME, FALSE_EXPRESSION, FALSE_RAISE_EVENT_TYPE);
        } else if (e.getActionId().startsWith(KEY_TRUEUPDATE)) {
            int rowKey = Integer.parseInt(e.getActionId().split("&")[1]);
            this.getModel().setValue(TRUE_RULE_NAME, ruleMap.get(PROP_DESCRIPTION), rowKey);
            this.getModel().setValue(TRUE_RULE_ID, ruleMap.get("Id"), rowKey);
            this.getModel().setValue(TRUE_RAISE_EVENT_TYPE, ruleMap.get(RAISE_EVENT_TYPE), rowKey);
            this.getModel().setValue(TRUE_EXPRESSION, (Object)ruleMap.get(EXPRESSION).toString(), rowKey);
            this.saveActions(e.getActionId(), KEY_TUREENTRY, ruleMap, KEY_TRUEACTIONS, TRUE_RULE_NAME, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE);
        } else if (e.getActionId().startsWith(KEY_FALSEUPDATE)) {
            int rowKey = Integer.parseInt(e.getActionId().split("&")[1]);
            this.getModel().setValue(FALSE_RULE_NAME, ruleMap.get(PROP_DESCRIPTION), rowKey);
            this.getModel().setValue(FALSE_RULE_ID, ruleMap.get("Id"), rowKey);
            this.getModel().setValue(FALSE_RAISE_EVENT_TYPE, ruleMap.get(RAISE_EVENT_TYPE), rowKey);
            this.getModel().setValue(FALSE_EXPRESSION, (Object)ruleMap.get(EXPRESSION).toString(), rowKey);
            this.saveActions(e.getActionId(), KEY_FALSEENTRY, ruleMap, KEY_FALSEACTIONS, FALSE_RULE_NAME, FALSE_EXPRESSION, FALSE_RAISE_EVENT_TYPE);
        }
    }

    private Map<String, Object> saveColumnData(Map<String, Object> ruleMap) {
        Object actions = ruleMap.get(EXPRESSION);
        Map actionMap = null;
        if (!StringUtils.isBlank((Object)actions)) {
            actionMap = (Map)SerializationUtils.fromJsonString((String)actions.toString(), Map.class);
            if (!StringUtils.isBlank((Object)ruleMap.get(PROP_DESCRIPTION))) {
                actionMap.put(PROP_DESCRIPTION, ruleMap.get(PROP_DESCRIPTION));
            }
            if (!StringUtils.isBlank((Object)ruleMap.get(RAISE_EVENT_TYPE))) {
                actionMap.put("RET", ruleMap.get(RAISE_EVENT_TYPE));
            }
        }
        return actionMap;
    }

    void saveActions(String key, String actionEntryKey, Map<String, Object> ruleMap, String actionKey, String ruleName, String expression, String ret) {
        ArrayList<Map> actionList = new ArrayList<Map>();
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTITY);
        if (entryGrid == null) {
            return;
        }
        int entryIndex = entryGrid.getEntryState().getFocusRow();
        int rowCount = this.getModel().getEntryRowCount(actionEntryKey);
        for (int i = 0; i < rowCount; ++i) {
            int rowKey;
            DynamicObject trueObj = this.getModel().getEntryRowEntity(actionEntryKey, i);
            if (key.split("&").length > 1 && i == (rowKey = Integer.parseInt(key.split("&")[1]))) {
                actionList.add(this.saveColumnData(ruleMap));
                continue;
            }
            Object trueactions = trueObj.get(expression);
            if (StringUtils.isBlank((Object)trueactions)) continue;
            Map trueMap = (Map)SerializationUtils.fromJsonString((String)trueactions.toString(), Map.class);
            if (!StringUtils.isBlank((Object)trueObj.get(ruleName))) {
                trueMap.put(PROP_DESCRIPTION, trueObj.get(ruleName));
            }
            if (!StringUtils.isBlank((Object)trueObj.get(ret))) {
                trueMap.put("RET", trueObj.get(ret));
            }
            actionList.add(trueMap);
        }
        this.getModel().setValue(actionKey, (Object)SerializationUtils.toJsonString(actionList), entryIndex);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTITY);
        int index = entryGrid.getEntryState().getFocusRow();
        int count = this.getModel().getEntryRowCount(KEY_ENTITY);
        if (!"add".equals(key)) {
            if (count < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u89c4\u5219\u6761\u4ef6\u3002", (String)"FormRulesPlugin_10", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                return;
            }
            if (index < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u89c4\u5219\u884c\u3002", (String)"FormRulesPlugin_11", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                return;
            }
        }
        if ("add".equals(key)) {
            this.add();
        } else if (KEY_TRUEADD.equals(key) || KEY_FALSEADD.equals(key)) {
            this.ruleAdd(key);
        } else if ("delete".equals(key)) {
            this.delete();
        } else if ("truedelete".equals(key)) {
            this.delete(KEY_TUREENTRY);
            HashMap<String, Object> ruleMap = new HashMap<String, Object>();
            this.saveActions(key, KEY_TUREENTRY, ruleMap, KEY_TRUEACTIONS, TRUE_RULE_NAME, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE);
        } else if ("falsedelete".equals(key)) {
            this.delete(KEY_FALSEENTRY);
            HashMap<String, Object> ruleMap = new HashMap<String, Object>();
            this.saveActions(key, KEY_FALSEENTRY, ruleMap, KEY_FALSEACTIONS, FALSE_RULE_NAME, FALSE_EXPRESSION, FALSE_RAISE_EVENT_TYPE);
        } else if (KEY_TRUEUPDATE.equalsIgnoreCase(key)) {
            this.ruleUpdate(key, KEY_TUREENTRY, TRUE_RULE_NAME, TRUE_RULE_ID, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE);
        } else if (KEY_FALSEUPDATE.equalsIgnoreCase(key)) {
            this.ruleUpdate(key, KEY_FALSEENTRY, FALSE_RULE_NAME, FALSE_RULE_ID, FALSE_EXPRESSION, FALSE_RAISE_EVENT_TYPE);
        } else if ("up".equals(key)) {
            this.up(KEY_ENTITY);
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(KEY_ENTITY);
            int[] rowsIndex = grid.getEntryState().getSelectedRows();
            this.selRowEvent(rowsIndex[0] - 1);
        } else if ("trueup".equalsIgnoreCase(key)) {
            this.up(KEY_TUREENTRY);
        } else if ("falseup".equalsIgnoreCase(key)) {
            this.up(KEY_FALSEENTRY);
        } else if ("down".equals(key)) {
            this.down(KEY_ENTITY);
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(KEY_ENTITY);
            int[] rowsIndex = grid.getEntryState().getSelectedRows();
            this.selRowEvent(rowsIndex[0] + 1);
        } else if ("truedown".equalsIgnoreCase(key)) {
            this.down(KEY_TUREENTRY);
        } else if ("falsedown".equalsIgnoreCase(key)) {
            this.down(KEY_FALSEENTRY);
        }
    }

    private void selRowEvent(int selectRows) {
        List trueList;
        Object trueactions;
        if (selectRows < 0) {
            return;
        }
        IDataModel rowData = this.getModel();
        this.getModel().deleteEntryData(KEY_TUREENTRY);
        if (this.isEntryGridExist(KEY_FALSEENTRY)) {
            List falseList;
            this.getModel().deleteEntryData(KEY_FALSEENTRY);
            Object falseactions = rowData.getValue(KEY_FALSEACTIONS, selectRows);
            if (falseactions == null || StringUtils.isBlank((Object)falseactions)) {
                falseactions = "[]";
            }
            if ((falseList = (List)SerializationUtils.fromJsonString((String)falseactions.toString(), List.class)) != null && !falseList.isEmpty()) {
                this.initEntity(falseList, KEY_FALSEENTRY, FALSE_RULE_ID, FALSE_RULE_NAME, FALSE_EXPRESSION, FALSE_RAISE_EVENT_TYPE);
            }
        }
        if ((trueactions = rowData.getValue(KEY_TRUEACTIONS, selectRows)) == null || StringUtils.isBlank((Object)trueactions)) {
            trueactions = "[]";
        }
        if ((trueList = (List)SerializationUtils.fromJsonString((String)trueactions.toString(), List.class)) != null && trueList.size() > 0) {
            this.initEntity(trueList, KEY_TUREENTRY, TRUE_RULE_ID, TRUE_RULE_NAME, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE);
        }
    }

    public void entryRowClick(RowClickEvent e) {
        EntryGrid entryGrid;
        if (e.getSource() != null && KEY_ENTITY.equals((entryGrid = (EntryGrid)e.getSource()).getKey())) {
            this.selRowEvent(e.getRow());
        }
    }

    public void entryRowDoubleClick(RowClickEvent e) {
        if (e.getSource() != null) {
            EntryGrid entryGrid = (EntryGrid)e.getSource();
            if (KEY_ENTITY.equals(entryGrid.getKey())) {
                this.selRowEvent(e.getRow());
            } else if (KEY_TUREENTRY.equals(entryGrid.getKey())) {
                this.ruleUpdate(KEY_TRUEUPDATE, KEY_TUREENTRY, TRUE_RULE_NAME, TRUE_RULE_ID, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE);
            } else if (KEY_FALSEENTRY.equals(entryGrid.getKey())) {
                this.ruleUpdate(KEY_FALSEUPDATE, KEY_FALSEENTRY, FALSE_RULE_NAME, FALSE_RULE_ID, FALSE_EXPRESSION, FALSE_RAISE_EVENT_TYPE);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }

    private void getReturnData(TreeNode node, List<Map<String, Object>> data) {
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("itemId", node.getId());
        para.put(META_TYPE, "formmeta");
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        ControlAp ctl = this.getFormMeta().getItem(node.getId());
        if (ctl instanceof EntryAp || ctl instanceof FormAp) {
            para.put("propertyName", "Rules");
        } else {
            para.put("propertyName", "ClientRules");
        }
        if (ctl instanceof ListGridViewAp) {
            para.put("designerMetaTypeId", "listmeta");
        }
        para.put(VALUE, node.getData());
        String alias = this.getRuleAlias((List)node.getData());
        para.put("alias", StringUtils.isBlank((CharSequence)alias) ? "\t" : alias);
        data.add(para);
        List childs = node.getChildren();
        if (childs != null && !childs.isEmpty()) {
            for (TreeNode child : childs) {
                this.getReturnData(child, data);
            }
        }
    }

    @Override
    protected void fireTabCloseEvent(DesignerTabCloseEvent e) {
        if (e.isForce()) {
            super.fireTabCloseEvent(e);
            return;
        }
        StringBuilder errBuils = new StringBuilder();
        if (!this.check(errBuils)) {
            e.setCancel(true, errBuils.toString());
            return;
        }
        e.addSetPropActionData(this.getTabPageData());
    }

    @Override
    protected void fireSwitchTabEvent(SwitchDesignerTabEvent e) {
        StringBuilder errBuils = new StringBuilder();
        if (!this.check(errBuils)) {
            e.setCancel(true, errBuils.toString());
            return;
        }
        e.addSetPropActionData(this.getTabPageData());
    }

    @Override
    protected void fireMergeTabDataEvent(MergeDesignerTabDataEvent e) {
        StringBuilder errBuils = new StringBuilder();
        if (!this.check(errBuils)) {
            e.setCancel(true, errBuils.toString());
            return;
        }
        this.mergeFormMeta(e.getProDesignerContent(), this.getTabPageData());
    }

    private boolean check(StringBuilder errBuild) {
        this.getDetailPageRules(errBuild);
        return errBuild.length() <= 0;
    }

    private List<Map<String, Object>> getTabPageData() {
        TreeNode root = this.getRootTreeNode();
        if (root == null) {
            return Collections.emptyList();
        }
        StringBuilder err = new StringBuilder();
        List<Map<String, Object>> data = this.getDetailPageRules(err);
        if (err.length() > 0) {
            return Collections.emptyList();
        }
        String currentId = this.getPageCache().get(KEY_CURRNODEID);
        TreeNode currentNode = root.getTreeNode(currentId, 3);
        currentNode.setData(data);
        this.getPageCache().put(CACHEKEY_TREENODE, SerializationUtils.toJsonString((Object)root));
        ArrayList<Map<String, Object>> itemsRule = new ArrayList<Map<String, Object>>();
        this.getReturnData(root, itemsRule);
        return itemsRule;
    }

    @Override
    protected String getTabId() {
        return "rulesetting";
    }
}

