/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.form.designer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.isv.ISVService;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.converter.FormMetadataConverter;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.MobileBillFormAp;
import kd.bos.metadata.form.MobileFormAp;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.metadata.list.ListFormAp;
import kd.bos.newdevportal.form.designer.MetaIsvCheckResultPlugIn;
import kd.bos.param.ParameterReader;

public class MetaIsvCheck {
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    public static final String ISV_KINGDEE = "kingdee";

    private static boolean isNeedCheckIsv() {
        Map cache = ParameterReader.loadPublicParameterFromCache();
        if (null == cache || cache.isEmpty()) {
            return true;
        }
        Object needIsvCheck = cache.get("designer_isv_check");
        if (null == needIsvCheck) {
            return true;
        }
        return (Boolean)needIsvCheck;
    }

    public static boolean checkEntity(IFormView view, Map<String, Object> newMetaMap, Map<String, Object> originMetaMap) {
        String isv = ISVService.getISVInfo().getId();
        if (ISV_KINGDEE.equalsIgnoreCase(isv)) {
            return true;
        }
        if (!MetaIsvCheck.isNeedCheckIsv()) {
            return true;
        }
        if (MetaIsvCheck.startWithNumber(isv)) {
            return true;
        }
        String modelType = (String)newMetaMap.get("modelType");
        if ("PrintModel".equalsIgnoreCase(modelType)) {
            return true;
        }
        FormMetadataConverter converter = new FormMetadataConverter();
        AbstractMetadata originMeta = converter.convertTo(originMetaMap);
        AbstractMetadata newMeta = converter.convertTo(newMetaMap);
        if (null == originMeta || originMeta instanceof PrintMetadata) {
            return true;
        }
        if (null == newMeta || newMeta instanceof PrintMetadata) {
            return true;
        }
        HashMap<String, IsvCheckResult> checkResultMap = new HashMap<String, IsvCheckResult>();
        MetaIsvCheck.entityKeyCheck(isv, MetaType.Form, newMeta, originMeta, checkResultMap);
        MetaIsvCheck.entityCheck(isv, MetaType.Form, newMeta, originMeta, checkResultMap);
        if (checkResultMap.isEmpty()) {
            return true;
        }
        FormShowParameter parameter = MetaIsvCheckResultPlugIn.show(checkResultMap.values());
        view.showForm(parameter);
        return false;
    }

    public static boolean check(IFormView view, Map<String, Object> newMetaMap, String originMetaCache) {
        String modelType;
        String isv = ISVService.getISVInfo().getId();
        if (ISV_KINGDEE.equalsIgnoreCase(isv)) {
            return true;
        }
        if (!MetaIsvCheck.isNeedCheckIsv()) {
            return true;
        }
        if (MetaIsvCheck.startWithNumber(isv)) {
            return true;
        }
        Map originMetaMap = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)originMetaCache)) {
            originMetaMap = (Map)SerializationUtils.fromJsonString((String)originMetaCache, Map.class);
        }
        if ("PrintModel".equalsIgnoreCase(modelType = (String)newMetaMap.get("modelType"))) {
            return true;
        }
        FormMetadataConverter converter = new FormMetadataConverter();
        AbstractMetadata originMeta = converter.convertTo(originMetaMap);
        AbstractMetadata newMeta = converter.convertTo(newMetaMap);
        if (null == originMeta || originMeta instanceof PrintMetadata) {
            return true;
        }
        if (null == newMeta || newMeta instanceof PrintMetadata) {
            return true;
        }
        HashMap<String, IsvCheckResult> checkResultMap = new HashMap<String, IsvCheckResult>();
        MetaIsvCheck.fieldCheck(isv, MetaType.Form, newMeta, originMeta, checkResultMap);
        MetaIsvCheck.subFormFieldCheck(isv, newMeta, originMeta, checkResultMap);
        MetaIsvCheck.entityCheck(isv, MetaType.Form, newMeta, originMeta, checkResultMap);
        if (checkResultMap.isEmpty()) {
            return true;
        }
        FormShowParameter parameter = MetaIsvCheckResultPlugIn.show(checkResultMap.values());
        view.showForm(parameter);
        return false;
    }

    private static boolean startWithNumber(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        char first = str.trim().charAt(0);
        return first >= '0' && first <= '9';
    }

    private static void subFormFieldCheck(String isv, AbstractMetadata newMeta, AbstractMetadata originMeta, Map<String, IsvCheckResult> checkResultMap) {
        BillFormAp originBillFormAp = ((FormMetadata)originMeta).getItems().stream().filter(control -> control instanceof BillFormAp).map(control -> (BillFormAp)control).findFirst().orElse(null);
        BillFormAp newBillFormAp = ((FormMetadata)newMeta).getItems().stream().filter(control -> control instanceof BillFormAp).map(control -> (BillFormAp)control).findFirst().orElse(null);
        FormMetadata originListMeta = null == originBillFormAp ? null : originBillFormAp.getListMeta();
        FormMetadata newListMeta = null == newBillFormAp ? null : newBillFormAp.getListMeta();
        MetaIsvCheck.fieldCheck(isv, MetaType.List, (AbstractMetadata)newListMeta, (AbstractMetadata)originListMeta, checkResultMap);
    }

    private static void entityCheck(String isv, MetaType metaType, AbstractMetadata newMeta, AbstractMetadata originMeta, Map<String, IsvCheckResult> checkResultMap) {
        HashMap<String, String> originTableMap = new HashMap<String, String>();
        HashMap<String, String> originTableFieldMap = new HashMap<String, String>();
        EntityMetadata originEntityMeta = ((FormMetadata)originMeta).getEntityMetadata();
        List originEntityItems = originEntityMeta.getItems();
        for (EntityItem item : originEntityItems) {
            if (item instanceof Field) {
                originTableFieldMap.put(item.getId(), ((Field)item).getFieldName());
                if (!(item instanceof MulBasedataField)) continue;
                originTableMap.put(item.getId(), ((MulBasedataField)item).getTableName());
                continue;
            }
            if (!(item instanceof Entity)) continue;
            originTableMap.put(item.getId(), ((Entity)item).getTableName());
            if (!(item instanceof BillEntity)) continue;
            originTableFieldMap.put(item.getId(), ((BillEntity)item).getPkFieldName());
        }
        String tablePrefixCheck = "tk_" + isv + "_";
        String fieldPrefixCheck = "fk_" + isv + "_";
        List entityItems = ((FormMetadata)newMeta).getEntityMetadata().getItems();
        for (EntityItem item : entityItems) {
            String tableName;
            IsvCheckResult result;
            String id;
            if (item instanceof Field) {
                String tableName2;
                String field;
                id = item.getId();
                if (!MetaIsvCheck.checkField(id, field = ((Field)item).getFieldName(), fieldPrefixCheck, originTableFieldMap)) {
                    LocaleString nameLocale = item.getName();
                    String name = nameLocale == null ? "" : nameLocale.getLocaleValue();
                    String msgLocale = ResManager.loadKDString((String)"\u5b57\u6bb5\u540d\u201c%1$s\u201d\u4e0d\u7b26\u5408\u89c4\u8303\uff1a\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MetaIsvCheck_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                    String msg = String.format(msgLocale, field, fieldPrefixCheck);
                    result = checkResultMap.computeIfAbsent(id, k -> new IsvCheckResult(id, name));
                    result.setField(field);
                    result.addDescription(msg);
                    result.setMetaType(metaType);
                }
                if (item instanceof MulBasedataField && !MetaIsvCheck.checkField(id, tableName2 = ((MulBasedataField)item).getTableName(), tablePrefixCheck, originTableMap)) {
                    LocaleString nameLocale = item.getName();
                    String name = nameLocale == null ? "" : nameLocale.getLocaleValue();
                    String msgLocale = ResManager.loadKDString((String)"\u8868\u540d\u201c%1$s\u201d\u4e0d\u7b26\u5408\u89c4\u8303\uff1a\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MetaIsvCheck_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                    String msg = String.format(msgLocale, tableName2, tablePrefixCheck);
                    IsvCheckResult result2 = checkResultMap.computeIfAbsent(id, k -> new IsvCheckResult(id, name));
                    result2.setTable(tableName2);
                    result2.addDescription(msg);
                    result2.setMetaType(metaType);
                }
            }
            if (!(item instanceof Entity) || MetaIsvCheck.checkField(id = item.getId(), tableName = ((Entity)item).getTableName(), tablePrefixCheck, originTableMap)) continue;
            String msgLocale = ResManager.loadKDString((String)"\u8868\u540d\u201c%1$s\u201d\u4e0d\u7b26\u5408\u89c4\u8303\uff1a\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MetaIsvCheck_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            String msg = String.format(msgLocale, tableName, tablePrefixCheck);
            LocaleString nameLocale = item.getName();
            String name = nameLocale == null ? "" : nameLocale.getLocaleValue();
            result = checkResultMap.computeIfAbsent(id, k -> new IsvCheckResult(id, name));
            result.setTable(tableName);
            result.addDescription(msg);
            result.setMetaType(metaType);
        }
    }

    private static void entityKeyCheck(String isv, MetaType metaType, AbstractMetadata newMeta, AbstractMetadata originMeta, Map<String, IsvCheckResult> checkResultMap) {
        HashMap<String, String> originFieldKeyMap = new HashMap<String, String>();
        EntityMetadata originEntityMeta = ((FormMetadata)originMeta).getEntityMetadata();
        List originEntityItems = originEntityMeta.getItems();
        for (EntityItem item : originEntityItems) {
            if (item instanceof Field) {
                originFieldKeyMap.put(item.getId(), item.getKey());
                continue;
            }
            if (!(item instanceof Entity) || !(item instanceof BillEntity)) continue;
            originFieldKeyMap.put(item.getId(), ((BillEntity)item).getKey());
        }
        List entityItems = ((FormMetadata)newMeta).getEntityMetadata().getItems();
        String fieldKeyPrefixCheck = isv + "_";
        for (EntityItem item : entityItems) {
            String key;
            String id;
            if (!(item instanceof Field) || MetaIsvCheck.checkField(id = item.getId(), key = ((Field)item).getKey(), fieldKeyPrefixCheck, originFieldKeyMap)) continue;
            LocaleString nameLocale = item.getName();
            String name = nameLocale == null ? "" : nameLocale.getLocaleValue();
            String msgLocale = ResManager.loadKDString((String)"\u6807\u8bc6\u201c%1$s\u201d\u4e0d\u7b26\u5408\u4e8c\u5f00\u7684\u524d\u7f00\u89c4\u8303\uff1a\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MetaIsvCheck_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            String msg = String.format(msgLocale, key, fieldKeyPrefixCheck);
            IsvCheckResult result = checkResultMap.computeIfAbsent(id, k -> new IsvCheckResult(id, name));
            result.setControl(key);
            result.addDescription(msg);
            result.setMetaType(metaType);
        }
    }

    private static void fieldCheck(String isv, MetaType metaType, AbstractMetadata newMeta, AbstractMetadata originMeta, Map<String, IsvCheckResult> checkResultMap) {
        if (null == newMeta) {
            return;
        }
        HashMap<String, String> originControlMap = new HashMap<String, String>(16);
        if (null != originMeta) {
            List originControls = ((FormMetadata)originMeta).getItems();
            for (ControlAp control : originControls) {
                originControlMap.put(control.getId(), control.getKey());
            }
        }
        String controlPrefixCheck = isv + "_";
        List controls = ((FormMetadata)newMeta).getItems();
        for (ControlAp control : controls) {
            String name;
            if (control instanceof MobileFormAp || control instanceof MobileBillFormAp || control instanceof ListFormAp) continue;
            String id = control.getId();
            String key = control.getKey();
            LocaleString nameLocale = control.getName();
            String string = name = nameLocale == null ? "" : nameLocale.getLocaleValue();
            if (MetaIsvCheck.checkField(id, key, controlPrefixCheck, originControlMap)) continue;
            String msgLocale = ResManager.loadKDString((String)"\u6807\u8bc6\u201c%1$s\u201d\u4e0d\u7b26\u5408\u4e8c\u5f00\u7684\u524d\u7f00\u89c4\u8303\uff1a\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MetaIsvCheck_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            String msg = String.format(msgLocale, key, controlPrefixCheck);
            IsvCheckResult result = checkResultMap.computeIfAbsent(id, k -> new IsvCheckResult(id, name));
            result.setControl(key);
            result.addDescription(msg);
            result.setMetaType(metaType);
        }
    }

    private static boolean checkField(String id, String field, String expectPrefix, Map<String, String> originMap) {
        if (StringUtils.isBlank((CharSequence)id) || StringUtils.isBlank((CharSequence)field)) {
            return true;
        }
        if (!originMap.containsKey(id) && !StringUtils.startsWithIgnoreCase((CharSequence)field, (CharSequence)expectPrefix)) {
            return false;
        }
        String originField = originMap.get(id);
        return !originMap.containsKey(id) || StringUtils.equals((CharSequence)field, (CharSequence)originField) || StringUtils.startsWithIgnoreCase((CharSequence)field, (CharSequence)expectPrefix);
    }

    public static class IsvCheckResult
    implements Serializable {
        private static final long serialVersionUID = 6067859875462605127L;
        private String id = "";
        private String name = "";
        private String control = "";
        private String table = "";
        private String field = "";
        private String descriptions = "";
        private MetaType metaType = MetaType.Form;
        private List<String> descriptionsList = new ArrayList<String>();

        public IsvCheckResult() {
        }

        public IsvCheckResult(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getControl() {
            return this.control;
        }

        public void setControl(String control) {
            this.control = control;
        }

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void addDescription(String msg) {
            this.descriptionsList.add(msg);
            this.descriptions = StringUtils.join((Object[])this.descriptionsList.toArray(), (String)"\r\n");
        }

        public String getDescriptions() {
            return this.descriptions;
        }

        public void setDescriptions(String descriptions) {
            this.descriptions = descriptions;
        }

        public MetaType getMetaType() {
            return this.metaType;
        }

        public void setMetaType(MetaType metaType) {
            this.metaType = metaType;
        }
    }

    public static enum MetaType {
        Form,
        List,
        Mob,
        MobList;


        public ILocaleString getName() {
            switch (this) {
                case Form: {
                    return ResManager.getLocaleString((String)"\u8868\u5355", (String)"MetaIsvCheck_0", (String)MetaIsvCheck.BOS_DESIGNER_PLUGIN);
                }
                case List: {
                    return ResManager.getLocaleString((String)"\u5217\u8868", (String)"MetaIsvCheck_1", (String)MetaIsvCheck.BOS_DESIGNER_PLUGIN);
                }
                case Mob: {
                    return ResManager.getLocaleString((String)"\u79fb\u52a8\u8868\u5355", (String)"MetaIsvCheck_2", (String)MetaIsvCheck.BOS_DESIGNER_PLUGIN);
                }
                case MobList: {
                    return ResManager.getLocaleString((String)"\u79fb\u52a8\u5217\u8868", (String)"MetaIsvCheck_3", (String)MetaIsvCheck.BOS_DESIGNER_PLUGIN);
                }
            }
            return new LocaleString();
        }
    }
}

