/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.form.designer;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.AbstractFormDesignerPlugin;
import kd.bos.designer.ISubDesginer;
import kd.bos.designer.dao.FormTemplateFactory;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.FormDesigner;
import kd.bos.form.control.events.PropertyEvent;
import kd.bos.isv.ISVService;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;

public class MobBillDesignerPlugin
extends AbstractFormDesignerPlugin
implements ISubDesginer {
    private static final String MOB_BILL_DESIGNER = "subformdesigner";
    private static final String ITEMS = "Items";
    private String id;
    private String key;

    protected String getDesignerKey() {
        return MOB_BILL_DESIGNER;
    }

    public Map<String, Object> loadData(FormDesigner designer, Object context, String propertName, Object value, String lang) {
        Map<String, Object> tMap;
        if (context instanceof List) {
            HashMap<String, Object> entityMeta = new HashMap<String, Object>();
            entityMeta.put(ITEMS, ((List)context).get(1));
            entityMeta.put("_Type_", "EntityMetadata");
            Map formmeta = null;
            if (value instanceof Map) {
                formmeta = (Map)value;
            }
            Map item = (Map)((List)((List)context).get(0)).get(0);
            this.id = (String)item.get("Id");
            this.key = item.get("Key") + "_mob";
            tMap = this.createMobFormMetadata(this.id, this.key, formmeta, entityMeta, lang);
        } else {
            tMap = new HashMap<String, Object>();
        }
        return tMap;
    }

    private Map<String, Object> createMobFormMetadata(String id, String key, Map<String, Object> srcFormmeta, Map<String, Object> srcEntityMeta, String lang) {
        ArrayList<Object> entityItems;
        Map item;
        List items;
        IFormTemplate template = FormTemplateFactory.createTemplate((String)"MobileBillFormModel");
        FormMetadata formMeta = null;
        if (srcFormmeta == null) {
            formMeta = template.getFormMetadata();
            formMeta.setModelType("MobileBillFormModel");
            FormAp fm = formMeta.getRootAp();
            fm.setDirection("column");
        } else {
            formMeta = (FormMetadata)template.deserializeFromMap(srcFormmeta, null);
        }
        formMeta.setId(id);
        formMeta.setKey(key);
        formMeta.getRootAp().setLanguage(lang);
        if (null == formMeta.getRootAp().getName() && null != srcEntityMeta && null != (items = (List)srcEntityMeta.get(ITEMS)) && !items.isEmpty() && null != (item = (Map)items.get(0))) {
            Object name = item.get("Name");
            if (name instanceof String) {
                formMeta.getRootAp().setName(new LocaleString(lang, name));
            } else if (name instanceof LocaleString) {
                formMeta.getRootAp().setName((LocaleString)name);
            }
        }
        ArrayList<Object> arrayList = entityItems = srcEntityMeta != null ? (ArrayList)srcEntityMeta.get(ITEMS) : new ArrayList<Object>(0);
        if (entityItems != null) {
            entityItems.removeIf(i -> i instanceof Map && "RefBillField".equalsIgnoreCase((String)((Map)i).get("_Type_")));
            entityItems.removeIf(i -> i instanceof Map && "TreeEntryEntity".equalsIgnoreCase((String)((Map)i).get("_Type_")));
            entityItems.removeIf(i -> i instanceof Map && "JsonSubEntryEntity".equalsIgnoreCase((String)((Map)i).get("_Type_")));
        }
        EntityMetadata entityMeta = (EntityMetadata)template.deserializeFromMap(srcEntityMeta, null);
        entityMeta.setId(entityMeta.getRootEntity().getId());
        formMeta.setEntityId(entityMeta.getRootEntity().getId());
        formMeta.bindEntityMetadata(entityMeta);
        HashMap<String, Object> tMap = new HashMap<String, Object>(8);
        tMap.put("entityreadonly", true);
        tMap.put("entitytree", this.postProcessEntityTree(entityMeta.buildDesgnerTree()));
        tMap.put("id", formMeta.getId());
        tMap.put("entitymeta", super.fillBackInheritProperty(srcEntityMeta, template.serializeToMap((Object)entityMeta)));
        tMap.put("ui", formMeta.builderDesgnerControls());
        tMap.put("formmeta", this.fillBackInheritProperty(srcFormmeta, template.serializeToMap((Object)formMeta)));
        tMap.put("islayout", true);
        tMap.put("isPC", false);
        tMap.put("isv", ISVService.getISVInfo().getId());
        return tMap;
    }

    protected Map<String, Object> fillBackInheritProperty(Map<String, Object> originMeta, Map<String, Object> needFillMeta) {
        Map r = super.fillBackInheritProperty(originMeta, needFillMeta);
        return this.fillBackFormPluginInherit(originMeta, r);
    }

    private Map<String, Object> fillBackFormPluginInherit(Map<String, Object> originMeta, Map<String, Object> needFillMeta) {
        if (null == originMeta || originMeta.isEmpty() || null == needFillMeta || needFillMeta.isEmpty()) {
            return needFillMeta;
        }
        HashMap<String, Boolean> inheritPlugins = new HashMap<String, Boolean>();
        if (null == originMeta || originMeta.isEmpty()) {
            return needFillMeta;
        }
        List originItems = (List)originMeta.get(ITEMS);
        List needFillItems = (List)needFillMeta.get(ITEMS);
        if (null == originItems || originItems.isEmpty() || null == needFillItems || needFillItems.isEmpty()) {
            return needFillMeta;
        }
        if (originItems.get(0) == null || needFillItems.get(0) == null) {
            return needFillMeta;
        }
        Map originAp = (Map)originItems.get(0);
        Map needFillAp = (Map)needFillItems.get(0);
        if (originAp.get("Plugins") == null || needFillAp.get("Plugins") == null) {
            return needFillMeta;
        }
        for (Map originPlugin : (List)originAp.get("Plugins")) {
            if (!Boolean.parseBoolean(String.valueOf(originPlugin.get("Inherit")))) continue;
            inheritPlugins.put(String.valueOf(originPlugin.get("ClassName")), true);
        }
        for (Map needfillPlugin : (List)needFillAp.get("Plugins")) {
            String className = String.valueOf(needfillPlugin.get("ClassName"));
            if (!inheritPlugins.containsKey(className) || !((Boolean)inheritPlugins.get(className)).booleanValue()) continue;
            needfillPlugin.put("Inherit", true);
        }
        return needFillMeta;
    }

    private Map<String, Object> postProcessEntityTree(Map<String, Object> entityTree) {
        List items = (List)entityTree.get(ITEMS);
        items.removeIf(i -> "TreeEntryEntity".equals(i.get("Type")) || "SubEntryEntity".equals(i.get("Type")));
        for (Map item : items) {
            if (!"EntryEntity".equals(item.get("Type"))) continue;
            List entryEntityItems = (List)item.get(ITEMS);
            entryEntityItems.removeIf(i -> "SubEntryEntity".equals(i.get("Type")));
        }
        return entityTree;
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btnok".equals(c.getKey())) {
            this.returnData();
        } else if ("btnpreview".equals(c.getKey())) {
            this.preview(this.key, "MobileBillFormModel");
        }
    }

    protected void beforeShowPropertyEdit(PropertyEvent e, FormShowParameter showParameter) {
        showParameter.setCustomParam("isPC", (Object)false);
    }

    private void returnData() {
        FormDesigner designer = (FormDesigner)this.getView().getControl(MOB_BILL_DESIGNER);
        Object v = this.getReturnData(designer, this.getView().getFormShowParameter().getCustomParams());
        if (v instanceof String) {
            this.getView().showTipNotification((String)v);
        } else {
            this.getView().returnDataToParent(v);
            this.getView().close();
        }
    }

    private String validateItem(Map<String, Object> map) {
        return "";
    }

    public Object getReturnData(FormDesigner subdesigner, Map<String, Object> params) {
        if (subdesigner.getContent() == null) {
            return false;
        }
        Map map = (Map)subdesigner.getContent().get("formmeta");
        String metastr = SerializationUtils.toJsonString((Object)map);
        String validate = this.validateItem(map);
        if (!validate.equals("")) {
            return validate;
        }
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("itemId", params.get("itemId"));
        para.put("metaType", params.get("metaType"));
        para.put("propertyName", params.get("propertyName"));
        para.put("value", SerializationUtils.fromJsonString((String)metastr, Map.class));
        return para;
    }
}

