/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.form.designer;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;

public class ShowGptDialogHandler
implements ClickListener {
    private static final String ITEMS = "Items";
    private static final Log logger = LogFactory.getLog(ShowGptDialogHandler.class);
    private final IFormView formView;

    public ShowGptDialogHandler(IFormView formView) {
        this.formView = formView;
    }

    public void click(EventObject evt) {
        try {
            ClickEvent clickEvent = (ClickEvent)evt;
            this.mergeToMetadata(clickEvent.getParamsMap());
            Map<String, Object> paramsMap = this.convertToGPTMap(clickEvent.getParamsMap());
            String pageId = this.formView.getPageCache().get("gpt_gai_form_embed_pageid");
            IFormView gptFormView = null;
            if (StringUtils.isNotBlank((CharSequence)pageId)) {
                gptFormView = this.formView.getViewNoPlugin(pageId);
            }
            if (gptFormView != null) {
                CustomControl control = (CustomControl)gptFormView.getControl("gpt_gai");
                SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                ArrayList list = new ArrayList(16);
                HashMap<String, Object> action = new HashMap<String, Object>(16);
                action.put("type", "initial");
                List selectControls = (List)paramsMap.get("selectionControls");
                this.fillProcessGroupIds(selectControls);
                paramsMap.put("switchSide", "true");
                action.put("data", paramsMap);
                list.add(action);
                map.put("actionList", list);
                map.put("time", sf.format(new Date()));
                control.setData(map);
                this.formView.sendFormAction(gptFormView);
            } else {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("gpt_gai_form_embedded");
                formShowParameter.getOpenStyle().setTargetKey("embedgptpanel");
                formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                paramsMap.forEach((arg_0, arg_1) -> ((FormShowParameter)formShowParameter).setCustomParam(arg_0, arg_1));
                formShowParameter.setCustomParam("switchSide", (Object)"true");
                List selectControls = (List)paramsMap.get("selectionControls");
                this.fillProcessGroupIds(selectControls);
                this.formView.getPageCache().put("gpt_gai_form_embed_pageid", formShowParameter.getPageId());
                this.formView.showForm(formShowParameter);
            }
        }
        catch (Exception e) {
            logger.error("start embed gpt assist form failed.", (Throwable)e);
        }
    }

    private void mergeToMetadata(Map<String, Object> map) {
        String currentMetadataStr = this.formView.getPageCache().get("current_metadata");
        if (!StringUtils.isEmpty((CharSequence)currentMetadataStr)) {
            Map currentMetadata = (Map)SerializationUtils.fromJsonString((String)currentMetadataStr, Map.class);
            List list = (List)map.get("selectionControls");
            for (Map itemMap : list) {
                Map formmeta = (Map)itemMap.get("formmeta");
                this.mergeItem((Map)currentMetadata.get("formmeta"), formmeta);
                Map entitymeta = (Map)itemMap.get("entitymeta");
                if (entitymeta == null) continue;
                this.mergeItem((Map)currentMetadata.get("entitymeta"), entitymeta);
            }
            this.formView.getPageCache().put("current_metadata", SerializationUtils.toJsonString((Object)currentMetadata));
        }
    }

    private void mergeItem(Map<String, Object> meta, Map<String, Object> itemMap) {
        List items = (List)meta.get(ITEMS);
        for (Object item : items) {
            Map map = (Map)item;
            if (!map.get("Id").equals(itemMap.get("Id"))) continue;
            map.putAll(itemMap);
            return;
        }
        items.add(itemMap);
    }

    private Map<String, Object> convertToGPTMap(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>(map.size());
        result.put("activeControlId", map.get("activeControlId"));
        List list = (List)map.get("selectionControls");
        ArrayList targetList = new ArrayList(list.size());
        for (Map selectionControlMap : list) {
            Map formmeta = (Map)selectionControlMap.get("formmeta");
            HashMap targetSelectionControl = new HashMap(4);
            targetSelectionControl.put("id", formmeta.get("Id"));
            targetSelectionControl.put("name", formmeta.get("Name"));
            targetSelectionControl.put("key", formmeta.get("Key"));
            targetSelectionControl.put("type", formmeta.get("_Type_"));
            if (formmeta.containsKey("FieldType")) {
                targetSelectionControl.put("fieldType", formmeta.get("FieldType"));
            }
            targetList.add(targetSelectionControl);
        }
        result.put("selectionControls", targetList);
        return result;
    }

    private void fillProcessGroupIds(List<Map<String, Object>> selectionControls) {
        HashSet<String> controlType = new HashSet<String>();
        for (Map<String, Object> control : selectionControls) {
            controlType.add(control.containsKey("fieldType") ? (String)control.get("fieldType") : (String)control.get("type"));
        }
        QFilter qFilter = new QFilter("type", "in", (Object)controlType.toArray());
        if (controlType.size() > 1) {
            qFilter.and(new QFilter("isonly", "=", (Object)false));
        }
        MainEntityType configType = EntityMetadataCache.getDataEntityType((String)"bos_emedctlconfig");
        Map datas = BusinessDataReader.loadFromCache((DynamicObjectType)configType, (QFilter[])new QFilter[]{qFilter});
        for (Map<String, Object> control : selectionControls) {
            String type = (String)control.get("type");
            boolean isEntryField = type.equals("EntryFieldAp") || type.equals("CardEntryFieldAp");
            String fieldType = control.containsKey("fieldType") ? (String)control.get("fieldType") : (String)control.get("type");
            ArrayList<String> groupIds = new ArrayList<String>();
            for (Map.Entry kv : datas.entrySet()) {
                if (!((DynamicObject)kv.getValue()).getString("type").equals(fieldType) || ((DynamicObject)kv.getValue()).getBoolean("isentry") != isEntryField) continue;
                groupIds.add(String.valueOf(((DynamicObject)kv.getValue()).getString("groupid")));
            }
            control.put("groupIds", groupIds);
        }
    }
}

