/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.formula;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.function.FunctionType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.func.IFuncParamEditor;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.newdevportal.util.RuleDesignMetaHelper;

public class FunctionFormulaPlugin
extends AbstractFormPlugin {
    private static final String FUNC_NAME = "funcname";
    private static final String RETURN_TYPE = "returntype";
    private static final String FUNC_DESC = "funcdesc";
    private static final String FUNC_PARAMETER = "funcparameter";
    private static final String BTN_OK = "btnok";
    private static final String CHILD_PAGE = "childpage";
    private static final String FUNC_TYPE = "functype";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        String functionId = (String)this.getView().getFormShowParameter().getCustomParam("funcid");
        String xmlFuns = (String)this.getView().getFormShowParameter().getCustomParam("functiontypes");
        FunctionType functionType = this.getFunctionType(functionId, xmlFuns);
        this.showFuncParameterPage(functionType);
    }

    private void showFuncParameterPage(FunctionType functionType) {
        if (functionType == null) {
            return;
        }
        ((Label)this.getView().getControl(FUNC_NAME)).setText(functionType.getDef());
        ((Label)this.getView().getControl(RETURN_TYPE)).setText(String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u503c\uff1a%s", (String)"FunctionFormulaPlugin_0", (String)"bos-devportal-new-plugin", (Object[])new Object[0]), functionType.getReturnType()));
        this.getModel().setValue(FUNC_DESC, (Object)this.getFuncDesc(functionType.getDesc().getLocaleValue()));
        String formId = functionType.getSettingFormId();
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(formId);
            parameter.setShowTitle(false);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey(FUNC_PARAMETER);
            StyleCss style = new StyleCss();
            style.setHeight("287");
            style.setWidth("814");
            parameter.getOpenStyle().setInlineStyleCss(style);
            parameter.setCustomParam("funcid", (Object)functionType.getId());
            parameter.setCustomParam("entityItems", this.getView().getFormShowParameter().getCustomParam("entityItems"));
            parameter.setCustomParam("entitynumber", this.getView().getFormShowParameter().getCustomParam("entitynumber"));
            this.getView().showForm(parameter);
            this.getPageCache().put(CHILD_PAGE, parameter.getPageId());
        }
    }

    private String getFuncDesc(String desc) {
        ArrayList<String> descLines = new ArrayList<String>(10);
        String temp = desc;
        int index = temp.indexOf("\\n");
        while (index > 0) {
            descLines.add(temp.substring(0, index));
            temp = index < temp.length() - 2 ? temp.substring(index + 2) : "";
            index = temp.indexOf("\\n");
        }
        if (StringUtils.isNotBlank((CharSequence)temp)) {
            descLines.add(temp);
        }
        return StringUtils.join((Object[])descLines.toArray(), (char)'\n');
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button button = (Button)evt.getSource();
        String func = this.getPageCache().get("func");
        FunctionType functionType = (FunctionType)SerializationUtils.fromJsonString((String)func, FunctionType.class);
        if (BTN_OK.equals(button.getKey())) {
            this.returnFunc(functionType);
        }
    }

    private void returnFunc(FunctionType functionType) {
        FormViewPluginProxy plugInProxy;
        IFuncParamEditor paramEditor = null;
        String funcSetting = "";
        String childPageId = this.getPageCache().get(CHILD_PAGE);
        IFormView childView = null;
        if (StringUtils.isNotBlank((CharSequence)childPageId) && (plugInProxy = (FormViewPluginProxy)(childView = this.getView().getView(childPageId)).getService(FormViewPluginProxy.class)) != null) {
            for (IFormPlugin plugin : plugInProxy.getPlugIns()) {
                if (!(plugin instanceof IFuncParamEditor)) continue;
                paramEditor = (IFuncParamEditor)plugin;
                break;
            }
        }
        if (paramEditor == null) {
            funcSetting = functionType.getDef();
        } else {
            StringBuilder sBuilder = new StringBuilder();
            if (!paramEditor.checkSetting(sBuilder).booleanValue()) {
                this.getView().showTipNotification(sBuilder.toString());
                return;
            }
            funcSetting = paramEditor.getSetting();
        }
        if (childView != null) {
            childView.close();
            this.getView().sendFormAction(childView);
        }
        this.getView().returnDataToParent((Object)funcSetting);
        this.getView().close();
    }

    private FunctionType getFunctionType(String functionId, String xmlFuncs) {
        FunctionType functionType = RuleDesignMetaHelper.getFunctionType(functionId, xmlFuncs);
        this.getPageCache().put("func", SerializationUtils.toJsonString((Object)functionType));
        return functionType;
    }
}

