/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.gpt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.RefProp;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.rule.BizRule;
import kd.bos.metadata.entity.rule.BizRuleAction;
import kd.bos.metadata.entity.rule.ClearValueAction;
import kd.bos.metadata.entity.rule.FormulaAction;
import kd.bos.metadata.entity.rule.TakeBasePropertyAction;
import kd.bos.metadata.entity.rule.TakeValueId;
import kd.bos.metadata.form.rule.FormRuleAction;
import kd.bos.newdevportal.gpt.model.GPTRule;
import kd.bos.newdevportal.gpt.model.GPTRuleAction;

public class BizRuleBuilder {
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final Log logger = LogFactory.getLog(BizRuleBuilder.class);

    public GPTRule[] createRule(EntityMetadata entityMetadata, JSONObject json) {
        GPTRule gptRule;
        HashMap<String, GPTRule> ruleMap = new HashMap<String, GPTRule>(16);
        List<GPTRuleAction> ruleActions = this.createRuleActions(entityMetadata, json.getJSONArray("trueaction"));
        for (GPTRuleAction ruleAction : ruleActions) {
            gptRule = ruleMap.computeIfAbsent(ruleAction.getEntityId() + "|" + ruleAction.isFormAction(), k -> this.createBizRule((String)k, json));
            gptRule.getRules().get(0).getTrueActions().add(ruleAction.getBizRuleAction());
        }
        ruleActions = this.createRuleActions(entityMetadata, json.getJSONArray("falseaction"));
        for (GPTRuleAction ruleAction : ruleActions) {
            gptRule = ruleMap.computeIfAbsent(ruleAction.getEntityId() + "|" + ruleAction.isFormAction(), k -> this.createBizRule((String)k, json));
            gptRule.getRules().get(0).getFalseActions().add(ruleAction.getBizRuleAction());
        }
        return ruleMap.values().toArray(new GPTRule[0]);
    }

    private GPTRule createBizRule(String key, JSONObject json) {
        BizRule bizRule = new BizRule();
        bizRule.setDescription(new LocaleString(json.getString("desc")));
        String condition = json.getString("condition");
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            FormulaEngine.extractVariables((String)condition);
        }
        bizRule.setPreCondition(condition);
        bizRule.setPreDescription(json.getString("desc"));
        GPTRule gptRule = new GPTRule();
        String[] s = key.split("\\|");
        gptRule.setId(s[0]);
        gptRule.setRules(Collections.singletonList(bizRule));
        gptRule.setRuleType("true".equals(s[1]) ? "formmeta" : "entitymeta");
        return gptRule;
    }

    private List<GPTRuleAction> createRuleActions(EntityMetadata entityMetadata, JSONArray jsonArray) {
        if (jsonArray == null) {
            return Collections.emptyList();
        }
        ArrayList<GPTRuleAction> list = new ArrayList<GPTRuleAction>(16);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject action = jsonArray.getJSONObject(i);
            String actionType = action.getString("actiontype");
            if (!StringUtils.isNotBlank((CharSequence)actionType)) continue;
            BizRuleAction bizRuleAction = null;
            if ("takevalue".equalsIgnoreCase(actionType)) {
                bizRuleAction = this.createTakeBaseProAction(entityMetadata, action);
            } else if ("formula".equalsIgnoreCase(actionType)) {
                bizRuleAction = this.createFormulaAction(action);
            } else if ("clearvalue".equalsIgnoreCase(actionType)) {
                bizRuleAction = this.createClearValueAction(action);
            }
            if (bizRuleAction == null) continue;
            GPTRuleAction gptRuleAction = new GPTRuleAction();
            Map mapAction = bizRuleAction.buildAction();
            Set dependencyFields = bizRuleAction.getDependencyFields();
            if (bizRuleAction instanceof ClearValueAction) {
                String[] exp = ((ClearValueAction)bizRuleAction).getExpression().split(":");
                dependencyFields.addAll(Arrays.asList(exp));
            } else if (bizRuleAction instanceof FormulaAction) {
                dependencyFields.add((String)mapAction.get("fieldkey"));
            }
            String dependEntityId = this.getDependEntityId(entityMetadata, dependencyFields);
            gptRuleAction.setEntityId(dependEntityId);
            gptRuleAction.setBizRuleAction(bizRuleAction);
            gptRuleAction.setFormAction(bizRuleAction instanceof FormRuleAction);
            list.add(gptRuleAction);
        }
        return list;
    }

    private String getDependEntityId(EntityMetadata entityMetadata, Set<String> dependencyFields) {
        MainEntity entity = entityMetadata.getRootEntity();
        for (String dependencyField : dependencyFields) {
            String parentId;
            EntryEntity entryEntity;
            Field field = entityMetadata.getFieldByKey(dependencyField);
            if (field == null || (entryEntity = entityMetadata.getEntryById(parentId = field.getParentId())) == null || entryEntity == entity) continue;
            entity = entryEntity;
        }
        return entity.getId();
    }

    protected BizRuleAction createClearValueAction(JSONObject action) {
        ClearValueAction ruleAction = new ClearValueAction();
        ruleAction.setActionType("ClearValueAction");
        String actionValue = action.getString("action");
        if (StringUtils.isBlank((CharSequence)actionValue)) {
            return null;
        }
        Pattern pattern = Pattern.compile("[,;]");
        Matcher matcher = pattern.matcher(actionValue);
        String result = matcher.replaceAll(":");
        ruleAction.setExpression(result);
        ruleAction.setDescription(ResManager.loadKDString((String)"\u6e05\u9664\u5b57\u6bb5", (String)"BizRuleBuilder_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        ruleAction.setRET(255);
        return ruleAction;
    }

    protected BizRuleAction createFormulaAction(JSONObject action) {
        FormulaAction formulaAction = new FormulaAction();
        formulaAction.setActionType("FormulaAction");
        formulaAction.setExpression(action.getString("action"));
        formulaAction.setDescription(ResManager.loadKDString((String)"\u8ba1\u7b97\u5b57\u6bb5", (String)"BizRuleBuilder_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        formulaAction.setRET(255);
        return formulaAction;
    }

    protected BizRuleAction createTakeBaseProAction(EntityMetadata entityMetadata, JSONObject jsonObject) {
        TakeBasePropertyAction takeBasePropertyAction = new TakeBasePropertyAction();
        takeBasePropertyAction.setActionType("TakeBaseProAction");
        takeBasePropertyAction.setRET(255);
        takeBasePropertyAction.setDescription(ResManager.loadKDString((String)"\u643a\u5e26\u57fa\u7840\u8d44\u6599", (String)"BizRuleBuilder_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        String actions = jsonObject.getString("action");
        if (actions == null) {
            return null;
        }
        String[] actionArray = actions.split(",");
        ArrayList<TakeValueId> listExpress = new ArrayList<TakeValueId>(16);
        ArrayList<TakeValueId> listFieldName = new ArrayList<TakeValueId>(16);
        StringBuilder logInfo = new StringBuilder();
        for (String action : actionArray) {
            TakeValueId takeValueId = new TakeValueId();
            String[] fields = action.split("=");
            if (fields.length < 2) continue;
            String targetKey = fields[0].trim();
            String srcKey = fields[1].trim();
            if ((srcKey = this.fixFieldKey(entityMetadata, srcKey)) == null) {
                logInfo.append(String.format("BizRuleBuilder,error srcKey is null,%s", action));
                continue;
            }
            Field targetField = entityMetadata.getFieldByKey(targetKey);
            Field<?> srcField = this.getField(entityMetadata, srcKey);
            if (targetField == null || srcField == null) {
                logInfo.append(String.format(",field is null,%s", action));
                continue;
            }
            if (!this.isMatchField(targetField, srcField)) {
                if (srcKey.contains(".")) {
                    srcField = this.getField(entityMetadata, srcKey = srcKey.substring(0, srcKey.lastIndexOf(46)));
                    if (!this.isMatchField(targetField, srcField)) {
                        logInfo.append(String.format(",field type not match,%s", action));
                        continue;
                    }
                } else {
                    logInfo.append(String.format(",field type not match,%s", action));
                    continue;
                }
            }
            takeValueId.setTargetField(targetKey);
            takeValueId.setSrcField(srcKey);
            listExpress.add(takeValueId);
            takeValueId = new TakeValueId();
            takeValueId.setTargetFieldName(this.getFieldName(entityMetadata, targetKey));
            takeValueId.setSrcFieldName(this.getFieldName(entityMetadata, srcKey));
            listFieldName.add(takeValueId);
        }
        logger.info(logInfo.toString());
        if (!listExpress.isEmpty()) {
            takeBasePropertyAction.setExpression(listExpress);
            takeBasePropertyAction.setFieldName(listFieldName);
            return takeBasePropertyAction;
        }
        return null;
    }

    private boolean isMatchField(Field<?> target, Field<?> src) {
        if (target == null || src == null) {
            return false;
        }
        if (target.getClass().equals(src.getClass())) {
            return true;
        }
        if (target.getClass().isAssignableFrom(src.getClass())) {
            return true;
        }
        return target.getFieldDBType() == src.getFieldDBType();
    }

    private String fixFieldKey(EntityMetadata entityMetadata, String fields) {
        Field<?> field;
        if (fields.contains(".")) {
            String[] s = fields.split("\\.");
            field = entityMetadata.getFieldByKey(s[0]);
        } else {
            field = entityMetadata.getFieldByKey(fields);
        }
        if (field != null) {
            return fields;
        }
        field = this.findFieldByRefProp(entityMetadata, fields);
        if (field == null) {
            return null;
        }
        return field.getKey() + "." + fields;
    }

    private Field<?> getField(EntityMetadata entityMetadata, String fields) {
        Field field = entityMetadata.getFieldByKey(fields.trim());
        if (field != null) {
            return field;
        }
        if (fields.contains(".")) {
            String[] segs = fields.split("\\.");
            field = entityMetadata.getFieldByKey(segs[0].trim());
            if (!(field instanceof BasedataField)) {
                return null;
            }
            BasedataField basedataField = (BasedataField)field;
            EntityMetadata refBaseEntityMeta = basedataField.getRefBaseEntityMeta();
            return this.getField(refBaseEntityMeta, fields.substring(segs[0].length() + 1));
        }
        return null;
    }

    private Field<?> findFieldByRefProp(EntityMetadata entityMetadata, String key) {
        BasedataField field = null;
        for (EntityItem item : entityMetadata.getItems()) {
            if (item instanceof BasedataField && !((BasedataField)item).getRefProps().isEmpty()) {
                for (RefProp refProp : ((BasedataField)item).getRefProps()) {
                    if (!refProp.getName().startsWith(key)) continue;
                    field = (BasedataField)item;
                    break;
                }
            }
            if (field == null) continue;
            break;
        }
        return field;
    }

    private String getFieldName(EntityMetadata entityMetadata, String fields) {
        Field field = entityMetadata.getFieldByKey(fields.trim());
        if (field != null) {
            return field.getName().toString();
        }
        if (fields.contains(".")) {
            String[] segs = fields.split("\\.");
            field = entityMetadata.getFieldByKey(segs[0].trim());
            if (field == null) {
                return "";
            }
            if (!(field instanceof BasedataField)) {
                return "";
            }
            BasedataField basedataField = (BasedataField)field;
            EntityMetadata refBaseEntityMeta = basedataField.getRefBaseEntityMeta();
            String subName = this.getFieldName(refBaseEntityMeta, fields.substring(segs[0].length() + 1));
            if (StringUtils.isNotBlank((CharSequence)subName)) {
                return field.getName().toString() + "." + subName;
            }
            return field.getName().toString();
        }
        return "";
    }
}

