/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.gpt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.newdevportal.gpt.FieldTypeFactory;
import kd.bos.newdevportal.gpt.GPTDesignerAction;
import kd.bos.newdevportal.gpt.GPTMockUtil;
import kd.bos.newdevportal.gpt.IFrameUtil;

public class DispGPTResultFormPlugin
extends AbstractFormPlugin {
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";
    private static final Log logger = LogFactory.getLog(DispGPTResultFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        JSONArray entryArray;
        String gptjsonresult;
        super.afterCreateNewData(e);
        IFormView formView = SessionManager.getCurrent().getViewNoPlugin(this.getDesingerPageId());
        if (formView != null) {
            IFrameUtil.stopOcrAnimate(formView);
            IFrameUtil.sendFormActionByWS(formView.getPageId(), formView.getActionResult());
        }
        if (StringUtils.isBlank((CharSequence)(gptjsonresult = this.getGptJsonResult()))) {
            throw new KDBizException(ResManager.loadKDString((String)"GPT\u751f\u6210\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DispGPTResultFormPlugin_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        }
        JSONObject jsonObject = GPTMockUtil.parseObject(gptjsonresult);
        this.getModel().beginInit();
        JSONArray headerArray = jsonObject.getJSONArray("header");
        if (headerArray != null && headerArray.size() > 0) {
            this.getModel().batchCreateNewEntryRow("billheader", headerArray.size());
            for (int i = 0; i < headerArray.size(); ++i) {
                JSONObject header = headerArray.getJSONObject(i);
                this.getModel().setValue("headername", (Object)header.getString("name"), i);
                this.getModel().setValue("headertype", (Object)FieldTypeFactory.getDataTypeDisplay(header.getString("type")), i);
                this.getModel().setValue("headerentityname", (Object)header.getString("basedata"), i);
            }
        }
        if ((entryArray = jsonObject.getJSONArray("entry")) != null && entryArray.size() > 0) {
            this.getModel().batchCreateNewEntryRow("billentry", entryArray.size());
            for (int i = 0; i < entryArray.size(); ++i) {
                JSONObject entry = entryArray.getJSONObject(i);
                this.getModel().setValue("entryname", (Object)entry.getString("name"), i);
                this.getModel().setValue("entrytype", (Object)FieldTypeFactory.getDataTypeDisplay(entry.getString("type")), i);
                this.getModel().setValue("entryentityname", (Object)entry.getString("basedata"), i);
            }
        }
        this.getModel().beginInit();
        this.getView().updateView();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (operate.getOperateKey().equals("createlayout")) {
            this.createLayout();
        }
    }

    private void createLayout() {
        GPTDesignerAction gptDesignerAction = new GPTDesignerAction();
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("input", this.getGptJsonResult());
        Map<String, String> result = gptDesignerAction.invokeAction(this.getDesingerPageId(), "CREATE_BILL", params);
        if (result == null) {
            IFormView view = SessionManager.getCurrent().getViewNoPlugin(this.getDesingerPageId());
            view.showTipNotification(ResManager.loadKDString((String)"\u5e03\u5c40\u521b\u5efa\u5931\u8d25\u3002", (String)"DispGPTResultFormPlugin_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            IFrameUtil.sendFormActionByWS(this.getDesingerPageId(), view.getActionResult());
        } else {
            IFormView view = SessionManager.getCurrent().getViewNoPlugin(this.getDesingerPageId());
            view.showTipNotification(ResManager.loadKDString((String)"\u5e03\u5c40\u521b\u5efa\u6210\u529f\u3002", (String)"DispGPTResultFormPlugin_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
            IFrameUtil.sendFormActionByWS(this.getDesingerPageId(), SerializationUtils.fromJsonStringToList((String)result.get("actionresult"), Object.class));
            this.getView().setEnable(Boolean.FALSE, new String[]{"btncreate"});
        }
    }

    private String getGptJsonResult() {
        String debugJson = System.getProperty("debug_json");
        if (StringUtils.isNotBlank((CharSequence)debugJson)) {
            return debugJson;
        }
        String designerPageId = this.getDesingerPageId();
        IPageCache pageCache = SessionManager.getCurrent().getPageCache(designerPageId);
        if (pageCache == null) {
            logger.warn("designerPageId error {}. may be designer is closed.", (Object)designerPageId);
            return "";
        }
        String gptjsonresult = pageCache.get("gptjsonresult");
        return gptjsonresult;
    }

    private String getDesingerPageId() {
        String desingerPageId = (String)this.getView().getFormShowParameter().getCustomParam("designerpageid");
        return desingerPageId;
    }
}

